/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2017-03-23 06:37:51 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_bwg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_album_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `album_id` bigint(20) NOT NULL,
  `is_album` tinyint(1) NOT NULL,
  `alb_gal_id` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `page_link` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `gallery_type` varchar(32) NOT NULL,
  `gallery_source` varchar(256) NOT NULL,
  `autogallery_image_number` int(4) NOT NULL,
  `update_flag` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gallery_id` bigint(20) NOT NULL,
  `slug` longtext NOT NULL,
  `filename` varchar(255) NOT NULL,
  `image_url` mediumtext NOT NULL,
  `thumb_url` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `alt` mediumtext NOT NULL,
  `date` varchar(128) NOT NULL,
  `size` varchar(128) NOT NULL,
  `filetype` varchar(128) NOT NULL,
  `resolution` varchar(128) NOT NULL,
  `author` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `comment_count` bigint(20) NOT NULL,
  `avg_rating` float NOT NULL,
  `rate_count` bigint(20) NOT NULL,
  `hit_count` bigint(20) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `pricelist_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `date` varchar(64) NOT NULL,
  `comment` mediumtext NOT NULL,
  `url` mediumtext NOT NULL,
  `mail` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `rate` float NOT NULL,
  `ip` varchar(64) NOT NULL,
  `date` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) NOT NULL,
  `image_id` bigint(20) NOT NULL,
  `gallery_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_shortcode` (
  `id` bigint(20) NOT NULL,
  `tagtext` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `options` longtext NOT NULL,
  `default_theme` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_cf7dbplugin_st` (
  `submit_time` decimal(16,4) NOT NULL,
  PRIMARY KEY (`submit_time`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_cf7dbplugin_submits` (
  `submit_time` decimal(16,4) NOT NULL,
  `form_name` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `field_name` varchar(127) CHARACTER SET utf8 DEFAULT NULL,
  `field_value` longtext CHARACTER SET utf8,
  `field_order` int(11) DEFAULT NULL,
  `file` longblob,
  KEY `submit_time_idx` (`submit_time`),
  KEY `form_name_idx` (`form_name`),
  KEY `field_name_idx` (`field_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log_function` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=665 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=558 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_bwg_gallery */
INSERT INTO `wp_bwg_gallery` VALUES("3", "Vynara Products", "vynara-products", "", "", "", "/thumb/DSCN1731.JPG", "3", "1", "1", "", "", "12", "");
INSERT INTO `wp_bwg_gallery` VALUES("4", "Workers on Duty", "workers-on-duty", "", "", "", "/thumb/DSCN1766.JPG", "4", "1", "1", "", "", "12", "");
INSERT INTO `wp_bwg_gallery` VALUES("5", "Bakers on Training", "bakers-on-training", "", "", "", "/thumb/IMG-20170303-WA0033.jpg", "5", "1", "1", "", "", "12", "");
INSERT INTO `wp_bwg_gallery` VALUES("6", "Others", "others", "", "", "", "/thumb/DSCN1771.JPG", "6", "1", "1", "", "", "12", "");
INSERT INTO `wp_bwg_gallery` VALUES("7", "Videos", "videos", "", "", "", "", "7", "1", "1", "", "", "12", "");

/* INSERT TABLE DATA: wp_bwg_image */
INSERT INTO `wp_bwg_image` VALUES("13", "3", "DSCN1731", "DSCN1731", "/DSCN1731.JPG", "/thumb/DSCN1731.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1731", "22 March 2017, 18:34", "114 KB", "JPG", "730 x 548 px", "1", "27", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("14", "3", "DSCN1730", "DSCN1730", "/DSCN1730.JPG", "/thumb/DSCN1730.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1730", "22 March 2017, 18:34", "136 KB", "JPG", "730 x 548 px", "1", "26", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("15", "3", "DSCN1678", "DSCN1678", "/DSCN1678.JPG", "/thumb/DSCN1678.JPG", "Aperture: 4\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1678", "22 March 2017, 18:34", "208 KB", "JPG", "730 x 548 px", "1", "25", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("16", "3", "DSCN1661", "DSCN1661", "/DSCN1661.JPG", "/thumb/DSCN1661.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1661", "22 March 2017, 18:34", "147 KB", "JPG", "730 x 548 px", "1", "24", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("17", "3", "DSCN1651", "DSCN1651", "/DSCN1651.JPG", "/thumb/DSCN1651.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1651", "22 March 2017, 18:34", "229 KB", "JPG", "730 x 548 px", "1", "23", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("18", "3", "DSCN1647", "DSCN1647", "/DSCN1647.JPG", "/thumb/DSCN1647.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1647", "22 March 2017, 18:34", "174 KB", "JPG", "730 x 548 px", "1", "22", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("19", "3", "DSCN1643", "DSCN1643", "/DSCN1643.JPG", "/thumb/DSCN1643.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1643", "22 March 2017, 18:34", "154 KB", "JPG", "730 x 548 px", "1", "21", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("20", "3", "DSCN1380", "DSCN1380", "/DSCN1380.JPG", "/thumb/DSCN1380.JPG", "Aperture: 3.2\nCamera: COOLPIX P100\nIso: 252\nOrientation: 1\n", "DSCN1380", "22 March 2017, 18:34", "209 KB", "JPG", "730 x 548 px", "1", "20", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("21", "3", "DSCN0854", "DSCN0854", "/DSCN0854.JPG", "/thumb/DSCN0854.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 306\nOrientation: 1\n", "DSCN0854", "22 March 2017, 18:34", "99 KB", "JPG", "730 x 548 px", "1", "19", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("22", "3", "DSCN0605", "DSCN0605", "/DSCN0605.JPG", "/thumb/DSCN0605.JPG", "Aperture: 3.5\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN0605", "22 March 2017, 18:34", "128 KB", "JPG", "730 x 548 px", "1", "18", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("23", "3", "DSCN0629", "DSCN0629", "/DSCN0629.JPG", "/thumb/DSCN0629.JPG", "Aperture: 3.5\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0629", "22 March 2017, 18:34", "137 KB", "JPG", "730 x 548 px", "1", "17", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("24", "3", "DSCN0628", "DSCN0628", "/DSCN0628.JPG", "/thumb/DSCN0628.JPG", "Aperture: 4\nCamera: COOLPIX P100\nIso: 200\nOrientation: 1\n", "DSCN0628", "22 March 2017, 18:34", "125 KB", "JPG", "730 x 548 px", "1", "16", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("25", "3", "DSCN0606", "DSCN0606", "/DSCN0606.JPG", "/thumb/DSCN0606.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 170\nOrientation: 1\n", "DSCN0606", "22 March 2017, 18:34", "130 KB", "JPG", "730 x 548 px", "1", "15", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("26", "3", "DSCN0603", "DSCN0603", "/DSCN0603.JPG", "/thumb/DSCN0603.JPG", "Aperture: 4\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN0603", "22 March 2017, 18:34", "131 KB", "JPG", "730 x 548 px", "1", "14", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("27", "3", "DSCN0601", "DSCN0601", "/DSCN0601.JPG", "/thumb/DSCN0601.JPG", "Aperture: 3.2\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN0601", "22 March 2017, 18:34", "146 KB", "JPG", "730 x 548 px", "1", "13", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("28", "3", "DSCN0594", "DSCN0594", "/DSCN0594.JPG", "/thumb/DSCN0594.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 323\nOrientation: 1\n", "DSCN0594", "22 March 2017, 18:34", "105 KB", "JPG", "730 x 548 px", "1", "12", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("29", "3", "DSCN0492", "DSCN0492", "/DSCN0492.JPG", "/thumb/DSCN0492.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0492", "22 March 2017, 18:34", "124 KB", "JPG", "730 x 548 px", "1", "11", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("30", "3", "DSCN0593", "DSCN0593", "/DSCN0593.JPG", "/thumb/DSCN0593.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN0593", "22 March 2017, 18:34", "145 KB", "JPG", "730 x 548 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("31", "3", "DSCN0489", "DSCN0489", "/DSCN0489.JPG", "/thumb/DSCN0489.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0489", "22 March 2017, 18:34", "126 KB", "JPG", "730 x 548 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("32", "3", "DSCN0488", "DSCN0488", "/DSCN0488.JPG", "/thumb/DSCN0488.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0488", "22 March 2017, 18:34", "114 KB", "JPG", "730 x 548 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("33", "3", "DSCN0487", "DSCN0487", "/DSCN0487.JPG", "/thumb/DSCN0487.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0487", "22 March 2017, 18:34", "104 KB", "JPG", "730 x 548 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("34", "3", "BREADS ON CHELF2", "BREADS ON CHELF2", "/BREADS_ON_CHELF2.jpg", "/thumb/BREADS_ON_CHELF2.jpg", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 200\nOrientation: 1\n", "BREADS ON CHELF2", "22 March 2017, 18:34", "218 KB", "JPG", "730 x 548 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("35", "3", "DSCN0486", "DSCN0486", "/DSCN0486.JPG", "/thumb/DSCN0486.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0486", "22 March 2017, 18:34", "112 KB", "JPG", "730 x 548 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("36", "3", "DSCN0482", "DSCN0482", "/DSCN0482.JPG", "/thumb/DSCN0482.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0482", "22 March 2017, 18:34", "118 KB", "JPG", "730 x 548 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("37", "3", "DSCN0481", "DSCN0481", "/DSCN0481.JPG", "/thumb/DSCN0481.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN0481", "22 March 2017, 18:34", "128 KB", "JPG", "730 x 548 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("38", "3", "BREADS ON CHELF6", "BREADS ON CHELF6", "/BREADS_ON_CHELF6.jpg", "/thumb/BREADS_ON_CHELF6.jpg", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "BREADS ON CHELF6", "22 March 2017, 18:34", "212 KB", "JPG", "730 x 548 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("39", "3", "BREADS ON CHELF4", "BREADS ON CHELF4", "/BREADS_ON_CHELF4.jpg", "/thumb/BREADS_ON_CHELF4.jpg", "Aperture: 4\nCamera: COOLPIX P100\nIso: 305\nOrientation: 1\n", "BREADS ON CHELF4", "22 March 2017, 18:34", "170 KB", "JPG", "730 x 548 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("40", "4", "DSCN1766", "DSCN1766", "/DSCN1766.JPG", "/thumb/DSCN1766.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1766", "22 March 2017, 18:42", "135 KB", "JPG", "730 x 548 px", "1", "15", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("41", "4", "DSCN1764", "DSCN1764", "/DSCN1764.JPG", "/thumb/DSCN1764.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1764", "22 March 2017, 18:42", "130 KB", "JPG", "730 x 548 px", "1", "14", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("42", "4", "DSCN1763", "DSCN1763", "/DSCN1763.JPG", "/thumb/DSCN1763.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1763", "22 March 2017, 18:42", "128 KB", "JPG", "730 x 548 px", "1", "13", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("43", "4", "DSCN1746", "DSCN1746", "/DSCN1746.JPG", "/thumb/DSCN1746.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1746", "22 March 2017, 18:42", "137 KB", "JPG", "730 x 548 px", "1", "12", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("44", "4", "DSCN1733", "DSCN1733", "/DSCN1733.JPG", "/thumb/DSCN1733.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1733", "22 March 2017, 18:42", "121 KB", "JPG", "730 x 548 px", "1", "11", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("45", "4", "DSCN1711", "DSCN1711", "/DSCN1711.JPG", "/thumb/DSCN1711.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1711", "22 March 2017, 18:42", "147 KB", "JPG", "730 x 548 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("46", "4", "2", "2", "/2.JPG", "/thumb/2.JPG", "Aperture: 3.2\nCamera: COOLPIX P100\nIso: 356\nOrientation: 1\n", "2", "22 March 2017, 18:42", "95 KB", "JPG", "730 x 548 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("47", "4", "1", "1", "/1.jpg", "/thumb/1.jpg", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "1", "22 March 2017, 18:42", "163 KB", "JPG", "730 x 548 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("48", "4", "DSCN1695", "DSCN1695", "/DSCN1695.JPG", "/thumb/DSCN1695.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 200\nOrientation: 1\n", "DSCN1695", "22 March 2017, 18:42", "131 KB", "JPG", "730 x 548 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("49", "4", "DSCN1743", "DSCN1743", "/DSCN1743.JPG", "/thumb/DSCN1743.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 307\nOrientation: 1\n", "DSCN1743", "22 March 2017, 18:42", "127 KB", "JPG", "730 x 548 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("50", "4", "DSCN1734", "DSCN1734", "/DSCN1734.JPG", "/thumb/DSCN1734.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1734", "22 March 2017, 18:42", "154 KB", "JPG", "730 x 548 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("51", "4", "DSCN1725", "DSCN1725", "/DSCN1725.JPG", "/thumb/DSCN1725.JPG", "Aperture: 3.5\nCamera: COOLPIX P100\nIso: 218\nOrientation: 1\n", "DSCN1725", "22 March 2017, 18:42", "154 KB", "JPG", "730 x 548 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("52", "4", "DSCN1701", "DSCN1701", "/DSCN1701.JPG", "/thumb/DSCN1701.JPG", "Aperture: 3.5\nCamera: COOLPIX P100\nIso: 335\nOrientation: 1\n", "DSCN1701", "22 March 2017, 18:42", "116 KB", "JPG", "730 x 548 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("53", "4", "DSCN1704", "DSCN1704", "/DSCN1704.JPG", "/thumb/DSCN1704.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1704", "22 March 2017, 18:42", "137 KB", "JPG", "730 x 548 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("54", "4", "DSCN1709", "DSCN1709", "/DSCN1709.JPG", "/thumb/DSCN1709.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 246\nOrientation: 1\n", "DSCN1709", "22 March 2017, 18:42", "129 KB", "JPG", "730 x 548 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("55", "5", "IMG-20170303-WA0033", "IMG-20170303-WA0033", "/IMG-20170303-WA0033.jpg", "/thumb/IMG-20170303-WA0033.jpg", "", "IMG-20170303-WA0033", "22 March 2017, 18:45", "527 KB", "JPG", "1200 x 900 px", "1", "11", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("56", "5", "IMG-20170303-WA0022", "IMG-20170303-WA0022", "/IMG-20170303-WA0022.jpg", "/thumb/IMG-20170303-WA0022.jpg", "", "IMG-20170303-WA0022", "22 March 2017, 18:45", "546 KB", "JPG", "1200 x 900 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("57", "5", "IMG-20170303-WA0030", "IMG-20170303-WA0030", "/IMG-20170303-WA0030.jpg", "/thumb/IMG-20170303-WA0030.jpg", "", "IMG-20170303-WA0030", "22 March 2017, 18:45", "594 KB", "JPG", "1200 x 900 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("58", "5", "IMG-20170303-WA0029", "IMG-20170303-WA0029", "/IMG-20170303-WA0029.jpg", "/thumb/IMG-20170303-WA0029.jpg", "", "IMG-20170303-WA0029", "22 March 2017, 18:45", "615 KB", "JPG", "1200 x 900 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("59", "5", "IMG-20170303-WA0028", "IMG-20170303-WA0028", "/IMG-20170303-WA0028.jpg", "/thumb/IMG-20170303-WA0028.jpg", "", "IMG-20170303-WA0028", "22 March 2017, 18:45", "532 KB", "JPG", "1200 x 900 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("60", "5", "IMG-20170303-WA0004", "IMG-20170303-WA0004", "/IMG-20170303-WA0004.jpg", "/thumb/IMG-20170303-WA0004.jpg", "", "IMG-20170303-WA0004", "22 March 2017, 18:45", "485 KB", "JPG", "900 x 1200 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("61", "5", "IMG-20170303-WA0000", "IMG-20170303-WA0000", "/IMG-20170303-WA0000.jpg", "/thumb/IMG-20170303-WA0000.jpg", "", "IMG-20170303-WA0000", "22 March 2017, 18:45", "579 KB", "JPG", "1200 x 900 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("62", "5", "IMG-20170303-WA0012", "IMG-20170303-WA0012", "/IMG-20170303-WA0012.jpg", "/thumb/IMG-20170303-WA0012.jpg", "", "IMG-20170303-WA0012", "22 March 2017, 18:45", "498 KB", "JPG", "1200 x 900 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("63", "5", "IMG-20170303-WA0017", "IMG-20170303-WA0017", "/IMG-20170303-WA0017.jpg", "/thumb/IMG-20170303-WA0017.jpg", "", "IMG-20170303-WA0017", "22 March 2017, 18:45", "496 KB", "JPG", "1200 x 900 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("64", "5", "IMG-20170303-WA0019", "IMG-20170303-WA0019", "/IMG-20170303-WA0019.jpg", "/thumb/IMG-20170303-WA0019.jpg", "", "IMG-20170303-WA0019", "22 March 2017, 18:45", "452 KB", "JPG", "900 x 1200 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("65", "5", "IMG-20170303-WA0002", "IMG-20170303-WA0002", "/IMG-20170303-WA0002.jpg", "/thumb/IMG-20170303-WA0002.jpg", "", "IMG-20170303-WA0002", "22 March 2017, 18:45", "435 KB", "JPG", "1200 x 900 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("66", "6", "DSCN1771", "DSCN1771", "/DSCN1771.JPG", "/thumb/DSCN1771.JPG", "Aperture: 6.3\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1771", "22 March 2017, 18:49", "137 KB", "JPG", "730 x 548 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("67", "6", "DSCN1729", "DSCN1729", "/DSCN1729.JPG", "/thumb/DSCN1729.JPG", "Aperture: 2.8\nCamera: COOLPIX P100\nIso: 400\nOrientation: 1\n", "DSCN1729", "22 March 2017, 18:49", "90 KB", "JPG", "730 x 548 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("68", "6", "DSCN1768", "DSCN1768", "/DSCN1768.JPG", "/thumb/DSCN1768.JPG", "Aperture: 8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1768", "22 March 2017, 18:49", "120 KB", "JPG", "730 x 548 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("69", "6", "DSCN1770", "DSCN1770", "/DSCN1770.JPG", "/thumb/DSCN1770.JPG", "Aperture: 8\nCamera: COOLPIX P100\nIso: 160\nOrientation: 1\n", "DSCN1770", "22 March 2017, 18:49", "101 KB", "JPG", "730 x 548 px", "1", "1", "1", "0", "0", "0", "0", "", "0");

/* INSERT TABLE DATA: wp_bwg_shortcode */
INSERT INTO `wp_bwg_shortcode` VALUES("1", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"1\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("2", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"2\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("3", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"0\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"4\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"360\" thumb_height=\"180\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("4", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"3\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("5", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"4\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"4\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("6", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"5\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"4\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("7", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"0\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"4\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("8", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"7\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("9", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"3\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"4\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" load_more_image_count=\"30\" show_tag_box=\"0\" tag=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" popup_effect_duration=\"1\" watermark_type=\"none\" watermark_link=\"https://web-dorado.com\"");

/* INSERT TABLE DATA: wp_bwg_theme */
INSERT INTO `wp_bwg_theme` VALUES("1", "Theme 1", "{\"thumb_margin\":4,\"thumb_padding\":0,\"thumb_border_radius\":\"0\",\"thumb_border_width\":0,\"thumb_border_style\":\"none\",\"thumb_border_color\":\"CCCCCC\",\"thumb_bg_color\":\"FFFFFF\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":0,\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":100,\"thumb_align\":\"center\",\"thumb_hover_effect\":\"scale\",\"thumb_hover_effect_value\":\"1.1\",\"thumb_transition\":1,\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":16,\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"2px\",\"thumb_title_shadow\":\"0px 0px 0px #888888\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":0,\"page_nav_font_size\":12,\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":1,\"page_nav_border_style\":\"solid\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FFFFFF\",\"page_nav_button_bg_transparent\":100,\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":1,\"page_nav_button_text\":0,\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":70,\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":20,\"lightbox_ctrl_btn_margin_top\":10,\"lightbox_ctrl_btn_margin_left\":7,\"lightbox_ctrl_btn_transparent\":100,\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":14,\"lightbox_toggle_btn_width\":100,\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":65,\"lightbox_ctrl_cont_border_radius\":4,\"lightbox_close_btn_transparent\":100,\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":2,\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"0\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":10,\"lightbox_close_btn_width\":20,\"lightbox_close_btn_height\":20,\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":0,\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":40,\"lightbox_rl_btn_width\":40,\"lightbox_rl_btn_size\":20,\"lightbox_close_rl_btn_hover_color\":\"CCCCCC\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":400,\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"segoe ui\",\"lightbox_comment_font_size\":12,\"lightbox_comment_button_bg_color\":\"616161\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":1,\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":1,\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"2px\",\"lightbox_comment_separator_width\":1,\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"383838\",\"lightbox_comment_author_font_size\":14,\"lightbox_comment_date_font_size\":10,\"lightbox_comment_body_font_size\":12,\"lightbox_comment_share_button_color\":\"CCCCCC\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"3B3B3B\",\"lightbox_filmstrip_rl_btn_size\":20,\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":1,\"lightbox_filmstrip_thumb_border_style\":\"solid\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":80,\"lightbox_filmstrip_thumb_active_border_width\":0,\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"lightbox_rl_btn_transparent\":80,\"lightbox_bg_transparent\":100,\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":16,\"album_compact_back_font_weight\":\"bold\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":16,\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"2px\",\"album_compact_title_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_margin\":4,\"album_compact_thumb_padding\":0,\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":0,\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"CCCCCC\",\"album_compact_thumb_bg_color\":\"FFFFFF\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":0,\"album_compact_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_transparent\":100,\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"scale\",\"album_compact_thumb_hover_effect_value\":\"1.1\",\"album_compact_thumb_transition\":0,\"album_extended_thumb_margin\":2,\"album_extended_thumb_padding\":0,\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":0,\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"CCCCCC\",\"album_extended_thumb_bg_color\":\"FFFFFF\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":0,\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":100,\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"scale\",\"album_extended_thumb_hover_effect_value\":\"1.1\",\"album_extended_thumb_transition\":0,\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":20,\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":0,\"album_extended_div_border_radius\":\"0 0 0 0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":10,\"album_extended_div_separator_width\":1,\"album_extended_div_separator_style\":\"solid\",\"album_extended_div_separator_color\":\"E0E0E0\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":1,\"album_extended_thumb_div_border_style\":\"solid\",\"album_extended_thumb_div_border_color\":\"E8E8E8\",\"album_extended_thumb_div_padding\":\"5px\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":1,\"album_extended_text_div_border_style\":\"solid\",\"album_extended_text_div_border_color\":\"E8E8E8\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":1,\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":16,\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":2,\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":1,\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":14,\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"F2D22E\",\"album_extended_desc_more_size\":12,\"masonry_thumb_padding\":4,\"masonry_thumb_border_radius\":\"0\",\"masonry_thumb_border_width\":0,\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":0,\"masonry_thumb_transparent\":100,\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"scale\",\"masonry_thumb_hover_effect_value\":\"1.1\",\"masonry_thumb_transition\":0,\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":100,\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":0,\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"0px 0px 0px #000000\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":40,\"slideshow_rl_btn_size\":20,\"slideshow_rl_btn_width\":40,\"slideshow_close_rl_btn_hover_color\":\"CCCCCC\",\"slideshow_filmstrip_pos\":\"top\",\"slideshow_filmstrip_thumb_border_width\":1,\"slideshow_filmstrip_thumb_border_style\":\"solid\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":0,\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":80,\"slideshow_filmstrip_rl_bg_color\":\"3B3B3B\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":20,\"slideshow_title_font_size\":16,\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":70,\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"0 0 0 0\",\"slideshow_description_font_size\":14,\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":70,\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":12,\"slideshow_dots_height\":12,\"slideshow_dots_border_radius\":\"5px\",\"slideshow_dots_background_color\":\"F2D22E\",\"slideshow_dots_margin\":3,\"slideshow_dots_active_background_color\":\"FFFFFF\",\"slideshow_dots_active_border_width\":1,\"slideshow_dots_active_border_color\":\"000000\",\"slideshow_play_pause_btn_size\":60,\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"0\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":1,\"blog_style_border_style\":\"solid\",\"blog_style_border_color\":\"F5F5F5\",\"blog_style_bg_color\":\"FFFFFF\",\"blog_style_transparent\":80,\"blog_style_box_shadow\":\"\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":0,\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":16,\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"B3AFAF\",\"blog_style_share_buttons_bg_transparent\":0,\"blog_style_share_buttons_font_size\":20,\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"0\",\"image_browser_border_width\":1,\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"F5F5F5\",\"image_browser_bg_color\":\"EBEBEB\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":80,\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"0px 5px 0px 5px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":1,\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"EBEBEB\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":15,\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":2,\"image_browser_full_border_style\":\"none\",\"image_browser_full_border_color\":\"F7F7F7\",\"image_browser_full_bg_color\":\"F5F5F5\",\"image_browser_full_transparent\":90,\"image_browser_image_title_align\":\"top\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":70,\"lightbox_info_border_width\":1,\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":18,\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":14,\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":20,\"lightbox_rate_stars_count\":5,\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":70,\"lightbox_hit_border_width\":1,\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":14,\"masonry_description_font_size\":12,\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":16,\"album_masonry_back_font_weight\":\"bold\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":16,\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"2px\",\"album_masonry_title_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_margin\":4,\"album_masonry_thumb_padding\":0,\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":0,\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"CCCCCC\",\"album_masonry_thumb_bg_color\":\"FFFFFF\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":0,\"album_masonry_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_transparent\":100,\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"scale\",\"album_masonry_thumb_hover_effect_value\":\"1.1\",\"album_masonry_thumb_transition\":0,\"mosaic_thumb_padding\":4,\"mosaic_thumb_border_radius\":\"0\",\"mosaic_thumb_border_width\":0,\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":0,\"mosaic_thumb_transparent\":100,\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"scale\",\"mosaic_thumb_hover_effect_value\":\"1.1\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"mosaic_thumb_title_font_size\":16,\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":0,\"carousel_close_btn_transparent\":100,\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":0,\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":40,\"carousel_rl_btn_size\":20,\"carousel_play_pause_btn_size\":20,\"carousel_rl_btn_width\":40,\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"segoe ui\",\"carousel_feature_border_width\":2,\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":0,\"carousel_caption_p_mergin\":0,\"carousel_caption_p_pedding\":5,\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":14,\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":100,\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":1}", "1");
INSERT INTO `wp_bwg_theme` VALUES("2", "Theme 2", "{\"thumb_margin\":4,\"thumb_padding\":4,\"thumb_border_radius\":\"0\",\"thumb_border_width\":5,\"thumb_border_style\":\"none\",\"thumb_border_color\":\"FFFFFF\",\"thumb_bg_color\":\"E8E8E8\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":0,\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":100,\"thumb_align\":\"center\",\"thumb_hover_effect\":\"rotate\",\"thumb_hover_effect_value\":\"2deg\",\"thumb_transition\":1,\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":16,\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"5px\",\"thumb_title_shadow\":\"\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":0,\"page_nav_font_size\":12,\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":1,\"page_nav_border_style\":\"none\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FCFCFC\",\"page_nav_button_bg_transparent\":100,\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":1,\"page_nav_button_text\":0,\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":70,\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":20,\"lightbox_ctrl_btn_margin_top\":10,\"lightbox_ctrl_btn_margin_left\":7,\"lightbox_ctrl_btn_transparent\":80,\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":14,\"lightbox_toggle_btn_width\":100,\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":80,\"lightbox_ctrl_cont_border_radius\":4,\"lightbox_close_btn_transparent\":95,\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":0,\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":10,\"lightbox_close_btn_width\":20,\"lightbox_close_btn_height\":20,\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":2,\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":40,\"lightbox_rl_btn_width\":40,\"lightbox_rl_btn_size\":20,\"lightbox_close_rl_btn_hover_color\":\"FFFFFF\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":400,\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"segoe ui\",\"lightbox_comment_font_size\":12,\"lightbox_comment_button_bg_color\":\"333333\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":1,\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":1,\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"3px\",\"lightbox_comment_separator_width\":1,\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"2B2B2B\",\"lightbox_comment_author_font_size\":14,\"lightbox_comment_date_font_size\":10,\"lightbox_comment_body_font_size\":12,\"lightbox_comment_share_button_color\":\"FFFFFF\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"2B2B2B\",\"lightbox_filmstrip_rl_btn_size\":20,\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":1,\"lightbox_filmstrip_thumb_border_style\":\"none\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":80,\"lightbox_filmstrip_thumb_active_border_width\":0,\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"lightbox_rl_btn_transparent\":80,\"lightbox_bg_transparent\":100,\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":14,\"album_compact_back_font_weight\":\"normal\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":16,\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"5px\",\"album_compact_title_shadow\":\"\",\"album_compact_thumb_margin\":4,\"album_compact_thumb_padding\":4,\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":1,\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"000000\",\"album_compact_thumb_bg_color\":\"E8E8E8\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":100,\"album_compact_thumb_box_shadow\":\"\",\"album_compact_thumb_transparent\":100,\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"rotate\",\"album_compact_thumb_hover_effect_value\":\"2deg\",\"album_compact_thumb_transition\":1,\"album_extended_thumb_margin\":2,\"album_extended_thumb_padding\":4,\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":4,\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"E8E8E8\",\"album_extended_thumb_bg_color\":\"E8E8E8\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":100,\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":100,\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"rotate\",\"album_extended_thumb_hover_effect_value\":\"2deg\",\"album_extended_thumb_transition\":0,\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":16,\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":0,\"album_extended_div_border_radius\":\"0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":10,\"album_extended_div_separator_width\":1,\"album_extended_div_separator_style\":\"none\",\"album_extended_div_separator_color\":\"CCCCCC\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":0,\"album_extended_thumb_div_border_style\":\"none\",\"album_extended_thumb_div_border_color\":\"CCCCCC\",\"album_extended_thumb_div_padding\":\"0\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":1,\"album_extended_text_div_border_style\":\"none\",\"album_extended_text_div_border_color\":\"CCCCCC\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":1,\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":16,\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":2,\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":1,\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":14,\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"FFC933\",\"album_extended_desc_more_size\":12,\"masonry_thumb_padding\":4,\"masonry_thumb_border_radius\":\"2px\",\"masonry_thumb_border_width\":1,\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":0,\"masonry_thumb_transparent\":80,\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"rotate\",\"masonry_thumb_hover_effect_value\":\"2deg\",\"masonry_thumb_transition\":0,\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":100,\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":0,\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":40,\"slideshow_rl_btn_size\":20,\"slideshow_rl_btn_width\":40,\"slideshow_close_rl_btn_hover_color\":\"DBDBDB\",\"slideshow_filmstrip_pos\":\"bottom\",\"slideshow_filmstrip_thumb_border_width\":1,\"slideshow_filmstrip_thumb_border_style\":\"none\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":0,\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":80,\"slideshow_filmstrip_rl_bg_color\":\"303030\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":20,\"slideshow_title_font_size\":16,\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":70,\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"5px 10px 5px 10px\",\"slideshow_description_font_size\":14,\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":70,\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":10,\"slideshow_dots_height\":10,\"slideshow_dots_border_radius\":\"10px\",\"slideshow_dots_background_color\":\"292929\",\"slideshow_dots_margin\":1,\"slideshow_dots_active_background_color\":\"292929\",\"slideshow_dots_active_border_width\":2,\"slideshow_dots_active_border_color\":\"FFC933\",\"slideshow_play_pause_btn_size\":60,\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"4px\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":1,\"blog_style_border_style\":\"none\",\"blog_style_border_color\":\"CCCCCC\",\"blog_style_bg_color\":\"E8E8E8\",\"blog_style_transparent\":70,\"blog_style_box_shadow\":\"\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":0,\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":16,\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"A1A1A1\",\"blog_style_share_buttons_bg_transparent\":0,\"blog_style_share_buttons_font_size\":20,\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"2px\",\"image_browser_border_width\":1,\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"E8E8E8\",\"image_browser_bg_color\":\"E8E8E8\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":80,\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"24px 0px 0px 0px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":1,\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"E8E8E8\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":14,\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":1,\"image_browser_full_border_style\":\"solid\",\"image_browser_full_border_color\":\"EDEDED\",\"image_browser_full_bg_color\":\"FFFFFF\",\"image_browser_full_transparent\":90,\"image_browser_image_title_align\":\"top\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":70,\"lightbox_info_border_width\":1,\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":18,\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":14,\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":20,\"lightbox_rate_stars_count\":5,\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":70,\"lightbox_hit_border_width\":1,\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":14,\"masonry_description_font_size\":12,\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":14,\"album_masonry_back_font_weight\":\"normal\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":16,\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"5px\",\"album_masonry_title_shadow\":\"\",\"album_masonry_thumb_margin\":4,\"album_masonry_thumb_padding\":4,\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":1,\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"000000\",\"album_masonry_thumb_bg_color\":\"E8E8E8\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":100,\"album_masonry_thumb_box_shadow\":\"\",\"album_masonry_thumb_transparent\":100,\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"rotate\",\"album_masonry_thumb_hover_effect_value\":\"2deg\",\"album_masonry_thumb_transition\":1,\"mosaic_thumb_padding\":4,\"mosaic_thumb_border_radius\":\"2px\",\"mosaic_thumb_border_width\":1,\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":0,\"mosaic_thumb_transparent\":80,\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"rotate\",\"mosaic_thumb_hover_effect_value\":\"2deg\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"mosaic_thumb_title_font_size\":16,\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":0,\"carousel_close_btn_transparent\":100,\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":0,\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":40,\"carousel_rl_btn_size\":20,\"carousel_play_pause_btn_size\":20,\"carousel_rl_btn_width\":40,\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"segoe ui\",\"carousel_feature_border_width\":2,\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":0,\"carousel_caption_p_mergin\":0,\"carousel_caption_p_pedding\":5,\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":14,\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":100,\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":1}", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2017-02-16 22:01:19", "2017-02-16 22:01:19", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "Vynara", "58b6925a91dba8291170301092026", "100", "2017-03-01 09:20:41", "nejobest", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-01 09:20:26\";s:7:\"Version\";s:6:\"1.1.32\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"10.1.9\";s:10:\"VersionPHP\";s:5:\"7.0.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:6:\"Vynara\";s:4:\"Hash\";s:29:\"58b6925a91dba8291170301092026\";s:8:\"NameHash\";s:36:\"Vynara_58b6925a91dba8291170301092026\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://localhost/wordpress/wordpress/wp-snapshots/\";s:8:\"ScanFile\";s:46:\"Vynara_58b6925a91dba8291170301092026_scan.json\";s:7:\"Runtime\";s:10:\"72.98 sec.\";s:7:\"ExeSize\";s:8:\"382.97KB\";s:7:\"ZipSize\";s:7:\"23.63MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:8:\"nejobest\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:48:\"Vynara_58b6925a91dba8291170301092026_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"C:/xampp/htdocs/wordpress/wordpress\";s:4:\"Size\";i:24778242;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:50:\"Vynara_58b6925a91dba8291170301092026_installer.php\";s:4:\"Size\";i:392164;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:347416;s:4:\"File\";s:49:\"Vynara_58b6925a91dba8291170301092026_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:102:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp/Vynara_58b6925a91dba8291170301092026_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "Vynara", "58d36d2ca44f03548170323063732", "20", "2017-03-23 06:37:50", "nejobest", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-23 06:37:32\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"10.1.9\";s:10:\"VersionPHP\";s:5:\"7.0.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:2;s:4:\"Name\";s:6:\"Vynara\";s:4:\"Hash\";s:29:\"58d36d2ca44f03548170323063732\";s:8:\"NameHash\";s:36:\"Vynara_58d36d2ca44f03548170323063732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://localhost/wordpress/wordpress/wp-snapshots/\";s:8:\"ScanFile\";s:46:\"Vynara_58d36d2ca44f03548170323063732_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:8:\"nejobest\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:48:\"Vynara_58d36d2ca44f03548170323063732_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"C:/xampp/htdocs/wordpress/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-23 06:37:32\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"10.1.9\";s:10:\"VersionPHP\";s:5:\"7.0.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:6:\"Vynara\";s:4:\"Hash\";s:29:\"58d36d2ca44f03548170323063732\";s:8:\"NameHash\";s:36:\"Vynara_58d36d2ca44f03548170323063732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://localhost/wordpress/wordpress/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:50:\"Vynara_58d36d2ca44f03548170323063732_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:49:\"Vynara_58d36d2ca44f03548170323063732_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:31:\"mariadb.org binary distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_itsec_log */
INSERT INTO `wp_itsec_log` VALUES("1", "file_change", "File Changes Detected", "8", "2017-03-23 06:30:43", "2017-03-23 06:30:43", "", "", "0", "", "", "a:4:{s:5:\"added\";a:3486:{s:9:\".htaccess\";a:2:{s:1:\"d\";i:1490250163;s:1:\"h\";s:32:\"f630593cfa7ae07b05fb19d45d307a11\";}s:9:\"index.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"b61b25303be0f573a6b9446d5cbe3a5b\";}s:11:\"license.txt\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"0d0434c8b176c525a6fce9cefdf8e106\";}s:11:\"readme.html\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"fe8cf5b25298130f1b2ed912a5809e33\";}s:15:\"wp-activate.php\";a:2:{s:1:\"d\";i:1487282268;s:1:\"h\";s:32:\"7ba38b3c2c9f6848fbdaff94b0a182b4\";}s:18:\"wp-admin/about.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"c5818d667f97f40f67ec1bb1bed71f3a\";}s:23:\"wp-admin/admin-ajax.php\";a:2:{s:1:\"d\";i:1487282272;s:1:\"h\";s:32:\"a48454c9e64613a558061b49a66cfb11\";}s:25:\"wp-admin/admin-footer.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"37ad12e95ec47bf1e6a128eb8d6e9958\";}s:28:\"wp-admin/admin-functions.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"af0b46eafb24e3733a8839836d256146\";}s:25:\"wp-admin/admin-header.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"741d81821039b1f77f5258b923d38f92\";}s:23:\"wp-admin/admin-post.php\";a:2:{s:1:\"d\";i:1487282275;s:1:\"h\";s:32:\"163ecc5b73b40ce02ba418a3edee2c68\";}s:18:\"wp-admin/admin.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"450c7c2afa12684f28ff976cade11985\";}s:25:\"wp-admin/async-upload.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"320481c6834442bfd77c3c8bc95348bf\";}s:20:\"wp-admin/comment.php\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"d78ff82d6fe2cca6b06cf36d78a581dc\";}s:20:\"wp-admin/credits.php\";a:2:{s:1:\"d\";i:1487282272;s:1:\"h\";s:32:\"bb9dc962e13afc3789b0d18a3c6cf1f7\";}s:26:\"wp-admin/css/about-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"9f68812437e18cc5b27b48ade01e6319\";}s:30:\"wp-admin/css/about-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"cad438384d68d17329fc137dc4e70f6f\";}s:22:\"wp-admin/css/about.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"058a5c94a16613204b8b983be03b16c6\";}s:26:\"wp-admin/css/about.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"c32129f38a610afeb5dab84cc2b42e4c\";}s:31:\"wp-admin/css/admin-menu-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"4df6af8d274c9c84f00995c4b06b8668\";}s:35:\"wp-admin/css/admin-menu-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"7834f756df7bcd9b6158cabefe10feb5\";}s:27:\"wp-admin/css/admin-menu.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"5e1349161a85839be024488a50de95b3\";}s:31:\"wp-admin/css/admin-menu.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"1056f3272ebe83f13d5d3f86a82a77f4\";}s:33:\"wp-admin/css/color-picker-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"f875ffad5553d662beea97e63ec24bbf\";}s:37:\"wp-admin/css/color-picker-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"6996ba94f4b34f766673ae879e4a42d5\";}s:29:\"wp-admin/css/color-picker.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"12b60d94f9826d402e66c2e9194aa80b\";}s:33:\"wp-admin/css/color-picker.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"9c7f4adc0cd1fe1a15e89ff4082f4b7c\";}s:39:\"wp-admin/css/colors/blue/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"d69489d26322d01d3b284a6b71a65f9a\";}s:43:\"wp-admin/css/colors/blue/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"d76e3f993f962326e6a2336db75d3fd6\";}s:35:\"wp-admin/css/colors/blue/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"8b29881cd8a024af1c890f689893e50b\";}s:39:\"wp-admin/css/colors/blue/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"835228f437b76cb4336fd2db1841a984\";}s:36:\"wp-admin/css/colors/blue/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"d9d03549d79484672c29145aad594db3\";}s:41:\"wp-admin/css/colors/coffee/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"74dab612b62647eeac56102d9fded496\";}s:45:\"wp-admin/css/colors/coffee/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"f867fd7adccd1ecdf764739053a6ec2a\";}s:37:\"wp-admin/css/colors/coffee/colors.css\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"2bd83c43aed60c175a0f8c5d2738639b\";}s:41:\"wp-admin/css/colors/coffee/colors.min.css\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"a585d4eb32332d90b23f792312bc4d8a\";}s:38:\"wp-admin/css/colors/coffee/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"397e3820b27a234330c95e05250f61ce\";}s:44:\"wp-admin/css/colors/ectoplasm/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"093dcce1588c3b8cc4b40fc311974412\";}s:48:\"wp-admin/css/colors/ectoplasm/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"1e5ae890a49af4d069a4f732d85b1de3\";}s:40:\"wp-admin/css/colors/ectoplasm/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"b21f32953ad167424e9997c8ff5330ae\";}s:44:\"wp-admin/css/colors/ectoplasm/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"3c121862a0ba5b3bd489d428cc926624\";}s:41:\"wp-admin/css/colors/ectoplasm/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"940171d1392bd8071122a905d12b9195\";}s:40:\"wp-admin/css/colors/light/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"f60e0eb47f81bbc633a19b19e6cf6f7b\";}s:44:\"wp-admin/css/colors/light/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"d12c6321c2905a72081e07d1f3696532\";}s:36:\"wp-admin/css/colors/light/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"b0a2e41cc8e4fc1d20b51923cc1412b6\";}s:40:\"wp-admin/css/colors/light/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"4c299fa424111f5c08a1965011cec210\";}s:37:\"wp-admin/css/colors/light/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"480b9bd647e5b323ef88d63ce55e1d6f\";}s:43:\"wp-admin/css/colors/midnight/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"9527914dee63a89cf72473fb23bf063f\";}s:47:\"wp-admin/css/colors/midnight/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"ecb168ac881b1974386d6722018589df\";}s:39:\"wp-admin/css/colors/midnight/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"0657508b14c063564f0001878ea88d07\";}s:43:\"wp-admin/css/colors/midnight/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"ec678f19e1681ae3cfc6cc15d1b0a128\";}s:40:\"wp-admin/css/colors/midnight/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"26dc8daaf0c47c4457b8bc2145f48634\";}s:40:\"wp-admin/css/colors/ocean/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"0d868fe77c55aa8086815541a5febdf5\";}s:44:\"wp-admin/css/colors/ocean/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"e6c6ccbf9d3324987324ed2802a695de\";}s:36:\"wp-admin/css/colors/ocean/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"3a51a395483d77757c9e1d236651417b\";}s:40:\"wp-admin/css/colors/ocean/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"6def631dce1084cd5e47ec236997ac76\";}s:37:\"wp-admin/css/colors/ocean/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"1a7c5bfd9faf7f6cc77cd9b166062568\";}s:42:\"wp-admin/css/colors/sunrise/colors-rtl.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"d1ee46c95c1fee5816652ee120a70f6b\";}s:46:\"wp-admin/css/colors/sunrise/colors-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"c2718052027e9d64f65fdcc683368af7\";}s:38:\"wp-admin/css/colors/sunrise/colors.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"36da31029014d5cba2e1d6b2c3c94903\";}s:42:\"wp-admin/css/colors/sunrise/colors.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"e15962b9d758ca2c599163ff60c6d528\";}s:39:\"wp-admin/css/colors/sunrise/colors.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"5692871a8a7a1914ee0968ddf9923dec\";}s:31:\"wp-admin/css/colors/_admin.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"bd2094e9dc3209e839476eba00ff5838\";}s:32:\"wp-admin/css/colors/_mixins.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"1f5a52b31cf5aba613aa845f2db7ac9f\";}s:35:\"wp-admin/css/colors/_variables.scss\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"3ab501096b1a091972d84c85b284135a\";}s:27:\"wp-admin/css/common-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"86ccf56bbf7478ef06b2bf12e93bdc3c\";}s:31:\"wp-admin/css/common-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"57d1d231d84d16e1068f6af8219c16bb\";}s:23:\"wp-admin/css/common.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"b1992b6de3600f82b893aa6123f2972d\";}s:27:\"wp-admin/css/common.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"19783c0c8c8225b3fc31ea04e77ee50a\";}s:39:\"wp-admin/css/customize-controls-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"9ca2f97b97f33e072814772948ad051a\";}s:43:\"wp-admin/css/customize-controls-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"cdf5f4bb049f63d0c102eefe106595e5\";}s:35:\"wp-admin/css/customize-controls.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"318c49f14d9f92f62bb45641cb3f9eb5\";}s:39:\"wp-admin/css/customize-controls.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"1d8632e98daf0718d1b0998b432d48cc\";}s:40:\"wp-admin/css/customize-nav-menus-rtl.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"bf33fe1e46d08e362ea08a9cff9c428a\";}s:44:\"wp-admin/css/customize-nav-menus-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"0aca5fc957d7d65b7dc908967df8d2c1\";}s:36:\"wp-admin/css/customize-nav-menus.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"3b1a54b0ef1e4feebd577c268f3b7b56\";}s:40:\"wp-admin/css/customize-nav-menus.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"50392a954a951e46177355be44c21914\";}s:38:\"wp-admin/css/customize-widgets-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"7dd2a79d285e607be1ac31534fa8c6f1\";}s:42:\"wp-admin/css/customize-widgets-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"bc6035ebcc286399ae80c63933562faa\";}s:34:\"wp-admin/css/customize-widgets.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"49f0ad63a90d6cf3146aef5f705361ad\";}s:38:\"wp-admin/css/customize-widgets.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"b8abf8533b9e8ed351e6f32b2b2e49c8\";}s:30:\"wp-admin/css/dashboard-rtl.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"d3c3fcc9f814d55d40f611bf5680e0b6\";}s:34:\"wp-admin/css/dashboard-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"85d54bb343a31b620a1af2d429fc5436\";}s:26:\"wp-admin/css/dashboard.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"ede40a4a2c18bee8b93c01f7e55245a8\";}s:30:\"wp-admin/css/dashboard.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"151dfe98fe81cf303ddd51228ac6f3d0\";}s:37:\"wp-admin/css/deprecated-media-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"071db78449e52b5a8e4f74881f45ca76\";}s:41:\"wp-admin/css/deprecated-media-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"ac5bc02b710e35115cadca960308560c\";}s:33:\"wp-admin/css/deprecated-media.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"2257f52a92d7817195c7ea9659345ec0\";}s:37:\"wp-admin/css/deprecated-media.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"b1cc8030eb9a806f2fa3a4aeecdac87c\";}s:25:\"wp-admin/css/edit-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"6f48ef6a45393efdfdfbe8f8ed6a2506\";}s:29:\"wp-admin/css/edit-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"a72bd32f3d21c3fcda385af3e8bff5e3\";}s:21:\"wp-admin/css/edit.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"0902edb1b33e62df3b89e42ee0fb9284\";}s:25:\"wp-admin/css/edit.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"36beba49ddd70365704e68b6641cab63\";}s:31:\"wp-admin/css/farbtastic-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"118f1189ffbb71e014402121b5456bc2\";}s:35:\"wp-admin/css/farbtastic-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"1a884c09637a47af300c7e6c3057ddc2\";}s:27:\"wp-admin/css/farbtastic.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"f9e33829b8faed7d7bbef843fb683255\";}s:31:\"wp-admin/css/farbtastic.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"30996981c129bd331b5cdbb88a2fa23b\";}s:26:\"wp-admin/css/forms-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"195f55f6344af6ab4483de40fcaf6d46\";}s:30:\"wp-admin/css/forms-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"7ee4c4a582042409d1324354271dd33a\";}s:22:\"wp-admin/css/forms.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"70fa643d71370cbaafe974ad9ca04569\";}s:26:\"wp-admin/css/forms.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"ecb1fcf9fd153be961a297b91d5dbfe5\";}s:23:\"wp-admin/css/ie-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"12e3799f007d1876b12835d0e5ef2f52\";}s:27:\"wp-admin/css/ie-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"29628f240ceb396ef0b56da19cf30f8c\";}s:19:\"wp-admin/css/ie.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"a86bc93cbddb1a2b44fb30a46f66a8ad\";}s:23:\"wp-admin/css/ie.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"3ad10e15b536d246988e4107372192ad\";}s:28:\"wp-admin/css/install-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"9c9f28632838146ea5b1f9de9ac289c8\";}s:32:\"wp-admin/css/install-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"97e4d5c63a4bd3a4f073bba5dcab8ca6\";}s:24:\"wp-admin/css/install.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"b5aac84283aa7183c30a25527edd3152\";}s:28:\"wp-admin/css/install.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"e95806e74d09390abc3dc7b8094cdeea\";}s:25:\"wp-admin/css/l10n-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"69b0527be5b3aa2c1644fe5fc1c34afa\";}s:29:\"wp-admin/css/l10n-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"395ebbb01f0499dc79323d9e46bf99c9\";}s:21:\"wp-admin/css/l10n.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"b5c4b8f85029fb7c84f0719f72b280ad\";}s:25:\"wp-admin/css/l10n.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"55d6b57d8020d981dd12e3308c6d326e\";}s:32:\"wp-admin/css/list-tables-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"746b23cd955a0b7107f57b83bb42eaa8\";}s:36:\"wp-admin/css/list-tables-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"703a6a20853140742564c197783d7574\";}s:28:\"wp-admin/css/list-tables.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"42d17149c8bfdd7bebab0f53091a540a\";}s:32:\"wp-admin/css/list-tables.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"1979a03e73de2bfe8aa90aad9ffd6073\";}s:26:\"wp-admin/css/login-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"94fc4b1b3b506fae95e65c01ec8060ad\";}s:30:\"wp-admin/css/login-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"2730e933c7a1a342a216a88b59090922\";}s:22:\"wp-admin/css/login.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"e98aa1f1d14fd4fd2b80d456948b6262\";}s:26:\"wp-admin/css/login.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"5986a1680538ac8e83d217027d57543f\";}s:26:\"wp-admin/css/media-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"d5fbbc80155b5414f2a4da9c852bb9c0\";}s:30:\"wp-admin/css/media-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"de0809f2c9675d09fe4f48b617a7e6a1\";}s:22:\"wp-admin/css/media.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"48babc981cf0f439a769286d6a70fd48\";}s:26:\"wp-admin/css/media.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"31bb9d767dc660883cbe4f139d4a1594\";}s:30:\"wp-admin/css/nav-menus-rtl.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"63af64ba89f768e448bab87ee0cb94da\";}s:34:\"wp-admin/css/nav-menus-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"985b33c3a44691c0e59b3b40dd5df611\";}s:26:\"wp-admin/css/nav-menus.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"5fc6ab945e28c3ec1018d27359fc6fe0\";}s:30:\"wp-admin/css/nav-menus.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"f236f953d732ffea81874f232246a427\";}s:38:\"wp-admin/css/press-this-editor-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"464da848980476cd37de1c0d7964c1e4\";}s:42:\"wp-admin/css/press-this-editor-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"143da4e979fd86e002fba6cda338cf7c\";}s:34:\"wp-admin/css/press-this-editor.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"b01941463721a9e3d36d4b4dc3781c66\";}s:38:\"wp-admin/css/press-this-editor.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"2cf3344cb737ec622532596ac21cb85f\";}s:31:\"wp-admin/css/press-this-rtl.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"de05e92e39dd7c54887e9aff05928ae2\";}s:35:\"wp-admin/css/press-this-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"d4c4155fff66945ef367f81b9f007f23\";}s:27:\"wp-admin/css/press-this.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"670d07b379f5bfad08e0625eec4699bc\";}s:31:\"wp-admin/css/press-this.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"01ae9946e7a7a08c32f1261d031c0320\";}s:30:\"wp-admin/css/revisions-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"d2bb91a5e175182fd98b92423245b886\";}s:34:\"wp-admin/css/revisions-rtl.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"0114c79d89d3e0edd14d711c868d4fd7\";}s:26:\"wp-admin/css/revisions.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"2311887a1e17b942de617ba70baeda36\";}s:30:\"wp-admin/css/revisions.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"7db5304ec20677c46bbcbd7b9e9fa350\";}s:30:\"wp-admin/css/site-icon-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"06fa2062900ec9b9561403625050c939\";}s:34:\"wp-admin/css/site-icon-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"52189e8f1862001b7bd1f5f0ed71d30a\";}s:26:\"wp-admin/css/site-icon.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"02f37c95552dc7cda5e2ca3c4ef6ac20\";}s:30:\"wp-admin/css/site-icon.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"66a5336284db6dc9874764fa8548a471\";}s:27:\"wp-admin/css/themes-rtl.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"b845e2804487a2c5a4b64938a6c431e1\";}s:31:\"wp-admin/css/themes-rtl.min.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"46c7eef970445884324c035f739ca63a\";}s:23:\"wp-admin/css/themes.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"c1abb7c12d4e54061e011ca25c524ed8\";}s:27:\"wp-admin/css/themes.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"68eb02c6dc043646186b59a360559f0f\";}s:28:\"wp-admin/css/widgets-rtl.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"52222282329f1e2ba87d9df556b9da51\";}s:32:\"wp-admin/css/widgets-rtl.min.css\";a:2:{s:1:\"d\";i:1487282289;s:1:\"h\";s:32:\"56dcc8388a67eea5a342dc00491867e4\";}s:24:\"wp-admin/css/widgets.css\";a:2:{s:1:\"d\";i:1487282287;s:1:\"h\";s:32:\"53bfa004b8ec5ed07348b9ff3e79af55\";}s:28:\"wp-admin/css/widgets.min.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"feeb10baeb29b091f5d9cd6beccc0c16\";}s:29:\"wp-admin/css/wp-admin-rtl.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"74f9dcf5ab8c92f6666ff52c699873c8\";}s:33:\"wp-admin/css/wp-admin-rtl.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"06dd9aaea22ad8c13722470196c5aab4\";}s:25:\"wp-admin/css/wp-admin.css\";a:2:{s:1:\"d\";i:1487282288;s:1:\"h\";s:32:\"bfe4bd90350018abc7c9210bfb9d2a5b\";}s:29:\"wp-admin/css/wp-admin.min.css\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"a2e2f67626ed6f9beca5306c1a16abba\";}s:30:\"wp-admin/custom-background.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"2389591e3797a7e80160beafdc1aa04e\";}s:26:\"wp-admin/custom-header.php\";a:2:{s:1:\"d\";i:1487282275;s:1:\"h\";s:32:\"137fe9c1430a98e361fc46d7e606f09e\";}s:22:\"wp-admin/customize.php\";a:2:{s:1:\"d\";i:1487282275;s:1:\"h\";s:32:\"5324cfa3af9075a6202c92cd3d3444c9\";}s:26:\"wp-admin/edit-comments.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"cd1bf88c3a453ec4ddb8505229aa54f1\";}s:31:\"wp-admin/edit-form-advanced.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"92e5f145d0a5b367e11ba4046b638040\";}s:30:\"wp-admin/edit-form-comment.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"31ad01b2ba65a4a2e631e422b2581580\";}s:27:\"wp-admin/edit-link-form.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"9069905b0515b4163c3515e985f02ea4\";}s:26:\"wp-admin/edit-tag-form.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"eb64dde4473a131424da38ad59658f08\";}s:22:\"wp-admin/edit-tags.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"82eb39e062cf43cf5c9e5f3dfe7cbcf4\";}s:17:\"wp-admin/edit.php\";a:2:{s:1:\"d\";i:1487282277;s:1:\"h\";s:32:\"55373449cc2320c57803f1f5b52b9ce9\";}s:19:\"wp-admin/export.php\";a:2:{s:1:\"d\";i:1487282273;s:1:\"h\";s:32:\"9fefc2dfafaccf4644da004bc5db0cfe\";}s:21:\"wp-admin/freedoms.php\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"8bc3b573cfbadc367148fc4439abd723\";}s:32:\"wp-admin/images/bubble_bg-2x.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"16523d5bf9efd8ca3b92e7631edfc513\";}s:29:\"wp-admin/images/bubble_bg.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"3d2cb3f7baa628c9e51a326356e72038\";}s:34:\"wp-admin/images/date-button-2x.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"2952932c246bf9828429361643a8bb63\";}s:31:\"wp-admin/images/date-button.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"979d8e2e08aada49819556950ec48ff6\";}s:27:\"wp-admin/images/loading.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"2d5b92b61674c850bff00cecaf0864ec\";}s:38:\"wp-admin/images/media-button-image.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"7ea2c9c157c38edb40b1ce62d572d5b3\";}s:38:\"wp-admin/images/media-button-music.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"eff55df37f325c5aae2f02e4d913de95\";}s:38:\"wp-admin/images/media-button-other.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"8bc6b46bc70c7c1918dce62c4fe3229c\";}s:38:\"wp-admin/images/media-button-video.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"abaac3dfd81fbf72e578f13451eae7d0\";}s:29:\"wp-admin/images/resize-2x.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"f5e118653f892606682ee9c51d0aba99\";}s:33:\"wp-admin/images/resize-rtl-2x.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"f7c99ee74014fe92541012303aaadc7d\";}s:30:\"wp-admin/images/resize-rtl.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"db9217196313c95a59d43601da19c51d\";}s:26:\"wp-admin/images/resize.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"3fba1544df24f40dde5876c8c0aec461\";}s:27:\"wp-admin/images/sort-2x.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"186e51267fca5d20b230c72d9a8983ee\";}s:24:\"wp-admin/images/sort.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"2e8acb8dee99bfbcb61bd46c486a995d\";}s:30:\"wp-admin/images/spinner-2x.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"5c1371bcb4392968647852a9c9df5d6c\";}s:27:\"wp-admin/images/spinner.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"b0a3dde331637e27aa6476d476481871\";}s:40:\"wp-admin/images/wordpress-logo-white.svg\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"19bdd97150fb43aa862d53500c44e6f7\";}s:34:\"wp-admin/images/wordpress-logo.svg\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"f34ef6259364f7ef0ccf67cd1dddc970\";}s:35:\"wp-admin/images/wpspin_light-2x.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"7def33aad959cd289d49ddf2a41f076d\";}s:32:\"wp-admin/images/wpspin_light.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"dd4e6dd268a70ce4c1c5143b1a4092dd\";}s:26:\"wp-admin/images/xit-2x.gif\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"8fb0729c541cbdc4609faf3f4ad02fc7\";}s:23:\"wp-admin/images/xit.gif\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"e5012902a358fbb96031acdcf048d7ca\";}s:19:\"wp-admin/import.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"f3ee1ef15a9a620217059a853d728d7e\";}s:35:\"wp-admin/includes/admin-filters.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"bfe9bb0d8d6d7cb717cf3e7b829fa572\";}s:27:\"wp-admin/includes/admin.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"5c7b0c8c7acd69508d8f19c3c61a71c0\";}s:34:\"wp-admin/includes/ajax-actions.php\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"f9f91f8e724e96de060b3b06bf010520\";}s:30:\"wp-admin/includes/bookmark.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"125e5914dd11e40dc55c2e1dcee8eff7\";}s:51:\"wp-admin/includes/class-automatic-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"f3d19ee4c85726b0f24cdd1f36c414f9\";}s:53:\"wp-admin/includes/class-bulk-plugin-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"a3de5fc971707b8d955b57241e263651\";}s:52:\"wp-admin/includes/class-bulk-theme-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"1eb1414c632e0bbbb647ba40a46dc11a\";}s:46:\"wp-admin/includes/class-bulk-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"2a6f637c880abc3db8b33f57bf5d5947\";}s:41:\"wp-admin/includes/class-core-upgrader.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"32238f9b19232bfb4bb4bbd9f854da9e\";}s:48:\"wp-admin/includes/class-file-upload-upgrader.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"8f161cd539b60efd6c87dc716a7c77d8\";}s:36:\"wp-admin/includes/class-ftp-pure.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"42e4621745bde04512803e8702db1152\";}s:39:\"wp-admin/includes/class-ftp-sockets.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"076ca839e8552b45a3eef558aa2b1996\";}s:31:\"wp-admin/includes/class-ftp.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"c9bed1265f9efae3736499726a7a1b2e\";}s:55:\"wp-admin/includes/class-language-pack-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282297;s:1:\"h\";s:32:\"e3e92f246fab0106917406a8b1b73395\";}s:50:\"wp-admin/includes/class-language-pack-upgrader.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"28ff8ddb3c48d106c7bc05ca5ebc8be5\";}s:34:\"wp-admin/includes/class-pclzip.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"59c701d09896cf859689dcf457597084\";}s:49:\"wp-admin/includes/class-plugin-installer-skin.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"d80ed75337db94d22047c28cc19203d6\";}s:48:\"wp-admin/includes/class-plugin-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"5df98f9427e3c54dd8650bd22751e51e\";}s:43:\"wp-admin/includes/class-plugin-upgrader.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"d6c8fab06303f985708a8a270781a024\";}s:48:\"wp-admin/includes/class-theme-installer-skin.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"4964ebdde7ca0c6151768fcde6f38953\";}s:47:\"wp-admin/includes/class-theme-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282297;s:1:\"h\";s:32:\"f3f6cd7c70fc0e10e30b885e604c5c80\";}s:42:\"wp-admin/includes/class-theme-upgrader.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"16f444cde309bc27e1387bbf775f7361\";}s:53:\"wp-admin/includes/class-walker-category-checklist.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"c54a5ffa9365b471f384a85f350f1f1b\";}s:53:\"wp-admin/includes/class-walker-nav-menu-checklist.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"bc18ab19d5f50e93b47ff0cb0ec46ebf\";}s:48:\"wp-admin/includes/class-walker-nav-menu-edit.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"86218708edbddc9b8153e350982cb301\";}s:49:\"wp-admin/includes/class-wp-ajax-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"a945f43277e7e50758d17a819a9e9dd7\";}s:48:\"wp-admin/includes/class-wp-automatic-updater.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"81097f6f3da72f42a523822a6ff7b2a6\";}s:50:\"wp-admin/includes/class-wp-comments-list-table.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"f2e4325af8637c1a0e5046070d60ec5b\";}s:46:\"wp-admin/includes/class-wp-filesystem-base.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"31a9030a07853f40e96d873dddd401c9\";}s:48:\"wp-admin/includes/class-wp-filesystem-direct.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"547828f43eeae0068c00dbffe98c03fd\";}s:48:\"wp-admin/includes/class-wp-filesystem-ftpext.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"bfb31034e27e41277316dcdb2edadfa7\";}s:52:\"wp-admin/includes/class-wp-filesystem-ftpsockets.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"950b2f460e8702c2c048ee8c00218f6b\";}s:46:\"wp-admin/includes/class-wp-filesystem-ssh2.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"e2db6060c873bccc20ca441a05ed98c9\";}s:39:\"wp-admin/includes/class-wp-importer.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"2c77f5cde4095feacac9d72f4a53053b\";}s:48:\"wp-admin/includes/class-wp-internal-pointers.php\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"e3be49879e4e749823539e234113d6ce\";}s:47:\"wp-admin/includes/class-wp-links-list-table.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"6e8478d2b29efdccdf6beab89d365f79\";}s:48:\"wp-admin/includes/class-wp-list-table-compat.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"c59822e294b33495054a4faf43919528\";}s:41:\"wp-admin/includes/class-wp-list-table.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"fc8db19ba9565c6227896b64517a741a\";}s:47:\"wp-admin/includes/class-wp-media-list-table.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"43033837e46b975ffcfa848c98f838e5\";}s:50:\"wp-admin/includes/class-wp-ms-sites-list-table.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"03e807509156ee0f2c192a95f19eb36a\";}s:51:\"wp-admin/includes/class-wp-ms-themes-list-table.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"71867ba40a0293cae97e3427f9c291a4\";}s:50:\"wp-admin/includes/class-wp-ms-users-list-table.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"5c98b065d07e6e6513cda179b5070a29\";}s:56:\"wp-admin/includes/class-wp-plugin-install-list-table.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"0a4ff918be799fa527ed9f4fb09c0e73\";}s:49:\"wp-admin/includes/class-wp-plugins-list-table.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"2a7860f1f257f35a7b59436a49a2c013\";}s:55:\"wp-admin/includes/class-wp-post-comments-list-table.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"5c34f85a05eee305eac2654e5d25e544\";}s:47:\"wp-admin/includes/class-wp-posts-list-table.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"5e5fe4b5fa51fd291aed933504451d63\";}s:41:\"wp-admin/includes/class-wp-press-this.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"206d71854660581dad7c74d5c3409a9c\";}s:37:\"wp-admin/includes/class-wp-screen.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"69af18306232fe4f032490d13f0bdaf3\";}s:40:\"wp-admin/includes/class-wp-site-icon.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"d5e883f311ae9c875822de71218c7ccc\";}s:47:\"wp-admin/includes/class-wp-terms-list-table.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"4f4a9ebb5f3b4e0b0cf5b10f38032bca\";}s:55:\"wp-admin/includes/class-wp-theme-install-list-table.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"6114525c7a92c179fc343ea2abc22c2c\";}s:48:\"wp-admin/includes/class-wp-themes-list-table.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"6fa2ac7c4dec692a6d91ed23172fe538\";}s:44:\"wp-admin/includes/class-wp-upgrader-skin.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"2787360d4f8c565e9390ce1857f401a6\";}s:45:\"wp-admin/includes/class-wp-upgrader-skins.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"eb3f151fc0a8485ae1cb1e8cb9eb7655\";}s:39:\"wp-admin/includes/class-wp-upgrader.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"22a21203ec022b637902903abd9b9993\";}s:47:\"wp-admin/includes/class-wp-users-list-table.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"8b9d4c6607ee77dea53125fa811d077e\";}s:29:\"wp-admin/includes/comment.php\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"d097ee8cf112a84ffa3e9995a3f90d58\";}s:39:\"wp-admin/includes/continents-cities.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"448b712e4f42beb00c3612990aa76686\";}s:29:\"wp-admin/includes/credits.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"7d546a1a2ac9c890aa9fd68cca4b221d\";}s:31:\"wp-admin/includes/dashboard.php\";a:2:{s:1:\"d\";i:1487282297;s:1:\"h\";s:32:\"6611ad8c214f7c86bd19cf7b982f3504\";}s:32:\"wp-admin/includes/deprecated.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"d5db1d301b72e63e55227df914cc1c58\";}s:39:\"wp-admin/includes/edit-tag-messages.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"ed872aae05bc79fde6c864edadf77c81\";}s:28:\"wp-admin/includes/export.php\";a:2:{s:1:\"d\";i:1487282294;s:1:\"h\";s:32:\"7583047b883c965c82122f649094065d\";}s:26:\"wp-admin/includes/file.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"3f59b102243f4c5246ca8efeb3e8dc62\";}s:32:\"wp-admin/includes/image-edit.php\";a:2:{s:1:\"d\";i:1487282297;s:1:\"h\";s:32:\"846816f264eaafdbcb9d22a846ba3d9c\";}s:27:\"wp-admin/includes/image.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"7d4fb31b464ed33d82ef5db977227c76\";}s:28:\"wp-admin/includes/import.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"a481a69fbe321c95e019b1841d4a2467\";}s:32:\"wp-admin/includes/list-table.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"4e7c28cca8a3462521d71d0685b2f36f\";}s:27:\"wp-admin/includes/media.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"7d270679ed284e87dd673ab01a46f28e\";}s:26:\"wp-admin/includes/menu.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"a16c328791716cce6d032b933f4c9376\";}s:32:\"wp-admin/includes/meta-boxes.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"2fa7537472d3f63f0df58c698277c7d5\";}s:26:\"wp-admin/includes/misc.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"53cea3a70e5d2f083f07cb21c270bb1a\";}s:38:\"wp-admin/includes/ms-admin-filters.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"513716c01839cd14e187066c3b191f80\";}s:35:\"wp-admin/includes/ms-deprecated.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"ba200286cd6f6d89df9a6fc2b5ab824d\";}s:24:\"wp-admin/includes/ms.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"a94dac11fa28da5b8cf3dabdb6c2f491\";}s:30:\"wp-admin/includes/nav-menu.php\";a:2:{s:1:\"d\";i:1487282300;s:1:\"h\";s:32:\"3c26dfaf6ee75ae92c75c834f942b99f\";}s:29:\"wp-admin/includes/network.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"ec21265688e995f6e36904d717f8f78d\";}s:26:\"wp-admin/includes/noop.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"d54bd098e964f2d4b0ada68bc12fb4ad\";}s:29:\"wp-admin/includes/options.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"4e0b31153baf0ce43a5de42a5ad9e060\";}s:36:\"wp-admin/includes/plugin-install.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"fdcbfd48c3440038f250caca2ad0b1f1\";}s:28:\"wp-admin/includes/plugin.php\";a:2:{s:1:\"d\";i:1487282295;s:1:\"h\";s:32:\"ceed1b36f196390263bc750c2762fc12\";}s:26:\"wp-admin/includes/post.php\";a:2:{s:1:\"d\";i:1487282291;s:1:\"h\";s:32:\"86fcc82802c89d004029c5bf3d4616b0\";}s:30:\"wp-admin/includes/revision.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"5d80c16bba97299dbcc7b5fccf715891\";}s:28:\"wp-admin/includes/schema.php\";a:2:{s:1:\"d\";i:1487282296;s:1:\"h\";s:32:\"88990cd134c53937241f0e7edb753209\";}s:28:\"wp-admin/includes/screen.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"8e197a008123886c7f810f3b8021fa0c\";}s:30:\"wp-admin/includes/taxonomy.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"362f31b73f462cedc8aaff1fd730db5b\";}s:30:\"wp-admin/includes/template.php\";a:2:{s:1:\"d\";i:1487282292;s:1:\"h\";s:32:\"8fdcc91c233ce5e0a57346b1193e8674\";}s:35:\"wp-admin/includes/theme-install.php\";a:2:{s:1:\"d\";i:1487282297;s:1:\"h\";s:32:\"f5a463f03de9a3edf530952dcb19b5ee\";}s:27:\"wp-admin/includes/theme.php\";a:2:{s:1:\"d\";i:1487282302;s:1:\"h\";s:32:\"e2353fe01cda2fd646757af6f2fac999\";}s:41:\"wp-admin/includes/translation-install.php\";a:2:{s:1:\"d\";i:1487282298;s:1:\"h\";s:32:\"09c05a716d4e845ffbf0382106fbb6ee\";}s:33:\"wp-admin/includes/update-core.php\";a:2:{s:1:\"d\";i:1487282293;s:1:\"h\";s:32:\"72420e616456b4b3ebc857931d52aa8d\";}s:28:\"wp-admin/includes/update.php\";a:2:{s:1:\"d\";i:1487282304;s:1:\"h\";s:32:\"ecdb2f3c7f51e392eed22b089932a395\";}s:29:\"wp-admin/includes/upgrade.php\";a:2:{s:1:\"d\";i:1487282290;s:1:\"h\";s:32:\"2588d9b7f8dbf165e375bdbfda28b8fe\";}s:26:\"wp-admin/includes/user.php\";a:2:{s:1:\"d\";i:1487282301;s:1:\"h\";s:32:\"4ba9ce1c16d655ab3edb412d6b6f8839\";}s:29:\"wp-admin/includes/widgets.php\";a:2:{s:1:\"d\";i:1487282303;s:1:\"h\";s:32:\"89cb4fd9847b53bd30b216d0f5d62738\";}s:18:\"wp-admin/index.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"0ddf88662108af941f0e4b43c96d345a\";}s:27:\"wp-admin/install-helper.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"6456b260aa9dece9b30431260cdb1a6c\";}s:20:\"wp-admin/install.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"aa908223a0cd501a26297232ef98c91f\";}s:24:\"wp-admin/js/accordion.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"ef3fe33d4ce12fe5254e5af1025ce70a\";}s:28:\"wp-admin/js/accordion.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"226bc149fc7a1d2d56e4530d3b685e58\";}s:26:\"wp-admin/js/bookmarklet.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"95c9ef35b76af2aceaf9d6c5958e8d43\";}s:30:\"wp-admin/js/bookmarklet.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"a91cd95baeb66d4873dbe424b75970c3\";}s:27:\"wp-admin/js/color-picker.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"05c7f6756aeac3f2cf7d276af6881826\";}s:31:\"wp-admin/js/color-picker.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"2e3a1f2a0ac299060d3c853e61d002b0\";}s:22:\"wp-admin/js/comment.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"d9e3db00dcc6ef4d4c03ff455dcb9c55\";}s:26:\"wp-admin/js/comment.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"8f3603ed0d77c4a1ae8f82dbd3159ed9\";}s:21:\"wp-admin/js/common.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"30e4449aa544e1648d23ed7c2d1a5423\";}s:25:\"wp-admin/js/common.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"adc2e2546deb48d1564f5392650d2a05\";}s:32:\"wp-admin/js/custom-background.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"f4ceff60e63046245443bc55ee7baba9\";}s:36:\"wp-admin/js/custom-background.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"351f2eef1d5033d68e8982ea86167e3f\";}s:28:\"wp-admin/js/custom-header.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"32b3005887a4cb606fecc09c756605bb\";}s:33:\"wp-admin/js/customize-controls.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"562e8a9067a62789ace0e21a1cb12efd\";}s:37:\"wp-admin/js/customize-controls.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"0e9f7464783db8eec0a3629791448575\";}s:34:\"wp-admin/js/customize-nav-menus.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"9b6fd3900a2dd88c4de0e4655f362cb3\";}s:38:\"wp-admin/js/customize-nav-menus.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"676f559c24dcc8691869e86be3cf72c0\";}s:32:\"wp-admin/js/customize-widgets.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"da08d3e88ee6525511da0ca1518fef08\";}s:36:\"wp-admin/js/customize-widgets.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"06e1b9a8b892c70e1c85d6e71a818042\";}s:24:\"wp-admin/js/dashboard.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"e6aee15ae7cbc39c41e0caa2e93ef635\";}s:28:\"wp-admin/js/dashboard.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"0dc133e28d19ed6ae18702a58a335180\";}s:28:\"wp-admin/js/edit-comments.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"eabcc0c5e7d7a437b614fab4089a6810\";}s:32:\"wp-admin/js/edit-comments.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"a219a0b276225bb3bacac8c2cb3776b4\";}s:28:\"wp-admin/js/editor-expand.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"c7d8e24f4c208108b7caf2df88d9b54a\";}s:32:\"wp-admin/js/editor-expand.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"4500034a26d73b737f761adcc7ef5c79\";}s:21:\"wp-admin/js/editor.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"7d9001aa245e6004270b0389a945df88\";}s:25:\"wp-admin/js/editor.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"0ba8d7fa20e86f60b06176c72130bc4d\";}s:25:\"wp-admin/js/farbtastic.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"a73af354a03241715d8698feea340b92\";}s:22:\"wp-admin/js/gallery.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"78cfa96506bf3965c18afa6de5b5abb6\";}s:26:\"wp-admin/js/gallery.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"4e7b25e9bc3374cf391d5a652651a277\";}s:25:\"wp-admin/js/image-edit.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"16a3cb26cb0814a231d58b38c97df814\";}s:29:\"wp-admin/js/image-edit.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"53286d003e3e19eacc26926f76c0d7df\";}s:31:\"wp-admin/js/inline-edit-post.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"b920b259910fda3187d7669d3344bbe5\";}s:35:\"wp-admin/js/inline-edit-post.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"1c76cbbb1460865658523caa86f05cba\";}s:30:\"wp-admin/js/inline-edit-tax.js\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"ec5818c45238461cbce1fee187236490\";}s:34:\"wp-admin/js/inline-edit-tax.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"dde9127de4c2995fc434b200f0dd615b\";}s:23:\"wp-admin/js/iris.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"45076064fdcbfcf9f5c8996e10ac4bc9\";}s:31:\"wp-admin/js/language-chooser.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"09e20150c7561d0330d7158f744abb4a\";}s:35:\"wp-admin/js/language-chooser.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"1d6822384a71090c74add106e4468581\";}s:19:\"wp-admin/js/link.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"1c8675dcd035cfb374f67bfcbf117a8c\";}s:23:\"wp-admin/js/link.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"f9ff4694933001933bdec2c133b2252d\";}s:28:\"wp-admin/js/media-gallery.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"d0809048874d234e35abae65dc17710a\";}s:32:\"wp-admin/js/media-gallery.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"3296d1fa20d292b002bba10490f1ba6e\";}s:27:\"wp-admin/js/media-upload.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"94b464e9b4ec6b545486af795f24016d\";}s:31:\"wp-admin/js/media-upload.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"f320174ed63de275264dcf5430c309dc\";}s:20:\"wp-admin/js/media.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"9ddd4d762d805b2c5ea458515cc5e217\";}s:24:\"wp-admin/js/media.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"9be63adbaf5a5acfdbfdd555dc19777d\";}s:23:\"wp-admin/js/nav-menu.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"f5ae9e78b47c5096b10afeb0e1e951e5\";}s:27:\"wp-admin/js/nav-menu.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"030df1f8550983eeb6f34ff46bfd8d7b\";}s:38:\"wp-admin/js/password-strength-meter.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"2847576ec45293ab96dc0030974e2629\";}s:42:\"wp-admin/js/password-strength-meter.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"1aaa74a24aef982b82498717c1d1e6d1\";}s:29:\"wp-admin/js/plugin-install.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"b606cf2ba06353b0e383e36b4bd19a30\";}s:33:\"wp-admin/js/plugin-install.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"46ac03875245e24a0d1be489b6cb4c2f\";}s:19:\"wp-admin/js/post.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"410fd99a0aca02dcf6abda8b98222d99\";}s:23:\"wp-admin/js/post.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"ede5f7e8431dbeb790e8cf9665192171\";}s:22:\"wp-admin/js/postbox.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"e3dfc3b71fefc8c6eb82df54e3460b53\";}s:26:\"wp-admin/js/postbox.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"ddfe27f4efae737b800bad96ed8a0969\";}s:25:\"wp-admin/js/press-this.js\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"f248f30a8a7d782d4e38962c8f0e6329\";}s:29:\"wp-admin/js/press-this.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"ceec025d4710581c8a0986860c8dfac9\";}s:24:\"wp-admin/js/revisions.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"4eb824b75d3e4d62bdc80a6d2a79a377\";}s:28:\"wp-admin/js/revisions.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"189a4d84349fe1f4dfa0ec48c82efb04\";}s:33:\"wp-admin/js/set-post-thumbnail.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"2b5153576d1eee4002fb7ed9e5831251\";}s:37:\"wp-admin/js/set-post-thumbnail.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"8bc5ca12fa38a607d5af2181311b7a5b\";}s:26:\"wp-admin/js/svg-painter.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"87dcfbe97f902fa77cc4a9889c827afc\";}s:30:\"wp-admin/js/svg-painter.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"a79aca561a5b87b62a710b0526a8e4bd\";}s:23:\"wp-admin/js/tags-box.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"22409605b64b334cb93f77e246e35ff5\";}s:27:\"wp-admin/js/tags-box.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"b1a623391a6e45e237c884963c3d86c5\";}s:27:\"wp-admin/js/tags-suggest.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"8be7404f47238690d2661ef0c1b03481\";}s:31:\"wp-admin/js/tags-suggest.min.js\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"5023f66fa980414e5177e9a6b29aff26\";}s:19:\"wp-admin/js/tags.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"4cc64266f1b35a86c63cc1b2c42f7306\";}s:23:\"wp-admin/js/tags.min.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"4ec2ae66360aa0edc72274ea7188309a\";}s:20:\"wp-admin/js/theme.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"ecfb55ddd7b2f7340ee501195f636afb\";}s:24:\"wp-admin/js/theme.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"64cfe6d2916c9b29264414a55f79e038\";}s:22:\"wp-admin/js/updates.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"480a9683a87eb320d33d5f6030ead6f6\";}s:26:\"wp-admin/js/updates.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"3e99508d7b8c46362f99dccd1dcf963c\";}s:27:\"wp-admin/js/user-profile.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"c5f95e8f9ced3d06d137ec7f5a12de5a\";}s:31:\"wp-admin/js/user-profile.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"c4a664eec9fe972ffa4f58a9932a6ba1\";}s:27:\"wp-admin/js/user-suggest.js\";a:2:{s:1:\"d\";i:1487282283;s:1:\"h\";s:32:\"1e33290807fa8b2829ddb0347d0a9305\";}s:31:\"wp-admin/js/user-suggest.min.js\";a:2:{s:1:\"d\";i:1487282285;s:1:\"h\";s:32:\"e089545cd7fcde5c7cd70de3a70139e1\";}s:22:\"wp-admin/js/widgets.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"db1fe8e4e2d28b34933170e7651d9c3e\";}s:26:\"wp-admin/js/widgets.min.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"0cc751acbd9d40cfe25f0a5520899326\";}s:25:\"wp-admin/js/word-count.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"7717109f8797a1b6cffcaccd2f69181f\";}s:29:\"wp-admin/js/word-count.min.js\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"997f505fc9d24a27e4939641450e96a4\";}s:33:\"wp-admin/js/wp-fullscreen-stub.js\";a:2:{s:1:\"d\";i:1487282284;s:1:\"h\";s:32:\"968528cb325471eb001fd8578a8625e5\";}s:37:\"wp-admin/js/wp-fullscreen-stub.min.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"700a94e9934c7b419dfa6790b1dc4a35\";}s:18:\"wp-admin/js/xfn.js\";a:2:{s:1:\"d\";i:1487282282;s:1:\"h\";s:32:\"e2d6eecbd774af1e2bb1a16ec117286b\";}s:22:\"wp-admin/js/xfn.min.js\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"66b227ca28f41f2e0615b04a390d5e04\";}s:21:\"wp-admin/link-add.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"a0ee0eaab7c6f32171b0215409caa2fc\";}s:25:\"wp-admin/link-manager.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"05827856dbdbaf9824e28df033399750\";}s:28:\"wp-admin/link-parse-opml.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"58436a5af6f318352bf596ab8a3f4962\";}s:17:\"wp-admin/link.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"6e4173fd43a2a01b3509c80ee984d22b\";}s:25:\"wp-admin/load-scripts.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"fa4354ef9e729a065ba4db8943962705\";}s:24:\"wp-admin/load-styles.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"2b94aa72a6e283ef7ec401b4517b9da4\";}s:25:\"wp-admin/maint/repair.php\";a:2:{s:1:\"d\";i:1487282286;s:1:\"h\";s:32:\"e180a3bb17b896e1cdccf337995bfe2f\";}s:22:\"wp-admin/media-new.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"836f9208c65682aab7681909d9a80abd\";}s:25:\"wp-admin/media-upload.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"2c227209106b2c2d1a895e1c1ab233f2\";}s:18:\"wp-admin/media.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"cef201e4c977c908c869c63503c291d1\";}s:24:\"wp-admin/menu-header.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"65613cc3462f90f6aba3d1e77f2e3698\";}s:17:\"wp-admin/menu.php\";a:2:{s:1:\"d\";i:1487282275;s:1:\"h\";s:32:\"b57270e937333a89bfc9d9a7c47da107\";}s:23:\"wp-admin/moderation.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"541242a293805952a0e22234f09d6fa9\";}s:21:\"wp-admin/ms-admin.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"9a05b49740dfcdaf4516851b623606e4\";}s:27:\"wp-admin/ms-delete-site.php\";a:2:{s:1:\"d\";i:1487282277;s:1:\"h\";s:32:\"e6aa203d65f47c11a0d7d2a25148c74f\";}s:20:\"wp-admin/ms-edit.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"16d42ff617c4a616c3bd94ba103a4582\";}s:23:\"wp-admin/ms-options.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"a21d278e00ca7dccfe3a81d4e386afa9\";}s:21:\"wp-admin/ms-sites.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"5d186224ebf4ddd0f1719c9ef4b80468\";}s:22:\"wp-admin/ms-themes.php\";a:2:{s:1:\"d\";i:1487282273;s:1:\"h\";s:32:\"521cb94b9501ca24bc495a31c66925d8\";}s:31:\"wp-admin/ms-upgrade-network.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"7cb492260f22ee53816d96be3868be6d\";}s:21:\"wp-admin/ms-users.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"4823c8667b23ca83b31bf9093647e5a2\";}s:21:\"wp-admin/my-sites.php\";a:2:{s:1:\"d\";i:1487282275;s:1:\"h\";s:32:\"368c092f440e48809a8911e362832d43\";}s:22:\"wp-admin/nav-menus.php\";a:2:{s:1:\"d\";i:1487282277;s:1:\"h\";s:32:\"3de0cb551f65ba1c311e346aadb48f14\";}s:26:\"wp-admin/network/about.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"36fd6671a5493cc8c5405621d96dea7c\";}s:26:\"wp-admin/network/admin.php\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"48f1fe3370f9d713b027655b6785e694\";}s:28:\"wp-admin/network/credits.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"a1be54253e72acd96ce6317127e5a5c0\";}s:25:\"wp-admin/network/edit.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"94b2a24a1fc9883246fc103f22818930\";}s:29:\"wp-admin/network/freedoms.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"e1af39e94239a944440ab2925393ae60\";}s:26:\"wp-admin/network/index.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"2f120ed6f644578b5179093487580794\";}s:25:\"wp-admin/network/menu.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"b59e56dfe003b948ec73c0e91f33f02d\";}s:34:\"wp-admin/network/plugin-editor.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"658cf64b77d435555ae217a5bbb1536a\";}s:35:\"wp-admin/network/plugin-install.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"132a6c9d6e2cc68d650e2fca9a015ed2\";}s:28:\"wp-admin/network/plugins.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"e4f7cdfcaddc4693fe0bcc39bb55d68a\";}s:28:\"wp-admin/network/profile.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"6874157fda181bc2866fd860d93376b9\";}s:29:\"wp-admin/network/settings.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"cb87ba3001e447facdd45609c7f15add\";}s:26:\"wp-admin/network/setup.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"ce74e43d24d9c36cd579e932ee94b152\";}s:30:\"wp-admin/network/site-info.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"c2ed12e7782bbb666f95a27b7ccf93c5\";}s:29:\"wp-admin/network/site-new.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"eace356da77d4b54dd429910ebc97348\";}s:34:\"wp-admin/network/site-settings.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"d8265010a9de203be9387850bb059590\";}s:32:\"wp-admin/network/site-themes.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"9eec8995d0cce45e7ea52ffcfb7cb19b\";}s:31:\"wp-admin/network/site-users.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"945f0ce717838b873e35239bce2876f9\";}s:26:\"wp-admin/network/sites.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"41b8afbec2335981e9b11c80dfd67b40\";}s:33:\"wp-admin/network/theme-editor.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"5e1829bf1794ce06c5ad77b7e2d17142\";}s:34:\"wp-admin/network/theme-install.php\";a:2:{s:1:\"d\";i:1487282307;s:1:\"h\";s:32:\"629704e41fc670178a4226b323b6a9ec\";}s:27:\"wp-admin/network/themes.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"8f0f14575d5640321f393a8c1b723f1f\";}s:32:\"wp-admin/network/update-core.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"95b7d47ed7134912270f8d3059100e8c\";}s:27:\"wp-admin/network/update.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"fca6110bd2f3fbd9f247540677fcf1ac\";}s:28:\"wp-admin/network/upgrade.php\";a:2:{s:1:\"d\";i:1487282305;s:1:\"h\";s:32:\"f5233ee990c50aade7c4e3ab9b4fe524\";}s:30:\"wp-admin/network/user-edit.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"030bb6ad3f1c614f7f1aa7fd27b79509\";}s:29:\"wp-admin/network/user-new.php\";a:2:{s:1:\"d\";i:1487282306;s:1:\"h\";s:32:\"df7a0edcb7994581430379db56d8d53b\";}s:26:\"wp-admin/network/users.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"458a62eda0585caa1c199c45202ec631\";}s:20:\"wp-admin/network.php\";a:2:{s:1:\"d\";i:1487282277;s:1:\"h\";s:32:\"6d5f41d6b9177d211d420aa6af3d3358\";}s:31:\"wp-admin/options-discussion.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"8f3d4d4586cdd781884c46fccb50e5db\";}s:28:\"wp-admin/options-general.php\";a:2:{s:1:\"d\";i:1487282272;s:1:\"h\";s:32:\"0e969023a07783930ba42bb765649a6c\";}s:25:\"wp-admin/options-head.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"9a616e7dd468d1c2499b90600e710da5\";}s:26:\"wp-admin/options-media.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"48b3717cabdbccde59136c4f5c0c4c60\";}s:30:\"wp-admin/options-permalink.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"b399e3f16ffbad978d7dec67adf66eb0\";}s:28:\"wp-admin/options-reading.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"240bb0db18c56a59d4873653dffd55cf\";}s:28:\"wp-admin/options-writing.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"6d8155a195b6cc0eb4287c6fc8f16c20\";}s:20:\"wp-admin/options.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"5d32e65a1fe08da8c016d7206cd2fc85\";}s:26:\"wp-admin/plugin-editor.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"0117ab168f37636e1790b4ec16a42469\";}s:27:\"wp-admin/plugin-install.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"e7d05c6607ab4ee72848e928d91a8634\";}s:20:\"wp-admin/plugins.php\";a:2:{s:1:\"d\";i:1487282272;s:1:\"h\";s:32:\"bec92256b5da659b1567d8a9b2946b3c\";}s:21:\"wp-admin/post-new.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"c964821b5784905159f63045fe5983bb\";}s:17:\"wp-admin/post.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"2307c23664d0c475a12c6010f264b926\";}s:23:\"wp-admin/press-this.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"1d59e753240ac6313ed685b34f9d50fa\";}s:20:\"wp-admin/profile.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"9184e53f96bade3e7ae7cda9eddf7a26\";}s:21:\"wp-admin/revision.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"7c7275a9483338d119c46811dcb31e17\";}s:25:\"wp-admin/setup-config.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"7717c6fdf6f5488bf9008889de8ef831\";}s:17:\"wp-admin/term.php\";a:2:{s:1:\"d\";i:1487282273;s:1:\"h\";s:32:\"38c38ac9a1cd474e528e042d8302eb00\";}s:25:\"wp-admin/theme-editor.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"64697da003ff9f76c04102fd70a78eb7\";}s:26:\"wp-admin/theme-install.php\";a:2:{s:1:\"d\";i:1487282277;s:1:\"h\";s:32:\"d23c476e1987a5298a7e26eebb26cdb2\";}s:19:\"wp-admin/themes.php\";a:2:{s:1:\"d\";i:1487282271;s:1:\"h\";s:32:\"faf7215fcd7bb25a6bbf189c9f5290d3\";}s:18:\"wp-admin/tools.php\";a:2:{s:1:\"d\";i:1487282279;s:1:\"h\";s:32:\"0c138f39d1b0711ab921c60f3b47e315\";}s:24:\"wp-admin/update-core.php\";a:2:{s:1:\"d\";i:1487282272;s:1:\"h\";s:32:\"d74641e309fad17dd4f23689087e70eb\";}s:19:\"wp-admin/update.php\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"695951f144fb833c410bdf40adde1a99\";}s:30:\"wp-admin/upgrade-functions.php\";a:2:{s:1:\"d\";i:1487282276;s:1:\"h\";s:32:\"68070de41736e57f8757648a80b9cbbb\";}s:20:\"wp-admin/upgrade.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"b2efdd003aeacd49ea8325fc923000c3\";}s:19:\"wp-admin/upload.php\";a:2:{s:1:\"d\";i:1487282281;s:1:\"h\";s:32:\"4df7f6140c4763a0be89283b79db673b\";}s:23:\"wp-admin/user/about.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"99ec00da8d914b4efd2098a3e44ebe2d\";}s:23:\"wp-admin/user/admin.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"702d5220c70456456fe9fc8cc08cc524\";}s:25:\"wp-admin/user/credits.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"d920b4fb1be2c2c780081d5b4b7de55a\";}s:26:\"wp-admin/user/freedoms.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"1ba6cbb9e2a9d3deb348997492ed692e\";}s:23:\"wp-admin/user/index.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"c8fd98f7fdd52d78bdadf74e620789fa\";}s:22:\"wp-admin/user/menu.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"a529e3d3c2bb86671fb9cc1145cf70ee\";}s:25:\"wp-admin/user/profile.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"b9fa17a9811195800079dda4b1262d03\";}s:27:\"wp-admin/user/user-edit.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"2a7a75a363b0f88f0b6d094a91ef65ea\";}s:22:\"wp-admin/user-edit.php\";a:2:{s:1:\"d\";i:1487282273;s:1:\"h\";s:32:\"a99ba184c5beeb0763f2bbd1ec040671\";}s:21:\"wp-admin/user-new.php\";a:2:{s:1:\"d\";i:1487282274;s:1:\"h\";s:32:\"ae69fb252ca6615713634832e762b91b\";}s:18:\"wp-admin/users.php\";a:2:{s:1:\"d\";i:1487282278;s:1:\"h\";s:32:\"efb27212fd5bb84071a33066b33c48aa\";}s:20:\"wp-admin/widgets.php\";a:2:{s:1:\"d\";i:1487282280;s:1:\"h\";s:32:\"4e5ce0ae9dd9a3edf508d0b159196bcc\";}s:18:\"wp-blog-header.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"edad74614d6d3fa2252c3d74ff037ac7\";}s:20:\"wp-comments-post.php\";a:2:{s:1:\"d\";i:1487282268;s:1:\"h\";s:32:\"e54cae70b7252c32c1f9c0c8c1a7d1a4\";}s:20:\"wp-config-sample.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"d1490486fc3f4965a6200256a7fe11b9\";}s:13:\"wp-config.php\";a:2:{s:1:\"d\";i:1490249827;s:1:\"h\";s:32:\"9c088134ed4c49817696d8b43e9991b5\";}s:29:\"wp-content/advanced-cache.php\";a:2:{s:1:\"d\";i:1490249288;s:1:\"h\";s:32:\"13fae91ceacd450584e43d1d9f7286d8\";}s:27:\"wp-content/cache/index.html\";a:2:{s:1:\"d\";i:1490249288;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:20:\"wp-content/index.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:36:\"wp-content/plugins/akismet/.htaccess\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"bf39be827c95ade49c322dfe231ff19c\";}s:38:\"wp-content/plugins/akismet/akismet.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"521f24065e66e95a0ab7ee15c4b5ac5c\";}s:50:\"wp-content/plugins/akismet/class.akismet-admin.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"797476461418c68def39cd161fc09ed3\";}s:48:\"wp-content/plugins/akismet/class.akismet-cli.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"2b1b0b5ac8794ac58e3b914d2a5b47bd\";}s:51:\"wp-content/plugins/akismet/class.akismet-widget.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"bfd9b1a0ca7a06ba0f50d9bce1bcef53\";}s:44:\"wp-content/plugins/akismet/class.akismet.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"e84c8c51ac0fa6b0441a5944474e5b8a\";}s:36:\"wp-content/plugins/akismet/index.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"cf6895af2050eb5ae7c0badda2604566\";}s:38:\"wp-content/plugins/akismet/LICENSE.txt\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"b234ee4d69f5fce4486a80fdaf4a4263\";}s:37:\"wp-content/plugins/akismet/readme.txt\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"86561f745e92bfa939c40d246487efc5\";}s:43:\"wp-content/plugins/akismet/views/config.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"8d6e3150ad11a1edecc35496896a29b3\";}s:40:\"wp-content/plugins/akismet/views/get.php\";a:2:{s:1:\"d\";i:1490250212;s:1:\"h\";s:32:\"4efd5e1b3f2cda93bc66b7102f8791ad\";}s:43:\"wp-content/plugins/akismet/views/notice.php\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"0c4d0e2370192569d8b87f68f2cc9daf\";}s:42:\"wp-content/plugins/akismet/views/start.php\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"2ac9e400453c71d4217934e62fd3b045\";}s:42:\"wp-content/plugins/akismet/views/stats.php\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"a1adcd419f461e8902969a68e215d060\";}s:38:\"wp-content/plugins/akismet/wrapper.php\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"15fcd56c524b76c2e2470a2eed3426f4\";}s:43:\"wp-content/plugins/akismet/_inc/akismet.css\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"9d46e75152f76766188361ac195089e7\";}s:42:\"wp-content/plugins/akismet/_inc/akismet.js\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"3272b57a8958c7072a1b1a9c62cbeaf6\";}s:39:\"wp-content/plugins/akismet/_inc/form.js\";a:2:{s:1:\"d\";i:1490250213;s:1:\"h\";s:32:\"270f0cd7341bce6c2afacf2682e7690e\";}s:60:\"wp-content/plugins/better-wp-security/better-wp-security.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"81ba2eebcb0a2892348135919f85dabe\";}s:68:\"wp-content/plugins/better-wp-security/core/admin-pages/css/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:68:\"wp-content/plugins/better-wp-security/core/admin-pages/css/style.css\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"b39bb2da5d277366e47cf9ca2760a646\";}s:64:\"wp-content/plugins/better-wp-security/core/admin-pages/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:63:\"wp-content/plugins/better-wp-security/core/admin-pages/init.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"ddd383bda36ccc72b838681a223dfd40\";}s:67:\"wp-content/plugins/better-wp-security/core/admin-pages/js/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:67:\"wp-content/plugins/better-wp-security/core/admin-pages/js/script.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"da09d37ac425f4843773552708d8dd5e\";}s:74:\"wp-content/plugins/better-wp-security/core/admin-pages/module-settings.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"66a9cf4298697564cf18658b1ccbf730\";}s:70:\"wp-content/plugins/better-wp-security/core/admin-pages/page-go-pro.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"09e7587c3929aa53201bf7f0c62b1c7e\";}s:68:\"wp-content/plugins/better-wp-security/core/admin-pages/page-logs.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"9277364a54aa5b8bdcc6c7217eb17c6d\";}s:78:\"wp-content/plugins/better-wp-security/core/admin-pages/page-security-check.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"e2debdd7a0b1c2154239264bef6f683f\";}s:72:\"wp-content/plugins/better-wp-security/core/admin-pages/page-settings.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"16524985a98143c60a13e71e0718e389\";}s:73:\"wp-content/plugins/better-wp-security/core/admin-pages/sidebar-widget.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"168ff582a863841c2410749ec954f737\";}s:63:\"wp-content/plugins/better-wp-security/core/class-itsec-core.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"12980e78df7127702528eb3d49c2bc2c\";}s:64:\"wp-content/plugins/better-wp-security/core/class-itsec-files.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"9ffce8fbaf2a4427f1c64e8d58600624\";}s:62:\"wp-content/plugins/better-wp-security/core/class-itsec-lib.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"4bfd7ff27dc43cd2b16ac0281b499dd9\";}s:66:\"wp-content/plugins/better-wp-security/core/class-itsec-lockout.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"73161da5c670dbbdd58b07dd00972bc2\";}s:74:\"wp-content/plugins/better-wp-security/core/class-itsec-logger-all-logs.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"a3a4f82c5f8d28ef0e2ad48c0ae19b1d\";}s:65:\"wp-content/plugins/better-wp-security/core/class-itsec-logger.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"0d48ce9ed7e89dfd786eecb36c867cb1\";}s:66:\"wp-content/plugins/better-wp-security/core/class-itsec-modules.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"820b2b68daf64b26443703829ec882c7\";}s:65:\"wp-content/plugins/better-wp-security/core/class-itsec-notify.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"70348089bd9655c09312541a3bb59ed2\";}s:67:\"wp-content/plugins/better-wp-security/core/class-itsec-response.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"3f811caa626896a50b7541d589b7eb1a\";}s:64:\"wp-content/plugins/better-wp-security/core/class-itsec-setup.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"98d6825b1b45218657f00b4387992ce7\";}s:56:\"wp-content/plugins/better-wp-security/core/css/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:58:\"wp-content/plugins/better-wp-security/core/css/ithemes.css\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"bd8a02949ed7e6720d7632381e197c7f\";}s:63:\"wp-content/plugins/better-wp-security/core/css/itsec_notice.css\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"947a391c9eef4d20abc01677e5e7ac0a\";}s:54:\"wp-content/plugins/better-wp-security/core/history.txt\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"4e8be45163bc851ba3c5e3829e5be93e\";}s:56:\"wp-content/plugins/better-wp-security/core/img/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:52:\"wp-content/plugins/better-wp-security/core/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:71:\"wp-content/plugins/better-wp-security/core/js/admin-dashboard-footer.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"d1ea81a598b60670cd986f8e621ce017\";}s:64:\"wp-content/plugins/better-wp-security/core/js/admin-dashboard.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"699b0e443a57f28d7a3e669d640d40ed\";}s:70:\"wp-content/plugins/better-wp-security/core/js/admin-global-settings.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"cd77355904d3c8c275c20a04a333c23e\";}s:59:\"wp-content/plugins/better-wp-security/core/js/admin-logs.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"69ffc55192426976cbf0f4883c1ca4da\";}s:60:\"wp-content/plugins/better-wp-security/core/js/admin-modal.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"b9c2a320342943bd484d3a4aeee105b7\";}s:55:\"wp-content/plugins/better-wp-security/core/js/index.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:61:\"wp-content/plugins/better-wp-security/core/js/itsec-notice.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"4f566a5505d833da48dc12c6a4829f68\";}s:57:\"wp-content/plugins/better-wp-security/core/js/tracking.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"af44ef090dd429c67ab3c5b0ca0fa42b\";}s:52:\"wp-content/plugins/better-wp-security/core/js/url.js\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"599383847667e2d1ca51a959143ed207\";}s:82:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-canonical-roles.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"bf1949203de034c4a473d48ead1d7557\";}s:78:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-config-file.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"c6ca49b6f252e6d8bd13e85e85ba7fc4\";}s:76:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-directory.php\";a:2:{s:1:\"d\";i:1490249542;s:1:\"h\";s:32:\"4d4f1b066f49ebc32fcbe64aa085459e\";}s:71:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-file.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"b4a8cb9ad1e22fcffed51407fc5e27f1\";}s:75:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-ip-tools.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"063d67ff83ad8fef9fd338a2ee6b470a\";}s:80:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-user-activity.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"b0c9412c752b4ece86343f3149d90cca\";}s:74:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-utility.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"8bc34d223963271816c2039d101b2482\";}s:67:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-mail.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"3fe560fef9266819b1389c4d55ec4449\";}s:76:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-wp-list-table.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ad12b4ee76a173a953b5a0e00b336a4e\";}s:55:\"wp-content/plugins/better-wp-security/core/lib/form.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"691ddb72a67b1db0e0eac534bca0e461\";}s:56:\"wp-content/plugins/better-wp-security/core/lib/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:73:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:75:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matcher.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"84af90d45b02b4aebb56b6daa5365005\";}s:94:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/adjacency_graphs.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"8356304eeac40cad828d60541d6db56d\";}s:87:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/bruteforce.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"8392275eab9b12ee882735d31b87742f\";}s:81:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/date.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"d6a64fa98e47b4de2e2b1daf403ffab7\";}s:92:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/dictionary-l33t.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"cc1528101249e33ae18939affd99c927\";}s:95:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/dictionary-reverse.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"d9d71e3fbb263c05acb8ec15288cba70\";}s:87:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/dictionary.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"c3bf1ed7775f3cf139d0fcad1938b116\";}s:82:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:117:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-english_wikipedia.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"42fa73aa92a406b9efbf592670b82e68\";}s:112:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-female_names.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"02e3637d6b2ae4d274b04143f848f7ff\";}s:110:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-male_names.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"eb51073fa15d848c2baec964c1018783\";}s:109:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-passwords.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"33489e40438216c322e39d5a94dbcf8f\";}s:108:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-surnames.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"1969159e260d1803c60221435efefab3\";}s:114:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/ranked_frequency_list-us_tv_and_film.json\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"5bd1dedf66e3c399e34fcde3c84d9a15\";}s:82:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/regex.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"76c62680768549048c6547dac48baf27\";}s:83:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/repeat.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"3636f4fae786dadbe04978747bec1d62\";}s:85:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/sequence.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"fe4372758f485830201f90555da65a26\";}s:84:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/matchers/spatial.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"4d8742098890a1eb01fa11725e7b8447\";}s:73:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/readme.md\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"9665a459a076a1053789f9e1afd972ee\";}s:75:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/results.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"e6c561d67a5014d00c29bceb19be0865\";}s:74:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/scorer.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"fff34c2fa72523baa0726e43f9f4aa33\";}s:74:\"wp-content/plugins/better-wp-security/core/lib/itsec-zxcvbn-php/zxcvbn.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"aec159ed25a823e204be65376cb3c120\";}s:78:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/details-box.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"c58288b0f79eed865b00c4477fa5f25d\";}s:74:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/divider.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"69fea9f654e704de91c739e154a643f4\";}s:73:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/footer.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"aad6cdc607b45a431d46ba53e03013e8\";}s:73:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/header.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ba4febc0d7c786f274ed1f5f32c9ecca\";}s:71:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:75:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/info-box.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"562b8d7d6c93aa2d334da71aa258e30d\";}s:77:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/large-text.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"971e88ee5b5f32b26b54591b9f819373\";}s:81:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/lockouts-entry.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"81f35669878e14712e0652cf90d8c8aa\";}s:83:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/lockouts-summary.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"cef7690c7e740d1734a9fb5a146e0ce2\";}s:81:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/lockouts-table.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a3eef1d94fc74efc0d91b320140a77cc\";}s:80:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/module-button.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"3da7972b860899d4c6dcc9a3e52bff1d\";}s:78:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/pro-callout.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a990380eb3964f870956d112588b1f99\";}s:92:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/section-heading-with-icon.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"80d3d98406c4fff418c5147dea22b04c\";}s:82:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/section-heading.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"de5e87c6edcc301169a54ae0ce8e724a\";}s:71:\"wp-content/plugins/better-wp-security/core/lib/mail-templates/text.html\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"689213ddb85cc67292bf97407d13e0db\";}s:59:\"wp-content/plugins/better-wp-security/core/lib/settings.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"aa7f70f2d5669b9861d5d5102ed769d5\";}s:58:\"wp-content/plugins/better-wp-security/core/lib/storage.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"28c03ab301135150e1cf3f7724478521\";}s:60:\"wp-content/plugins/better-wp-security/core/lib/validator.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"5bb4f2ca72d30f28694e0c3e41e2df5a\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/404-detection/active.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"abec57c33b2e219578cc0b990f4d1294\";}s:97:\"wp-content/plugins/better-wp-security/core/modules/404-detection/class-itsec-four-oh-four-log.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"f729573f11f97375cc6e8a8af9f7cf38\";}s:93:\"wp-content/plugins/better-wp-security/core/modules/404-detection/class-itsec-four-oh-four.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"c51ee85ed14f881325d1d9ab58f51bbf\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/404-detection/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:89:\"wp-content/plugins/better-wp-security/core/modules/404-detection/js/admin-four-oh-four.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"45b5ac6b844b96ee18e5500a6dd80678\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/404-detection/js/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/404-detection/settings-page.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"09600640c67a0ff5a80bc2cc2840efc3\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/404-detection/settings.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"3664985c382f9e2ea41e85a4d8b36e6d\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/404-detection/setup.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"3d5778b215bb103e09377c28e72c7d91\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/404-detection/validator.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"d763a77f07ebff4bc777078997b9db38\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/admin-user/active.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ce407ff5715c837d02b1aba7975bf512\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/admin-user/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:84:\"wp-content/plugins/better-wp-security/core/modules/admin-user/js/admin-admin-user.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"1fd96f3c6412b0b509c8f23d9634f1b5\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/admin-user/js/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/admin-user/settings-page.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"70b64fb07c4283abbffb7fedce52a7e2\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/admin-user/settings.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"6fa14f0d7541ba8254214690a42ae52c\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/admin-user/validator.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"55f77172621935674a10d29b43050e2b\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/away-mode/active.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"8b9ae6232add0a837d0a665f09483a05\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/away-mode/class-itsec-away-mode.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"bf0c556b0b2a6ff5aa280073f316476e\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/images/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/jquery-ui.min.css\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"fd1ff820fcf875772e26f0260a0b4d9d\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/jquery.datepicker.css\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a995cff531fa79ab6d80037723a61c42\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/away-mode/deactivate.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"0ebdc54a6221d5f12d06e91c8e4bb956\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/away-mode/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/away-mode/js/admin-away-mode.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"7ec5147185ec4df40a7fde2265607ec0\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/away-mode/js/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/away-mode/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"342617b5ab055d48ba894360a3febc0e\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/away-mode/settings-page.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"c03517b81097dce3cfc1e317f2712f44\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/away-mode/settings.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"2cd45719dca2e27b169df9c29bd1ecab\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/away-mode/setup.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"bcefac71b1a9419bb511be4dfc6edce8\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/away-mode/sync-verbs/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:95:\"wp-content/plugins/better-wp-security/core/modules/away-mode/sync-verbs/itsec-get-away-mode.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"522a0d8b81e8a2419e1c83dc07f9b773\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/away-mode/sync-verbs/itsec-override-away-mode.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"696cd11557267a5e7b9bb0ac5a34a53d\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/away-mode/utilities.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"2551f32eb32f0d52d03a2be388fbe5be\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/away-mode/validator.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"b83dd7ebc62aeb4310226155f0031f41\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/backup/active.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ada70bb4e028b23240df0efa7dbb671c\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/backup/class-itsec-backup.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a0e402a630d50e37f5e63531660c1916\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/backup/css/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/backup/css/multi-select.css\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"8317a4491407795d85521c820897dbff\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/backup/css/settings-page.css\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"df094aa33aa28949d58ae15d0c45bedb\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/backup/img/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/backup/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/backup/js/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:83:\"wp-content/plugins/better-wp-security/core/modules/backup/js/jquery.multi-select.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"1a0dd3138876ec438b3ff0bb93752209\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/backup/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"55b88116dde00e57a7633fbf2912ab49\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/backup/settings-page.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"82d6cec15d227806861caf4879f65eba\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/backup/settings.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"1d50857aa012e4eaa488bc67264e6259\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/backup/setup.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"4792f9fcf6e354c74b4b8244466788dc\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/backup/validator.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"39fc2e6e08bd7cbf7a5c51c6ffb2b3fd\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/ban-users/activate.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"801124f95930f49eca073618b760188c\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/ban-users/active.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"b86621b40a86330cb4c4b3c327668051\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/ban-users/class-itsec-ban-users.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"5ee50afb675c3b1efbcaa9b1c873f02b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/ban-users/config-generators.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"925f5cb254d0c2658d061de74409cc06\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/ban-users/deactivate.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"00fc522a16fad1e431ca003e3a6d9566\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/ban-users/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/ban-users/init.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"cb36189ae26353203fd28aa54f13796d\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/ban-users/js/admin-ban_users.js\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a25c79323346673ea6b30b10fa1d91e5\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/ban-users/js/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-apache.inc\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ce47acd2c9e97963881c01454d10a189\";}s:91:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-litespeed.inc\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"ce47acd2c9e97963881c01454d10a189\";}s:87:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-nginx.inc\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"c6156ce22d7de97ab7ddc1fdfe675a83\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/index.php\";a:2:{s:1:\"d\";i:1490249543;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/ban-users/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"08dd1ad13afce02aab169e05ef1531c0\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/ban-users/settings.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"fb7472e5a89d9a219f158cab66184ac4\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/ban-users/setup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"f6b57072c10a607c7493e54b2f70805a\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/ban-users/validator.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"57b7d8a2e248d83a9320c3008e4c4f83\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/brute-force/active.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"227d82506a40b25aadfd4c12c21ab9e4\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/brute-force/class-itsec-brute-force-log.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"7859ed7be3d14e8350dde2e8aab901d1\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/brute-force/class-itsec-brute-force.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"703fa661dc2e26afe6324e9c07aeb8e3\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/brute-force/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/brute-force/js/admin-brute-force.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"f8d46e51fcc0472fb880899fb50f1414\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/brute-force/js/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/brute-force/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"bfb8ad3d562e3219c3a3700f33c758a7\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/brute-force/settings.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"7699841834537531500651419741106c\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/brute-force/setup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"0fb3332c570ede669be0760e5efaab53\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/brute-force/validator.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"9b2df22dc03becbbe472476445e8f871\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/content-directory/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/content-directory/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a76217adcef394d9db95f2c075dff584\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/content-directory/utility.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"1b48f88106f87873b7af7d562a7ff98a\";}s:66:\"wp-content/plugins/better-wp-security/core/modules/core/active.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"8ee72ab5d6f447ea73bcbed0b559766d\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/core/class-itsec-core-admin.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"d3bd2d87dedb30d8d4c58fd1f7b0c3e6\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/core/img/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/core/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/core/js/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/core/js/mc-validate.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"da377be172ed4b9322260112887f5b62\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/core/settings.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"356445a023a052f59f950c618bf191db\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/core/setup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"0b36ef1d810adb292113e52793ca0e01\";}s:98:\"wp-content/plugins/better-wp-security/core/modules/core/sidebar-widget-backupbuddy-cross-promo.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"b5c03cb980b8ec9b8464b58ca0123456\";}s:91:\"wp-content/plugins/better-wp-security/core/modules/core/sidebar-widget-mail-list-signup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"4850615abe7ab5b82d53b843089b8d59\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/core/sidebar-widget-pro-upsell.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"2d75c9e99a043de5c073d1a3e8e2998f\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/core/sidebar-widget-support.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"7c7db504f9a581babd7d0f02a66f349a\";}s:91:\"wp-content/plugins/better-wp-security/core/modules/core/sidebar-widget-sync-cross-promo.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"45f04c57a3c0ad305f1c4838ec33eb83\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/core/validator.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"ef1ffebcb18eb035abce6c6d53a8ffb3\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/database-prefix/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:84:\"wp-content/plugins/better-wp-security/core/modules/database-prefix/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"04bdfb16d7c5d6d005d7fa89bfdbfa37\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/database-prefix/utility.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"b087dd5e9d0ffd2346f6224977e6dd5c\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/file-change/active.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"957777c629067569779d2fa705320e0b\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/file-change/admin.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"daa55b088a7e4501620387ee2b2f8bac\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-itsec-file-change-log.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"db15d5c7eba1b8ee545519da05f5c34a\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-itsec-file-change.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"9238a15624f09c211c9b77fef7a15f8c\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/file-change/css/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/file-change/css/settings.css\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"b898e370555960d5799e2e0ceb51a1ef\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/file-change/images/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/file-change/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/admin-file-change-warning.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"892b85a2b487aeb8f07ece552a6f8924\";}s:91:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/filetree/images/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:93:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/filetree/images/spinner.gif\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"9a8269421303631316be4ab5e34870e1\";}s:84:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/filetree/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:93:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/filetree/jqueryFileTree.css\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"60f395cd20597c1609bea2fc572d3d4d\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/filetree/jqueryFileTree.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"36548e752f6a754125c83b86afed099f\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/script.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"f279b3c5267bc6b31f6e4cb52a805999\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"3cef7c8e855632707d271165c10b4f16\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/file-change/scanner.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"cc569964fd064a1f2613ee2135d1cb95\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/file-change/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"5eb98a20fbc09575e3bd4f51e0b6a29f\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/file-change/settings.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"451a946a5aa8db16d2fb07a152f0877f\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/file-change/setup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"6df291012adbb1619dee08b82c44e7c4\";}s:83:\"wp-content/plugins/better-wp-security/core/modules/file-change/sync-verbs/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:101:\"wp-content/plugins/better-wp-security/core/modules/file-change/sync-verbs/itsec-perform-file-scan.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"5e5eda6c634aec9c009fb957bb25b065\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/file-change/validator.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"744bdfabd3b53f49696f8d587a9857b6\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/file-permissions/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/file-permissions/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"924b5049a99b2fc7b280598a25f1a27b\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/file-writing/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/file-writing/settings-page.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"29f75bee246ecb8ed65417f1cf5b8734\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/file-writing/setup.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"ce407ff5715c837d02b1aba7975bf512\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/global/active.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"1d74e2babbca558340e5771e8cb3c7fc\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/global/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/global/js/index.php\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/global/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249544;s:1:\"h\";s:32:\"cb56c78b6dbe95bc1635d566a1c6f405\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/global/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"e24305bec0fc2f017763dab67340563a\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/global/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c0ddd66abf31f4b5cfd48db0820501eb\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/global/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"b0c71c8c49cf785fc0eef332f8b295a6\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/global/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"45ef4e1907e1290d1851e5546c22a29b\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"8b70beeec3ff2d7e1e172c369559e1db\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/class-itsec-hide-backend.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"5ec934a320c0dce6c1f9fe857bdae4de\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/config-generators.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"7a1243223e529a0173d7395226512154\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:83:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"575d09b9e06b6b02563b3900170c7802\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"41c0f71680f576a496be2beb7cfa619d\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"cdc5c94f6f18517fa0b46efe088099d0\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"1b74087090c4e955edc9f561b106b4e2\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"722f6b99e3a48645e3a18d2940f1cf8a\";}s:60:\"wp-content/plugins/better-wp-security/core/modules/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"aa0c83580921333d664322b693fa757b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/class-itsec-ipcheck.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a82897d52f2b25e7dd18fd92b8497be7\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"9b1d78a0554b96660d48b3e438ac1877\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c66f917a4781ac3a156b8e6e1bb246a2\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"f7eb6d20cfe18bc4211b604b72aa10dd\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"7d1ed352fd590dce562a5dee9d8f37b7\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/utilities.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"d4f962f5dad5900047cc6798e3fec9e8\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3ef6b8075c1efc155b6820979854844b\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/malware/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"ac84cbab30ae5e7bdae8274f531641d0\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-log.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"90de3268c8483641c00912db5ef61776\";}s:104:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-scan-results-template.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c705ec45a9bc5a50a431e68ddeaf34e7\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-scanner.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"34c7c8163ef2a478817176f6fe7b6647\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"1b3132759e66c3a1d0d18934132f0263\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/malware/css/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/malware/css/malware.css\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"130f95a10299b27581f05f9e122b95a0\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/malware/css/settings.css\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"130f95a10299b27581f05f9e122b95a0\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/malware/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/malware/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/malware/js/malware.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"f1a1e9af4d9efffed71bb76b97d07ad6\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/malware/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a93c0500ba0db76d423da34badee2575\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/malware/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"691b419c1421975e6dbedbce812bfdbe\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/malware/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"ea8accba63e9414b770fd2e654b71ca5\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/malware/sync-verbs/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:95:\"wp-content/plugins/better-wp-security/core/modules/malware/sync-verbs/itsec-do-malware-scan.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"5e981b0d315e8d67baaf99ce7230ea28\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/malware/sync-verbs/itsec-get-malware-scan-log.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3cd91980565a8bf142023db3473aaa02\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"15a693142b639bebe480363cf1eb4a9d\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/class-itsec-multisite-tweaks.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"fd6919df594a28cd5e2753736cebf10d\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c9e83ed2386cb0e415eb6a26d33959be\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"4f042b651ccc0e0237779a84e972266a\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"b0d1fc05a146b839c3b3df6b4ab01871\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/multisite-tweaks/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3b6cf5ffa0304d31e2fbd128547f65d6\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/pro/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/pro/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"397e91fe28c366403be29e4c5e6baaf1\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/pro/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"5a6f1078eeae438be029b115e418873c\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/salts/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"ce407ff5715c837d02b1aba7975bf512\";}s:66:\"wp-content/plugins/better-wp-security/core/modules/salts/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/salts/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"bb8917f14c87fcddf65fcc792f5bc90f\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/salts/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"7846b860564da007e3bb44eae95a7ed3\";}s:66:\"wp-content/plugins/better-wp-security/core/modules/salts/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"08088815347a2411f008bf77b2e8c573\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/salts/utilities.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"8e60dbabe8a72671114bd955cd8bdca8\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/salts/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3d6e9f7e9ff78590df02413587605b86\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/security-check/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/security-check/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/security-check/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"f9369f1250b822a96c16a9c282c7661b\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/security-check/scanner.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"35a7fd25939afcbb90a977f5781a0a2d\";}s:83:\"wp-content/plugins/better-wp-security/core/modules/security-check/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"64dea1311874d5f472c63469a5dd0db0\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/ssl/activate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"ee71fb06c2300e28351dfbfb6ae69e97\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/ssl/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"f89e1edc7be7af2e875e67c21ad8f662\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/ssl/class-itsec-ssl-admin.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"e4be18355fcc7ecbfc2eab5b7bfb5d0c\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/ssl/class-itsec-ssl.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"af020e5da6b9e8fb01ca88b35f9fa39d\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/ssl/deactivate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"148c35ecb0ee92a25117c65e280eda80\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/ssl/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/ssl/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/ssl/js/settings-page.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"eccf7c9a69dc80496f79189e336cec73\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/ssl/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"5805857285e8550d09f8ea089e0845e0\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/ssl/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3f920d710b7160f081f452adfa7428aa\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/ssl/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"0b4c9f73e19eaa67f5d6c3b6b0b51063\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/ssl/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"237941a55ec15c62219bfcfec70aa200\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"70681f1b7017ef4925ef9a99622bc21f\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/class-itsec-strong-passwords.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"617e887cbfc6b19bba6b33e6a9737c6f\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/js/script.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"d7c1f9a2057ef493ddc694a407c519ca\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"aaafecbed5f138b62fa13a6379dcc76c\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"191076abf2c891d235a00991478b863a\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"1d5b8b64c956276f95a42a04809c9b3b\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"7c1b67f73a5ff55eddfdb0cb8d7c8c9b\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/activate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c028cc2b3058437a109a177b36c40f34\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3778470393a87b7e373320ac7bd4c589\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/class-itsec-system-tweaks.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"006e9f93479c4e55a08566982da1821a\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/config-generators.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"183a24c2049a6c49eb81c264c132f9ee\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/deactivate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"64b65c1e19cf17eb91417c27b3b2426f\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/settings-page.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"3944290d703e096d127bf3083d4c7cdb\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/settings.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c13a5df1c2eb71b602e7989431ad74c8\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/setup.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"709e4d670ac738eb766fe83c16287469\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/system-tweaks/validator.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a374f065f625b90b1b1e1c0bf79ee709\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/activate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"15f144ec7d33b7ed1e3b37cfbc860a7c\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/active.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"36ac85d1fbcac8a1dd9ac999c039d3ab\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/class-itsec-wordpress-tweaks.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"cd1cc53c2c9d36c90ec399994356fcde\";}s:89:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/config-generators.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"b96dd312ad88d688cdd075f550b6c9bb\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/deactivate.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"54aa496c6107d14d119092aa0c30bab1\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:101:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/js/blankshield/blankshield.min.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"48bc9e9d8beb4a741f8a1a120b02d928\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/js/blankshield/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/js/blankshield/LICENSE\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"c23e4b477e53765c6092518e5e15643f\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/js/block-tabnapping.js\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"57ec1ebdca32e08c4ad92587d88e4313\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/js/index.php\";a:2:{s:1:\"d\";i:1490249545;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/settings-page.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"6aa1453d72aec8aac9c6e755b5fcf839\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/settings.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"7b3c562019ce0009735bb368cffc4890\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/setup.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"3e46b445f881e14f6f5ad5091ecc38a4\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/wordpress-tweaks/validator.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"33a7236102e73859f24eda5afc24d48f\";}s:75:\"wp-content/plugins/better-wp-security/core/show-multiple-version-notice.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"614ae85a21ef48d51dee055c1cc2d726\";}s:77:\"wp-content/plugins/better-wp-security/core/sidebar-widget-active-lockouts.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"1c02bd3e909a998ebb0603c70083ffa7\";}s:76:\"wp-content/plugins/better-wp-security/core/sidebar-widget-temp-whitelist.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"7c50eefeacf28e9a30c9d1532d406574\";}s:63:\"wp-content/plugins/better-wp-security/core/sync-verbs/index.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:78:\"wp-content/plugins/better-wp-security/core/sync-verbs/itsec-get-everything.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"986516639d7832316d83d68fa2f87c7e\";}s:76:\"wp-content/plugins/better-wp-security/core/sync-verbs/itsec-get-lockouts.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"a4efe2fe48feb3881c86eb5bd911a747\";}s:82:\"wp-content/plugins/better-wp-security/core/sync-verbs/itsec-get-temp-whitelist.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"946a9933fa382c55aa3dbddc6915d61b\";}s:79:\"wp-content/plugins/better-wp-security/core/sync-verbs/itsec-release-lockout.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"6457a548a8f8ffee5ea0eb53eccb639e\";}s:82:\"wp-content/plugins/better-wp-security/core/sync-verbs/itsec-set-temp-whitelist.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"6f0ae8c556a1399fba7f5c7c04887ace\";}s:49:\"wp-content/plugins/better-wp-security/history.txt\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"eaa93f86f0342f025fd96ce901b6a485\";}s:47:\"wp-content/plugins/better-wp-security/index.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"56d4439768678cd301f9a9f140f9440b\";}s:68:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/index.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.eot\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"806a53b830f29c4e1a92398a5233dbce\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.svg\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"80804bef4ecda4805e6f87f9325a77af\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.ttf\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"3638c3971bed7ade6547754a896668e8\";}s:77:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.woff\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"1849448daea1ad4ba5d53cc439b2e773\";}s:64:\"wp-content/plugins/better-wp-security/lib/icon-fonts/history.txt\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"a1314384f4d9242b5ffef5a365473efa\";}s:67:\"wp-content/plugins/better-wp-security/lib/icon-fonts/icon-fonts.css\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"07a63c161dc5e944dd1450699dd47ebb\";}s:62:\"wp-content/plugins/better-wp-security/lib/icon-fonts/index.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:61:\"wp-content/plugins/better-wp-security/lib/icon-fonts/init.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"daf9ccc98e1dd336debfd9523d34f9ce\";}s:61:\"wp-content/plugins/better-wp-security/lib/icon-fonts/load.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"7a36ea8313f8bdbd123c037f75b0e3e6\";}s:51:\"wp-content/plugins/better-wp-security/lib/index.php\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"56d4439768678cd301f9a9f140f9440b\";}s:48:\"wp-content/plugins/better-wp-security/readme.txt\";a:2:{s:1:\"d\";i:1490249546;s:1:\"h\";s:32:\"624748928b21b2a9a7527040105d05ae\";}s:57:\"wp-content/plugins/cf7-conditional-fields/admin-style.css\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"7421a5170e01a6dece4c21ac4aee4a2e\";}s:51:\"wp-content/plugins/cf7-conditional-fields/admin.php\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"53e5ed8262e13878b41d1f68adb0540b\";}s:79:\"wp-content/plugins/cf7-conditional-fields/contact-form-7-conditional-fields.php\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"75c145b76ec06a5ee34d5f9b2bd16268\";}s:55:\"wp-content/plugins/cf7-conditional-fields/js/scripts.js\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"30ac6b5f034a45e8d1e8fb51b65a52b1\";}s:61:\"wp-content/plugins/cf7-conditional-fields/js/scripts_admin.js\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"bd85a47ce25388437842dc9d1299371a\";}s:52:\"wp-content/plugins/cf7-conditional-fields/readme.txt\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"effea42d92a4eefd9a360b48e04a1e2b\";}s:51:\"wp-content/plugins/cf7-conditional-fields/style.css\";a:2:{s:1:\"d\";i:1488685806;s:1:\"h\";s:32:\"350fd6ef6446635f7a8f608434a405ec\";}s:49:\"wp-content/plugins/contact-form-7/admin/admin.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"f7e9ae9c0db70b8bb789ec582984f534\";}s:58:\"wp-content/plugins/contact-form-7/admin/css/styles-rtl.css\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"8b17904db6ac5d9f54c65aa5fc903a6f\";}s:54:\"wp-content/plugins/contact-form-7/admin/css/styles.css\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"844575c58d1ed87701088811285b8bb1\";}s:61:\"wp-content/plugins/contact-form-7/admin/edit-contact-form.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"e8013abf59d6adced363a36d261e339c\";}s:68:\"wp-content/plugins/contact-form-7/admin/includes/admin-functions.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"a4dddc6f2443cae80d5d62ad321810de\";}s:83:\"wp-content/plugins/contact-form-7/admin/includes/class-contact-forms-list-table.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"54337d6a50788ce40aeac26915e5dc80\";}s:59:\"wp-content/plugins/contact-form-7/admin/includes/editor.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"4293831fb9fe85716a165e19f3b4842f\";}s:62:\"wp-content/plugins/contact-form-7/admin/includes/help-tabs.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"eebcc317eef2ae4e005681c390d70914\";}s:66:\"wp-content/plugins/contact-form-7/admin/includes/tag-generator.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"e7a60e20449ea777124ba1c002e5acff\";}s:66:\"wp-content/plugins/contact-form-7/admin/includes/welcome-panel.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"62300c057b53b6fc5ff8cf7ebe210c44\";}s:53:\"wp-content/plugins/contact-form-7/admin/js/scripts.js\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"eec23d3c3156872154ad6d9c4a6f9bd6\";}s:59:\"wp-content/plugins/contact-form-7/admin/js/tag-generator.js\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"03c956be7a0c6a89d7d01fa60a8d9f8a\";}s:56:\"wp-content/plugins/contact-form-7/images/ajax-loader.gif\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"af962b37779a443a77ab836b3b7a93f5\";}s:59:\"wp-content/plugins/contact-form-7/includes/capabilities.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"000b3dc482620d875288f1560dfa4c36\";}s:63:\"wp-content/plugins/contact-form-7/includes/config-validator.php\";a:2:{s:1:\"d\";i:1488687371;s:1:\"h\";s:32:\"22f0cda037dc527be2ccd7d7ce401dd8\";}s:69:\"wp-content/plugins/contact-form-7/includes/contact-form-functions.php\";a:2:{s:1:\"d\";i:1490064765;s:1:\"h\";s:32:\"26df4c35c0ab5d8370424d5469c5999e\";}s:68:\"wp-content/plugins/contact-form-7/includes/contact-form-template.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"c82f5cce367a55c9cabf3c7d24bb89a9\";}s:59:\"wp-content/plugins/contact-form-7/includes/contact-form.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"314d5ff5b8c42771920940427f2fa324\";}s:57:\"wp-content/plugins/contact-form-7/includes/controller.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"623c94d6c55d84c69c559e0e19672657\";}s:61:\"wp-content/plugins/contact-form-7/includes/css/styles-rtl.css\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"a250e950adc23b5d57f692d7ba709e68\";}s:57:\"wp-content/plugins/contact-form-7/includes/css/styles.css\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"7d5d92ddcbe33c91355c20a1d35e7a95\";}s:55:\"wp-content/plugins/contact-form-7/includes/form-tag.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"c0b578e13b2bf9a2b42e683ca2cf9f16\";}s:64:\"wp-content/plugins/contact-form-7/includes/form-tags-manager.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"5a6aa47bcbeba47ad3b2fbebe4a900f2\";}s:57:\"wp-content/plugins/contact-form-7/includes/formatting.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"88fb2c00c9915f9eb4bd59b426ed910d\";}s:56:\"wp-content/plugins/contact-form-7/includes/functions.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"6dd8c83801fb910a85007cf70ffb71ce\";}s:58:\"wp-content/plugins/contact-form-7/includes/integration.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"41a61c33fbf633c5190577b4702369cb\";}s:101:\"wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/images/animated-overlay.gif\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"2b912f7c0653008ca28ebacda49025e7\";}s:87:\"wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery-ui.css\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"d172b560b073f3bc42fea160bbff96a2\";}s:91:\"wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery-ui.min.css\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"60f0405edd95e7135ec6a0bbc36d1385\";}s:93:\"wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery.ui.theme.css\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"2c238464ee5deea4320eada193f15378\";}s:60:\"wp-content/plugins/contact-form-7/includes/js/jquery.form.js\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"08a24670beb2eae7ef79a6d5ac23874b\";}s:64:\"wp-content/plugins/contact-form-7/includes/js/jquery.form.min.js\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"f448c593c242d134e9733a84c7a4d26c\";}s:56:\"wp-content/plugins/contact-form-7/includes/js/scripts.js\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"13e0e49e4df7890caaa4f213d9de9281\";}s:51:\"wp-content/plugins/contact-form-7/includes/l10n.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"5ef79d8c410f73a74c9d2ab0d8ee01b5\";}s:51:\"wp-content/plugins/contact-form-7/includes/mail.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"f620d9b91fe2465dcfb470a9323974a7\";}s:51:\"wp-content/plugins/contact-form-7/includes/pipe.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"454e28daaabb2c6840dbad4283b7f332\";}s:55:\"wp-content/plugins/contact-form-7/includes/rest-api.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"47f95898b44c8bb2b4de002c912ffa43\";}s:57:\"wp-content/plugins/contact-form-7/includes/shortcodes.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"dab6dda50b2c04ab97529faa57fd920d\";}s:57:\"wp-content/plugins/contact-form-7/includes/submission.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"9de986546907e0b3c74ddc7fba522e09\";}s:54:\"wp-content/plugins/contact-form-7/includes/upgrade.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"e1b5346d1a288ed33983b03fab31118d\";}s:57:\"wp-content/plugins/contact-form-7/includes/validation.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"d661ce6ea50e08e5156912e5b3c64d41\";}s:54:\"wp-content/plugins/contact-form-7/languages/readme.txt\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"085954261a986f5e4705d4a8a3c8f47d\";}s:45:\"wp-content/plugins/contact-form-7/license.txt\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"0e60df107d763e5ea6b906bc4c88de3a\";}s:56:\"wp-content/plugins/contact-form-7/modules/acceptance.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"d7ce9e1a8eb8e745ef5379d6cd2c67da\";}s:53:\"wp-content/plugins/contact-form-7/modules/akismet.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"c182caf18dec29fb6e82fd8bdfa86f11\";}s:54:\"wp-content/plugins/contact-form-7/modules/checkbox.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"7c08aacabf5e53b94348a0bbe02c496f\";}s:51:\"wp-content/plugins/contact-form-7/modules/count.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"5fd300bdec72498940a154f2509250bf\";}s:50:\"wp-content/plugins/contact-form-7/modules/date.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"5684ad43d143309760c0ee321b08671f\";}s:50:\"wp-content/plugins/contact-form-7/modules/file.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"136789a3a24ae7917ca47e059d9727cc\";}s:54:\"wp-content/plugins/contact-form-7/modules/flamingo.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"68d5fa7d0a44f53aece9c0a2186e0f0e\";}s:52:\"wp-content/plugins/contact-form-7/modules/hidden.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"e251b2417b5650c156c007a5e36061fe\";}s:51:\"wp-content/plugins/contact-form-7/modules/listo.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"c185874ed6cd1800c2e1871829b2eb7b\";}s:52:\"wp-content/plugins/contact-form-7/modules/number.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"15249fe324666c3d3fea08d74c68455b\";}s:50:\"wp-content/plugins/contact-form-7/modules/quiz.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"9e60e9a8636b928daf763ecdf981ea24\";}s:67:\"wp-content/plugins/contact-form-7/modules/really-simple-captcha.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"70b92e874637c1c3dac8c08eb6427ab1\";}s:55:\"wp-content/plugins/contact-form-7/modules/recaptcha.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"e15b8c94e79e3f793a835f535a87d5b3\";}s:54:\"wp-content/plugins/contact-form-7/modules/response.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"7d91ec8f29ef042caebcef6fc9048f12\";}s:52:\"wp-content/plugins/contact-form-7/modules/select.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"3e99e8d2bc05015bdc0f59aa037e8e96\";}s:52:\"wp-content/plugins/contact-form-7/modules/submit.php\";a:2:{s:1:\"d\";i:1488687372;s:1:\"h\";s:32:\"6388befd40ed1daf617368e572b0f45e\";}s:50:\"wp-content/plugins/contact-form-7/modules/text.php\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"c7f5e6fdd8390a6c7130a304b0269e01\";}s:54:\"wp-content/plugins/contact-form-7/modules/textarea.php\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"23e24458131011355d35e4d2228e0356\";}s:44:\"wp-content/plugins/contact-form-7/readme.txt\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"89652b3b5d71f9907470b8541c114a18\";}s:46:\"wp-content/plugins/contact-form-7/settings.php\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"dc176cbf97d54afcf4a1c11ceb0d785f\";}s:47:\"wp-content/plugins/contact-form-7/uninstall.php\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"56323fc8270525fd129ebacefe30a016\";}s:55:\"wp-content/plugins/contact-form-7/wp-contact-form-7.php\";a:2:{s:1:\"d\";i:1488687373;s:1:\"h\";s:32:\"b6ed880821b8e7b46b0d7e668c510501\";}s:54:\"wp-content/plugins/contact-form-7-datepicker/admin.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"7201281cb483696a12505bfb7651695d\";}s:74:\"wp-content/plugins/contact-form-7-datepicker/contact-form-7-datepicker.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"ed99b97c315fd8d33d47477f2b11088a\";}s:63:\"wp-content/plugins/contact-form-7-datepicker/datetimepicker.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"61716138c258d7c2c59ddaa8b13c16aa\";}s:73:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-sliderAccess.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"8367560b688f3f1b2e86af001988a20e\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-af.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"a02f23d5b66f10e7581fb882e0bdf317\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-bg.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"343869b366749f1451b0a6179f42efeb\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-bs.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"c9b3749956fdffeacd231fba58000f63\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-ca.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"3a3cd2649eaa99e9938429ff2075982b\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-cs.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"46ffec1ca2765fcee2c01d40138b41f0\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-da.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"8c49f5221f6179c66ee777783aa8112e\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-de.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"f3ff69db7be71cf54ab7a2ffd387c49f\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-el.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"528ecddd0446a10445a705c67da823dd\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-en-GB.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"d36fddd5a078c85b707c9afe55d8cab5\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-es.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"532dd5fa93ac3c3afeb890a585dfba80\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-et.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"25632de55d80842e87384f883ee984ec\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-eu.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"0c4cd6181dd0833cc2ca25b22999653e\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-fi.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"5560f7bdc3101ce9ad070d6f70f0c6bf\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-fr.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"b76543bff3d7bcd3095b9f48c6e6dba6\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-gl.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"8245b5526d1f4a5044cf4c173ba470ee\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-he.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"068b8228d43727837635a5c88dc5b10e\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-hr.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"27b4ca7978acdceaf364d53cfe2c638f\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-hu.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"e80f4ae0814a13770276aa14e63761cb\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-id.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"7321d252d54d82b85de57be1cb9cb444\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-it.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"6a7ab5b34b489beb7c2cf7c259854512\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-ja.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"c2daaad769c2f4387216bc8ae796ea4d\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-ko.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"01952ad2fa9dc177abbe2e1f58e06aeb\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-lt.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"b23b44998884eca222b5572c93a0a7ac\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-nl.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"ff855336ccaeb0352cb29046c7c4bbce\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-no.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"f3ea21fd63921ab170156ca498e85c5a\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-pl.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"655fd7eb87e587614a9f91be5bb2d966\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-pt-BR.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"e823347de0c6a1c136d375c96ab6f6c2\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-pt.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"fd1efae0b33904dd9073443f7f6884f9\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-ro.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"9795928f8a49eed8c57bbb51dadee43c\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-ru.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"fef030025b73ee10f614dad6a9d274e6\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-sk.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"21d8144beffbf17744afff16b50a992b\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-sr-RS.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"f15a184fcb78abab6fc772ecebde38bb\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-sr-YU.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"548bff7d3a1e35486a270f11a3ba923b\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-sv.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"3c010e04b382f721828248cb34b3ef73\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-th.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"4ce6332a10bd56a1347e1e113c2516ba\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-tr.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"63baf7bffd8cc61b9e7c19810ec5c569\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-uk.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"834d7bad81289dfdfc170455f647787b\";}s:100:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-vi.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"56b4e706cc439db86a953eb1f27f1795\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-zh-CN.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"21cc8c82b7f013b54bf14fcbbf857db8\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/i18n/jquery-ui-timepicker-zh-TW.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"8a39dd6285c99076f18a120ff62d80f7\";}s:103:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/jquery-ui-timepicker-addon.min.css\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"83f09fbb59bf59cf81372ff283e75cf2\";}s:102:\"wp-content/plugins/contact-form-7-datepicker/js/jquery-ui-timepicker/jquery-ui-timepicker-addon.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"22fbf77f6db899402d5d04eedc2c662f\";}s:77:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-blind.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"c6edc5eceb11bbdb611f6e601c9418ce\";}s:78:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-bounce.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"bb108f71d4d1e2cd23d5330c154ab646\";}s:76:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-clip.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"812d29cc0842fea1fcc712b7c748020a\";}s:76:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-drop.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"fbdb632bf512c45f5c8facb9077a0359\";}s:79:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-explode.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"53aac1a27651b0ae7a760882a07c58fe\";}s:76:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-fade.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"c688f1214e82fde439c0587a98e1d021\";}s:76:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-fold.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"b82f962e121b61d55e263879b1e85733\";}s:81:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-highlight.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"bf0389811d136c087201f6013d85ab95\";}s:79:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-pulsate.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"5cba80beb192aa6849db5d31958c587c\";}s:77:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-scale.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"0d34c2dae66d9e17ec41ceb1bb406ee1\";}s:77:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-shake.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"5ab7e3cecf16acf06d48ca2bb73b2964\";}s:77:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-slide.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"523d5680b6b63b24f5be3c35155eebc6\";}s:80:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect-transfer.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"dc656bbba39e505802a2ed78a8db746f\";}s:71:\"wp-content/plugins/contact-form-7-datepicker/js/jquery.ui.effect.min.js\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"3707abdba6a0f7543e751653a504e58e\";}s:61:\"wp-content/plugins/contact-form-7-datepicker/modules/date.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"49abbc645b94bf03c2aebea2c17e1f0b\";}s:65:\"wp-content/plugins/contact-form-7-datepicker/modules/datetime.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"a424b66939a97bcd7c1b26ecdf581551\";}s:72:\"wp-content/plugins/contact-form-7-datepicker/modules/generators/date.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"1c45e0208746c573d048cb8231dde016\";}s:76:\"wp-content/plugins/contact-form-7-datepicker/modules/generators/datetime.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"1757be41c08e88f8be341dbbb2068547\";}s:72:\"wp-content/plugins/contact-form-7-datepicker/modules/generators/time.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"88fd72ff0caeb19811aa379285ce385a\";}s:61:\"wp-content/plugins/contact-form-7-datepicker/modules/time.php\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"eef22806efa63fa6cec3b842db70a57a\";}s:55:\"wp-content/plugins/contact-form-7-datepicker/readme.txt\";a:2:{s:1:\"d\";i:1490068632;s:1:\"h\";s:32:\"47f3649ff2d260bd4835d6e7eaf6c677\";}s:59:\"wp-content/plugins/contact-form-7-style/admin/css/admin.css\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"86754f234036dcadc4b516d28a4682cf\";}s:64:\"wp-content/plugins/contact-form-7-style/admin/css/codemirror.css\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"a2617eae2b69a3d43a725d3387f35dd7\";}s:62:\"wp-content/plugins/contact-form-7-style/admin/images/gears.svg\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"7f65a50971882d75c9bf6b8ddb96c2cb\";}s:63:\"wp-content/plugins/contact-form-7-style/admin/images/paypal.svg\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"fa90774cf99780f6efdf8f65a400d8d2\";}s:61:\"wp-content/plugins/contact-form-7-style/admin/js/admin-min.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"e11ebbb05306d7e9070c0d6e519cb3ff\";}s:57:\"wp-content/plugins/contact-form-7-style/admin/js/admin.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"2c92c465ca96f51a34f021ab9dabb53b\";}s:62:\"wp-content/plugins/contact-form-7-style/admin/js/codemirror.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"5feae2dfd625d3e12070b11f2bab70aa\";}s:64:\"wp-content/plugins/contact-form-7-style/admin/js/mode/css/css.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"761d12fcb3bbf5fafa1814552e2a694f\";}s:63:\"wp-content/plugins/contact-form-7-style/admin/js/overall-min.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"97b033140b388aaab0ac5a9800ddfcd8\";}s:59:\"wp-content/plugins/contact-form-7-style/admin/js/overall.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"2b345228862470403e9f1a9532c35745\";}s:66:\"wp-content/plugins/contact-form-7-style/admin/js/quick.edit-min.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"7abbc40c4bb4b72f811f053ecd273a71\";}s:62:\"wp-content/plugins/contact-form-7-style/admin/js/quick.edit.js\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"f4e3b10f7000831fb8415013ba6d1021\";}s:63:\"wp-content/plugins/contact-form-7-style/cf7-style-match-old.php\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"49b36736ccc1a81c5da9d624db2a5e17\";}s:62:\"wp-content/plugins/contact-form-7-style/cf7-style-meta-box.php\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"74a766ab655339dbf7c7744039418fa2\";}s:53:\"wp-content/plugins/contact-form-7-style/cf7-style.php\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"df562a2b8660d6c2e335759023a325c2\";}s:57:\"wp-content/plugins/contact-form-7-style/css/admin-bar.css\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"974e026fe9a86bb85f018a82df062d8e\";}s:56:\"wp-content/plugins/contact-form-7-style/css/frontend.css\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"581393722ecc62743402540e97801eee\";}s:58:\"wp-content/plugins/contact-form-7-style/css/responsive.css\";a:2:{s:1:\"d\";i:1488685846;s:1:\"h\";s:32:\"4c7a484dea14abf84b68c05eaafd62ba\";}s:57:\"wp-content/plugins/contact-form-7-style/inc/cssparser.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"d10ab98ebb78144e70e60e44b68b608d\";}s:59:\"wp-content/plugins/contact-form-7-style/inc/editor_page.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"c849b2272715ccde87f7270c3f68ec25\";}s:63:\"wp-content/plugins/contact-form-7-style/inc/slider_meta_box.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"a4d947e0edaa1c767be9fb59467bf545\";}s:61:\"wp-content/plugins/contact-form-7-style/inc/system_status.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"a35aa41ad81eb089930576a9de899f23\";}s:58:\"wp-content/plugins/contact-form-7-style/js/frontend-min.js\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"4118c086c8e78195c85bd4d31f915ea4\";}s:54:\"wp-content/plugins/contact-form-7-style/js/frontend.js\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"27927fc3ceffe8f9b6ea1ebab194a39b\";}s:54:\"wp-content/plugins/contact-form-7-style/misc/index.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"4f7ee74a63e733bfa68fd59be80bee21\";}s:57:\"wp-content/plugins/contact-form-7-style/misc/tracking.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"1fe5cd9ef1ebc8e0632320d360e5edec\";}s:56:\"wp-content/plugins/contact-form-7-style/misc/welcome.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"18128ac3c726fe7712a4798214ae6c1d\";}s:51:\"wp-content/plugins/contact-form-7-style/options.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"403df0451ed58565182ab9d1590de72b\";}s:58:\"wp-content/plugins/contact-form-7-style/plugin-options.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"e94e6508beb22c146c1831e0bc0692ec\";}s:64:\"wp-content/plugins/contact-form-7-style/predefined-templates.php\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"244d39fe9a6a0bfced06d58640fee6ee\";}s:50:\"wp-content/plugins/contact-form-7-style/readme.txt\";a:2:{s:1:\"d\";i:1488685847;s:1:\"h\";s:32:\"6480cf1cdf8819a3ba09e5029dd50fff\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/AddRowNumberField.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"1a285b78cbec4006dcb5da3e71403b01\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/AverageField.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"351a4acc5f855977eb4b7762c14ec5d3\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/BaseTransform.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"2756d7222156584d82c1a64b2dccf1bb\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBInstallIndicator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"cf217e3753cef6ec6e54afb29666a46f\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBOptionsManager.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"85f97aab7ffc51063573ffdc28d3ab27\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBPlugin.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"05426c67eac9ef9b464ba4c0bc18ef40\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBPluginExporter.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"04d2ad98885a0f8f922ca3f000607092\";}s:80:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBPluginLifeCycle.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"cb60d94f987594e2beddb6255cbde20c\";}s:76:\"wp-content/plugins/contact-form-7-to-database-extension/CF7DBPlugin_init.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"cd7e0b885b811923dcbad844427b5a93\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/cfdb-transform-functions.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"e8879eb316d20ee97a6c7b787e84ab81\";}s:92:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBAbstractQueryResultsIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"5c3eb3d7066e0877781c6b173dabc679\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBCleanupData.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"718d590cf780626d190a79effdbd0e8e\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBCompositeEvaluator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"a27e19b6261b9267b98af76e4c130b54\";}s:76:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBDataIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"03bb2ea7158087b89a16dc0287d71379\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBDataIteratorDecorator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"f4fbae9f56dfb6b37a6881f0183ff4b5\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBDateFormatter.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"35536e8c2370aff2608c9217721b2475\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBDeobfuscate.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"5ffe8d76e1ad54e0373de14a33db2af7\";}s:67:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBDie.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"e308fbaf0e3a84f2c1f710ab2b52be64\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBErrorLog.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"7c16af697fd71cd81f975f313061d07b\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBEvaluator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"f43cbf160a3835770eb375339dd3c61a\";}s:70:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBExport.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"c9339613c329c857441603e34288c100\";}s:76:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBFilterParser.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"8de446543ddcfbb0c1a44857a4107681\";}s:76:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBFormIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"98ddf720272b00b87865204644aa78c5\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBFunctionEvaluator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"cefab170a5c51e0d6f8e7b2e5a1095e0\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBGoogleSSLiveData.js\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"268b497dfeacfe8d354038b00f3be37f\";}s:80:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBGoogleSSLiveData.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"07794a3630f275b0a298b778eeed3b2d\";}s:87:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationCalderaForms.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"46c2c0d162add99905e31b9849e6a1ba\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationCFormsII.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"ef7e87a45fb3084018e9d06f283ce763\";}s:87:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationContactForm7.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"c45a2d41b85977fe9b1f452d24e1addd\";}s:86:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationEnfoldTheme.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"dce5d92ac976ec9317648dfa09388950\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationFMS.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"e10d91f5e7541e43166c24bf5b4c62ae\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationFormidableForms.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"8ee20563ba8cda7527da423d4ffa99e6\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationFromCraft.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"9c2d6ad45d5148b9d2bc999effd19a1a\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationFSCF.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"7535cd8a932cd412c4ab4b22acb96890\";}s:87:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationGravityForms.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"977bc7c8c9f80274c5ac2b6a01aff48a\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationJetPack.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"a20108e9bb3057d3285ec5680fc41a42\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationNinjaForms.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"1305efe484dc170f199a1a3593356728\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationQuform.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"acfc97870982b2c262773ab316e77d17\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationVerySimpleContactForm.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"26fdadcf46e7d7e46d2cf0cbacfca7d8\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBIntegrationWRContactForm.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"4366026f850ca27ab777b7ea252a303f\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBMimeTypeExtensions.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"7917fbd164dbbfb26974d989fef106f4\";}s:74:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBParserBase.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"b7e1cd9ad69309c70d546dfa53951c0b\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBPermittedFunctions.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"8b542a63974e94881241547b1cbf373d\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBPostDataConverter.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"0e223340fa4b20292a91beeaf3b0f575\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBQueryResultIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"70a3d69eb087d694e9c81df8004427bd\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBQueryResultIteratorFactory.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"06335fcf6323fd6885af33c0ec124525\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBSearchEvaluator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"ffd7fdea36e8aacfe81fd45f7e6e4570\";}s:86:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortCodeContentParser.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"52d4571519ba29b0ce6f1ead50e5c8ab\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeCount.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"1714dc2e6613676b3a4af45bc7f1da0e\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeDataTable.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"4da897b7ddaa24ebdd5646e444e73cf5\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeExportUrl.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"b476a78cd3b76b34254cf5ce29902a0d\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeHtml.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"f5c2e1848170394376332a83da87a4c1\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeJson.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"5beb868d02ff794df109f8d8fac940f6\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortCodeSaveFormMakerSubmission.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"02c17ef88949ded4b0957e0616361926\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortCodeSavePostData.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"4826e6c4640b1e6b14b0f55c2c9fa2b9\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeTable.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"6c42a102b10aedb6ab97430c58dada67\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBShortcodeValue.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"8942e1784667f0e5af4fc52132e3274d\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBTransform.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"ccd1c9c5449432cbc903f0fd50ac582c\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBTransformByClassIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"c1d44b29d66ff80a6628adb9353d93f8\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBTransformByFunctionIterator.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"9e9478b58305d22646011ead3e344ede\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBTransformEndpoint.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"ffd587104b0f3a80d78d16cc70b81cd3\";}s:79:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBTransformParser.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"80e6336be2ec3b2f3310caeaacf5f873\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBValueConverter.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"1111968f75f4b57758f5e15824c5ce0a\";}s:68:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBView.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"dbb2c919ac32c7f858364c169f74f9a6\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBViewImportCsv.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"5c8798d65eeb7575f06629d7e1daf4d3\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBViewOptions.php\";a:2:{s:1:\"d\";i:1488685910;s:1:\"h\";s:32:\"a2002f9b8b13ee98057323a5dc4b51a2\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBViewShortCodeBuilder.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"0908c27d3cb9cb43113df9ffba530375\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBViewWhatsInDB.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"0ae23951e78de0e62d7db7f94929e85f\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBWpdbResultIterator.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"b423e6e55843a1edd3a7f621b61e8dc6\";}s:92:\"wp-content/plugins/contact-form-7-to-database-extension/CFDBWpdbUnbufferedResultIterator.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"6d6bf71f845793a1b497094da7a72b53\";}s:69:\"wp-content/plugins/contact-form-7-to-database-extension/composer.json\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"7209ce60dd2fde6af6c0b79ed0f453ae\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/contact-form-7-db.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"e5a7ed1069fc52f5f07fa426b6cded52\";}s:70:\"wp-content/plugins/contact-form-7-to-database-extension/CountField.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"ea5b090c7ad88a68936e58c70a22985d\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/CountInField.php\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"2b8ae881b75550ed414d98c54bc28db5\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/css/jquery-ui.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"1d353473c45ee6ac3f47622924dd7c69\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/css/misctable.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"c20f5fa612cf3b26f5e81ebc861e6fcf\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/css/paginate.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"7311e72c6cde521f15f1853cf3bb5d54\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/license-bsd.txt\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"6be0b139c13bcccd53cb26d71b9f8634\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/license-gpl2.txt\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"751419260aa954499f7abaabaa882bbe\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/css/demo_page.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"c44a3deb74de1d0bef75378b3349808d\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/css/demo_table.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"ba835dab01f1b91f93f0ee4ad2de1a4b\";}s:95:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/css/demo_table_jui.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"bd968116e9ade41f7ffde91bb8f6063a\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/css/jquery.dataTables.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"b0cfd2a97c10400d18ae40f3b97c2fa0\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/css/jquery.dataTables_themeroller.css\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"5bdd3692a1252b1403ddb7538d34fa8e\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/images/favicon.ico\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"c30dc560221bcc0645b55eff79b4741e\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/js/jquery.dataTables.js\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"051441eb8008be7093a760ee03f777ab\";}s:100:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/js/jquery.dataTables.min.js\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"f1e6c13d39826544090e00e128207edb\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/media/js/jquery.js\";a:2:{s:1:\"d\";i:1488685911;s:1:\"h\";s:32:\"1d14cd3798bc4d6aaf65dd625870723f\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/DataTables/Readme.txt\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"92288a4ab5a9a07c392bba16ec19b3d1\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/DefaultField.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"379f6c48dbebcc0bb7a968f2b6115fbd\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/DereferenceShortcodeVars.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"88e2f23a7a3bda546db123011e7b1676\";}s:62:\"wp-content/plugins/contact-form-7-to-database-extension/des.js\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"668d15e961c30f2a424369b3170f79f0\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ar.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"0cf979a0e94e611834f8426f6dfa8cde\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/bg.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"86f62139b8b5703faa35420e48039343\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ca.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"29443dc820fbacdb7f2b40c6e2098f9b\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/cs.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"ae80ecf75ba4abaa5e0f48ef9487cc00\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/da.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"541cd3b8592dbbe4e7f40ad21a0f0239\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/de.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"551187c32fea6846ef2227aef740cbb7\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/el.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"fb874a78cf1816b10039e297cc566dfb\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/es.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"b78c2da64dd0bc83d865bb3c1b9618e2\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/et.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"e9b2ed0f8a187473be4eea12620ebb43\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/fa.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"14cb6a8ca08b3e0f4175a50712f5fc40\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/fi.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"ea4bddbb3298c0b3d800e2d904b68c13\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/fr.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"445a8a111e1dc1bf55041c107ad1ba93\";}s:74:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/gl_ES.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"b3d14345cdcc1f5746069e8b851beec4\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/he.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"fbac5faedea215389f1290fb9cae5629\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/hi.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"3ad5cad628dfac17556723a01488237f\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/hr.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"921ccad44c281ef4ebd3d007ab7bc590\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/hu.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"5963cc757b045d0ea81878a80e37c5c9\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/id.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"e128bc83d866b1ada07f55136e81d4aa\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/it.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"1b2666d82dddf9687f7f1b396aa9d93c\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ka.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"3759fc44ad69cadf6bf158064f1e90c4\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/lt.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"a3767059e9b89f96ee4f135aa6729e49\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/lv.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"b6fc4d62381a9ad9eaf9e3bb74eaa5b5\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/nb.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"adad2c386d5e99b7fbe755881f052821\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/nl.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"ac5b7628b83b780a1d11633ed78f4136\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/pl.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"34576013a2a0b686b711352c558bad38\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/pt.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"1913d7b0eb1ab4bd940ad969beb774bc\";}s:74:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/pt_BR.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"6e1ba600dc07557651c92c7067bac0e6\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ro.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"69ecc83138a3ed457f56ecb2e0b5e35b\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ru.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"88a53fde15ef1b9ff6fd0f38b44a74a3\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/sk.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"3774708f463787c4a26f82004ce009d2\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/sl.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"93ac7bf83cc89d0208da0b8fffcd8bb6\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/sr.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"2952d1662379071c2d30eb86912c34e5\";}s:80:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/sr_RS@latin.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"2952d1662379071c2d30eb86912c34e5\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/sv.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"4c61116fa1ae5235bbbf5408bd76fb25\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/th.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"bb21bdb23f69c94be81ea514a7f077ed\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/tr.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"7991cc5a64d0363077614d35bdd0cf77\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/uk.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"991c1e8b0018b7fa08a11de47728d71a\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/ur.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"e0c7c1ff5a13e9dd260549588ac349bb\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/vi.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"017f1ea1b88cd286d36671cadbca1244\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/zh.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"eaf036d401598c4de2d4b15805446417\";}s:74:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/zh_TW.json\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"247783693f736d49d73c585d5f2c75db\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/dt_i18n/_README.txt\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"4910f77430151ef031faeff4ca294585\";}s:70:\"wp-content/plugins/contact-form-7-to-database-extension/ExportBase.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"5eb1e9822984293313ed6362b24bc599\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/ExportEntry.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"e5b5bab2b7e0ab708866a2ac2b01b500\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToCsvUtf16le.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"a159eb3f378cac58e72346c2c2836fa6\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToCsvUtf8.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"a44d61c96f561538316ab283f71bfc51\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToExcel.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"1795364dcc7d57391ca1681cda1a858e\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToGoogleLiveData.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"6e35b1077634f5c566d937f5823e8af8\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToHtmlTable.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"73b2fb53dc5fc6370e157ddadc920db3\";}s:80:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToHtmlTemplate.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"22e765ba7e370f12a4c365ed76c8d6da\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToIqy.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"2513b56188e56db79e51e6df8b58104c\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToJson.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"90fc00437307cddeebc09f60d93a0fe0\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToRSS.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"158d412f8af05b3537042bbabad91708\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/ExportToValue.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"c2ca059b5810eb1b9bf29f9385e3872e\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/HistogramTransform.php\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"16c17d9693bc2f60f2961267bb8b2891\";}s:93:\"wp-content/plugins/contact-form-7-to-database-extension/jquery-ui/jquery-ui-1.8.21.custom.css\";a:2:{s:1:\"d\";i:1488685912;s:1:\"h\";s:32:\"e0128ca6399a1fbb049aad4f1f1286a4\";}s:106:\"wp-content/plugins/contact-form-7-to-database-extension/languages/contact-form-7-to-database-extension.pot\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"8ed3f4f518783d2041658729a7b16328\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/languages/_README.txt\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"2f1168fa1bdf16117c16b994d785bfdb\";}s:67:\"wp-content/plugins/contact-form-7-to-database-extension/license.txt\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"4fe869ee987a340198fb0d54c55c47f1\";}s:68:\"wp-content/plugins/contact-form-7-to-database-extension/MaxField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"3d96051a169d30d8771be8382f3f51f1\";}s:68:\"wp-content/plugins/contact-form-7-to-database-extension/MinField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"0eb7e20b521d89cb17f644f7dd38b854\";}s:78:\"wp-content/plugins/contact-form-7-to-database-extension/NaturalSortByField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"6db9dd81f735a9f2a55b28af38f50c92\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/NaturalSortByMultiField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"a60d15e2f0a2235de737dfb4c3ce9ceb\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/BuildInStats_Test.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"f75684748c00f9acc2e6bf934d07d33e\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CF7DBOptionsManagerTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"06da736c9c01170f47f229b2b7aff463\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBErrorLogTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"afb8e1863b9892677312b87e43c45769\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBFilterParserTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"7f892d544d82b29246dd69f0e40ee749\";}s:104:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationCalderaFormsTest/form.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"2295089499c013c19a58464483bf826b\";}s:99:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationCalderaFormsTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ebae8da474c257fd4613330f041151f0\";}s:117:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/dataContentEmail.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"f85a2aca58e4f9edf0db941fee3214cc\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/dataForms.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b7f0b951c248913ce668f6392990e0f8\";}s:121:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/nameFileByIdentifier.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b069dbdb0d18a2da4d6c5cbf2951eada\";}s:105:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/post.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e0254cba49474be20aeb41d36064fefc\";}s:114:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/requiredField.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"607f675b4a250e427d8077e0092f8de2\";}s:116:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest/submissionsData.dat\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"d41a38c2f3d0c0595d19954e02333227\";}s:100:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBIntegrationWRContactFormTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"9a8f377d16f290eabdd76695bb1f6766\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBPermittedFunctionsTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"9e1e98a4b9f686e5a0f1aec1db11057a\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBShortCodeContentParserTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"83583dfd2d75e51d907ad846afa2f07c\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CFDBTransformParserTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"f016c7c40d44789241c6c8cb22653115\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/compoundfieldsComma.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"c267c9ad3102e80844cba5c014ac45b9\";}s:87:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/compoundfieldsPipe.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ec760447e47d1b0f676f4b19575d75ab\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/CountInField_Test.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"91520d2022f5faa95fc9f8c26e676379\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/DefaultFieldTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"652808b0f24803a9615020d249a6e77c\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/DereferenceShortcodeVarsTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"924255a3154945db3997ae9135d76d6c\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/DereferenceShortcodeVars_ExportTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"a8df0de99bf5d007317e717b93fd47a6\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/HtmlTemplateMissingFieldTest.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"5ad127110242e9ed51c479eaea84b578\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/HtmlTemplateMissingFieldTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e0fb6abf9e29af04da4a09098a20a6a5\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/HtmlTemplateTransformTest.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"3965d755c44c24375b582e6261f6bdc5\";}s:93:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/HtmlTemplateTransformTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"cc510bd5871db8c2b2c5615bb5244cf1\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/MockQueryResultIterator.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"367ea3a8bc5f45d863370ff8ac8ed59d\";}s:95:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/NaturalSortByMultiFieldTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e7fc58aea1ef3fdc1e7ac872d39755dd\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/ParseFieldMatchesTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"9e741fa9545c958c934c84edb2aee5b5\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/phpunit.xml\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ff76c66c0f98c26808b42e173bf26a0e\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/scores.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"067075e6f14e6116077258b4e3eb5b3a\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/ShiftJisConverterTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"8ab698f07785703f2bb240caa055469f\";}s:92:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/ShortCodeBeforeAfterTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"a35ab46bf460b3b982c80e56a6810a82\";}s:87:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SortByDateFieldTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"045871e55d3d4a8045adddc46f04c0df\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SortByDateField_TransformTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ca0c4817356c7c78acc8b0ec9fc058ff\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SplitFieldDefaultDelimiterTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"c3b05067d1c3809698b8243bd643be4c\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SplitFieldTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"2616730846fd118ab6337ae356a2985c\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SquashOutputUnitTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e07d1f991d5f7aa8f5156d33fcf02375\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/SummationRowTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"7e7695f39edd0b139bef7fe9f40995a1\";}s:95:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/TransformEntryFunctionTest.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"4ddfaee347cd41f543a47218926f889b\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/TransformEntryFunctionTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"fb067ee1d2b8a21cd269819dec52974e\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/TransformsTest.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ba4d0dd87b5c4bf228a6adebea897d38\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/TransformsTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"22c6e33b8dd414bad06d57af2699bcd4\";}s:84:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/UnCurlyQuoteTest.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"26cc95824131440513faf52cb495f141\";}s:74:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/votes.json\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"c8de9cff0d0cc804acae350337c9e94b\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/WPDB_Mock.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"42260f136730e845367b08213afc9145\";}s:85:\"wp-content/plugins/contact-form-7-to-database-extension/phpunit/WP_Mock_Functions.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"676089029e1920cf132615b09fca5101\";}s:65:\"wp-content/plugins/contact-form-7-to-database-extension/README.md\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"99f60e606f795bc554369b78d124f379\";}s:66:\"wp-content/plugins/contact-form-7-to-database-extension/readme.txt\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"01727ab908d77e250c75a2e39e1e1935\";}s:77:\"wp-content/plugins/contact-form-7-to-database-extension/ShiftJisConverter.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"ddc5e982a114c9d8176e3ad147f1fc29\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/ShortCodeLoader.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"49e99740b1a43b084fe9feaac3a68569\";}s:81:\"wp-content/plugins/contact-form-7-to-database-extension/ShortCodeScriptLoader.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b9d960fced6e3773d21dc9ecf80892ee\";}s:75:\"wp-content/plugins/contact-form-7-to-database-extension/SortByDateField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b26e63a72ef7f2428d677f128010aa3a\";}s:71:\"wp-content/plugins/contact-form-7-to-database-extension/SortByField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"7c3ba56fedd97e27b6b36d032058bf8f\";}s:82:\"wp-content/plugins/contact-form-7-to-database-extension/SortByFunctionAndField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b277e0dc1a141b5d8acda0dfac7518fe\";}s:76:\"wp-content/plugins/contact-form-7-to-database-extension/SortByMultiField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"5e796c31eba8c87b391803951eec1c3a\";}s:73:\"wp-content/plugins/contact-form-7-to-database-extension/SortTransform.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"91fd505b125f636f43966b732b32e3fb\";}s:70:\"wp-content/plugins/contact-form-7-to-database-extension/SplitField.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e865f3937204ec263c3565fdd07f0c80\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Autoloader/autoload.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"2b479407423dab55ae1e2ea4161634c2\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Autoloader/Psr4Autoloader.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"72651e60250a7e8d552f6a128db4ed8b\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Escaper/CSV.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"a9a1bdec7e43615be057a38edc226395\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Escaper/EscaperInterface.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"74feff1f3f17d78324f54b55bcd8022d\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Escaper/ODS.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"bfacca41b01d47f7924d39836caf03dc\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Escaper/XLSX.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"51ef926c93d89a39464cdc97941aae46\";}s:116:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Exception/EncodingConversionException.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"0190339f6704dbdb339d74863dec8340\";}s:113:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Exception/InvalidArgumentException.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"6dd8e0cc66964b5ed32b6abab2a34b10\";}s:100:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Exception/IOException.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"7b6ad91bbb6b2cabf4e6036b52d31d1d\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Exception/SpoutException.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"73992acc1136cc39e38ecfdf028852be\";}s:113:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Exception/UnsupportedTypeException.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"89ee66c9fc49599f3261c865e7f511d1\";}s:100:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Helper/EncodingHelper.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"b97e0d069461e6c1ea40675d9ac59fa2\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Helper/FileSystemHelper.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"c98e8823dc4052aa81bf1984a9af4e14\";}s:107:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Helper/GlobalFunctionsHelper.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"862763bae12d774975527f6ddbad591f\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Helper/StringHelper.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"0133e31dc6a62e1015f4ab101584bfd4\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Singleton.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"3a6f9174ed66158c58ed22d3f2da94fb\";}s:83:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Common/Type.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"dfddea7ad48b9ad62b7a756af628a614\";}s:93:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/AbstractReader.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"0b6ac4db4c14b75db24103a574bc16c1\";}s:99:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Common/ReaderOptions.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"476004a0a9d71d1001c2283c04f9bebe\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Common/XMLProcessor.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"e0de1cc9acf36d34dfc881c4b5bbcc96\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/CSV/Reader.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"28daaa100f810c4fdde8575329de58ae\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/CSV/ReaderOptions.php\";a:2:{s:1:\"d\";i:1488685913;s:1:\"h\";s:32:\"96e8224ac5cd81c04d10aab02e26469d\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/CSV/RowIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"d9cd710a3971aa22d058fc41de0663f8\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/CSV/Sheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"4eccb15f127c929501890c51fd3577f1\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/CSV/SheetIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"e0145d44ee942a782fa7ee294be28487\";}s:119:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/IteratorNotRewindableException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"e4739ab7d61c00b743e4bb1f0e5af256\";}s:111:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/NoSheetsFoundException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"7dd255691b4b9e11bdd3831672500b96\";}s:104:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/ReaderException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"c491054fb023f1c66a75fb565aab29ea\";}s:113:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/ReaderNotOpenedException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"edfecb6e7a1d104f0efc18d60a4b4137\";}s:118:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/SharedStringNotFoundException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"55e89388ea8ba5d456f96b32d629a8ca\";}s:111:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Exception/XMLProcessingException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"3d7f1205df8fb99affb448bbb7b0d3d5\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/IteratorInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"a2729b7f216bd085e56691882cf44783\";}s:108:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/Helper/CellValueFormatter.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"574a38fe5959ece29e6f124e06768e76\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/Reader.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"a9873acc6b2fa7970d7d7480f79fafa1\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/ReaderOptions.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"6d8affc2cc18eb75b130a41fd55e3d8d\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/RowIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"11296faa25311fe88d87e02bae651705\";}s:88:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/Sheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"4aea23547311370bacdeb6bd506b0d3c\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ODS/SheetIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"de36022594e709d547a1eef51897c186\";}s:92:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ReaderFactory.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"8cc27edd342a21311266c69802f77dd2\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/ReaderInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"24a44cf1c6f1d5a3acdd76fa2464a5f6\";}s:93:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/SheetInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"aa27f09ab98bd3389175a60861871804\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Wrapper/SimpleXMLElement.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"d10bf724b6dd0a6c4c57efc90d34e880\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Wrapper/XMLInternalErrorsHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"5e882a4059df9a9c27ef83634b00eabf\";}s:96:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/Wrapper/XMLReader.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"1b88d9c3a250732e9379161b7cef71b7\";}s:101:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/CellHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"15a2853fa743e9ce621b8c7ec386638b\";}s:109:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/CellValueFormatter.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"0d0fa56a5a39af6c5fb0a993b4be3964\";}s:107:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/DateFormatHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"4ca4ed0da553ef549bd771235d88b450\";}s:134:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SharedStringsCaching/CachingStrategyFactory.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"a976db065b5c66432c279dbe1da2f71e\";}s:136:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SharedStringsCaching/CachingStrategyInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"8c3164cbb61b58c61cdaf4a1c09c2f5d\";}s:129:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SharedStringsCaching/FileBasedStrategy.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"23e1e00e17d6fd14ece50254a3e6df48\";}s:128:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SharedStringsCaching/InMemoryStrategy.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"5a96387f1727b4f1ae78ef097f3c6b6a\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SharedStringsHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"36e4b1eb5bc9a1c8ee6af8dc7a1417b4\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/SheetHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"d2d52547c12c3762016f2ecb5daf5e7a\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Helper/StyleHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"b58f3d2fff54a56ecfc2c239d97c6808\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Reader.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"10da7cd953681769fb62adb2031afb56\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/ReaderOptions.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"864092b46a2af8f1b6aa74d87167e4af\";}s:95:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/RowIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"d145dbd67e3d85d6a5c1841f74eb10aa\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/Sheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"c8847d6331038d96607ef4dd94a1d42a\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Reader/XLSX/SheetIterator.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"6d8c2e628fedbc16be33b54b0f62d2da\";}s:104:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/AbstractMultiSheetsWriter.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"b8330be72982218177974578a1706e81\";}s:93:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/AbstractWriter.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"83e98e7a355d22ce852c5e44d6670b8d\";}s:112:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Helper/AbstractStyleHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"2775f9015797d13aeaae78dace3901ad\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Helper/CellHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"db709e0b9f44f9e8da1b859bf7ba3db4\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Helper/ZipHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"7f04d43854178880546d13aae828139f\";}s:111:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Internal/AbstractWorkbook.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"e1d8e1b1b21bbf3c60bb13219d025027\";}s:112:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Internal/WorkbookInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"81e31a4b1c0c63da89f0c371275d27f4\";}s:113:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Internal/WorksheetInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"1e7e4961a60a914de95a361058d430ab\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Common/Sheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"4a95e2c52fbee7479b79964846847ff4\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/CSV/Writer.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"4ab6f3877f349cf630b5fb96f32f92fd\";}s:116:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/Border/InvalidNameException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"e6eb9d751c39340591100a1049d8c476\";}s:117:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/Border/InvalidStyleException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"3c4bb65b9734ec766be9ade600aa37ae\";}s:117:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/Border/InvalidWidthException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"b6ae1f1f2a1b6b8c2656c16b72bb0c31\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/InvalidColorException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"970f5a7eab8a1d162546bedc1f2c66bc\";}s:114:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/InvalidSheetNameException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"160e2f59cf468f625f353b41637dba16\";}s:111:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/SheetNotFoundException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"2a00c7eca9ce9935670e6aa60c3dcc43\";}s:117:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/WriterAlreadyOpenedException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"35c6e98d9a40fe8899121d92fc6aac44\";}s:104:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/WriterException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"ea93300c74d9c8f93408384987cffc0f\";}s:113:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Exception/WriterNotOpenedException.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"ed1f9f00b16d53fe3aa93637e01c8858\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Helper/BorderHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"3abace1fb93ef56bd76f5be501fc502f\";}s:106:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Helper/FileSystemHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"f7224c967b740f68741baf569d4f9bdf\";}s:101:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Helper/StyleHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"5a7737ad983629844ca47a2e6fb6ab20\";}s:100:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Internal/Workbook.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"7ba5933bfb05bdf0159e2e232f03facf\";}s:101:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Internal/Worksheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"200077833f9387bf7523f1e723a049ce\";}s:89:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/ODS/Writer.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"1041fb8f8f9e21b287b250395176c266\";}s:91:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/Border.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"d59406ac87853209698157bc72f7bf60\";}s:98:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/BorderBuilder.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"8eb90972b4e13c0218e3e4228c389b2d\";}s:95:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/BorderPart.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"a8522a6446924a6beb2cf1f8d7941edc\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/Color.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"78dec37151ae7ccfd21c3f5a499e4905\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/Style.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"00c0b479baaa74ba303d4d2dac07557f\";}s:97:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/Style/StyleBuilder.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"939da6393a629c02ec2b628a512ee577\";}s:92:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/WriterFactory.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"a2a7fd1ec2e2f3548f34be701f6f82c2\";}s:94:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/WriterInterface.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"c58dde3f310b0da1d0c6496ce0c4f2eb\";}s:103:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Helper/BorderHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"e45ea02d2178a88b497c2ad42c329154\";}s:107:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Helper/FileSystemHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"eef3a7cb1e9397581c82bb1ab0474219\";}s:110:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Helper/SharedStringsHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"de22714f2a292ded5ae1c08bf7626d17\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Helper/StyleHelper.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"812487676b13c7163daac8d7e3da3470\";}s:109:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Internal/HyperlinkFormula.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"bc47e179de89c0668185b2d1f9d756ff\";}s:101:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Internal/Workbook.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"fb72d76232e066694d057322ac7b8ecc\";}s:102:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Internal/Worksheet.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"de31a4f87edbc641e428ef700b702421\";}s:90:\"wp-content/plugins/contact-form-7-to-database-extension/Spout-2.7.1/Writer/XLSX/Writer.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"c7464b3ddb1f9b6974d3aa24e6c01a03\";}s:68:\"wp-content/plugins/contact-form-7-to-database-extension/SumField.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"f7cca98a94f92a90cc7c900fac24e1d8\";}s:72:\"wp-content/plugins/contact-form-7-to-database-extension/SummationRow.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"10bd80dd99924528eeca093931af5d77\";}s:70:\"wp-content/plugins/contact-form-7-to-database-extension/TotalField.php\";a:2:{s:1:\"d\";i:1488685914;s:1:\"h\";s:32:\"5e2906c5fe0fd6ffc7b2bc5321b707e4\";}s:69:\"wp-content/plugins/contact-form-7-to-database-extension/uninstall.php\";a:2:{s:1:\"d\";i:1488685915;s:1:\"h\";s:32:\"805ad4cf4dd37d0c385c4f9660e17104\";}s:61:\"wp-content/plugins/duplicator/assets/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"4083f5d376eb849a458cc790b53ba080\";}s:54:\"wp-content/plugins/duplicator/assets/css/jquery-ui.css\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"a4670525d5133a3db3cab91742425d1c\";}s:50:\"wp-content/plugins/duplicator/assets/css/style.css\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"963c5e0d6693ccc7f259c926d3f68a45\";}s:66:\"wp-content/plugins/duplicator/assets/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"25a32416abee198dd821b0b17a198a8f\";}s:66:\"wp-content/plugins/duplicator/assets/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"d7c639084f684d66a1bc66855d193ed8\";}s:66:\"wp-content/plugins/duplicator/assets/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"1dc35d25e61d819a9c357074014867ab\";}s:67:\"wp-content/plugins/duplicator/assets/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"c8ddf1e5e5bf3682bc7bebf30f394148\";}s:68:\"wp-content/plugins/duplicator/assets/fonts/fontawesome-webfont.woff2\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"e6cf7c6ec7c2d6f670ae9d762604cb0b\";}s:58:\"wp-content/plugins/duplicator/assets/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"5dc41d8fe329a22fa1ee9225571c843e\";}s:54:\"wp-content/plugins/duplicator/assets/img/logo-menu.svg\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"186d5ff21c3436191a59662e9456f92b\";}s:57:\"wp-content/plugins/duplicator/assets/js/handlebars.min.js\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"a5dff92bc9a01f60c9986cdabb2a2129\";}s:54:\"wp-content/plugins/duplicator/assets/js/javascript.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"b091151e572e8e1a96053a05923e3759\";}s:71:\"wp-content/plugins/duplicator/assets/js/jquery.qtip/jquery.qtip.min.css\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"4d7d40f66aa66a9f8767c9981619bf10\";}s:70:\"wp-content/plugins/duplicator/assets/js/jquery.qtip/jquery.qtip.min.js\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"bd3a04e1ff2195e9c2d597fd2ed98423\";}s:65:\"wp-content/plugins/duplicator/assets/js/parsley-standalone.min.js\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"851d74cc118c0bf055e7b75054441392\";}s:55:\"wp-content/plugins/duplicator/classes/class.logging.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"749f56db9abbdb54efc0ec1b1b0b1681\";}s:56:\"wp-content/plugins/duplicator/classes/class.settings.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"04ab433545e719340f90158ceb0b8729\";}s:76:\"wp-content/plugins/duplicator/classes/package/class.pack.archive.filters.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"b3128c17ab9bd8d1c46c4eb2e8484f5d\";}s:68:\"wp-content/plugins/duplicator/classes/package/class.pack.archive.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"254e820553684f6dc267c18a85b685b6\";}s:72:\"wp-content/plugins/duplicator/classes/package/class.pack.archive.zip.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"f73110e2fae6dc684c2d3e98eb5fc05b\";}s:69:\"wp-content/plugins/duplicator/classes/package/class.pack.database.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"a6d6d338741cc8ea0e0e3054cc5f8c26\";}s:70:\"wp-content/plugins/duplicator/classes/package/class.pack.installer.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"526c0d1fc0c2cc97b32367903a7211d3\";}s:60:\"wp-content/plugins/duplicator/classes/package/class.pack.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"ac99db252a82ca8c047ea9139cf90718\";}s:60:\"wp-content/plugins/duplicator/classes/ui/class.ui.dialog.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"a8b784e06e30a718cb14d25aaeba1a2b\";}s:60:\"wp-content/plugins/duplicator/classes/ui/class.ui.notice.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"f345e989a1d69fbd61d83cb2dca60315\";}s:63:\"wp-content/plugins/duplicator/classes/ui/class.ui.viewstate.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"0833ce43099ad4dc91346572dc84d46e\";}s:60:\"wp-content/plugins/duplicator/classes/utilities/class.db.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"8dfffcfaffa04b23bff42698b9ec6b05\";}s:68:\"wp-content/plugins/duplicator/classes/utilities/class.scan.check.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"01d53c01dac69747992d02b005db9c7b\";}s:64:\"wp-content/plugins/duplicator/classes/utilities/class.server.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"be72442c71f4c127dcfeff7f3913be16\";}s:62:\"wp-content/plugins/duplicator/classes/utilities/class.util.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"14378ed93f2ab246a30a6c9c008bf64f\";}s:49:\"wp-content/plugins/duplicator/ctrls/ctrl.base.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"edc6fb84530d6d51a628f268a91acb34\";}s:52:\"wp-content/plugins/duplicator/ctrls/ctrl.package.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"fea4d55c98d336d6ab53fe0e1d07f3c2\";}s:50:\"wp-content/plugins/duplicator/ctrls/ctrl.tools.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"ad5cd2df7cf1c1bc38a8168c7c4b4bfb\";}s:47:\"wp-content/plugins/duplicator/ctrls/ctrl.ui.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"dfab0c34d3ad849b183b6a7f4c955741\";}s:44:\"wp-content/plugins/duplicator/debug/main.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"ab51093e6988c16c1cdbe6f0ebd739bb\";}s:52:\"wp-content/plugins/duplicator/debug/tst.packages.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"9a672ccbe1b191e4524231391303c3da\";}s:49:\"wp-content/plugins/duplicator/debug/tst.tools.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"655d03ebfefdd91989ce9a4bb1c858dc\";}s:46:\"wp-content/plugins/duplicator/debug/tst.ui.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"47530261999bf4c9a343b20838d3a386\";}s:40:\"wp-content/plugins/duplicator/define.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"3276641f30f263827df6c15eb09f7800\";}s:44:\"wp-content/plugins/duplicator/duplicator.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"c7c7c792e20baab3c58e46f366bd32f1\";}s:60:\"wp-content/plugins/duplicator/installer/build/ajax.step1.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"1dba1a11e3a5a5164b453698b25fbbc5\";}s:60:\"wp-content/plugins/duplicator/installer/build/ajax.step2.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"b8489151e78b3b671258eb35d1b39b4a\";}s:64:\"wp-content/plugins/duplicator/installer/build/assets/inc.css.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"fb9354a9796937a274cae787a2e702fe\";}s:63:\"wp-content/plugins/duplicator/installer/build/assets/inc.js.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"564ca367221fed1a8d3bd15ad3434c47\";}s:69:\"wp-content/plugins/duplicator/installer/build/assets/inc.libs.css.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"b22672ebbb91db37f3a9f1daa5be2303\";}s:68:\"wp-content/plugins/duplicator/installer/build/assets/inc.libs.js.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"efe11e714be20f5ef8042f97f70e8b0a\";}s:70:\"wp-content/plugins/duplicator/installer/build/classes/class.engine.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"f27b41611148086c7b35ef4bbb600924\";}s:71:\"wp-content/plugins/duplicator/installer/build/classes/class.logging.php\";a:2:{s:1:\"d\";i:1490250578;s:1:\"h\";s:32:\"d2c22099ad828b1553a4b3c307899d0e\";}s:79:\"wp-content/plugins/duplicator/installer/build/classes/config/class.conf.srv.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"ebf0110054f74654c740981e4d955cd4\";}s:78:\"wp-content/plugins/duplicator/installer/build/classes/config/class.conf.wp.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"c69860bfe9b0693feeaad09b896b6265\";}s:71:\"wp-content/plugins/duplicator/installer/build/classes/util/class.db.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"86d9d35e480b032179db1b1d8417bee8\";}s:74:\"wp-content/plugins/duplicator/installer/build/classes/util/class.utils.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"7ea15f576f9b3cfdaac987b2c47014f2\";}s:64:\"wp-content/plugins/duplicator/installer/build/main.installer.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"e0bae9c24d29f91e06cff99222ea25ed\";}s:59:\"wp-content/plugins/duplicator/installer/build/view.help.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"161dd0790d86681d3a1279d91a6dc017\";}s:60:\"wp-content/plugins/duplicator/installer/build/view.step0.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"cf87edb2ca9d342ea503bf64ee1f05ac\";}s:60:\"wp-content/plugins/duplicator/installer/build/view.step1.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"9b1de705fa80a9a5e6b2df4de409a0f9\";}s:60:\"wp-content/plugins/duplicator/installer/build/view.step2.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"ad5071ee8b626dc73b17eefecddb16ac\";}s:60:\"wp-content/plugins/duplicator/installer/build/view.step3.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"b602b4c8ec321552bb2d7395a4dd6511\";}s:50:\"wp-content/plugins/duplicator/installer/dtoken.php\";a:2:{s:1:\"d\";i:1490250586;s:1:\"h\";s:32:\"c6ae56de1c7b1269fba8ca589f7e9548\";}s:56:\"wp-content/plugins/duplicator/lib/forceutf8/Encoding.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"688564fb70ab49fa75e56dc45182de4d\";}s:53:\"wp-content/plugins/duplicator/lib/forceutf8/README.md\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"a5309327504b18401e092eb50674e974\";}s:40:\"wp-content/plugins/duplicator/readme.txt\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"763e387c6e6e7d3ec58903269d290343\";}s:43:\"wp-content/plugins/duplicator/uninstall.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"fc07b5c2d156c8a9625e47255e4c6794\";}s:50:\"wp-content/plugins/duplicator/views/help/about.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"a7a261efe6f9bafd1f89986cf740b950\";}s:50:\"wp-content/plugins/duplicator/views/help/gopro.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"4592a3e8d2fd9caed1acd25d51eca8e8\";}s:49:\"wp-content/plugins/duplicator/views/help/help.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"f6ecfe3f327210b565fda32049f39110\";}s:50:\"wp-content/plugins/duplicator/views/inc.header.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"883821b5fbfc4203217837a6365bb818\";}s:50:\"wp-content/plugins/duplicator/views/javascript.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"17c59cb71c3a5ffab6258c51de3136ff\";}s:59:\"wp-content/plugins/duplicator/views/packages/controller.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"68a2a12840c9d77730af7a9c3e49ecad\";}s:67:\"wp-content/plugins/duplicator/views/packages/details/controller.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"2f2aafba90332e6f1c7c8fdfdd3bb53d\";}s:63:\"wp-content/plugins/duplicator/views/packages/details/detail.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"819abc068c82c8c2439bdaf436cccb43\";}s:65:\"wp-content/plugins/duplicator/views/packages/details/transfer.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"7f0c2ab76c4dc81aab61408782d8b4d9\";}s:64:\"wp-content/plugins/duplicator/views/packages/main/controller.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"1a9abc9d5ef29b8ef93c85a8a51ecb07\";}s:67:\"wp-content/plugins/duplicator/views/packages/main/new1.inc.form.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"4eba55d552cf98de6dcdb478d41ab8e6\";}s:64:\"wp-content/plugins/duplicator/views/packages/main/new1.setup.php\";a:2:{s:1:\"d\";i:1490250579;s:1:\"h\";s:32:\"994e7bf7ec46de4058b76aad11f0b2c6\";}s:63:\"wp-content/plugins/duplicator/views/packages/main/new2.scan.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"c4d0ab62ee976e49231dd8ffd7c967ef\";}s:64:\"wp-content/plugins/duplicator/views/packages/main/new3.build.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"9e3f075df6c9e302943ed41ab5924c10\";}s:62:\"wp-content/plugins/duplicator/views/packages/main/packages.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"5217bbba22e376ee6b09226e0d92e0f1\";}s:59:\"wp-content/plugins/duplicator/views/settings/controller.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"e913a21a104cdc5e89291bf94b21fd48\";}s:56:\"wp-content/plugins/duplicator/views/settings/general.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"346b02405a8b8f3cfd2dbe85c5a19750\";}s:53:\"wp-content/plugins/duplicator/views/tools/cleanup.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"81452efbf90dcefdb43b14f3241053de\";}s:56:\"wp-content/plugins/duplicator/views/tools/controller.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"579659b8f71570e3ca4fda86727a550f\";}s:66:\"wp-content/plugins/duplicator/views/tools/diagnostics/inc.data.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"b43dfbd506660d102fb634fff83a05b1\";}s:69:\"wp-content/plugins/duplicator/views/tools/diagnostics/inc.phpinfo.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"575e9106deb23688bda0b766fb822adb\";}s:70:\"wp-content/plugins/duplicator/views/tools/diagnostics/inc.settings.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"002fc067a8b5e51bb4bf6490cde452ed\";}s:71:\"wp-content/plugins/duplicator/views/tools/diagnostics/inc.validator.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"af629d2cf7d4f7438150d43820f88517\";}s:62:\"wp-content/plugins/duplicator/views/tools/diagnostics/main.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"1480cff35009062f2659e94b0c75b563\";}s:57:\"wp-content/plugins/duplicator/views/tools/diagnostics.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"6ceb6ae33da985cddde118ebb479b930\";}s:53:\"wp-content/plugins/duplicator/views/tools/logging.php\";a:2:{s:1:\"d\";i:1490250580;s:1:\"h\";s:32:\"d34702059bcaeaa90d5575e66a787a06\";}s:28:\"wp-content/plugins/hello.php\";a:2:{s:1:\"d\";i:1487282316;s:1:\"h\";s:32:\"52a7f011f362416f939a74215f7ebd12\";}s:28:\"wp-content/plugins/index.php\";a:2:{s:1:\"d\";i:1487282316;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:63:\"wp-content/plugins/jquery-collapse-o-matic/collapse-o-matic.php\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"dfe29933f9d119fe3093fd926fd8d230\";}s:57:\"wp-content/plugins/jquery-collapse-o-matic/dark_style.css\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"9d5d5cafc0e78b06afbd3b44f4b603d7\";}s:60:\"wp-content/plugins/jquery-collapse-o-matic/images/arrows.psd\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"2aede05a6d26552bdbf65398fcbbf184\";}s:57:\"wp-content/plugins/jquery-collapse-o-matic/js/collapse.js\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"40ec2f3468a575e2b577120d18ec0923\";}s:58:\"wp-content/plugins/jquery-collapse-o-matic/light_style.css\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"c20e636efb7db3374183c0eb207581b7\";}s:53:\"wp-content/plugins/jquery-collapse-o-matic/readme.txt\";a:2:{s:1:\"d\";i:1490065224;s:1:\"h\";s:32:\"38ef50831ef7a697497140302e83a22b\";}s:54:\"wp-content/plugins/members/admin/class-cap-control.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"815bd50b971e11701a635798961c7674\";}s:60:\"wp-content/plugins/members/admin/class-cap-group-factory.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"25c0987ef9179a370bd4d91a2e82f2b2\";}s:52:\"wp-content/plugins/members/admin/class-cap-group.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"c2149a1b33e2ea48370b05e935a93922\";}s:54:\"wp-content/plugins/members/admin/class-cap-section.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"9b26ec13a0922b62c8492db96f3bc91b\";}s:51:\"wp-content/plugins/members/admin/class-cap-tabs.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"c30a5cd960b8025e0fc0d493d3bd22db\";}s:55:\"wp-content/plugins/members/admin/class-manage-roles.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"51692ee74dcf0069c5756c3a0322b6ed\";}s:71:\"wp-content/plugins/members/admin/class-meta-box-content-permissions.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"8623b7a30689678ea5526dfcc7b97e8b\";}s:62:\"wp-content/plugins/members/admin/class-meta-box-custom-cap.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"23cf2e85e6b7b88a273c81cdfec6f745\";}s:64:\"wp-content/plugins/members/admin/class-meta-box-publish-role.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"c1d8e4d89c4f5753b46d2daa21f25dc2\";}s:52:\"wp-content/plugins/members/admin/class-role-edit.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"badce43a8d9d64dcd1f977ec7559dd90\";}s:61:\"wp-content/plugins/members/admin/class-role-group-factory.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"8cafa7886674a69763b20f9557ff5f60\";}s:53:\"wp-content/plugins/members/admin/class-role-group.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"dbae08d01eba16de8f94562c6b7070c7\";}s:58:\"wp-content/plugins/members/admin/class-role-list-table.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"ab7275acfb46499d017d8783b2dbf93b\";}s:51:\"wp-content/plugins/members/admin/class-role-new.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"67ce5339a7e76c2fe4d7cd304b1e8020\";}s:48:\"wp-content/plugins/members/admin/class-roles.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"68987b9fc3b512f0738fc7da9ce1c262\";}s:51:\"wp-content/plugins/members/admin/class-settings.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"1c36ecd32b01ccfc876cdc7c72f4e12f\";}s:52:\"wp-content/plugins/members/admin/class-user-edit.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"3a9d289a80dabec74641344c32e6140f\";}s:52:\"wp-content/plugins/members/admin/functions-admin.php\";a:2:{s:1:\"d\";i:1490071085;s:1:\"h\";s:32:\"12fc4c998c4707ba33d67e8d9d2ad631\";}s:57:\"wp-content/plugins/members/admin/functions-cap-groups.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"07b851c330134964bc9245214c0ca6a0\";}s:51:\"wp-content/plugins/members/admin/functions-help.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"9cfd20d9b41c1b1d906aa5b37b881a33\";}s:58:\"wp-content/plugins/members/admin/functions-role-groups.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"ee5f85af9e1685a8e28679c8ef4bb0a3\";}s:53:\"wp-content/plugins/members/admin/tmpl/cap-control.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"0c227fdf5bb53c88c455d4b9c6fbbd4a\";}s:53:\"wp-content/plugins/members/admin/tmpl/cap-section.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"4e46c0b640c6405162e8c3f8b1762864\";}s:60:\"wp-content/plugins/members/admin/tmpl/cp-control-message.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"bb9cb9fd83a6792a2495ebec3315b8ca\";}s:57:\"wp-content/plugins/members/admin/tmpl/cp-control-role.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"53cfedc18ecd91039fe411a94527136f\";}s:48:\"wp-content/plugins/members/admin/tmpl/cp-nav.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"b82d96ea248ef877276198bd0c1ce67f\";}s:52:\"wp-content/plugins/members/admin/tmpl/cp-section.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"53b76cfd7e0d004faf83c6c0fce8f457\";}s:39:\"wp-content/plugins/members/changelog.md\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"51d413743b800ceca2932d1350ec8db8\";}s:42:\"wp-content/plugins/members/contributing.md\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"582dcf26e22d13501d8a8acabeb76234\";}s:40:\"wp-content/plugins/members/css/admin.css\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"1531e2f0bbfd2131e153036638d35174\";}s:44:\"wp-content/plugins/members/css/admin.min.css\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"a38f5f2de366de81921a6dea490ed648\";}s:53:\"wp-content/plugins/members/inc/class-role-factory.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"0ca6ba568b2cfa16e9fb67e3980a6538\";}s:45:\"wp-content/plugins/members/inc/class-role.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"17bb35968b83f40dfb2ed98fddbb7fa1\";}s:53:\"wp-content/plugins/members/inc/class-widget-login.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"716ef51755da58b8e74d89d6f7d8ba2e\";}s:53:\"wp-content/plugins/members/inc/class-widget-users.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"75ed0e12967e4184fc0ce20e16aab199\";}s:54:\"wp-content/plugins/members/inc/functions-admin-bar.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"2d6747022c8d005c831a9f29a5abbe16\";}s:57:\"wp-content/plugins/members/inc/functions-capabilities.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"7f0a50070b59406a18dc0f939530a8ab\";}s:64:\"wp-content/plugins/members/inc/functions-content-permissions.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"e3922c1828331384604e9ac7ebe3d5be\";}s:55:\"wp-content/plugins/members/inc/functions-deprecated.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"dd16cc1a9fa8e44a899dfafad7f82f48\";}s:52:\"wp-content/plugins/members/inc/functions-options.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"2558ac559bc90fc5c66b4dfe5303ab3d\";}s:57:\"wp-content/plugins/members/inc/functions-private-site.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"01c03fdce1d59c469da1b2d02b6de56d\";}s:54:\"wp-content/plugins/members/inc/functions-role-meta.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"24f8ed2de31fb7cd358fdefdc5271c9f\";}s:50:\"wp-content/plugins/members/inc/functions-roles.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"a12e1539d3b4c36bd49f895cf57f7cf3\";}s:55:\"wp-content/plugins/members/inc/functions-shortcodes.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"b07615129dadf6fc7513656b63f5df8e\";}s:50:\"wp-content/plugins/members/inc/functions-users.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"c7244fb6ec5137c2db7c68ab7380fc20\";}s:52:\"wp-content/plugins/members/inc/functions-widgets.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"590a692daf052bdac2df7dde54905c39\";}s:44:\"wp-content/plugins/members/inc/functions.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"7a4241f25cc779f629a2cb4c7c62a0a2\";}s:43:\"wp-content/plugins/members/inc/template.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"cc66d95620947273e101531f38016d9f\";}s:42:\"wp-content/plugins/members/js/edit-post.js\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"ba0f208d38b538d7cf3f4a4112116f61\";}s:42:\"wp-content/plugins/members/js/edit-role.js\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"0ba10b5e6a06767befc1cdb9d1048bb4\";}s:46:\"wp-content/plugins/members/js/edit-role.min.js\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"e309a5d815bc1178c8483299163098f5\";}s:41:\"wp-content/plugins/members/js/settings.js\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"f8031a732cad5345275aa97b42b1a4af\";}s:45:\"wp-content/plugins/members/js/settings.min.js\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"a20eea962357d6fc763869c22e5d2f36\";}s:48:\"wp-content/plugins/members/languages/members.pot\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"e1879b79f40d39d4bde84c72d4f4026b\";}s:37:\"wp-content/plugins/members/license.md\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"3da40c4facb3c17aea2357e73db21ca4\";}s:38:\"wp-content/plugins/members/members.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"d60cb45952ac213369193bd270bd5977\";}s:36:\"wp-content/plugins/members/readme.md\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"c8b77210d6eab9dd7e1aad1e88978efd\";}s:37:\"wp-content/plugins/members/readme.txt\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"df7830cf0510c276b9057e5aac2d2add\";}s:49:\"wp-content/plugins/members/templates/comments.php\";a:2:{s:1:\"d\";i:1490071086;s:1:\"h\";s:32:\"f19d72657d4012077ac64b360c9b4376\";}s:50:\"wp-content/plugins/photo-gallery/addons/addons.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"a14b3142db9b429395eea90cca475a8e\";}s:49:\"wp-content/plugins/photo-gallery/addons/style.css\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"00df8bdb03049844dd6cd25a771d599b\";}s:86:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerAddAlbumsGalleries.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"e061a0f73171a48ce1e3d27aa8ade8ed\";}s:75:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerAddTags.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"f78f6057e2166f9845792dec86f6b2e6\";}s:78:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerAlbums_bwg.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"ee56f8d47a5813450beb5a3e24265542\";}s:80:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerBWGShortcode.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"7b717d605d23c1287e160bbc8f83ddcd\";}s:77:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerEditThumb.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"deb123e905ab8293bd3bb4fef048a2c1\";}s:81:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerGalleries_bwg.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"dd7d46bc09894695ff7d6e1828227d3a\";}s:81:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerLicensing_bwg.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"207a0df5661d76996a136d6838491b85\";}s:79:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerOptions_bwg.php\";a:2:{s:1:\"d\";i:1488636716;s:1:\"h\";s:32:\"bc1576fb1491baf0b7fa84421b43f15c\";}s:76:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerTags_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"633c60966d64eca0665b99c75ae1cfd6\";}s:78:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerThemes_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"a918cd1f12f963a37be36ea3355f945b\";}s:81:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerUninstall_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"e980e142610ab4446b9fea908a0bf377\";}s:74:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerWidget.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"3cb7da7fd07212336af1a49271b8fd85\";}s:83:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerWidgetSlideshow.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"d7fc62b4ef93c075cff7dc9191b43e03\";}s:78:\"wp-content/plugins/photo-gallery/admin/controllers/BWGControllerWidgetTags.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"c825bb6b5fc8af0ca221f00fe7f25cab\";}s:76:\"wp-content/plugins/photo-gallery/admin/models/BWGModelAddAlbumsGalleries.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"8c4fce53b05b531bd5f8f94d74f1fb1f\";}s:65:\"wp-content/plugins/photo-gallery/admin/models/BWGModelAddTags.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"f25aea21eeb20e201974ab037326c503\";}s:68:\"wp-content/plugins/photo-gallery/admin/models/BWGModelAlbums_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"cbbee9a2b430bd7227cc47f7e3d3127c\";}s:70:\"wp-content/plugins/photo-gallery/admin/models/BWGModelBWGShortcode.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"6ab908d1805b23d6556b51ceb4813094\";}s:67:\"wp-content/plugins/photo-gallery/admin/models/BWGModelEditThumb.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"c6657adaa6cf61df15e39b6e5b2163f8\";}s:71:\"wp-content/plugins/photo-gallery/admin/models/BWGModelGalleries_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"cca0e5be5ff27e16192649efe173c354\";}s:71:\"wp-content/plugins/photo-gallery/admin/models/BWGModelLicensing_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"a4e8a46e4b060a0772e78c3625c6d47a\";}s:69:\"wp-content/plugins/photo-gallery/admin/models/BWGModelOptions_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"9e72ce058ef36acb331f6dae630f40e4\";}s:66:\"wp-content/plugins/photo-gallery/admin/models/BWGModelTags_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"99300d320999e283538e56164d2dd7f8\";}s:68:\"wp-content/plugins/photo-gallery/admin/models/BWGModelThemes_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"d02f2fc881ba92eab878fc9a5bf6fd5f\";}s:71:\"wp-content/plugins/photo-gallery/admin/models/BWGModelUninstall_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"476f28a72e5296841ef7bcdcb08fbcd5\";}s:64:\"wp-content/plugins/photo-gallery/admin/models/BWGModelWidget.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"a69f816f4b0605602104add933d8e8eb\";}s:73:\"wp-content/plugins/photo-gallery/admin/models/BWGModelWidgetSlideshow.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"464815954c8c6c1270c9e3fb86155e85\";}s:68:\"wp-content/plugins/photo-gallery/admin/models/BWGModelWidgetTags.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"e25aa051b091066b4dc63d0e26f6b560\";}s:74:\"wp-content/plugins/photo-gallery/admin/views/BWGViewAddAlbumsGalleries.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"ab491491bbc019d5fd56bbb5030233c0\";}s:63:\"wp-content/plugins/photo-gallery/admin/views/BWGViewAddTags.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"afc7d789879fc93bdac4c6349ee6591a\";}s:66:\"wp-content/plugins/photo-gallery/admin/views/BWGViewAlbums_bwg.php\";a:2:{s:1:\"d\";i:1488636717;s:1:\"h\";s:32:\"e95212b376c0afbbddc8282d10849034\";}s:68:\"wp-content/plugins/photo-gallery/admin/views/BWGViewBWGShortcode.php\";a:2:{s:1:\"d\";i:1488636718;s:1:\"h\";s:32:\"71529c3a8f18375df9a43316342f8095\";}s:65:\"wp-content/plugins/photo-gallery/admin/views/BWGViewEditThumb.php\";a:2:{s:1:\"d\";i:1488636719;s:1:\"h\";s:32:\"294ca4ee0348fa0d82b7d270f00dc38f\";}s:69:\"wp-content/plugins/photo-gallery/admin/views/BWGViewGalleries_bwg.php\";a:2:{s:1:\"d\";i:1488636719;s:1:\"h\";s:32:\"a86f48dbe59932655ed506af24dfa37b\";}s:69:\"wp-content/plugins/photo-gallery/admin/views/BWGViewLicensing_bwg.php\";a:2:{s:1:\"d\";i:1488636719;s:1:\"h\";s:32:\"0c52626bf35cf2f2816a2f890cf22fdc\";}s:67:\"wp-content/plugins/photo-gallery/admin/views/BWGViewOptions_bwg.php\";a:2:{s:1:\"d\";i:1488636720;s:1:\"h\";s:32:\"2efce6e7a0c11e39ba6584a1e2ee7f2c\";}s:64:\"wp-content/plugins/photo-gallery/admin/views/BWGViewTags_bwg.php\";a:2:{s:1:\"d\";i:1488636720;s:1:\"h\";s:32:\"4c79522479cf6ead1a149a8ba1bca1f9\";}s:66:\"wp-content/plugins/photo-gallery/admin/views/BWGViewThemes_bwg.php\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"d63a018f32149db52cc9cd32c1ef9870\";}s:69:\"wp-content/plugins/photo-gallery/admin/views/BWGViewUninstall_bwg.php\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"eff2de7c6c1f7b329128464b4eff0eac\";}s:62:\"wp-content/plugins/photo-gallery/admin/views/BWGViewWidget.php\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"45efd328dffce81a927bdf06fbbc8f02\";}s:71:\"wp-content/plugins/photo-gallery/admin/views/BWGViewWidgetSlideshow.php\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"47b8ab681033ffaaf04b556b688acdb1\";}s:66:\"wp-content/plugins/photo-gallery/admin/views/BWGViewWidgetTags.php\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"b9fb1d0d927388f050e55a8c7f6f46f7\";}s:55:\"wp-content/plugins/photo-gallery/css/bwg_edit_image.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"2569678ca40765cc2be0bb425266108a\";}s:53:\"wp-content/plugins/photo-gallery/css/bwg_frontend.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"e50cd0004fdb060ffe0d45e988b4cc40\";}s:54:\"wp-content/plugins/photo-gallery/css/bwg_licensing.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"6eb36fc6069beeef133a8e19b661aa8e\";}s:54:\"wp-content/plugins/photo-gallery/css/bwg_shortcode.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"083ba03c8b365b79cd06f9eefac4a777\";}s:51:\"wp-content/plugins/photo-gallery/css/bwg_tables.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"22158885917b96e4c75fdb114711b4d7\";}s:66:\"wp-content/plugins/photo-gallery/css/font-awesome/font-awesome.css\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"6480d42fb358be80424835fbcdf28876\";}s:79:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"25a32416abee198dd821b0b17a198a8f\";}s:79:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"d7c639084f684d66a1bc66855d193ed8\";}s:79:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"1dc35d25e61d819a9c357074014867ab\";}s:80:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"c8ddf1e5e5bf3682bc7bebf30f394148\";}s:81:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/fontawesome-webfont.woff2\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"e6cf7c6ec7c2d6f670ae9d762604cb0b\";}s:71:\"wp-content/plugins/photo-gallery/css/font-awesome/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"5dc41d8fe329a22fa1ee9225571c843e\";}s:68:\"wp-content/plugins/photo-gallery/css/font-awesome/less/animated.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"08baef05e05301cabc91599a54921081\";}s:75:\"wp-content/plugins/photo-gallery/css/font-awesome/less/bordered-pulled.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"898f90e40876883214bbd121b0c20e9f\";}s:64:\"wp-content/plugins/photo-gallery/css/font-awesome/less/core.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"fb4efe4ae63737706875bbbfc7b7e9af\";}s:71:\"wp-content/plugins/photo-gallery/css/font-awesome/less/fixed-width.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"5e07ec001f8d21bd279c12ee542813f7\";}s:72:\"wp-content/plugins/photo-gallery/css/font-awesome/less/font-awesome.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"f53235946c37e394a6cd6d92f84587a8\";}s:65:\"wp-content/plugins/photo-gallery/css/font-awesome/less/icons.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"3c3bb8fbcd54a6b66a41137d5e9e8a33\";}s:66:\"wp-content/plugins/photo-gallery/css/font-awesome/less/larger.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"8cb65280c0f889daf72626c21a7c8628\";}s:64:\"wp-content/plugins/photo-gallery/css/font-awesome/less/list.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"975571323cf880a4a30601998236b027\";}s:66:\"wp-content/plugins/photo-gallery/css/font-awesome/less/mixins.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"fbb1f2f1ab96ba020c7f14208aac72b8\";}s:64:\"wp-content/plugins/photo-gallery/css/font-awesome/less/path.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"a8c41460c42a4fe9e98550f00c8b3f19\";}s:75:\"wp-content/plugins/photo-gallery/css/font-awesome/less/rotated-flipped.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"a8476cdc50c264abd11ff59d6a9dd025\";}s:73:\"wp-content/plugins/photo-gallery/css/font-awesome/less/screen-reader.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"0f881617264587bef0df6ce92253ecea\";}s:67:\"wp-content/plugins/photo-gallery/css/font-awesome/less/stacked.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"518e2b2d263982d2caa1e6514b4b4eac\";}s:69:\"wp-content/plugins/photo-gallery/css/font-awesome/less/variables.less\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"45fa411bbd22ff8467e027318a88a557\";}s:72:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/font-awesome.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"ace7fb9336021f92b1cf68a10d5f452c\";}s:69:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_animated.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"39ff4f359a7b81d6585075715f41e5dc\";}s:76:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_bordered-pulled.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"4cad0df17bf40327feae33fa9a6c6ba2\";}s:65:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_core.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"ef059a98cf9de6ca5b77ee6850771cf0\";}s:72:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_fixed-width.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"9277ab6964a434d499873687b00be906\";}s:66:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_icons.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"fdffb08bc3d85c7427d8697f268fb072\";}s:67:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_larger.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"e95931566f6fc6ad5685c4fa9802e206\";}s:65:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_list.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"7107e80b053928271d5fcf422dc29490\";}s:67:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_mixins.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"aa2b8f32b403733713d8885f14ab86cc\";}s:65:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_path.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"ab5a9e8388563e097b5ce835601f01d2\";}s:76:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_rotated-flipped.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"9f5d4bc6fadea89328d2aac26574a9d8\";}s:74:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_screen-reader.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"8907bd7dbf4799e8120bda5568d76fea\";}s:68:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_stacked.scss\";a:2:{s:1:\"d\";i:1488636723;s:1:\"h\";s:32:\"5594237226aedfbca2fa1c7f4604c214\";}s:70:\"wp-content/plugins/photo-gallery/css/font-awesome/scss/_variables.scss\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"783d4422626a7f27fa8f513de3ad4795\";}s:64:\"wp-content/plugins/photo-gallery/css/images/animated-overlay.gif\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"2b912f7c0653008ca28ebacda49025e7\";}s:64:\"wp-content/plugins/photo-gallery/css/jquery-ui-1.10.3.custom.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"16ce288b5d915329c0996afb1dd28d9f\";}s:64:\"wp-content/plugins/photo-gallery/css/jquery.mCustomScrollbar.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"134d36ccd55a3865fccee8ffa9840c2f\";}s:48:\"wp-content/plugins/photo-gallery/css/notices.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"b2684bb691ba2a1a70208ca868facba4\";}s:51:\"wp-content/plugins/photo-gallery/css/sumoselect.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"ccfbd12b9b34c29639dd9c39f22bc00e\";}s:54:\"wp-content/plugins/photo-gallery/featured/featured.php\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"f1c2647c912b28a3bc8027ec4562fb5f\";}s:61:\"wp-content/plugins/photo-gallery/featured/featured_themes.php\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"3429351130f9e210b6a67ea5a2d10ae5\";}s:51:\"wp-content/plugins/photo-gallery/featured/style.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"a66751821ac8bcf25e42e35557f58d17\";}s:58:\"wp-content/plugins/photo-gallery/featured/themes_style.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"bdb92eb9de29f7915d892d7c09841188\";}s:59:\"wp-content/plugins/photo-gallery/filemanager/controller.php\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"8782511ed7cf2bdea4e80ae05dadb8d7\";}s:60:\"wp-content/plugins/photo-gallery/filemanager/css/default.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"7e71a0be62141626d959eb55f19af77e\";}s:70:\"wp-content/plugins/photo-gallery/filemanager/css/default_view_list.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"25cf63835f0722a93ad504cf2315321c\";}s:72:\"wp-content/plugins/photo-gallery/filemanager/css/default_view_thumbs.css\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"003abcf0692486d44be67f962a576a1a\";}s:59:\"wp-content/plugins/photo-gallery/filemanager/css/index.html\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"8ca096fda23d564fe62bc65ef5f498e0\";}s:72:\"wp-content/plugins/photo-gallery/filemanager/images/btn_icons/index.html\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"8ca096fda23d564fe62bc65ef5f498e0\";}s:73:\"wp-content/plugins/photo-gallery/filemanager/images/file_icons/index.html\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"d9e311cbe069f878ca40865e6a29e538\";}s:62:\"wp-content/plugins/photo-gallery/filemanager/images/index.html\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"d9e311cbe069f878ca40865e6a29e538\";}s:67:\"wp-content/plugins/photo-gallery/filemanager/images/progressbar.gif\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"ee4d9be0634f56ca6791e23e4a39843c\";}s:58:\"wp-content/plugins/photo-gallery/filemanager/js/default.js\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"4c1700b408e3c124674aeb1a6e8132cb\";}s:70:\"wp-content/plugins/photo-gallery/filemanager/js/jq_uploader/index.html\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"d9e311cbe069f878ca40865e6a29e538\";}s:80:\"wp-content/plugins/photo-gallery/filemanager/js/jq_uploader/jquery.fileupload.js\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"02a99fa9ae914adc01e77cffcda49e00\";}s:86:\"wp-content/plugins/photo-gallery/filemanager/js/jq_uploader/jquery.iframe-transport.js\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"e041d8a3038edd182d73e92660a698bf\";}s:82:\"wp-content/plugins/photo-gallery/filemanager/js/jq_uploader/jquery.upload-1.0.2.js\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"94466a640d5b6830cd9724d071a8e9bf\";}s:54:\"wp-content/plugins/photo-gallery/filemanager/model.php\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"82611b8877b459abd70196dbc6f2a4dd\";}s:62:\"wp-content/plugins/photo-gallery/filemanager/UploadHandler.php\";a:2:{s:1:\"d\";i:1488636724;s:1:\"h\";s:32:\"67bd4bcff0fdc3ead77b2b814222e53d\";}s:53:\"wp-content/plugins/photo-gallery/filemanager/view.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"027b82f814a81aee0a855042dd891137\";}s:48:\"wp-content/plugins/photo-gallery/fonts/arial.ttf\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"6e7385fb7d6ceddf07b5a41e0bc2712d\";}s:57:\"wp-content/plugins/photo-gallery/framework/BWGOptions.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"17cffe5199cec7223c3a132de8c86b63\";}s:57:\"wp-content/plugins/photo-gallery/framework/WDWLibrary.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"2000d88aee50c1035125403e9a799401\";}s:62:\"wp-content/plugins/photo-gallery/framework/WDWLibraryEmbed.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"81dc359271e70d0927a3ed010e583bd0\";}s:92:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerAlbum_compact_preview.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"744dd8e3714f9e514003ce27f94e8b63\";}s:93:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerAlbum_extended_preview.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"5811b7f54fa1ef0a6921e25699cd6fa9\";}s:81:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerGalleryBox.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"f380f988d4820cc27932856d75105cc1\";}s:84:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerImage_browser.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"3152bca256a0614410e76d3d61f17071\";}s:80:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerSlideshow.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"2e026578c0612c81dd05501da56dc083\";}s:81:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerThumbnails.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"faaf88d60ca79eb10f83361a18dad642\";}s:77:\"wp-content/plugins/photo-gallery/frontend/controllers/BWGControllerWidget.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"40462448f047a65c772b6b140cec9df6\";}s:82:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelAlbum_compact_preview.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"c44e1f9096459352c552f44485f72439\";}s:83:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelAlbum_extended_preview.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"601e571e5c94717a9e470b1f47d05851\";}s:71:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelGalleryBox.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"8f3a75da9dcf54f23dd874dd0792f98e\";}s:74:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelImage_browser.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"60635522c3c1d78499dd03c4a2e6d23f\";}s:70:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelSlideshow.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"9abafb782d4ada7849fbfc7918558c68\";}s:71:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelThumbnails.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"3afaf0e7c1996ddbb738bc3e89b91ee6\";}s:67:\"wp-content/plugins/photo-gallery/frontend/models/BWGModelWidget.php\";a:2:{s:1:\"d\";i:1488636725;s:1:\"h\";s:32:\"dacb7d9446519141bee612b45f7125bd\";}s:80:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewAlbum_compact_preview.php\";a:2:{s:1:\"d\";i:1488636726;s:1:\"h\";s:32:\"3fad0abf393f3eaa8c5b578696605a2c\";}s:81:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewAlbum_extended_preview.php\";a:2:{s:1:\"d\";i:1488636726;s:1:\"h\";s:32:\"c3573bbb8d44afc2a0466c8f6ef10bc8\";}s:69:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewGalleryBox.php\";a:2:{s:1:\"d\";i:1488636727;s:1:\"h\";s:32:\"38e5fa9c6461651231b757880351854a\";}s:72:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewImage_browser.php\";a:2:{s:1:\"d\";i:1488636727;s:1:\"h\";s:32:\"62b89b00b3c55688fdd2dcf8d369ad47\";}s:68:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewSlideshow.php\";a:2:{s:1:\"d\";i:1488636727;s:1:\"h\";s:32:\"c1ad080f27929e0afad6c1902f79217a\";}s:69:\"wp-content/plugins/photo-gallery/frontend/views/BWGViewThumbnails.php\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"180a9ed124eccbab87dd75edc25476c2\";}s:55:\"wp-content/plugins/photo-gallery/images/ajax_loader.gif\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"402be40ea6d821fcc12010d2b23eb541\";}s:49:\"wp-content/plugins/photo-gallery/images/blank.gif\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"325472601571f31e1bf00674c368d335\";}s:58:\"wp-content/plugins/photo-gallery/includes/bwg_pointers.php\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"ee036a0d75f7b02b20ae9aa02e5aaf2d\";}s:42:\"wp-content/plugins/photo-gallery/js/bwg.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"8f6062c7e5a65a1ca1297c21e20c509f\";}s:56:\"wp-content/plugins/photo-gallery/js/bwg_editor_button.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"2772b8b9199508a342cfdf7ef8f81842\";}s:48:\"wp-content/plugins/photo-gallery/js/bwg_embed.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"f86e8ce46cc7cd7867eb534d18a5e907\";}s:51:\"wp-content/plugins/photo-gallery/js/bwg_frontend.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"52c2477a9d8e37973179c732f3495d7c\";}s:54:\"wp-content/plugins/photo-gallery/js/bwg_gallery_box.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"41354a8245ae4659a22a514356db03ac\";}s:52:\"wp-content/plugins/photo-gallery/js/bwg_shortcode.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"e76323cc472a64d643de96a75d4cd1c5\";}s:62:\"wp-content/plugins/photo-gallery/js/jquery.fullscreen-0.4.1.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"a20ccc97b8ab6324adeb56fa34a04c55\";}s:73:\"wp-content/plugins/photo-gallery/js/jquery.mCustomScrollbar.concat.min.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"c0efc8c25969b270348069a176e93f8c\";}s:52:\"wp-content/plugins/photo-gallery/js/jquery.mobile.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"63d1efa154bd0728b1dcb3c4abee929d\";}s:60:\"wp-content/plugins/photo-gallery/js/jquery.sumoselect.min.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"ba1220160c45d126b5b4ef26568d484c\";}s:53:\"wp-content/plugins/photo-gallery/js/jscolor/arrow.gif\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"5034704a76cd55c1cbcbc58ea6bf523f\";}s:53:\"wp-content/plugins/photo-gallery/js/jscolor/cross.gif\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"ba9a274b9323753cd95bc3b1eb2f4e5f\";}s:54:\"wp-content/plugins/photo-gallery/js/jscolor/index.html\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"016c56fbb606cfb9881b85ceb31fdd11\";}s:54:\"wp-content/plugins/photo-gallery/js/jscolor/jscolor.js\";a:2:{s:1:\"d\";i:1488636728;s:1:\"h\";s:32:\"aaf59a0d48e6f3ff4b9b2a7c0a94b1f1\";}s:58:\"wp-content/plugins/photo-gallery/photo-gallery-notices.php\";a:2:{s:1:\"d\";i:1488636730;s:1:\"h\";s:32:\"becf035be3271443b49716077561712e\";}s:50:\"wp-content/plugins/photo-gallery/photo-gallery.php\";a:2:{s:1:\"d\";i:1488636730;s:1:\"h\";s:32:\"2b7b53e14fa2be0b6b542ca49f84b985\";}s:43:\"wp-content/plugins/photo-gallery/readme.txt\";a:2:{s:1:\"d\";i:1488636730;s:1:\"h\";s:32:\"cd413c94fcc87b03faad29e6b24b9080\";}s:54:\"wp-content/plugins/photo-gallery/update/bwg_update.php\";a:2:{s:1:\"d\";i:1488636730;s:1:\"h\";s:32:\"69434517cda6d347a28153cf045c69d3\";}s:54:\"wp-content/plugins/tabby-responsive-tabs/css/index.php\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"6cb801e23c332f8edf1ac208477c4eaa\";}s:60:\"wp-content/plugins/tabby-responsive-tabs/css/tabby-print.css\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"a4d4ea8b36570744d39713f072278f45\";}s:54:\"wp-content/plugins/tabby-responsive-tabs/css/tabby.css\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"522855735d49f7803f1810f2b2ddb066\";}s:50:\"wp-content/plugins/tabby-responsive-tabs/index.php\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"6cb801e23c332f8edf1ac208477c4eaa\";}s:53:\"wp-content/plugins/tabby-responsive-tabs/js/index.php\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"6cb801e23c332f8edf1ac208477c4eaa\";}s:52:\"wp-content/plugins/tabby-responsive-tabs/js/tabby.js\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"fcc32f5c35396e15490bca709938862c\";}s:51:\"wp-content/plugins/tabby-responsive-tabs/readme.txt\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"bca09d2e3355678839c03bfdc49765ff\";}s:66:\"wp-content/plugins/tabby-responsive-tabs/tabby-responsive-tabs.php\";a:2:{s:1:\"d\";i:1487529835;s:1:\"h\";s:32:\"2d9b6de2eaab2f6dfce82db393f26888\";}s:56:\"wp-content/plugins/w3-total-cache/Base_Page_Settings.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"68c004cbea5b57e999ecc57ccf39ae8f\";}s:63:\"wp-content/plugins/w3-total-cache/BrowserCache_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"7bf24194f51d0ca482c08dcf6b1342d9\";}s:55:\"wp-content/plugins/w3-total-cache/BrowserCache_Core.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"c4079235af921212b28d05e134b08734\";}s:62:\"wp-content/plugins/w3-total-cache/BrowserCache_Environment.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"3b733d90664d4a3fbb60bd0cc7a1ff6f\";}s:55:\"wp-content/plugins/w3-total-cache/BrowserCache_Page.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"32908614ea8e1cb25ecc061063978cfa\";}s:57:\"wp-content/plugins/w3-total-cache/BrowserCache_Plugin.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"a78c8e39994ebc940be1627614056e8c\";}s:63:\"wp-content/plugins/w3-total-cache/BrowserCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"570f959bb65737651d3759e8d48b6a70\";}s:43:\"wp-content/plugins/w3-total-cache/Cache.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"db076ad40dbfe163b7959981ba8f2ce5\";}s:48:\"wp-content/plugins/w3-total-cache/CacheFlush.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"29003fb06f0225101d673b55b219bf75\";}s:56:\"wp-content/plugins/w3-total-cache/CacheFlush_Locally.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"12ef11ed69bdfe403c94aa2088a5f5bb\";}s:47:\"wp-content/plugins/w3-total-cache/Cache_Apc.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"3364918eb2d82ea7a9cb86d5db934fa5\";}s:48:\"wp-content/plugins/w3-total-cache/Cache_Apcu.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"67d6791db5f18edbc8a3a5517301f94c\";}s:48:\"wp-content/plugins/w3-total-cache/Cache_Base.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"57dd5611c61704fed6a5ec835f9790c8\";}s:56:\"wp-content/plugins/w3-total-cache/Cache_Eaccelerator.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"9055fe0792f0f471d533d6050f70d35d\";}s:48:\"wp-content/plugins/w3-total-cache/Cache_File.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"aafa778f56ec73edd4a84cdca51a1583\";}s:56:\"wp-content/plugins/w3-total-cache/Cache_File_Cleaner.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"474f19769ea25d73b30d906485dc70cc\";}s:64:\"wp-content/plugins/w3-total-cache/Cache_File_Cleaner_Generic.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"193e3510a874c16b70ae15053bcd287d\";}s:56:\"wp-content/plugins/w3-total-cache/Cache_File_Generic.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"b003ac675229b538f247d6305cae3dde\";}s:52:\"wp-content/plugins/w3-total-cache/Cache_Memcache.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"9038ad4caa8838258746405cff4904e8\";}s:53:\"wp-content/plugins/w3-total-cache/Cache_Memcached.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"a3a134042678d8b4b80f81f2470104ba\";}s:59:\"wp-content/plugins/w3-total-cache/Cache_Memcached_Stats.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e08953b7ec132c68715e1b58ebf86b55\";}s:49:\"wp-content/plugins/w3-total-cache/Cache_Redis.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"d4e10008350365cf9702d81be9165671\";}s:52:\"wp-content/plugins/w3-total-cache/Cache_Wincache.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e0bb01e5a9f9016db41eac5919b105fc\";}s:50:\"wp-content/plugins/w3-total-cache/Cache_Xcache.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"b2a28e3704f3831a49b4c4e25bc3e7ef\";}s:47:\"wp-content/plugins/w3-total-cache/CdnEngine.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"7efb02590a96b3e2459b0c21a1b9ad90\";}s:53:\"wp-content/plugins/w3-total-cache/CdnEngine_Azure.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"1a8633500770315454b62920430efaaa\";}s:52:\"wp-content/plugins/w3-total-cache/CdnEngine_Base.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"6c90aec327a205a6943225f046edcac4\";}s:51:\"wp-content/plugins/w3-total-cache/CdnEngine_Ftp.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"f1cf55f5959135eb1b0f4f4dd501e4e8\";}s:59:\"wp-content/plugins/w3-total-cache/CdnEngine_GoogleDrive.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e10a5dce027358b0eadf1fbaa65100bc\";}s:54:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"7f204c33eaf3e85157114c22edd6922c\";}s:61:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Akamai.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"9ad2994c61554804a3fcc54dc98ef5ea\";}s:58:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Att.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"146bf7f44517453c8b065e176bf21408\";}s:62:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Cotendo.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"2174ec11cf815c37f6002810ff3ef6ae\";}s:63:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Edgecast.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"b56c30b88632b1abba338c50e3c31681\";}s:64:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Highwinds.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"691ba75bd23ba4dabd0f05fbdb3d3c7a\";}s:61:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_MaxCdn.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"d9a1659494244d69258d0026e1051c2d\";}s:61:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_Netdna.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"775d0990bfa15be6aac28fa34c8d2ab5\";}s:67:\"wp-content/plugins/w3-total-cache/CdnEngine_Mirror_RackSpaceCdn.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"95a551d1ed9f78ed688ab0573237ef9a\";}s:67:\"wp-content/plugins/w3-total-cache/CdnEngine_RackSpaceCloudFiles.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e5d76d631bb7f34fd42aaea409df712c\";}s:50:\"wp-content/plugins/w3-total-cache/CdnEngine_S3.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"79fbab417fb329fee28547f3b852cd77\";}s:53:\"wp-content/plugins/w3-total-cache/CdnEngine_S3_Cf.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e5610aefd82b57ebf3ad536fb6f77765\";}s:60:\"wp-content/plugins/w3-total-cache/CdnEngine_S3_Cf_Custom.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e537f56130e2fd6d601a440ac5b9ed9f\";}s:56:\"wp-content/plugins/w3-total-cache/CdnEngine_S3_Cf_S3.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"2229e5113f86738474961bf8d735ba21\";}s:61:\"wp-content/plugins/w3-total-cache/CdnEngine_S3_Compatible.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"21ba605383c746879e6679a7c290e16b\";}s:54:\"wp-content/plugins/w3-total-cache/Cdn_AdminActions.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"b7a4764dadf4f37f9c9e82895590e141\";}s:52:\"wp-content/plugins/w3-total-cache/Cdn_AdminNotes.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"ae610b70bc65663c28df5172d636f901\";}s:52:\"wp-content/plugins/w3-total-cache/Cdn_CacheFlush.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e0ee3d99d998b791b48461f6a3d4eb9b\";}s:59:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Api.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"b28e16f3f90acb6048fa10a8980862d2\";}s:62:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Engine.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"26c40adf7889fc686464413d379421a4\";}s:60:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Page.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"77e4a9724dfe26bf7a79c5b6bdd8f5ce\";}s:64:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Page_View.js\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"373f353a862f8b2e7ebba0e9577924ac\";}s:65:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Page_View.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"fbcda62052cc66a10558bb316a4ffeab\";}s:61:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Popup.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"e9704659db24e44eefe0b777bed3e603\";}s:79:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Popup_View_Distribution.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"39e53fc14ca3ac35499e64091180325c\";}s:80:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Popup_View_Distributions.php\";a:2:{s:1:\"d\";i:1490249267;s:1:\"h\";s:32:\"fb738d1693fd1b15e64f46e9d638e27d\";}s:72:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"e79d56d357cf4511faa8bd3ab4ca7a3c\";}s:74:\"wp-content/plugins/w3-total-cache/Cdn_CloudFrontFsd_Popup_View_Success.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"5d361c2ec8bd0bb3b00d1e7493daa1b7\";}s:54:\"wp-content/plugins/w3-total-cache/Cdn_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"d06f3e4e687516d28ea226d1e2e51153\";}s:46:\"wp-content/plugins/w3-total-cache/Cdn_Core.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"ff1de2d0cb78d01883ec3ef0567a82b5\";}s:52:\"wp-content/plugins/w3-total-cache/Cdn_Core_Admin.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"55c0be39863db0c6e6e6ea8d738af4fd\";}s:53:\"wp-content/plugins/w3-total-cache/Cdn_Environment.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f62e2149439df8bf2c2ce8717886c18e\";}s:56:\"wp-content/plugins/w3-total-cache/Cdn_Fsd_CacheFlush.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"7f918555bd74cbcfb07f2efd9c6c23a3\";}s:50:\"wp-content/plugins/w3-total-cache/Cdn_Fsd_Core.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"97a24fb3ea915d8e1ae5cb6b85d4c1bb\";}s:50:\"wp-content/plugins/w3-total-cache/Cdn_Fsd_Util.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f0d282f210c3a200521e6cb31a73a204\";}s:58:\"wp-content/plugins/w3-total-cache/Cdn_GeneralPage_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"c047ef05803f5d8eff149140ad096fe9\";}s:66:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_AdminActions.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"7f906804bf2e00f33c5eee1086999b57\";}s:58:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"c09507f805710a2e2a4d93b43a9ab304\";}s:62:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_Page_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"c90ff9554bce75f4ec47a92088a737c6\";}s:63:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_Page_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"ed8d02aedd5c7cc8333939c07e10f036\";}s:70:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_Popup_AuthReturn.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f0b66b8c6aefc2a1836f8ba5c655dbf0\";}s:75:\"wp-content/plugins/w3-total-cache/Cdn_GoogleDrive_Popup_AuthReturn_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"582b496b49204c8006ff41bca24dd5c2\";}s:55:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Api.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"3397dad020af57972eb689a0203299ec\";}s:56:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"0db3deaee3cd1c847f13c1d9343ac9f8\";}s:60:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Page_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"9ae3d9754c867dfb60fc268c77a30b44\";}s:61:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Page_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"2ea3594f6b78270df000f7bba63d3819\";}s:57:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Popup.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"ef4b8270c5dc06851268a08bc5ea9f52\";}s:82:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Popup_View_ConfigureCnamesForm.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f30452c63d8efc5cb8963e6a4be3a786\";}s:68:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"aa9830a2d74744915598a808da3911cf\";}s:73:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Popup_View_SelectHost.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"a2e86ba5dfb77cc2cf27b9d13e5b4f6c\";}s:58:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Widget.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"58d5d27a9c54f2ed12ec7644a798c3b6\";}s:63:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Widget_View.css\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"39db6fdafc7f117af12a3bb1bc440542\";}s:62:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Widget_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"c0a8ce0d7c319e43c66990674ba8a7b6\";}s:63:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Widget_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"47526f4b65e8f3e6235ba18d1acccf9a\";}s:77:\"wp-content/plugins/w3-total-cache/Cdn_Highwinds_Widget_View_NotConfigured.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"26bd5154c3e740e45679a3f0c1071dec\";}s:58:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Engine.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"c3c83661ce3522c315e8454c2a3a1295\";}s:56:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"147bdd8c080a64eb45fb4cd5b723793b\";}s:60:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Page_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"b0fab02c86fc9c2dc1bb84f2a635c628\";}s:61:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Page_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"e1d8b9e3194ec5f861570af34eb12e35\";}s:57:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Popup.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"971e131274c33093bd1e6eefe0e0c14c\";}s:68:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"8a95f7014694e9d41496fc402727ec7d\";}s:70:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Popup_View_Success.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"2e948d704cda85d5f068967aee34e440\";}s:67:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Popup_View_Zone.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"d4ec45221bc6dd87c70ae27ed2aaf5bd\";}s:68:\"wp-content/plugins/w3-total-cache/Cdn_MaxCdnFsd_Popup_View_Zones.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"52d7a16d6cd681b0c79d8b0d72917b89\";}s:46:\"wp-content/plugins/w3-total-cache/Cdn_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"bb2234e09dc9263bd5c0246d041caab3\";}s:69:\"wp-content/plugins/w3-total-cache/Cdn_Page_View_Fsd_HeaderActions.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"eb00ab429813c89fe66ae025fe3b10ff\";}s:58:\"wp-content/plugins/w3-total-cache/Cdn_Page_View_Header.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"a556ef892c84473bee57017cbde9ac24\";}s:48:\"wp-content/plugins/w3-total-cache/Cdn_Plugin.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"ddd5f3cc8b5c82648292d5711f5285a7\";}s:54:\"wp-content/plugins/w3-total-cache/Cdn_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"93f0b1866faa861488e062f6446fb0af\";}s:61:\"wp-content/plugins/w3-total-cache/Cdn_Plugin_WidgetMaxCdn.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"52755516914b2f474e0516aca51dbae0\";}s:61:\"wp-content/plugins/w3-total-cache/Cdn_Plugin_WidgetNetDna.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"b14e6bf6be4a64f2d23ab0e8c360d88b\";}s:67:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_AdminActions.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"1eb3da03e0370380eeb0863136105408\";}s:59:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"5dc566300ce755dc2e8825028c783081\";}s:63:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Page_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"fdb2b234da74d99ec95f8c76e07487c5\";}s:64:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Page_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"4fbe666fa8ecc09a46b28acb92a85055\";}s:60:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"cc2e19d69da76b11c20bd945478d0dde\";}s:82:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_ConfigureDomains.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"28466cd4a0fd0c3141e0e3f3356aac77\";}s:71:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"a7e68cad3f1113114bbeba1022f2a200\";}s:73:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Regions.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"833ef6c237b6930acbabc7c93ea80e0c\";}s:74:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Services.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"20164da04aa3b8617a3ae753ef562c48\";}s:83:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Service_Actualize.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"399d4eac0dfea98cf60b2ec67881b8c3\";}s:80:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Service_Create.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f8fde1eaa38b597ce51a7d08c2255bc2\";}s:81:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCdn_Popup_View_Service_Created.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"e0334473b1ece273ab4c36a789e42d34\";}s:66:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Page.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"4ca9bd4860d5c30dc61bb50e5e1cc95e\";}s:70:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Page_View.js\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"d46be08fea75b921ffa3f534be4a0fc3\";}s:71:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Page_View.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f0d04484a0f5081153966c056c56db28\";}s:67:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Popup.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"333218c8c456d447cd8b8d686bfd52b7\";}s:83:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Popup_View_Containers.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"f84db745cc64f734ed6cca0ec3a12d26\";}s:78:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"26c07c32c6f02d0464633fc9773cd2e0\";}s:80:\"wp-content/plugins/w3-total-cache/Cdn_RackSpaceCloudFiles_Popup_View_Regions.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"09c30994e8caf1e1567f268c17f4e59d\";}s:70:\"wp-content/plugins/w3-total-cache/Cdn_RackSpace_Api_CaCert-example.pem\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"34626577b5076f5d12f17543555a9b07\";}s:59:\"wp-content/plugins/w3-total-cache/Cdn_RackSpace_Api_Cdn.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"91e81d135ea1affa1ce1f0500f7e02b5\";}s:66:\"wp-content/plugins/w3-total-cache/Cdn_RackSpace_Api_CloudFiles.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"ad2d331397bbcda531df578446e444f8\";}s:69:\"wp-content/plugins/w3-total-cache/Cdn_RackSpace_Api_CloudFilesCdn.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"2335aa79fab7317229e89e37b2adf0e4\";}s:62:\"wp-content/plugins/w3-total-cache/Cdn_RackSpace_Api_Tokens.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"25b084096ba2caa6db697c7d3e0e1446\";}s:46:\"wp-content/plugins/w3-total-cache/Cdn_Util.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"4631d248093b11e7cb2e1e20143fae27\";}s:47:\"wp-content/plugins/w3-total-cache/changelog.txt\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"334b138cbc2ef4f53d3df4462f78d57e\";}s:41:\"wp-content/plugins/w3-total-cache/Cli.php\";a:2:{s:1:\"d\";i:1490249268;s:1:\"h\";s:32:\"12e54d2f75f31d941fda50f46ec9e18d\";}s:44:\"wp-content/plugins/w3-total-cache/Config.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"7b96061a70e335017e93d9fd5e832cdb\";}s:52:\"wp-content/plugins/w3-total-cache/ConfigCompiler.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"c98d20121998d40efb0764253579a3fe\";}s:48:\"wp-content/plugins/w3-total-cache/ConfigKeys.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"74862301afd866d311b5e1b16ca84bc1\";}s:49:\"wp-content/plugins/w3-total-cache/ConfigState.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"9d4a1982d22abc460f0326b759eb8b9b\";}s:53:\"wp-content/plugins/w3-total-cache/ConfigStateNote.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"1342f386ab015b26b53b1c77c438d2a0\";}s:58:\"wp-content/plugins/w3-total-cache/DbCache_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"4b36bfd43d9b9bb1e23511282082ede3\";}s:50:\"wp-content/plugins/w3-total-cache/DbCache_Core.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"28560a3c62f21c01bba6a45d707a3c92\";}s:57:\"wp-content/plugins/w3-total-cache/DbCache_Environment.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"855a79612b8edbbb09058ed6bd595570\";}s:50:\"wp-content/plugins/w3-total-cache/DbCache_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"082a0708acf0bfe0ba17e71cf67cbb47\";}s:52:\"wp-content/plugins/w3-total-cache/DbCache_Plugin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"9f601e4ee58f621948d3dd9ba58d6a1d\";}s:58:\"wp-content/plugins/w3-total-cache/DbCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"0e75efc720cd029327a29d30c0c07156\";}s:50:\"wp-content/plugins/w3-total-cache/DbCache_Wpdb.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"e554cc4148f86130ef4bb9207aba4e00\";}s:54:\"wp-content/plugins/w3-total-cache/DbCache_WpdbBase.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"ed9d3e947e15b53164af01077504a1eb\";}s:59:\"wp-content/plugins/w3-total-cache/DbCache_WpdbInjection.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"1018a56f060d1c70a729d2a96243c350\";}s:72:\"wp-content/plugins/w3-total-cache/DbCache_WpdbInjection_QueryCaching.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"9544e55680bdb42569744e8fcf21b7c8\";}s:48:\"wp-content/plugins/w3-total-cache/Dispatcher.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"abc6239fc3213e1a7fbd4eda363b6f1c\";}s:72:\"wp-content/plugins/w3-total-cache/Enterprise_CacheFlush_MakeSnsEvent.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"44f3768ddb783a09294b7f5eba64e97a\";}s:78:\"wp-content/plugins/w3-total-cache/Enterprise_Dbcache_WpdbInjection_Cluster.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"0775ec6794c7a46c2ec33061d10ad513\";}s:56:\"wp-content/plugins/w3-total-cache/Enterprise_SnsBase.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"09c0e7bfd078a7c059e489b66a35083a\";}s:58:\"wp-content/plugins/w3-total-cache/Enterprise_SnsServer.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"782dc61e5a4decc949598e1b2c8f06c0\";}s:73:\"wp-content/plugins/w3-total-cache/extension-example/Extension_Example.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"dc46137bfda5c8db01403137b66176ac\";}s:79:\"wp-content/plugins/w3-total-cache/extension-example/Extension_Example_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"afd7e86b514ab6ee16ef115bbddc65aa\";}s:83:\"wp-content/plugins/w3-total-cache/extension-example/Extension_Example_Page_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"b5c64325a28266dffdf14b76a155a336\";}s:78:\"wp-content/plugins/w3-total-cache/extension-example/w3-total-cache-example.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"605f32854a35821c89c498a2954800cc\";}s:61:\"wp-content/plugins/w3-total-cache/Extensions_AdminActions.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"85cf5045b8eff4aaaac7fc05f9018afc\";}s:53:\"wp-content/plugins/w3-total-cache/Extensions_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"db04dc560441b7f5750a177063d9b7ad\";}s:61:\"wp-content/plugins/w3-total-cache/Extensions_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"032b8ac4e2bf7f35fe1f86f7dd7d4e92\";}s:53:\"wp-content/plugins/w3-total-cache/Extensions_Util.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"5ee0c59950232d68a9e7c881c9e1afa5\";}s:58:\"wp-content/plugins/w3-total-cache/Extension_Amp_Plugin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"6c83d2b5de4f77b3730fed681737cf47\";}s:64:\"wp-content/plugins/w3-total-cache/Extension_Amp_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"caa8b0a289cf0f2e50ee98da8063eaee\";}s:71:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_AdminActions.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"07c90039d16fdc6e7c21c7ef62a6d4d9\";}s:62:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Api.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"5385386bb3e8416857752cc52fab08cb\";}s:75:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_GeneralPage_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"c4512b267a321456918be6e2fa073987\";}s:63:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"5f75750638953dfb34f90ab7410af5e2\";}s:67:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Page_View.js\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"9bb186c8e0e18db0d63847f979bedce9\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Page_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"518c69f1f51ea221cdbfe77251e1a448\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Plugin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"ceda219c567997ae3710feaee899bee7\";}s:71:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"a7e246457e3b50c47c891fe08ae86a28\";}s:64:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Popup.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"2a6f1499f3eed100c1c82af06201f7e5\";}s:75:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"b70bdee4cfe24990e92c3386bb3c949b\";}s:75:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Popup_View_Zones.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"cdc5037282206c5b782424d8c2680d0c\";}s:72:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_SettingsForUi.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"d5d0631ea046d45fb1d177fe4fb43cd8\";}s:72:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_View_Comments.css\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"633ab7e999a0b6e6c2becbccf03d83ae\";}s:71:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_View_Comments.js\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"e0b7ae29ac39ab2e9e491f4786e4107f\";}s:72:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_View_Dashboard.js\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"1e52e47a927428cb8a1d7c6b879415f7\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Widget.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"00512927221b61a4d490b88f48debd47\";}s:70:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Widget_View.css\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"c9d853505db839eaba8d9e35b3056f77\";}s:70:\"wp-content/plugins/w3-total-cache/Extension_CloudFlare_Widget_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"8af48ada48db36b6116577ece0ffa8d0\";}s:70:\"wp-content/plugins/w3-total-cache/Extension_FeedBurner_Environment.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"bb44605f94ce7b8927d32c55e1e800e0\";}s:63:\"wp-content/plugins/w3-total-cache/Extension_FeedBurner_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"a2c04c22aaed013904164eb8b6be7807\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_FeedBurner_Page_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"876e3a4ad16697623215752352efffcf\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_FeedBurner_Plugin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"4e78eac5505ce5226c7091cd014318cf\";}s:71:\"wp-content/plugins/w3-total-cache/Extension_FeedBurner_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"34c7daaab1b0ff6807e3dac0850a9b89\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Api.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"a60f749a950334d798cf9bc80fd920ae\";}s:66:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Core.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"111373d7cc8501ef295b1328b1647bc8\";}s:73:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Environment.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"4525e272283a783033cc670061f205a2\";}s:73:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_GeneralPage.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"58bb84cb011eb7ac9008ecfb589bc35a\";}s:78:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_GeneralPage_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"716edc0b8052fbc9f182af948d50cbe4\";}s:66:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"592dcd1015bd27ea1c351c63ce1eac35\";}s:71:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Page_View.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"36807d1a6dcda20c1ae0bf5905d564cb\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Plugin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"adeeb2c2b556bdfda34dde10485446a9\";}s:74:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"97a10c3a7c15a200f99d937253238fdb\";}s:75:\"wp-content/plugins/w3-total-cache/Extension_FragmentCache_WpObjectCache.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"45af28e660e12e0061f7650e5e43be6c\";}s:60:\"wp-content/plugins/w3-total-cache/Extension_Genesis_Page.php\";a:2:{s:1:\"d\";i:1490249269;s:1:\"h\";s:32:\"af7ba13f1ffb67d617a005e10726a82e\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_Genesis_Page_View.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"acf7fc88e84c4d40c7332476aa28be43\";}s:62:\"wp-content/plugins/w3-total-cache/Extension_Genesis_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1b89566e62683d9f58e50fabac351412\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_Genesis_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1af9fa04dbe1a98873aae52dd5aefa4c\";}s:69:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_AdminActions.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"26267ee2253e0f69db3910269ee33cdc\";}s:67:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_AdminNotes.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"6d89d5ae0cd5ac6b3df8c4c75990594c\";}s:60:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Api.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"7b7251820999762db2de77a354b3bb85\";}s:61:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Core.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d8ad85e8f6d844aaa5e2f0a965637ecd\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_GeneralPage.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"37c1a0ec36bbf6a83cc23059a1743a14\";}s:73:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_GeneralPage_View.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"3945d4b92d159ecc90c64ee2fce194d4\";}s:61:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Page.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"ef210fe722ea011ef394b310d56bfe51\";}s:70:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Page_View_Apm.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"ad8fe4dec635e32f42f83e4c6e820d65\";}s:63:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"eaefd74153e7d7854879561a6784bea0\";}s:69:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"805a61594ae615421295c4e2f62195ab\";}s:62:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Popup.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"c1a8d470d5e9df7142bc935e42714f67\";}s:66:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Popup_View.js\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"5f0de4f3a6b09347f1fe4d1ef86a801d\";}s:73:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Popup_View_Intro.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"bcba31ade2f39e7e0b07e3ba51011ed6\";}s:84:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Popup_View_ListApplications.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"8226c6f4021de15de0f0f1e8d48d9dfd\";}s:64:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Service.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"8c133256b65ee644d2fa58ee67508014\";}s:63:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"e61f533e83ad0cc0f63adb56791a083c\";}s:68:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget_View.css\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"61e8c1517c7a16eab9d6bc6d80cbe978\";}s:67:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget_View.js\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"8df35ef8834de4416320cc8ae196a228\";}s:72:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget_View_Apm.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"ff4e63029ac89cda35128474c81f2a5c\";}s:76:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget_View_Browser.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"37e5def865d0557f9eefa3e88573ca47\";}s:82:\"wp-content/plugins/w3-total-cache/Extension_NewRelic_Widget_View_NotConfigured.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1b6d85a52e69c6655d3ae75261cf859d\";}s:67:\"wp-content/plugins/w3-total-cache/Extension_WordPressSeo_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"067bf5eb7e126a929bbd84970746fef3\";}s:73:\"wp-content/plugins/w3-total-cache/Extension_WordPressSeo_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"fd1545896e1e76dc92558ecf25be5103\";}s:59:\"wp-content/plugins/w3-total-cache/Extension_Wpml_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"57c46c2786027a4810239325a2ff4b16\";}s:65:\"wp-content/plugins/w3-total-cache/Extension_Wpml_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"b28d27c79fbf3d72a41c0f30e403bec2\";}s:65:\"wp-content/plugins/w3-total-cache/Generic_AdminActions_Config.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"cae5c4d2fc7381552031f5c67862af48\";}s:66:\"wp-content/plugins/w3-total-cache/Generic_AdminActions_Default.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"546a824baf3d253428bb4a7541fd9e05\";}s:67:\"wp-content/plugins/w3-total-cache/Generic_AdminActions_EdgeMode.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"0e6f7e252bc53cd527ce96159df50d6e\";}s:64:\"wp-content/plugins/w3-total-cache/Generic_AdminActions_Flush.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"19b6cc73abdfdd9ad41cb80a2ff845f0\";}s:63:\"wp-content/plugins/w3-total-cache/Generic_AdminActions_Test.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"3e73fec34d3d376806dadb0225a9cff5\";}s:56:\"wp-content/plugins/w3-total-cache/Generic_AdminLinks.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"aad4fb1ae4853c79653ec313e2154341\";}s:56:\"wp-content/plugins/w3-total-cache/Generic_AdminNotes.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"b185ea590d61e4845120d9941d128cd9\";}s:58:\"wp-content/plugins/w3-total-cache/Generic_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"7baf7d7736db0bd79002e85acd503828\";}s:57:\"wp-content/plugins/w3-total-cache/Generic_Environment.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"a59b9a4314499634ec0d44361819aea5\";}s:49:\"wp-content/plugins/w3-total-cache/Generic_Faq.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"75a4c3cc6dd000afe299007426a6810c\";}s:70:\"wp-content/plugins/w3-total-cache/Generic_GeneralPage_View_ShowEdge.js\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"b612671b652f9b8fecf92f3c6816ec05\";}s:75:\"wp-content/plugins/w3-total-cache/Generic_GeneralPage_View_ShowSupportUs.js\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"a6f6117358ae8e465794ea5a41208f97\";}s:56:\"wp-content/plugins/w3-total-cache/Generic_Page_About.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"8fca00053ba61c47da7f61417dbccfac\";}s:60:\"wp-content/plugins/w3-total-cache/Generic_Page_Dashboard.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"171a6746c5ed16951a01832eb54e73c2\";}s:65:\"wp-content/plugins/w3-total-cache/Generic_Page_Dashboard_View.css\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"77d550751f99242e4532bad09dbbb86a\";}s:54:\"wp-content/plugins/w3-total-cache/Generic_Page_Faq.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"e96460a727f71f3ad178fd11963adfea\";}s:58:\"wp-content/plugins/w3-total-cache/Generic_Page_General.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"dd97499b01538f017ec20a4bd9417372\";}s:58:\"wp-content/plugins/w3-total-cache/Generic_Page_Install.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"aca3261e5812d2f46e120fb001c4fd37\";}s:52:\"wp-content/plugins/w3-total-cache/Generic_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d203673e104a1d56897a711f6818519f\";}s:58:\"wp-content/plugins/w3-total-cache/Generic_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d40035982e2c63b163ad9176763dc37a\";}s:71:\"wp-content/plugins/w3-total-cache/Generic_Plugin_AdminCompatibility.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"ea952956a185ad06920b137ed5fe6d7d\";}s:71:\"wp-content/plugins/w3-total-cache/Generic_Plugin_AdminNotifications.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1bf78f6563b522785fa3148097e2baac\";}s:68:\"wp-content/plugins/w3-total-cache/Generic_Plugin_AdminRowActions.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"9d854aa4719dea32f752f8d9dbb577ca\";}s:64:\"wp-content/plugins/w3-total-cache/Generic_Plugin_WidgetForum.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"a773a53a791615802bd83179df92e09d\";}s:63:\"wp-content/plugins/w3-total-cache/Generic_Plugin_WidgetNews.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"41f0ae290cfaaea28ac5a861a2c2ae83\";}s:60:\"wp-content/plugins/w3-total-cache/Generic_WidgetServices.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"8e1d0729212be24b2175eb9f3c5dc199\";}s:65:\"wp-content/plugins/w3-total-cache/Generic_WidgetServices_View.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"ec5685f64ea897f36f33427d96610225\";}s:64:\"wp-content/plugins/w3-total-cache/Generic_WidgetSpreadTheWord.js\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"e623cb447a34ccbee8f0b2ee32459677\";}s:72:\"wp-content/plugins/w3-total-cache/Generic_WidgetSpreadTheWord_Plugin.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"f227a5127209ceec0cea35299d2f5fb4\";}s:70:\"wp-content/plugins/w3-total-cache/Generic_WidgetSpreadTheWord_View.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"a32e2c7782f6844e9ddb3a0a0f8c8c3b\";}s:48:\"wp-content/plugins/w3-total-cache/inc/define.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1bc3d0a68a9d93e99c47b0441d7c0aec\";}s:54:\"wp-content/plugins/w3-total-cache/inc/email/index.html\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:74:\"wp-content/plugins/w3-total-cache/inc/email/minify_error_notification.html\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"7b64d948b142dd10d1bf501dc135bd1d\";}s:73:\"wp-content/plugins/w3-total-cache/inc/email/minify_error_notification.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"7b64d948b142dd10d1bf501dc135bd1d\";}s:63:\"wp-content/plugins/w3-total-cache/inc/email/support_request.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d00db396a565f2a27a9a343833b3574b\";}s:47:\"wp-content/plugins/w3-total-cache/inc/error.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"cf2a244df09c163939a4378e123f1985\";}s:48:\"wp-content/plugins/w3-total-cache/inc/index.html\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:73:\"wp-content/plugins/w3-total-cache/inc/lightbox/cdn_s3_bucket_location.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"660ffb336b6039a26f796b7a221637b2\";}s:81:\"wp-content/plugins/w3-total-cache/inc/lightbox/create_netdna_maxcdn_pull_zone.php\";a:2:{s:1:\"d\";i:1490249270;s:1:\"h\";s:32:\"1dfd1db2963dd0d2d9c7eda9e14b89ce\";}s:55:\"wp-content/plugins/w3-total-cache/inc/lightbox/edge.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"b63422a257b30998804eb07c28e614db\";}s:57:\"wp-content/plugins/w3-total-cache/inc/lightbox/index.html\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:73:\"wp-content/plugins/w3-total-cache/inc/lightbox/minify_recommendations.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"e1e0df7ee6db217db0d7711b316da70c\";}s:59:\"wp-content/plugins/w3-total-cache/inc/lightbox/purchase.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"92a375a8f3f89d9dbd6ab63c58628b3f\";}s:60:\"wp-content/plugins/w3-total-cache/inc/lightbox/self_test.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"8ebadc91103c18e8f3451150d2c5194c\";}s:61:\"wp-content/plugins/w3-total-cache/inc/lightbox/support_us.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"d699166e776f7d7a2e15b0cc788c9f85\";}s:58:\"wp-content/plugins/w3-total-cache/inc/lightbox/upgrade.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"b1f7e5c465c5d4f913d83199c8d9cfcc\";}s:50:\"wp-content/plugins/w3-total-cache/inc/mime/all.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"cf8f50f29eeae921728984cf40294c48\";}s:52:\"wp-content/plugins/w3-total-cache/inc/mime/cssjs.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"2abdccc5bfb3b008b08c576ca3dc6afd\";}s:51:\"wp-content/plugins/w3-total-cache/inc/mime/html.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"df61a43aa99d4469f05c50316c8bdbce\";}s:53:\"wp-content/plugins/w3-total-cache/inc/mime/index.html\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:52:\"wp-content/plugins/w3-total-cache/inc/mime/other.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"dbaf81cf75ab4787b78989f79cbd9605\";}s:55:\"wp-content/plugins/w3-total-cache/inc/options/about.php\";a:2:{s:1:\"d\";i:1490249271;s:1:\"h\";s:32:\"d0309ccd83408515f237bd426285b45e\";}s:62:\"wp-content/plugins/w3-total-cache/inc/options/browsercache.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"133db10c39678182f98d42b3f0ef7a39\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/cdn/akamai.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"f8c99770f9c70df1182bcd3a3735ed31\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/cdn/att.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"2f2fd9406a127faf7561a9b6b016f2dd\";}s:59:\"wp-content/plugins/w3-total-cache/inc/options/cdn/azure.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"fdfe139b28a34c710f894f2807320740\";}s:56:\"wp-content/plugins/w3-total-cache/inc/options/cdn/cf.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"9f99cecce037c444a1b8acb3a25a91c8\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/cdn/cf2.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"e2c71823824e2932ccf089ff2f9c1374\";}s:76:\"wp-content/plugins/w3-total-cache/inc/options/cdn/common/cnames-readonly.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"61716067d21c277dfbde760dcaafd513\";}s:67:\"wp-content/plugins/w3-total-cache/inc/options/cdn/common/cnames.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"681bdbb87cd17ef12f2566d0f1b3c868\";}s:67:\"wp-content/plugins/w3-total-cache/inc/options/cdn/common/index.html\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/cdn/cotendo.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"6fa7b525596b48d03cadf02a30111198\";}s:62:\"wp-content/plugins/w3-total-cache/inc/options/cdn/edgecast.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"09ec8cd56a9bd95486c3c908501ff30c\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/cdn/ftp.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"cb3735be92484c3568082b6c601ad617\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/cdn/index.html\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/cdn/maxcdn.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"23fb1167dc266497a5ad6bddf989a982\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/cdn/mirror.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"5f3685df9bf0c83ff312e32903c13287\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/cdn/netdna.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"b83c3242b62eb29f51e3a736fe0c9184\";}s:58:\"wp-content/plugins/w3-total-cache/inc/options/cdn/rscf.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"979403f3d13a5d8c4da2ae5c11554c84\";}s:56:\"wp-content/plugins/w3-total-cache/inc/options/cdn/s3.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"1383c4f8860688b37011ae7eee465bb8\";}s:67:\"wp-content/plugins/w3-total-cache/inc/options/cdn/s3_compatible.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"d99ff5178b35d79dbd600c7053c81b76\";}s:53:\"wp-content/plugins/w3-total-cache/inc/options/cdn.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"8d0945f9eac8a60343169badc5f2ddeb\";}s:63:\"wp-content/plugins/w3-total-cache/inc/options/common/footer.php\";a:2:{s:1:\"d\";i:1490249272;s:1:\"h\";s:32:\"7e7acd0117eeb58b8f1fc7c2e95ebd27\";}s:63:\"wp-content/plugins/w3-total-cache/inc/options/common/header.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"6ea87df47acf517f18a09ff18c8f80b1\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/common/help.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"8e654e14e345bc0a25a2e546700b77ef\";}s:63:\"wp-content/plugins/w3-total-cache/inc/options/common/index.html\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:59:\"wp-content/plugins/w3-total-cache/inc/options/dashboard.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"555d39ea7fafe44a44c54eeb91d14695\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/dbcache.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"5921cf90a775bc500ae3ba81e11656bb\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/edd/buy.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"dcd2bbb409f50c2a270e48ce88709f56\";}s:77:\"wp-content/plugins/w3-total-cache/inc/options/enterprise/dbcluster-config.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"39980cccdcf64ab404c8fdaafdd56c88\";}s:86:\"wp-content/plugins/w3-total-cache/inc/options/enterprise/dbcluster_general_section.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"3d75b3f1cbbe6fcd0742601644d3fe71\";}s:65:\"wp-content/plugins/w3-total-cache/inc/options/extensions/list.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"c65f43bbfee54ceeb14ce8ccff8cfd6c\";}s:69:\"wp-content/plugins/w3-total-cache/inc/options/extensions/settings.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"f71a2188cc879a7d6e84a5ab9c5fc0a2\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/extensions.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"e93b3f3830f7234b7de7d66458f9dd54\";}s:53:\"wp-content/plugins/w3-total-cache/inc/options/faq.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"823ce682b2109789c77a04f07dc62ae3\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/general.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"f07fecbc4359bd8ccf3dc02858dada3b\";}s:56:\"wp-content/plugins/w3-total-cache/inc/options/index.html\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/install.php\";a:2:{s:1:\"d\";i:1490249273;s:1:\"h\";s:32:\"35a64633a93bd09f8668ba7aa358d883\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/minify/ccjs.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"3e33bdedad237f5d763bf27ba3c2297c\";}s:62:\"wp-content/plugins/w3-total-cache/inc/options/minify/ccjs2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"4989ba0e6c86d83a034489fb2df46ebf\";}s:60:\"wp-content/plugins/w3-total-cache/inc/options/minify/css.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"d49d473640ec328cc42f49bc15124e55\";}s:64:\"wp-content/plugins/w3-total-cache/inc/options/minify/csstidy.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"391f0b0d82ca7d88926055f17ce6821b\";}s:65:\"wp-content/plugins/w3-total-cache/inc/options/minify/csstidy2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"75e75995dcf364f0d88bef869ab8ccb9\";}s:68:\"wp-content/plugins/w3-total-cache/inc/options/minify/googleccjs2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"8e4f34b272c9e9e7e566fc094d1a3980\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/minify/html.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"5ab2dd0c16de6b4f48d7701a0b27dda1\";}s:65:\"wp-content/plugins/w3-total-cache/inc/options/minify/htmltidy.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"43c72f5e49a1a0e279489b089a7874b6\";}s:66:\"wp-content/plugins/w3-total-cache/inc/options/minify/htmltidy2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"85e0784022025e10c42a661c864e703b\";}s:63:\"wp-content/plugins/w3-total-cache/inc/options/minify/index.html\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:59:\"wp-content/plugins/w3-total-cache/inc/options/minify/js.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"11402801b3a5e7710d76cdc39c56af23\";}s:64:\"wp-content/plugins/w3-total-cache/inc/options/minify/yuicss2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"2de10bc04e254e10286ae49da441baf6\";}s:62:\"wp-content/plugins/w3-total-cache/inc/options/minify/yuijs.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"c014bc9f119a102aa7d0940b67d1a00a\";}s:63:\"wp-content/plugins/w3-total-cache/inc/options/minify/yuijs2.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"3750ef1eea0705aa0b3bed43a28949bd\";}s:56:\"wp-content/plugins/w3-total-cache/inc/options/minify.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"07d8b3acb6e47eaa03b3b728e18493d8\";}s:56:\"wp-content/plugins/w3-total-cache/inc/options/mobile.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"185afe7cb44893b89dc7d30d61dd082e\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/objectcache.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"7ce66a15c04a7e4eb69b490495db963d\";}s:65:\"wp-content/plugins/w3-total-cache/inc/options/parts/memcached.php\";a:2:{s:1:\"d\";i:1490249274;s:1:\"h\";s:32:\"0e4a986f025fa18668b03daf14a25f00\";}s:75:\"wp-content/plugins/w3-total-cache/inc/options/parts/memcached_extension.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"04785f8fa25f5445e4369f289dc5a0fa\";}s:61:\"wp-content/plugins/w3-total-cache/inc/options/parts/redis.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"6eae9105f8e1c814a83ec0373bf7e77b\";}s:71:\"wp-content/plugins/w3-total-cache/inc/options/parts/redis_extension.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"031130038b9e1a3aa1ede2a3593b8ac7\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/pgcache.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"c980879893b2cf356bbd6c8817e6bee5\";}s:58:\"wp-content/plugins/w3-total-cache/inc/options/referrer.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"3c48bdd24986d05e7985cb4a84491cb9\";}s:57:\"wp-content/plugins/w3-total-cache/inc/options/support.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"cbcd84a6f5e6bc38bd225d6ee0410818\";}s:63:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_export_file.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d3db4301394644ad5d9211df8197dfcb\";}s:66:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_export_library.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"aa0960b2de99de21b5c7c5aa2e4435f1\";}s:66:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_import_library.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"4612a6167f31dfd438e08c0f535f3a87\";}s:57:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_purge.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"34512e3700019f6e4d67fb795e076661\";}s:57:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_queue.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"84b23b8f55bfba2aea83414fc845a80c\";}s:65:\"wp-content/plugins/w3-total-cache/inc/popup/cdn_rename_domain.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"9621ff088d9c7fa408fa4d47d3a49013\";}s:61:\"wp-content/plugins/w3-total-cache/inc/popup/common/footer.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"f7f3f12fff874b9d02fbf0d14a107e0f\";}s:61:\"wp-content/plugins/w3-total-cache/inc/popup/common/header.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"4250825ccfd7ccb9dd00ce3e3bddf065\";}s:61:\"wp-content/plugins/w3-total-cache/inc/popup/common/index.html\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:54:\"wp-content/plugins/w3-total-cache/inc/popup/index.html\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:65:\"wp-content/plugins/w3-total-cache/inc/popup/pagespeed_results.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"0654bb91d961a6705bfd0aa1a9c27d11\";}s:55:\"wp-content/plugins/w3-total-cache/inc/widget/index.html\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:55:\"wp-content/plugins/w3-total-cache/inc/widget/latest.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"e9683421dec63eb1380a9dadebbbdf24\";}s:60:\"wp-content/plugins/w3-total-cache/inc/widget/latest_ajax.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"6b7b400833b4423eb769867f2ccb6036\";}s:63:\"wp-content/plugins/w3-total-cache/inc/widget/latest_control.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"8f1dd7edebc11dbb79e24904a46aa87c\";}s:60:\"wp-content/plugins/w3-total-cache/inc/widget/latest_news.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"e9683421dec63eb1380a9dadebbbdf24\";}s:65:\"wp-content/plugins/w3-total-cache/inc/widget/latest_news_ajax.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"1d1e5990159a809a26fa8ca3a1686936\";}s:68:\"wp-content/plugins/w3-total-cache/inc/widget/latest_news_control.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"68b3546a782a347a4863f9f5e69c0a18\";}s:55:\"wp-content/plugins/w3-total-cache/inc/widget/maxcdn.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"88a94fb9790276df395ef26280a997a1\";}s:62:\"wp-content/plugins/w3-total-cache/inc/widget/maxcdn_signup.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"a216c8a5da2039c314776f85894b6c3d\";}s:55:\"wp-content/plugins/w3-total-cache/inc/widget/netdna.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"4f79068777ba875c2428a0f6842f457b\";}s:62:\"wp-content/plugins/w3-total-cache/inc/widget/netdna_signup.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"7e74e88c93fb4141864e5bb0529e9c66\";}s:44:\"wp-content/plugins/w3-total-cache/index.html\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:45:\"wp-content/plugins/w3-total-cache/ini/apc.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"a23acbe2b79ba8c3469600eb5e55d251\";}s:65:\"wp-content/plugins/w3-total-cache/ini/dbcluster-config-sample.php\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"cd291b453b9f117a27aef3b48d464c2d\";}s:54:\"wp-content/plugins/w3-total-cache/ini/eaccelerator.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"efce6df5152c0678bde95f0dff770b52\";}s:48:\"wp-content/plugins/w3-total-cache/ini/index.html\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:50:\"wp-content/plugins/w3-total-cache/ini/memcache.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"3005b85c659bae6cf8c762bb2f6318c0\";}s:70:\"wp-content/plugins/w3-total-cache/ini/nginx-network-sample-config.conf\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"a4581f262593f87655eab23ae8b17b64\";}s:73:\"wp-content/plugins/w3-total-cache/ini/nginx-standalone-sample-config.conf\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"8664d6b92388fe00e0f50a111089c06f\";}s:49:\"wp-content/plugins/w3-total-cache/ini/opcache.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"9d46ab58e10d2937f1129edbbbdf3483\";}s:52:\"wp-content/plugins/w3-total-cache/ini/php.append.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"89170804e3585b690f3a91e5e38338bd\";}s:58:\"wp-content/plugins/w3-total-cache/ini/s3-sample-policy.txt\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"e6f1d4a45ee02007e3eb3d0162991f51\";}s:63:\"wp-content/plugins/w3-total-cache/ini/varnish-sample-config.vcl\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"a69246128ca199f4a820a30e5647ecae\";}s:48:\"wp-content/plugins/w3-total-cache/ini/xcache.ini\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"3bdec61187c05217be7348df51c0d574\";}s:68:\"wp-content/plugins/w3-total-cache/languages/faq-enterprise-en_US.xml\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"407b48e35bf50f63f798532906762120\";}s:57:\"wp-content/plugins/w3-total-cache/languages/faq-en_US.xml\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"55aeaa16b57946b6dd84265b38d99c81\";}s:61:\"wp-content/plugins/w3-total-cache/languages/faq-pro-en_US.xml\";a:2:{s:1:\"d\";i:1490249275;s:1:\"h\";s:32:\"259aba6b1d18dca2431adbd3b32ea04e\";}s:62:\"wp-content/plugins/w3-total-cache/languages/w3-total-cache.pot\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"b27390b74f58996aaf3a9ee759b0a891\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Client.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"4f116d439fd06d64da5d3cb2bd765439\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/ClientInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"59a3e49db021b1ba3392d08f07754319\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Cookie/CookieJar.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"8af307569bc5483ea7df423555672cf7\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Cookie/CookieJarInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"0cd2c557aba26246ef86188f882a53b2\";}s:79:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Cookie/FileCookieJar.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"ecdc4a51c4285b588284188cb51ba212\";}s:82:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Cookie/SessionCookieJar.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"3ecf615008dc2288a86bd2f77d1ba5ad\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Cookie/SetCookie.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"683c055fa72355f8d7b37a3a9f1fdc18\";}s:89:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/BadResponseException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"5d502016856c146aa47d0bbed5106ee1\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/ClientException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d1c7f54a71cb105131c0c22b20619bcb\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/ConnectException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"4c3a541bc2a97f9278417c8ccd49a256\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/GuzzleException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"be57c551f72e6faff7af43b4bf27c95e\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/RequestException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"96e3509db51ccbaff2e9a801bb0d4e37\";}s:82:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/SeekException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d3321b4b634f612a98acd08e08ef6e74\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/ServerException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"36ecb7a8e416e9633b10e677fa5a639e\";}s:94:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/TooManyRedirectsException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"9952c5877077fad22bed15fbe04a1ca7\";}s:86:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Exception/TransferException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"67921f32b8ca0b62c1640262b48a1055\";}s:68:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/functions.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"0f28c4525f3ba3b7edbd20916f0dff8e\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/functions_include.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"5f6ee7f97cc86838635c9c1350415bc8\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/CurlFactory.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"7451a32af69647548e6850c883db22bb\";}s:87:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/CurlFactoryInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"b4dbdca4de39177941fbea19855eb74f\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/CurlHandler.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"18c8727a9457cf6d1f382b4cb394979f\";}s:83:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/CurlMultiHandler.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"dc20cc9837a45e56607bbcb5d89024fa\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/EasyHandle.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"02eec42dd5ec3cd6ef6cca4735c2eb9b\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/MockHandler.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"1e989983e107b30c02697de55cf00b35\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/Proxy.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"0eade7e36c32b1b98a70483348ca98f9\";}s:80:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Handler/StreamHandler.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"4db311c8bf154a28abb32e8df3382e7c\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/HandlerStack.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"ccd0aeb3a6975d8f3836dea18603ad6d\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/MessageFormatter.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"ddc316fe5a1d06a0c129e6a65cd36cfc\";}s:69:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Middleware.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d410c016da6acbb32969f96657821e62\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Pool.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"05269a24991f95c28cead841ac0b7a13\";}s:80:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/PrepareBodyMiddleware.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"fee264e3f0640f8086d184c28906fdf4\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/AggregateException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"babe9fcc334d0b4fea85e9e05f4d552e\";}s:88:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/CancellationException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a9a2fbcbd5dcfb0fdfb3feaf5c7b4324\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/Coroutine.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"e85129b6991bc6e91430d638b94acaf2\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/EachPromise.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"df6789b4bd35f2bbd68cb5faf46d79ad\";}s:83:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/FulfilledPromise.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d6001563130d4d92f1b58eeb714c117d\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/functions.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"2ff33484d4b21748efdd577c6b6a45c1\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/functions_include.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"f5cb9de3f9980feda6ea3341215bf7ac\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/Promise.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"5ec444867e365565e1821f0ad47f965b\";}s:83:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/PromiseInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d89b4dc299c87456f210c253c6b94e22\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/PromisorInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a9d3c230da1e74e747cf37099bbf3dfa\";}s:82:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/RejectedPromise.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"0dec3a7152df237c1138075adba8f77a\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/RejectionException.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"dcf7b821573f91b31bf52e9f00e494bd\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/TaskQueue.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"f689afac69023ad70c4239acc0594760\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Promise/TaskQueueInterface.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"93f20d7dee241a3a2acfb9f378d0446c\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/AppendStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"c3a6a4c089d769f6c2f48587f2ea73b6\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/BufferStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"ca89bcf988c8e4d13a39d5febb985331\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/CachingStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"9044f074880bee4ad2d17f1097055e68\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/DroppingStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"adac9db8a35c6892151e065e9eadd8ac\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/FnStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"8c73770e5baa5e7cc4df48ee852f63c1\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/functions.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"7eb219d6c8b23351ed64d40ae8b6c738\";}s:81:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/functions_include.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"847190da01ae741e44241753f23cc1da\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/InflateStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"3b09783825c0a3d024bb1b8f4f99b476\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/LazyOpenStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"2648cdbb073317f8ea813383393aee2b\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/LimitStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"957492238ad22a50fdc79dc31cdfe605\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/MessageTrait.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a6b829b5cc2644e0af0e0cc7a55a5b95\";}s:79:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/MultipartStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a62ba2ea6d57a5fdde0b7541265f4a4c\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/NoSeekStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a0717a0ab4fe202dcc050b0aa46e375b\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/PumpStream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"55ac4bb5f9a26cd93e5fa10a1f5132c3\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/Request.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"607dc1e7fa7118bd807ae2562229bdf1\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/Response.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"e0eb0ba0d8a7394818846ce7789e7410\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/ServerRequest.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"3b3a9349d18435f413aef70d8f79f72c\";}s:70:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/Stream.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"c5bf50476cf7c5ea7f9c325cc66362b8\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/StreamDecoratorTrait.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"d4b43ceea144a8327ee0ef440c83bf8b\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/StreamWrapper.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"cf8a930a24993a423894f705ad7825a7\";}s:76:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/UploadedFile.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"a36b94212547cd38bb7857f030258a01\";}s:67:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/Psr7/Uri.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"01c9343599ff38afcb225c1d36d87a7c\";}s:77:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/RedirectMiddleware.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"8970586ea24f21c963050313ceef3909\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/RequestOptions.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"b448222661f034a6b8368bb7e5b769ce\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/RetryMiddleware.php\";a:2:{s:1:\"d\";i:1490249276;s:1:\"h\";s:32:\"2267eeb5be0a87f30d543334482880f1\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/TransferStats.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"f94bd1d051bac09f9538b8b8720084e6\";}s:70:\"wp-content/plugins/w3-total-cache/lib/Azure/GuzzleHttp/UriTemplate.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"8e71ed1dd6b3906cbf29cacf35e06395\";}s:54:\"wp-content/plugins/w3-total-cache/lib/Azure/loader.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"0484c7c950fa5c195cbac0d34d1155af\";}s:88:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/BlobRestProxy.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"15ddc60a39dd9735cc9e084650fd0a04\";}s:89:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Internal/IBlob.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"bf02b2c40df26182f3a8de0cd5de748b\";}s:97:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/AccessCondition.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"2877c466f5c54f75c787a24e4db6ca29\";}s:94:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/AccessPolicy.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"16efa61d77bce09f7bf522c598178db3\";}s:101:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/AcquireLeaseOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"7c876534ffc96288f674a6c447b9d7ed\";}s:100:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/AcquireLeaseResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"7721fe63b43e99d74882c3d47f3e047c\";}s:86:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/Blob.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"de80d722daaf1fc8fa6029ce38b77382\";}s:95:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlobBlockType.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"8408a488673febe76a6dcf23423f70e2\";}s:92:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlobPrefix.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"2bdee7122c9ef7677008ce4bfce950d8\";}s:96:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlobProperties.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"43697b57cf367312fadd6c70dd3ab84c\";}s:100:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlobServiceOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"97739fdb9b4982072ccd385fe46f2edb\";}s:90:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlobType.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"1afa7c7cf45161b40452010843b98454\";}s:87:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/Block.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"128777c196aafed312ca028f91cc3dfd\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BlockList.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"e1946998692a30ec506c95c1dc923d0d\";}s:98:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/BreakLeaseResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"f46efc8cc5f29e1a878aac66a6e3680f\";}s:105:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CommitBlobBlocksOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"8f4911b72584942fade0963b40317b9f\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/Container.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"7b079282fc5f292182c49e61f9f395ba\";}s:94:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ContainerACL.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"cb0977a783e2f3d3619001e633476ee5\";}s:101:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ContainerProperties.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"b0a3b94b10a46fa2d97b7998ca3f8ee8\";}s:97:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CopyBlobOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"511d3d77b2cddb33c7f5b4805e5751f2\";}s:96:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CopyBlobResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"4838863a8fa6ff0e661f48d328632da2\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobBlockOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"eb9f17038c23f787babaa22d01d4004e\";}s:99:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"300e37076d1221fc1250bfa2620a4a9c\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobPagesOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"4a662b8301f7b5b3a07c5754f39ae1bb\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobPagesResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"05f84b06a80d3ec6cb9a0456b94456bc\";}s:107:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobSnapshotOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"53439c72217c730675347ff95550aae0\";}s:106:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateBlobSnapshotResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"200cf1a0e6c832644bedc8c6dfd05240\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/CreateContainerOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"9605304dbe2f4f9bca63eb752667d090\";}s:99:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/DeleteBlobOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"1fda65dcb09f2bbc2bb450153983bfec\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/DeleteContainerOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"b4dd312b7446865f8d5e8d16a24040db\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobMetadataOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"da1d8c8528555c0a00f4b5476678b181\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobMetadataResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"45b1cbfd9b2668535564bd91e64beab1\";}s:96:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"713169eef963e3f61feb1afa50714346\";}s:106:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobPropertiesOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"f86dd6144b88e7cda7551a7a8fccbfde\";}s:105:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobPropertiesResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"a344b403ad954e469c0b2ddec59c6644\";}s:95:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetBlobResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"791f8a7dc8b8dc798819ae1fb6351113\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetContainerACLResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"030ce03e9e1c1ade65b0004bb794c753\";}s:110:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/GetContainerPropertiesResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"b14fcb7a2a693a49328b54d5526d9fac\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/LeaseMode.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"71ae1f41417bdc39af4b9366b523e58f\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListBlobBlocksOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"c0bf13af1e7a6513f6da872e14657e08\";}s:102:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListBlobBlocksResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"24f971d52a42355641e62cf87a1bb799\";}s:98:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListBlobsOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"2135a1cfe53791aed2ca9c99704dc05b\";}s:97:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListBlobsResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"77e908ccf7ef4fbaae5a2df3a8b78b3e\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListContainersOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"b9c0cfe4e490d08f0169353488b64953\";}s:102:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListContainersResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"5f106b093aa0aa40fa9b998b1f552332\";}s:107:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListPageBlobRangesOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"bcdcaf7c266c96bb1c3015c33b843f86\";}s:106:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/ListPageBlobRangesResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"943a85160ac5307f29bc671955f622e3\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/PageRange.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"23ad2680808ef375e074235fe8a11c02\";}s:97:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/PageWriteOption.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"f1ac6cefa76a39370282d648a0cab9c5\";}s:98:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/PublicAccessType.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"94228899152033d797474aab1c1a0642\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SetBlobMetadataOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"7ae1b7144b1b3f45ded198332980f53f\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SetBlobMetadataResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"2e2377453024540dfcf9d9b50804ea35\";}s:106:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SetBlobPropertiesOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"0b0baed720e282fee4b3515a3bfa6deb\";}s:105:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SetBlobPropertiesResult.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"5f89435ca8ac2a8d14a9a547fd9534c1\";}s:109:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SetContainerMetadataOptions.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"c2df6bf82561a55431a097d11f0ef909\";}s:98:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Blob/Models/SignedIdentifier.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"b0040339b313bef35e6a77e90f264188\";}s:102:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/CloudConfigurationManager.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"73f9a3eaafd3dbab3db7cbc9ca9296c0\";}s:112:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Authentication/IAuthScheme.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"790d5560180a7274cf9fc5204beb4247\";}s:120:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Authentication/SharedKeyAuthScheme.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"2a23604a8ca811f6c1d8b730150a3f99\";}s:118:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Authentication/StorageAuthScheme.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"30dc6d83f1eee64474a919b7aa3f87d0\";}s:129:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Authentication/TableSharedKeyLiteAuthScheme.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"6f35d34dff6ddd673cdf609f93c7f6cc\";}s:108:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/ConnectionStringParser.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"f19936d17eff424014c79e2a5f36a818\";}s:108:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/ConnectionStringSource.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"eed13d0094dc6e948ece46f7646cbcd7\";}s:103:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/FilterableService.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"c227197e89caece0d95cc9cfb4cb9b8a\";}s:114:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/AuthenticationFilter.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"dcccd605b4809f787c9d0e714d714f8b\";}s:104:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/DateFilter.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"824c51004d399d5f526e2d0b06805150\";}s:116:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/ExponentialRetryPolicy.php\";a:2:{s:1:\"d\";i:1490249277;s:1:\"h\";s:32:\"3bf3974076b93fbb7fe79f83eece2fbd\";}s:107:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/HeadersFilter.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"5fc13576eb65ddf59ea82bb42de2c3e7\";}s:105:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/RetryPolicy.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"fb7b56b6d8732a6bc5c2211913c6b185\";}s:111:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Filters/RetryPolicyFilter.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"88e0dcdc957a55a0e73c38c7df9c48db\";}s:106:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Http/HttpCallContext.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"61efe098995755648e62c345aab50357\";}s:99:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/HttpFormatter.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"13a93aa6a2b7a7eb6f33b8a9f1686460\";}s:114:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/InvalidArgumentTypeException.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"a50c0bad44d90fc09c20cd237c94b48c\";}s:100:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/IServiceFilter.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"a43f03e26ff274b7880541b065ec7dc0\";}s:92:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Logger.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"b7593ab372ed7cccbf934059bcfd5287\";}s:95:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Resources.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"ee6fdc4ada2ba0ce5b1b16ddf183db24\";}s:95:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/RestProxy.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"88e647f5fb0aa257cf20699fdf5795c2\";}s:108:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/RetryMiddlewareFactory.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"54f9975b17569dc866dbddf56f84ac82\";}s:111:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Serialization/ISerializer.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"4f532da077fca691fdf08d3bda21c6fa\";}s:114:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Serialization/JsonSerializer.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"338d07fc5f48e19be615b5eee4ff8343\";}s:113:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Serialization/XmlSerializer.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"90bf6245d685f31b666c20d2913040d5\";}s:102:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/ServiceRestProxy.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"5fbdf69775ea4d5911e95fcb1b8f5ef3\";}s:101:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/ServiceSettings.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"521c9cbf70d4742a81c754d7ccec4c67\";}s:108:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/StorageServiceSettings.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"155fbfc042091be265cb4aa6f754f071\";}s:95:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Utilities.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"f97eb4a1ccfd95f973c5ef38c9d0c146\";}s:94:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Internal/Validate.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"b1a8ed46d8a2ae7ae2f746959782cc78\";}s:110:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Models/GetServicePropertiesResult.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"88089cfe6d425f01e74b978d023744de\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Models/Logging.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"12b1ade8200d77a6506d727885e7feba\";}s:91:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Models/Metrics.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"7bdd05dbf3bb08bfdb6ddb31829e6d66\";}s:99:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Models/RetentionPolicy.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"6db2c875516ea8715faf8b7f629cfd74\";}s:101:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/Models/ServiceProperties.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"2c327e7c792a60f4bd8a37b0d74755b2\";}s:93:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/ServiceException.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"bd5c39f7f3ef817dabd01a77559c95c1\";}s:92:\"wp-content/plugins/w3-total-cache/lib/Azure/MicrosoftAzureStorage/Common/ServicesBuilder.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"f50aa61159476a259c0b51d14a7a679d\";}s:79:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/MessageInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"5b86144b4235dd435ae390a2d2b497e1\";}s:79:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/RequestInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"9f968a5accc656ebb969b6a973f43610\";}s:80:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/ResponseInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"3a902ea57f57a8250e371ba6ea40c3b1\";}s:85:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/ServerRequestInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"8694cf6882b28ef2c24c444d290682ea\";}s:78:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/StreamInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"dde87a38357aa58a17128df6bca5a554\";}s:84:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/UploadedFileInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"bf303071ee88d14c0b9f4482002698a0\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Azure/PsrHttpMessage/UriInterface.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"77f0ea01e2cd3a2848d1dec182b2c9eb\";}s:63:\"wp-content/plugins/w3-total-cache/lib/CSSTidy/class.csstidy.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"715de617fc103c02926d3afcc833d105\";}s:72:\"wp-content/plugins/w3-total-cache/lib/CSSTidy/class.csstidy_optimise.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"432114b6afc8086e413af15646b3e753\";}s:69:\"wp-content/plugins/w3-total-cache/lib/CSSTidy/class.csstidy_print.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"0734c1e68d782461ca3e4a0324aa7d08\";}s:58:\"wp-content/plugins/w3-total-cache/lib/CSSTidy/data.inc.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"fb1053ac3503e1d2dc94f3fe10c80498\";}s:56:\"wp-content/plugins/w3-total-cache/lib/CSSTidy/index.html\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:50:\"wp-content/plugins/w3-total-cache/lib/Db/mssql.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"25d5e5d612b502ed6898a618282818a9\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/Abstract.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"b97dc092caa6a3706eae2f328e7ffc4d\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/AppIdentity.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"987bcc5f86959f43687ec82906864a4d\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/AssertionCredentials.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"0dac38122e70ab5ec915585cc2391cdd\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/Exception.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"0fa398302b3d8f74bfd5b1e76c917f26\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/LoginTicket.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"5378cf2deb189a439f04c4477519ead5\";}s:60:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/OAuth2.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"26b58f9a60a3b7c6365ea75c8caee023\";}s:60:\"wp-content/plugins/w3-total-cache/lib/Google/Auth/Simple.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"4935374d23fde223bbba33c513d5c3e0\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/Abstract.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"c43e0e404a9208231a27908038c00030\";}s:58:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/Apc.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"6deb6e2d505d86b331713e54c38107a6\";}s:64:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/Exception.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"d7937176662a44ffd02fbfddd0c2469d\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/File.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"4470f1f5d15863a907c023ee81f34424\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/Memcache.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"6966fa756461a16b17e3d4b6ef09cb18\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/Cache/Null.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"7182ad2c7605016470dfa96788a7e5b4\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Google/Client.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"182ae8432f1e40e1a4e563793d725fbc\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/Collection.php\";a:2:{s:1:\"d\";i:1490249278;s:1:\"h\";s:32:\"1d54fa59d06fac016b44895e5186202d\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Google/Config.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"731d69ca773557eb7a0429cbc8364f85\";}s:58:\"wp-content/plugins/w3-total-cache/lib/Google/Exception.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"934c0e79b4e0c05940e14191e388ed6c\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/Http/Batch.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"b067f56f4d6cf31c662824285f1a7267\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Google/Http/CacheParser.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"8f5c1446b0c165978959483ecea8fa45\";}s:69:\"wp-content/plugins/w3-total-cache/lib/Google/Http/MediaFileUpload.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"9486160bc35bbec0fb101bbc9c5b9fda\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Google/Http/Request.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"5a5f69fb40f598f675aae03028c70364\";}s:58:\"wp-content/plugins/w3-total-cache/lib/Google/Http/REST.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"2fc5479aba81387e950ab5fe15d600ed\";}s:60:\"wp-content/plugins/w3-total-cache/lib/Google/IO/Abstract.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"b211940938e5a44ad94a58064884080c\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/IO/cacerts.pem\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"a527b93e71b94759d99643641ff3b531\";}s:56:\"wp-content/plugins/w3-total-cache/lib/Google/IO/Curl.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"a51ad5f87dd9e5edffde1940ea509cfe\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Google/IO/Exception.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"e1438d33e3559088d4f67059d73feaa1\";}s:58:\"wp-content/plugins/w3-total-cache/lib/Google/IO/Stream.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"084397b66a4b4356c449417693d869dc\";}s:54:\"wp-content/plugins/w3-total-cache/lib/Google/Model.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"096831dd70b1d85d1abe103404ffead4\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Google/Service/Drive.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"20c8b655d49523437fec9d5bf36f8ed6\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Google/Service/Exception.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"5de8de551f1d698c9b298d764a674027\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Google/Service/Oauth2.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"6bb0781187bbd800a8c0f1740b9cd92e\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Google/Service/Resource.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"1198137b35a555ef712b844dcb60a9e3\";}s:56:\"wp-content/plugins/w3-total-cache/lib/Google/Service.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"47677f6f249815bf28f6a99c672ab517\";}s:64:\"wp-content/plugins/w3-total-cache/lib/Google/Signer/Abstract.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"1e16c2f49fd65fff0ac9629a57c85e5d\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Google/Signer/P12.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"eb87edae33df36ec7db0cf8b5a1c5eb5\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Google/Utils/URITemplate.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"0af76a052579e42e2ebba06da4d09dc3\";}s:54:\"wp-content/plugins/w3-total-cache/lib/Google/Utils.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"373c79714d2abca5418b25f908424de2\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Google/Verifier/Abstract.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"cbb15538000f61bf949dc5502a2fbbf1\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Google/Verifier/Pem.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"953049393caa6b9425191b3318f08d16\";}s:48:\"wp-content/plugins/w3-total-cache/lib/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Minify/CSSmin.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"ceff3b9ab2c13880baea08b063a9e01e\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/DooDigestAuth.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"9d66abc8cfa37b5f593fc09c734f0269\";}s:68:\"wp-content/plugins/w3-total-cache/lib/Minify/HTTP/ConditionalGet.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"b4db85775593f4dd32667962d9d35d9a\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Minify/HTTP/Encoder.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"e103a09e8122ece22d0aefe9399cb1e9\";}s:60:\"wp-content/plugins/w3-total-cache/lib/Minify/HTTP/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Minify/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:54:\"wp-content/plugins/w3-total-cache/lib/Minify/JSMin.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"2b4feb6bd313781e04e320282597f554\";}s:58:\"wp-content/plugins/w3-total-cache/lib/Minify/JSMinPlus.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"07fa4bf4cd2bb59c1d5c96f0a6ba2ab1\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Build.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"99800ab664e1fb0ff46a7133ab13bb1b\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Cache/File.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"a13801e8f4b9bac355a6f8628b6e82a0\";}s:68:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Cache/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Cache/W3TCDerived.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"23c8f32bc8093b9279d31b395ccd7937\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Cache/ZendPlatform.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"a20755bc554cfef6733ac64574c4f90e\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/ClosureCompiler.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"69fcd6ecb7b871134b6dd0a93e7f62b4\";}s:67:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CombineOnly.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"0e90e6024b37c5d3a5cc750ecd0fbad9\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CommentPreserver.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"f9fbae74aea3125d25f375942846d9c0\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/Base.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"c35e49ba368e05b5f4272ab5f6eea990\";}s:72:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/Files.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"a0bc419aa48d256e19a64596dee53991\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/Groups.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"bf35ccd3d384c40033b978a402eaf917\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/MinApp.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"251019d7ad609b1275f9070a30a5e21b\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/Page.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"8413e384e00781c84d5e86519ef90aa6\";}s:75:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Controller/Version1.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"02429d779debfc6e64af0ca01524537c\";}s:70:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CSS/Compressor.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"82ed8b7053441faba5fff9f7387f3a51\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CSS/index.html\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CSS/UriRewriter.php\";a:2:{s:1:\"d\";i:1490249279;s:1:\"h\";s:32:\"43ff9fbff6096092944384a4d0fb17f6\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CSS.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"ab8475619b9bca9e1caab297b1e70e76\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/CSSTidy.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"0b111287226a5128c51ac3e9b9c7ae78\";}s:69:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/DebugDetector.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"578c000b491157db9f9a7fef2537b393\";}s:67:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/HTML/Helper.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"af89e2e30f70dd935dd86d31649159e6\";}s:60:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/HTML.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"2357062e2a86a1902a00b83ee94326f3\";}s:64:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/HTMLTidy.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"a89435d95fc2bf35a6fdae86314fe734\";}s:79:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/IgnoredCommentPreserver.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"3cb35db181c335d862e4796a9ac0082f\";}s:71:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/ImportProcessor.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"028a803aef6aec0b595ba610fbd2f735\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/index.html\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Inline/CSS.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"53b3b77b0c0d4f55eea8e37e79d158a9\";}s:69:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Inline/index.html\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Inline/JavaScript.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"64839f722c87fa2ac8de0dceb03ddeb3\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Inline.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"7c0b25a62e06a6c4bfdf78477cf2999d\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/JS/ClosureCompiler.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"07be70c22d0cf2cf48bddeede1abd11b\";}s:61:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Lines.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"ad474907f5a31b71d0768a8558f878d7\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Loader.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"5e84b0e739587d8df742f47953f135d5\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Logger.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"b074c744b82d0739a7f95b25da377796\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Packer.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"25e6f213205f060853db918c2d67ef06\";}s:62:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/Source.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"95b921274dd47856db0fcda809a1591e\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/YUI/CssCompressor.java\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"cb15a586f2dcc4fead535bc982e3f91e\";}s:73:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/YUI/CssCompressor.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"12d5b4e38488c68bc84cc0efba6eb338\";}s:69:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify/YUICompressor.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"4c2e14268a71d52b74ae1558b929cda5\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Minify/Minify.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"33e2820513337347bbda552eaeb745e3\";}s:55:\"wp-content/plugins/w3-total-cache/lib/NetDNA/NetDNA.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"e27d3418800bd789e11421f1f3927fe4\";}s:67:\"wp-content/plugins/w3-total-cache/lib/NetDNA/NetDNAPresentation.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"42be422cfd36c0b48c02d2b97286e5c1\";}s:68:\"wp-content/plugins/w3-total-cache/lib/NetDNA/W3tcWpHttpException.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"cee79bd8aa65a48256863d3156ab1ec3\";}s:62:\"wp-content/plugins/w3-total-cache/lib/NewRelic/NewRelicAPI.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"1fe8534534eff0065d9325a9496a0175\";}s:66:\"wp-content/plugins/w3-total-cache/lib/NewRelic/NewRelicWrapper.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"7f69b2a419bac1422641972d2cc3c92b\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.nusoap_base.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"882bd26c7b714903c8e7285815d1b364\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.soapclient.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"acbb403ebedcbd6dd7bd4bf4457f55f2\";}s:65:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.soap_fault.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"04ad073798ce71bcda83cf858fe3d3e2\";}s:66:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.soap_parser.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"8a29b5b261ad04313fefbfd2428cc1cd\";}s:74:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.soap_transport_http.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"6de2a344df78f2f62eca846ec4bdcb93\";}s:63:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.soap_val.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"6c3978e769cba458fa3ef9baf9324eaf\";}s:59:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.wsdl.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"db1c8c96c56050a4311428ab97bc982e\";}s:64:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.wsdlcache.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"870f48e863ac355182347a89bf7565f1\";}s:64:\"wp-content/plugins/w3-total-cache/lib/Nusoap/class.xmlschema.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"3143a5dca266f6b807b6601770f8e6e1\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Nusoap/index.html\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:55:\"wp-content/plugins/w3-total-cache/lib/Nusoap/nusoap.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"ad62289c352eee409a21f3276fbefcf3\";}s:57:\"wp-content/plugins/w3-total-cache/lib/OAuth/W3tcOAuth.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"a681e33db9ea7df68c404443884867ab\";}s:44:\"wp-content/plugins/w3-total-cache/lib/S3.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"87304f1025771f151787edcde5868780\";}s:68:\"wp-content/plugins/w3-total-cache/lib/SNS/lib/requestcore/cacert.pem\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"4e0c8fcca8148533e6723f94463a3c73\";}s:65:\"wp-content/plugins/w3-total-cache/lib/SNS/lib/requestcore/LICENSE\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"70f142181074f83b33d258164c008cd9\";}s:67:\"wp-content/plugins/w3-total-cache/lib/SNS/lib/requestcore/README.md\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"702485f100351d8dcc1346d087d09656\";}s:79:\"wp-content/plugins/w3-total-cache/lib/SNS/lib/requestcore/requestcore.class.php\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"84345c7421c25a284076ba6f5da25888\";}s:51:\"wp-content/plugins/w3-total-cache/lib/SNS/README.md\";a:2:{s:1:\"d\";i:1490249280;s:1:\"h\";s:32:\"5ebb7e264b1131f56b91dde12f3ca3a6\";}s:55:\"wp-content/plugins/w3-total-cache/lib/SNS/sdk.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"21427bc7a1908a66e46d6d2802d8a09a\";}s:79:\"wp-content/plugins/w3-total-cache/lib/SNS/services/MessageValidator/Message.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"254ec097174d92659d4b6a086d60a4d6\";}s:88:\"wp-content/plugins/w3-total-cache/lib/SNS/services/MessageValidator/MessageValidator.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"9d32f2a9ef2c08b7860ae3a8f5723948\";}s:86:\"wp-content/plugins/w3-total-cache/lib/SNS/services/MessageValidator/sns-exceptions.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"3bdec9772c613c46b5b21c24b68feca5\";}s:64:\"wp-content/plugins/w3-total-cache/lib/SNS/services/sns.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"cb3d8df826476829c357ec35bb585469\";}s:69:\"wp-content/plugins/w3-total-cache/lib/SNS/utilities/request.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"21146811c1c182bb1f3db4a36631305c\";}s:70:\"wp-content/plugins/w3-total-cache/lib/SNS/utilities/response.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"128a6eff75168fbcddbb1872aa46088d\";}s:71:\"wp-content/plugins/w3-total-cache/lib/SNS/utilities/simplexml.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"e02af3baf386f4aa9effd3b1c85e1c6d\";}s:71:\"wp-content/plugins/w3-total-cache/lib/SNS/utilities/utilities.class.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"dae2d6836f0866237d5c75161227a459\";}s:60:\"wp-content/plugins/w3-total-cache/Licensing_AdminActions.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"2b036a8471e4a7ccb0a4cd5a7d437f21\";}s:52:\"wp-content/plugins/w3-total-cache/Licensing_Core.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"44cb6bde87402e7a17e2e5cf2f5bafed\";}s:60:\"wp-content/plugins/w3-total-cache/Licensing_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"1bb10d13b7542760095e03c223d6e130\";}s:57:\"wp-content/plugins/w3-total-cache/Minify_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"8ad9cba2db30362fd36d57aeaa153345\";}s:60:\"wp-content/plugins/w3-total-cache/Minify_ContentMinifier.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"fffc1a7d5bbe56834bb2f2ecaeb017a8\";}s:49:\"wp-content/plugins/w3-total-cache/Minify_Core.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"31a92e39ad08ab29de271374f93a93ff\";}s:56:\"wp-content/plugins/w3-total-cache/Minify_Environment.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"e1d92df9eb5b4c82e2bdda74dc0d5598\";}s:52:\"wp-content/plugins/w3-total-cache/Minify_Extract.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"21c8f33028400a35844edfac8da60cae\";}s:69:\"wp-content/plugins/w3-total-cache/Minify_GeneralPage_View_ShowHelp.js\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"972e931e7edd2fce3b7cec5c9fc90c48\";}s:74:\"wp-content/plugins/w3-total-cache/Minify_GeneralPage_View_ShowHelpForce.js\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"7d788d387252f324cc43f81bd302f0cb\";}s:59:\"wp-content/plugins/w3-total-cache/Minify_HelpPopup_View.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"52aec46de8bb2cfa548b1b9bb31b288d\";}s:71:\"wp-content/plugins/w3-total-cache/Minify_MinifiedFileRequestHandler.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"69265bf24a93f1411abf56ab0538ec59\";}s:49:\"wp-content/plugins/w3-total-cache/Minify_Page.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"72de8e11184526b3336e31fa789767aa\";}s:51:\"wp-content/plugins/w3-total-cache/Minify_Plugin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d7fa59574f23b90db50d71b6c9b56418\";}s:57:\"wp-content/plugins/w3-total-cache/Minify_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"87ffe4d7c365375f48317ee84f3bd984\";}s:49:\"wp-content/plugins/w3-total-cache/Mobile_Base.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"dc22ff66239a8f6c5a45dd4b127e91a9\";}s:64:\"wp-content/plugins/w3-total-cache/Mobile_Page_ReferrerGroups.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"970f15d1df97763baa49ec4f27ab7ee0\";}s:65:\"wp-content/plugins/w3-total-cache/Mobile_Page_UserAgentGroups.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"a8bcdd5c550dfdf476612a7557bf2367\";}s:53:\"wp-content/plugins/w3-total-cache/Mobile_Redirect.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"69bff375ba703d102eb405201f131e30\";}s:53:\"wp-content/plugins/w3-total-cache/Mobile_Referrer.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d248f39288613fbcc775b696ba6371a0\";}s:54:\"wp-content/plugins/w3-total-cache/Mobile_UserAgent.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"cf7c10e8e03bc65adda7d4f0a4d38eda\";}s:50:\"wp-content/plugins/w3-total-cache/ModuleStatus.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"624662215bba3ba2cf9f5cc815c4bef4\";}s:62:\"wp-content/plugins/w3-total-cache/ObjectCache_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"50f148014cdcdd301d890c9f274ea0d9\";}s:61:\"wp-content/plugins/w3-total-cache/ObjectCache_Environment.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"3d4b87f2ff847b869309c351142d6844\";}s:54:\"wp-content/plugins/w3-total-cache/ObjectCache_Page.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"b746f5fb42fea9a34fa8dcb86fc83e02\";}s:56:\"wp-content/plugins/w3-total-cache/ObjectCache_Plugin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"1482d49b8b5783ae8b659614457ddc7a\";}s:62:\"wp-content/plugins/w3-total-cache/ObjectCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"ef2f7c70d33d450f0cd44c796d1182e0\";}s:63:\"wp-content/plugins/w3-total-cache/ObjectCache_WpObjectCache.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"dd7642c19b6cf8eab590219a7326cb49\";}s:71:\"wp-content/plugins/w3-total-cache/ObjectCache_WpObjectCache_Regular.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"03f26a5327ab6de686b4f3fa795300fd\";}s:51:\"wp-content/plugins/w3-total-cache/PageSpeed_Api.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"57bb966463a68f3b05d15cdb7ac11d9a\";}s:61:\"wp-content/plugins/w3-total-cache/PageSpeed_Plugin_Widget.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"2e1054df72f4e1eaa08e897d48d2e56e\";}s:59:\"wp-content/plugins/w3-total-cache/PageSpeed_Widget_View.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"16c0ec479e215123df6f44d0d51f941a\";}s:58:\"wp-content/plugins/w3-total-cache/PageSpeed_Widget_View.js\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"2b4f47c73ce3ebf6f67ce65f07115cb1\";}s:59:\"wp-content/plugins/w3-total-cache/PageSpeed_Widget_View.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"7f5a9c6aaaefb9aaa988ebcbb3c1f873\";}s:73:\"wp-content/plugins/w3-total-cache/PageSpeed_Widget_View_NotConfigured.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"0b79097513391c255efa3194acd04630\";}s:58:\"wp-content/plugins/w3-total-cache/PgCache_ConfigLabels.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"91156b35bd4fff60ced45c926a0ea401\";}s:60:\"wp-content/plugins/w3-total-cache/PgCache_ContentGrabber.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d493cb57a96f5d5237c59934fd00af92\";}s:57:\"wp-content/plugins/w3-total-cache/PgCache_Environment.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"a56d4bebce9db36ce0fd5333d59e7bd6\";}s:51:\"wp-content/plugins/w3-total-cache/PgCache_Flush.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d1d8c205a8dd596aadb6f064d600035c\";}s:50:\"wp-content/plugins/w3-total-cache/PgCache_Page.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"0b394ad4d5429c2a727c9a682764ddec\";}s:52:\"wp-content/plugins/w3-total-cache/PgCache_Plugin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"88930af6c84bc897b69fd65e377fb47b\";}s:58:\"wp-content/plugins/w3-total-cache/PgCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"6c3f5f81ba1d4928f0e5c778d7593832\";}s:51:\"wp-content/plugins/w3-total-cache/pub/css/error.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"271d7040e01a1de4c7cb3a165b6f7bec\";}s:52:\"wp-content/plugins/w3-total-cache/pub/css/index.html\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:54:\"wp-content/plugins/w3-total-cache/pub/css/lightbox.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"f0bc6409ee7535e259fc6f46d69257b1\";}s:53:\"wp-content/plugins/w3-total-cache/pub/css/options.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"a898d8f208f7898ae8cb571f2d0b5d6a\";}s:51:\"wp-content/plugins/w3-total-cache/pub/css/popup.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"34042fb7d3b18ac179476014ba863b44\";}s:52:\"wp-content/plugins/w3-total-cache/pub/css/widget.css\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"1aa1e42e6850160801bfe532083452b6\";}s:52:\"wp-content/plugins/w3-total-cache/pub/img/index.html\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:52:\"wp-content/plugins/w3-total-cache/pub/img/ps_bar.gif\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"3c56b79f7f227153ca6d275deac46526\";}s:53:\"wp-content/plugins/w3-total-cache/pub/img/ps_grad.gif\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"31bd8fecc9bb403e7fefd1b35aa00d43\";}s:58:\"wp-content/plugins/w3-total-cache/pub/img/wpspin_light.gif\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"730b0a7a3ccb756dcacbbc9f90565a06\";}s:48:\"wp-content/plugins/w3-total-cache/pub/index.html\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:51:\"wp-content/plugins/w3-total-cache/pub/js/index.html\";a:2:{s:1:\"d\";i:1490249281;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:62:\"wp-content/plugins/w3-total-cache/pub/js/jquery.masonry.min.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"a6b726ee7fce43453a6eb25e8a1cb819\";}s:52:\"wp-content/plugins/w3-total-cache/pub/js/lightbox.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"2aa6bd401d42f19feeec19794f1a4a45\";}s:52:\"wp-content/plugins/w3-total-cache/pub/js/metadata.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"47185fe908ef602b79b82e0705aa0804\";}s:51:\"wp-content/plugins/w3-total-cache/pub/js/options.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"4f938aa47c92267dc9ae0e55f93835ed\";}s:49:\"wp-content/plugins/w3-total-cache/pub/js/popup.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"8270e575e63c8c4b0eb02ef29c64854d\";}s:50:\"wp-content/plugins/w3-total-cache/pub/js/widget.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"338d6442b4dde231d62597ea8ed04c01\";}s:49:\"wp-content/plugins/w3-total-cache/pub/opcache.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"30cf072175d3e61b2f34d5c001814b00\";}s:45:\"wp-content/plugins/w3-total-cache/pub/sns.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"064abde5bcf4ab4d5c46049b16d73c36\";}s:44:\"wp-content/plugins/w3-total-cache/readme.txt\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"bce3d60eb1042e98900866a2328e6448\";}s:55:\"wp-content/plugins/w3-total-cache/Root_AdminActions.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"7c7b02a0729f66af92c7392de4746b64\";}s:58:\"wp-content/plugins/w3-total-cache/Root_AdminActivation.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"5ae6f44c6d8bb77a5d074fa3e44d52fb\";}s:52:\"wp-content/plugins/w3-total-cache/Root_AdminMenu.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"812e12fcc69357d9287f5fb8cea4328b\";}s:54:\"wp-content/plugins/w3-total-cache/Root_Environment.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"e99e541fa27509e2be9d97e693c278d7\";}s:49:\"wp-content/plugins/w3-total-cache/Root_Loader.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"d9370b73d4819216ac91a200eee7f9d3\";}s:58:\"wp-content/plugins/w3-total-cache/Support_AdminActions.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"0be47fb4e719a60023cd5cdd569005ae\";}s:50:\"wp-content/plugins/w3-total-cache/Support_Page.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"7e0ebc802dbd0aacb09ecb86b79118c8\";}s:67:\"wp-content/plugins/w3-total-cache/Support_Page_View_DoneContent.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"c7fef4e2bb0e36f6aa33c2b47bb61271\";}s:67:\"wp-content/plugins/w3-total-cache/Support_Page_View_PageContent.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"ac3bb40bc4d9fc2d7bd54fc069754ff0\";}s:64:\"wp-content/plugins/w3-total-cache/SystemOpCache_AdminActions.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"f7cd2029625bff69b6b8d2dcbc439c92\";}s:56:\"wp-content/plugins/w3-total-cache/SystemOpCache_Core.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"232d05f045d91e922ca359e4dc285294\";}s:68:\"wp-content/plugins/w3-total-cache/SystemOpCache_GeneralPage_View.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"927811ab1cf30b669614bfa93edaab4f\";}s:64:\"wp-content/plugins/w3-total-cache/SystemOpCache_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"0ee9a254621cbd294357d8b95f356a6e\";}s:58:\"wp-content/plugins/w3-total-cache/UsageStatistics_Core.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"fb6587ae9c4efdc8693b966922efd53f\";}s:60:\"wp-content/plugins/w3-total-cache/UsageStatistics_Plugin.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"6fce912f7d0293b0496a89a56afaa164\";}s:66:\"wp-content/plugins/w3-total-cache/UsageStatistics_Plugin_Admin.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"3b4fe8623aaa1ecbaf022dbeda18c645\";}s:67:\"wp-content/plugins/w3-total-cache/UsageStatistics_StorageReader.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"0ffccdd467bb697d0ed509556666e0f6\";}s:67:\"wp-content/plugins/w3-total-cache/UsageStatistics_StorageWriter.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"7180c0127d6b58164551d1af065e6f64\";}s:66:\"wp-content/plugins/w3-total-cache/UsageStatistics_View_General.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"92c6414ab7d8240792e552a9f43ba0e8\";}s:60:\"wp-content/plugins/w3-total-cache/UsageStatistics_Widget.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"9a557955ab875063132eb048c8798a0a\";}s:65:\"wp-content/plugins/w3-total-cache/UsageStatistics_Widget_View.css\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"5fe744ed5e2ace3e1986f5d0306e67ac\";}s:64:\"wp-content/plugins/w3-total-cache/UsageStatistics_Widget_View.js\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"571544bd88304acfcf684b7f28c4c7fe\";}s:65:\"wp-content/plugins/w3-total-cache/UsageStatistics_Widget_View.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"c6212248518edb849637254d17dd2b5b\";}s:74:\"wp-content/plugins/w3-total-cache/UsageStatistics_Widget_View_Disabled.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"2680f2b7704162c3489b209a8f624596\";}s:53:\"wp-content/plugins/w3-total-cache/Util_Activation.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"d74d120450255c745df3090b57a3ad1a\";}s:48:\"wp-content/plugins/w3-total-cache/Util_Admin.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"54ba6bc81b5373e73b03b414cbe05c03\";}s:58:\"wp-content/plugins/w3-total-cache/Util_AttachToActions.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"6fa2d276388f9b32be72910e52189138\";}s:46:\"wp-content/plugins/w3-total-cache/Util_Bus.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"5ed8b38c2602487cba74057857c262ad\";}s:54:\"wp-content/plugins/w3-total-cache/Util_ConfigLabel.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"cb53f4a668d17f25b107bbadbebaf375\";}s:50:\"wp-content/plugins/w3-total-cache/Util_Content.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"899149b2da72c6d1c32bbe81f1dc1dee\";}s:48:\"wp-content/plugins/w3-total-cache/Util_Debug.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"ae6c756d388f873498641fb6fed5911c\";}s:54:\"wp-content/plugins/w3-total-cache/Util_Environment.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"2ca024fbf492500d2bccee4046c8638e\";}s:64:\"wp-content/plugins/w3-total-cache/Util_Environment_Exception.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"7b5c2c273bb2c10804a558ca47b73fa5\";}s:65:\"wp-content/plugins/w3-total-cache/Util_Environment_Exceptions.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"2d5055484d39fa64ba764089cb13a2b1\";}s:47:\"wp-content/plugins/w3-total-cache/Util_File.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"bbf1e7bd145648942d80168cb23fada2\";}s:47:\"wp-content/plugins/w3-total-cache/Util_Http.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"8c958584eea666621249c9b547e7caf8\";}s:52:\"wp-content/plugins/w3-total-cache/Util_Installed.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"b1204d653890c78beb2f8b424a54f4b4\";}s:47:\"wp-content/plugins/w3-total-cache/Util_Mime.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"5e0731a7fb0d043f0229341ee04e9441\";}s:51:\"wp-content/plugins/w3-total-cache/Util_PageUrls.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"7efc1fa7370279e8c68fe1fd7dcb8791\";}s:50:\"wp-content/plugins/w3-total-cache/Util_Request.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"c73bcd41940c84c2c6ac0da5a5af74f9\";}s:47:\"wp-content/plugins/w3-total-cache/Util_Rule.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"8d1730aaf9123b06e1de5182d74e05d2\";}s:54:\"wp-content/plugins/w3-total-cache/Util_RuleSnippet.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"3c51f00b06d9f133efbe01437a6be64e\";}s:48:\"wp-content/plugins/w3-total-cache/Util_Theme.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"c8ebd29c760d1e93c29a544a38577b53\";}s:45:\"wp-content/plugins/w3-total-cache/Util_Ui.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"873d8ccabab1aa29e16a3853a35f2e41\";}s:58:\"wp-content/plugins/w3-total-cache/Util_UsageStatistics.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"c98d417b31a9f0bfaf0b2656182e1992\";}s:49:\"wp-content/plugins/w3-total-cache/Util_Widget.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"827656ee2a815c0813cd1b5c26fc9860\";}s:49:\"wp-content/plugins/w3-total-cache/Util_WpFile.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"269e093d62bdf7ea76d2eb260cbcc938\";}s:74:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemChmodException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"4a3cc2a2be77c4ee068fbdd24443254c\";}s:73:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemCopyException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"f699676f3796c0804cbb3b0c862380b4\";}s:74:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemMkdirException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"4accd9441a8be0f0c3ceb8ea8463bdde\";}s:75:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemModifyException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"91ee29f25eecbf258928faa1e4e0708d\";}s:78:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemOperationException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"631d6191b3001b826e7ec49e670f47fd\";}s:74:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemRmdirException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"a35bb3728a50408c18d96aa0d525f581\";}s:71:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemRmException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"3001a52d12748c1ecdc7f3abbfc41d29\";}s:74:\"wp-content/plugins/w3-total-cache/Util_WpFile_FilesystemWriteException.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"9e5b362ba384251f76e04894d149f3b5\";}s:54:\"wp-content/plugins/w3-total-cache/Util_WpmuBlogmap.php\";a:2:{s:1:\"d\";i:1490249282;s:1:\"h\";s:32:\"58319598aa998cdce25eae5b4f51230f\";}s:51:\"wp-content/plugins/w3-total-cache/Varnish_Flush.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"cd60af9eef01182e7a3501471dc7d834\";}s:52:\"wp-content/plugins/w3-total-cache/Varnish_Plugin.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"5ea067ee65cc30cb2d69f7688e324387\";}s:56:\"wp-content/plugins/w3-total-cache/w3-total-cache-api.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"79b725736a8fe4e7c7e0c253a4271b6e\";}s:60:\"wp-content/plugins/w3-total-cache/w3-total-cache-old-php.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"1535558785da1876c8a2c44d8cc2b3b9\";}s:52:\"wp-content/plugins/w3-total-cache/w3-total-cache.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"245586b74fa80ffe285d29f8102f1275\";}s:63:\"wp-content/plugins/w3-total-cache/wp-content/advanced-cache.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"13fae91ceacd450584e43d1d9f7286d8\";}s:51:\"wp-content/plugins/w3-total-cache/wp-content/db.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"ea5ed9522607dccf1214f8fcaa09ba7e\";}s:55:\"wp-content/plugins/w3-total-cache/wp-content/index.html\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:61:\"wp-content/plugins/w3-total-cache/wp-content/object-cache.php\";a:2:{s:1:\"d\";i:1490249283;s:1:\"h\";s:32:\"4283fe54666a7131ad3e072acf36c572\";}s:45:\"wp-content/plugins/wp-members/admin/admin.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"28a21eef4df36be78e4ab8eb46c37ea2\";}s:49:\"wp-content/plugins/wp-members/admin/css/admin.css\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"08a6f44d840ac84f2d7b94be3a70d0e6\";}s:49:\"wp-content/plugins/wp-members/admin/css/index.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:47:\"wp-content/plugins/wp-members/admin/dialogs.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"f006a7ed4cf2f479c8944e8465d506ee\";}s:52:\"wp-content/plugins/wp-members/admin/includes/api.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"2c61d422cf4a83b90107675d7db4826d\";}s:75:\"wp-content/plugins/wp-members/admin/includes/class-wp-members-admin-api.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"a940294bcb99a8920b35fd3aa2ff6cde\";}s:87:\"wp-content/plugins/wp-members/admin/includes/class-wp-members-sortable-user-columns.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"49fd37cac9a51bfac6f6df8e87cbb89b\";}s:81:\"wp-content/plugins/wp-members/admin/includes/class-wp-members-tinymce-buttons.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"21475309d3cd33769c3f670637dd49b2\";}s:54:\"wp-content/plugins/wp-members/admin/includes/index.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:45:\"wp-content/plugins/wp-members/admin/index.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:47:\"wp-content/plugins/wp-members/admin/js/admin.js\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"12af12de3f6f5a8aa6796099957e05c6\";}s:48:\"wp-content/plugins/wp-members/admin/js/index.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:60:\"wp-content/plugins/wp-members/admin/js/shortcodes_tinymce.js\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"db1cac33356dbbbab5cde7b9f89d16e1\";}s:62:\"wp-content/plugins/wp-members/admin/js/shortcodes_tinymce_4.js\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"8e882b5975575b74e933e3faf839b8bc\";}s:44:\"wp-content/plugins/wp-members/admin/post.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"ef299e185f30765938c970b4eaa4d1e6\";}s:49:\"wp-content/plugins/wp-members/admin/tab-about.php\";a:2:{s:1:\"d\";i:1490074508;s:1:\"h\";s:32:\"9bf4aa13cde9082108a1a3743465c63a\";}s:51:\"wp-content/plugins/wp-members/admin/tab-captcha.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"148935d7ea7681c98648ecc7efaef36d\";}s:51:\"wp-content/plugins/wp-members/admin/tab-dialogs.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"d13b2d6bce7bfd8d0e9ad20ca37f5e9f\";}s:50:\"wp-content/plugins/wp-members/admin/tab-emails.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"a09981714d5333bf1a2025f2645e4798\";}s:50:\"wp-content/plugins/wp-members/admin/tab-fields.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"2d027247d8d29655a9a2bcfbf2c44c70\";}s:51:\"wp-content/plugins/wp-members/admin/tab-options.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"73df893c1a81131fafb7d0e628b25e47\";}s:51:\"wp-content/plugins/wp-members/admin/user-export.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"ac59d7a6d4fa82c5bbc44dbd558652d5\";}s:52:\"wp-content/plugins/wp-members/admin/user-profile.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"2cefeae473ec4c390108bb21e8adcfac\";}s:45:\"wp-content/plugins/wp-members/admin/users.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"5967446831583e8aea3290e745df1352\";}s:43:\"wp-content/plugins/wp-members/changelog.txt\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"c4eafe96964b1ca296d0ae0c9fa89a1f\";}s:54:\"wp-content/plugins/wp-members/css/generic-no-float.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"99295424c9f4e34e20ee15ad587fe049\";}s:51:\"wp-content/plugins/wp-members/css/generic-rigid.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"cc6dd3d9f13ee2386b5671fca7e3043e\";}s:43:\"wp-content/plugins/wp-members/css/index.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:46:\"wp-content/plugins/wp-members/css/wp-login.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"3299308fb0868306c0d6a5d9e51eee47\";}s:53:\"wp-content/plugins/wp-members/css/wp-members-2011.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"5eaab21ecdd335e2c34a87d1b0e5600f\";}s:53:\"wp-content/plugins/wp-members/css/wp-members-2012.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"a2a91e52396701443913ca6aa745ab41\";}s:53:\"wp-content/plugins/wp-members/css/wp-members-2013.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"9292e1380e59ab5a2d6f717226ddbda0\";}s:62:\"wp-content/plugins/wp-members/css/wp-members-2014-no-float.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"9f9e82c344f4ee7d2928c7aca71bb49c\";}s:53:\"wp-content/plugins/wp-members/css/wp-members-2014.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"040464dd655f088991348bcf294d6f1f\";}s:62:\"wp-content/plugins/wp-members/css/wp-members-2015-no-float.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"616c0156496e69dcca7d1f672b4229e2\";}s:53:\"wp-content/plugins/wp-members/css/wp-members-2015.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"f7ccec4b2b55dd67e0f66ff1e906f003\";}s:62:\"wp-content/plugins/wp-members/css/wp-members-2016-no-float.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"63bb61970bfc74973462da3f0becdb2d\";}s:56:\"wp-content/plugins/wp-members/css/wp-members-kubrick.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"f10584635fdeffee57c47e416daaa6f7\";}s:48:\"wp-content/plugins/wp-members/css/wp-members.css\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"87760910124934fbc5d999a7d5c6a2cd\";}s:41:\"wp-content/plugins/wp-members/inc/api.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"2cb635448ab699fb41d2f57b8f7be115\";}s:58:\"wp-content/plugins/wp-members/inc/class-wp-members-api.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"4fe1a74abf3aab5f1cd4ab6622526524\";}s:60:\"wp-content/plugins/wp-members/inc/class-wp-members-forms.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"996d1b695113528c04a4f66627768ddc\";}s:61:\"wp-content/plugins/wp-members/inc/class-wp-members-widget.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"6c41f010832de8b95f0f5eb484bcb20c\";}s:54:\"wp-content/plugins/wp-members/inc/class-wp-members.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"3c13bdcc15492e105876734b9e4381f4\";}s:42:\"wp-content/plugins/wp-members/inc/core.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"e6ec9f1701017335a23944d67e463b01\";}s:45:\"wp-content/plugins/wp-members/inc/dialogs.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"755736f959a15976fb1be989dc86c001\";}s:43:\"wp-content/plugins/wp-members/inc/email.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"df8a56723008a95e997daafc6e40c42a\";}s:43:\"wp-content/plugins/wp-members/inc/forms.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"e98ad2d91c4df71c324d9ed30510bab0\";}s:43:\"wp-content/plugins/wp-members/inc/index.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:46:\"wp-content/plugins/wp-members/inc/register.php\";a:2:{s:1:\"d\";i:1490074509;s:1:\"h\";s:32:\"af754560dfd87f0a46a1dc28488a2025\";}s:48:\"wp-content/plugins/wp-members/inc/shortcodes.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"24025fa58565e158a9eea97878b5337e\";}s:45:\"wp-content/plugins/wp-members/inc/sidebar.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"665591539c3708d90654b1ddab0f0ad7\";}s:43:\"wp-content/plugins/wp-members/inc/users.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"e54f2b8220ef5347b824d094aee55aa0\";}s:47:\"wp-content/plugins/wp-members/inc/utilities.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"dc7b74d55b00449b6c1fbd260b593df5\";}s:53:\"wp-content/plugins/wp-members/inc/wp-registration.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"488fbb1214648d602dcd2baa74f9b804\";}s:39:\"wp-content/plugins/wp-members/index.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:44:\"wp-content/plugins/wp-members/lang/index.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:49:\"wp-content/plugins/wp-members/lang/wp-members.pot\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"f40bd24a009369060fd1a9286aee7ce4\";}s:55:\"wp-content/plugins/wp-members/lib/comments_template.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"77acee7c4553ae82cb525d13d66b39bf\";}s:43:\"wp-content/plugins/wp-members/lib/index.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"571eac15abf7b1273b9d5123e1c49467\";}s:50:\"wp-content/plugins/wp-members/lib/recaptchalib.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"fa3346fea926aa3f71d2410fdac56163\";}s:41:\"wp-content/plugins/wp-members/license.txt\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"ffa10f40b98be2c2bc9608f56827ed23\";}s:40:\"wp-content/plugins/wp-members/readme.txt\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"a96414c3ec2597498015aa0575272ee5\";}s:43:\"wp-content/plugins/wp-members/uninstall.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"f29d010db571c45b134c34a353992c0c\";}s:52:\"wp-content/plugins/wp-members/wp-members-install.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"15c555d57da5d580dfe62b8c9b39085e\";}s:48:\"wp-content/plugins/wp-members/wp-members-tos.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"ff5c1395ed15b0aa4a7f4612fe5b19f4\";}s:44:\"wp-content/plugins/wp-members/wp-members.php\";a:2:{s:1:\"d\";i:1490074510;s:1:\"h\";s:32:\"424f3ece2ac445a3777a8305b7076d15\";}s:27:\"wp-content/themes/index.php\";a:2:{s:1:\"d\";i:1487282308;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:44:\"wp-content/themes/skt-restaurant-pro/404.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"b9814ee21cf73b7d3f451661ad003a24\";}s:48:\"wp-content/themes/skt-restaurant-pro/archive.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"110a7191b69717cba2350a21e37f6563\";}s:61:\"wp-content/themes/skt-restaurant-pro/blog-post-full-width.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"f304f85865f9094b50d7ffb8587608bb\";}s:63:\"wp-content/themes/skt-restaurant-pro/blog-post-left-sidebar.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"1c3ec26144250649f57f029c30d5173a\";}s:61:\"wp-content/themes/skt-restaurant-pro/blog-post-no-sidebar.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"68282355e010c7d08acd721da640aa3f\";}s:59:\"wp-content/themes/skt-restaurant-pro/blog-right-sidebar.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"0fd505428984e86c2a4bac955b6c00ca\";}s:49:\"wp-content/themes/skt-restaurant-pro/category.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"73ad1ea433dae6bcc19b97451fd6db40\";}s:51:\"wp-content/themes/skt-restaurant-pro/change_log.txt\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"e7165c77bdcc5a4ca23d0889a0cdf575\";}s:49:\"wp-content/themes/skt-restaurant-pro/comments.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"679423f3c5e894bf3b4fd0bf6f48e03f\";}s:53:\"wp-content/themes/skt-restaurant-pro/content-home.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"16ea946b878c8c4284ba5f6dffb954e4\";}s:53:\"wp-content/themes/skt-restaurant-pro/content-page.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"c3df691c0f89136aca728295ba9b8e64\";}s:55:\"wp-content/themes/skt-restaurant-pro/content-single.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"d3d8e133f6dc8e539cacbd152f7bb77b\";}s:48:\"wp-content/themes/skt-restaurant-pro/content.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"f69943d2cfd04a3ff4596e222c562d5d\";}s:54:\"wp-content/themes/skt-restaurant-pro/css/animation.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"993555a382d87b3e6497d699611bafa8\";}s:57:\"wp-content/themes/skt-restaurant-pro/css/font-awesome.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"65c24b8ab0dbb7030ce94e9d237e15aa\";}s:70:\"wp-content/themes/skt-restaurant-pro/css/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"32400f4e08932a94d8bfd2422702c446\";}s:70:\"wp-content/themes/skt-restaurant-pro/css/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"f775f9cca88e21d45bebe185b27c0e5b\";}s:70:\"wp-content/themes/skt-restaurant-pro/css/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"a3de2170e4e9df77161ea5d3f31b2668\";}s:71:\"wp-content/themes/skt-restaurant-pro/css/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"a35720c2fed2c7f043bc7e4ffb45e073\";}s:72:\"wp-content/themes/skt-restaurant-pro/css/fonts/fontawesome-webfont.woff2\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"db812d8a70a4e88e888744c1c9a27e89\";}s:62:\"wp-content/themes/skt-restaurant-pro/css/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"87d8ca3ddc57e7d2da6226e480f90457\";}s:47:\"wp-content/themes/skt-restaurant-pro/css/ie.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"d7e618b2ccbdf6d1801670dc9d760f7b\";}s:56:\"wp-content/themes/skt-restaurant-pro/css/nivo-slider.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ef4cee4eb57eadce6f558f3daf071943\";}s:56:\"wp-content/themes/skt-restaurant-pro/css/prettyPhoto.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"5d380f50f8384f73f7f32bb7e244859b\";}s:55:\"wp-content/themes/skt-restaurant-pro/css/style_base.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"75c51e8dc148f159a69dd9a0617fa411\";}s:61:\"wp-content/themes/skt-restaurant-pro/css/theme-responsive.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"5f5b3c6a3ec13eb3f8920d246d292603\";}s:53:\"wp-content/themes/skt-restaurant-pro/editor-style.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"60204302c38a961c4140f691c9e16084\";}s:47:\"wp-content/themes/skt-restaurant-pro/footer.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"402b125af0d59408b5d0ae926b8f547c\";}s:51:\"wp-content/themes/skt-restaurant-pro/full-width.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"417d7d7f919672b000532eb5565e340b\";}s:50:\"wp-content/themes/skt-restaurant-pro/functions.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"3578e50aee688d910f575de31201175c\";}s:47:\"wp-content/themes/skt-restaurant-pro/header.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"2f0e90e6cd0eb99ee10bbdc9827d989e\";}s:46:\"wp-content/themes/skt-restaurant-pro/image.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"1018cd9bdc9fd941b04e2d54b1912352\";}s:55:\"wp-content/themes/skt-restaurant-pro/images/base/hr.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ee8d1c499e8a8e7e578e9ba8e74e8f0a\";}s:55:\"wp-content/themes/skt-restaurant-pro/images/loading.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"dd6b7b0bf5c3af22499abc0a9ee1e1b2\";}s:90:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/dark_rounded/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:79:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/dark_rounded/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"4297900ae2d9d0c4eb00d1c15462fb19\";}s:89:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/dark_square/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:78:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/dark_square/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"4297900ae2d9d0c4eb00d1c15462fb19\";}s:74:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/default/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"8393c5f7e394698f751ee6a11fff3dc7\";}s:86:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/facebook/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:75:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/facebook/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:91:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/light_rounded/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:80:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/light_rounded/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:90:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/light_square/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:79:\"wp-content/themes/skt-restaurant-pro/images/prettyPhoto/light_square/loader.gif\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:65:\"wp-content/themes/skt-restaurant-pro/inc/css/optionsframework.css\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"8c4399e171f5c9bbf49f647a12bedb9b\";}s:61:\"wp-content/themes/skt-restaurant-pro/inc/custom-functions.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"61a9cd25b5195f832b98b35057859153\";}s:58:\"wp-content/themes/skt-restaurant-pro/inc/custom-header.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"380aa0c559fa5aba449aa05808666a19\";}s:55:\"wp-content/themes/skt-restaurant-pro/inc/customizer.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"cd9486877a40205bcbfd82d181804407\";}s:51:\"wp-content/themes/skt-restaurant-pro/inc/extras.php\";a:2:{s:1:\"d\";i:1487334229;s:1:\"h\";s:32:\"3f724fead8584be64c424ae85af5c30b\";}s:83:\"wp-content/themes/skt-restaurant-pro/inc/includes/class-options-framework-admin.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"cd50a24b26300d78f4689142aff00215\";}s:77:\"wp-content/themes/skt-restaurant-pro/inc/includes/class-options-framework.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"ea000f92d67367c3b5ec941aabb3a9e4\";}s:77:\"wp-content/themes/skt-restaurant-pro/inc/includes/class-options-interface.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"f02de426277ddd63158be19174ecfe61\";}s:82:\"wp-content/themes/skt-restaurant-pro/inc/includes/class-options-media-uploader.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"9885623d9347cf780ac160092c9adf6f\";}s:76:\"wp-content/themes/skt-restaurant-pro/inc/includes/class-options-sanitize.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"32ecdd36a439b2d7d103eb6213422e6a\";}s:52:\"wp-content/themes/skt-restaurant-pro/inc/jetpack.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"f01194853f795065960dc8393b0e319e\";}s:61:\"wp-content/themes/skt-restaurant-pro/inc/js/media-uploader.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"cf418db09d0540f16b06405667641248\";}s:61:\"wp-content/themes/skt-restaurant-pro/inc/js/options-custom.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"4307ed46a477aba422d7fb057691f13e\";}s:62:\"wp-content/themes/skt-restaurant-pro/inc/options-framework.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"be02312bb7e6d5536efda013f6a90398\";}s:58:\"wp-content/themes/skt-restaurant-pro/inc/template-tags.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"00cef66d78f3aabad1b2545f62044ad9\";}s:54:\"wp-content/themes/skt-restaurant-pro/index-default.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"10642b745a01e03b51bb635253eebf64\";}s:46:\"wp-content/themes/skt-restaurant-pro/index.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"a82b14449571f9c861e3a81e588ffdb5\";}s:59:\"wp-content/themes/skt-restaurant-pro/js/custom.customize.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"3d0a8e5c1f73fa69be0ae8efb2ad3bcf\";}s:49:\"wp-content/themes/skt-restaurant-pro/js/custom.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"3ac69f147d60286df65f88ee736a9742\";}s:48:\"wp-content/themes/skt-restaurant-pro/js/html5.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"45a6734a5b5708eb13b82fb9ce4a4c69\";}s:56:\"wp-content/themes/skt-restaurant-pro/js/jquery.appear.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"e9105274247eb5f6038ca5eb97119338\";}s:61:\"wp-content/themes/skt-restaurant-pro/js/jquery.nivo.slider.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"d3356754fe8c2e45837b1efbfe7d3264\";}s:61:\"wp-content/themes/skt-restaurant-pro/js/jquery.prettyPhoto.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"e8f5d4c1d798440c7b554f76527b5791\";}s:57:\"wp-content/themes/skt-restaurant-pro/languages/readme.txt\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"108ae30b4a17d39d9c115ff25821218b\";}s:65:\"wp-content/themes/skt-restaurant-pro/languages/restaurant-pro.pot\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"ed886a757ea50b4a82397a0d01b6c655\";}s:53:\"wp-content/themes/skt-restaurant-pro/left-sidebar.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"d4b612890f1930b98457c11e9f68da19\";}s:48:\"wp-content/themes/skt-restaurant-pro/license.txt\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"d32239bcb673463ab874e80d47fae504\";}s:53:\"wp-content/themes/skt-restaurant-pro/mixitup/demo.css\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"668e2de03c98ff7be9c7a7ee3c4d5ba9\";}s:62:\"wp-content/themes/skt-restaurant-pro/mixitup/jquery_mixitup.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"29cb73527b4532bea42cbfe1787e24c3\";}s:51:\"wp-content/themes/skt-restaurant-pro/no-results.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"6b380d18c892658eb990dc40669dc87e\";}s:51:\"wp-content/themes/skt-restaurant-pro/no-sidebar.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"f41b7dfc71a72a6fb50c8d0561493766\";}s:48:\"wp-content/themes/skt-restaurant-pro/options.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"d87497df465d37d812dd6dee008b15e2\";}s:45:\"wp-content/themes/skt-restaurant-pro/page.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"8a9a0a75cdd6929e6a38db65bb09e4d4\";}s:47:\"wp-content/themes/skt-restaurant-pro/readme.txt\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"b5bacc3bd9ffbc80a68f9f3c9d393470\";}s:47:\"wp-content/themes/skt-restaurant-pro/search.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"b4b29df32a599495dea11d2a1bb737ff\";}s:51:\"wp-content/themes/skt-restaurant-pro/searchform.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"4863a627c3dd41fd4d0998023a4cce28\";}s:53:\"wp-content/themes/skt-restaurant-pro/sidebar-blog.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"4cb9b27b9c6da7ee0f7ff62009be1668\";}s:48:\"wp-content/themes/skt-restaurant-pro/sidebar.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"49b8c0c18cba76535a191b3bd2bc24af\";}s:47:\"wp-content/themes/skt-restaurant-pro/single.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"1f9420edaf5d2e13316faa2a7933344c\";}s:46:\"wp-content/themes/skt-restaurant-pro/style.css\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"e708999d9a0157addef1505ba7811694\";}s:73:\"wp-content/themes/skt-restaurant-pro/testimonials-rotator/js/bootstrap.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"fb068e2e626dcf71eeaa8f077dc30518\";}s:84:\"wp-content/themes/skt-restaurant-pro/testimonials-rotator/js/jquery.quovolver.min.js\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"f98631151c0ed50e38e940e085b1cb07\";}s:75:\"wp-content/themes/skt-restaurant-pro/testimonials-rotator/js/tm-rotator.css\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"8301cd76da3f12b501361392b67ff9b9\";}s:52:\"wp-content/themes/skt-restaurant-pro/woocommerce.php\";a:2:{s:1:\"d\";i:1487334230;s:1:\"h\";s:32:\"9ec6c57980a38bb9356dcff352b43b3e\";}s:53:\"wp-content/uploads/ithemes-security/backups/index.php\";a:2:{s:1:\"d\";i:1490249619;s:1:\"h\";s:32:\"a605acf2b02df4876305872b2c14a29b\";}s:45:\"wp-content/uploads/ithemes-security/index.php\";a:2:{s:1:\"d\";i:1490249973;s:1:\"h\";s:32:\"a605acf2b02df4876305872b2c14a29b\";}s:50:\"wp-content/uploads/ithemes-security/logs/index.php\";a:2:{s:1:\"d\";i:1490249617;s:1:\"h\";s:32:\"a605acf2b02df4876305872b2c14a29b\";}s:48:\"wp-content/uploads/photo-gallery/.original/2.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"e8d26a37b6631f247a52e25a9a0a519a\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0481.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"21b5a3a2c75dae12b436730ce81e78b6\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0482.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"0db8a9e6383950e0f0683f12a66818c1\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0486.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"2eaab5c61636ed52a4a0821d53efa379\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0487.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"3e34bf80d194e4b8e32b2f6b97c5652e\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0488.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"890e0281843bc142e993d517cd3a36f2\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0489.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"1a1948c04f0841740c08a64ba94825ac\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0492.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"98d8335645d632a4217775dc23b888db\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0593.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"6e3d23532f3ad3c0e9a93dbfac18dcac\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0594.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"74dc48846b50a2422a3aacf633f0a62d\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0601.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"d9518c0dd0e05343a891cfd43cd5a2df\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0603.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"1bb2ab0b6e4022bafce9a5439754f4d9\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0605.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"646307e12fc51a6309aed59632ad5613\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0606.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"f79c3a424663c7c44a0b70fa0feb4b69\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0628.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"224cb843545bdf722ba22023dd4e3b7e\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0629.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"ed542c824ac4012eb9e4beb371bdaf9f\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN0854.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"0cf1f3a0c546991a15da6bf016c8a57e\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1380.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"9e8cbaa5ee845e9f8fddf974da7925f7\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1643.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"332379ef2cd58da43a9988e3696995a1\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1647.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"6708e953fcfcba583bada4dfa4dc604b\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1651.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"a2fb07693a1563e0bb9acdc3b3794718\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1661.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"10c7b1fb452a342aaf2f95cbdeea27a1\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1678.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"d0001ad4f7ddf35d204aa7a0ecdf8739\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1695.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"341cfdb12df49949ef99a35e30edce1e\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1701.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"bed05968f486ded32a7e00b177e7361f\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1704.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"664c54031fa5643cb1dad53b60183c30\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1709.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"aa0bf63642614722320260af0ac76082\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1711.JPG\";a:2:{s:1:\"d\";i:1490208139;s:1:\"h\";s:32:\"e38ceecf156b8773f45a89551a8d9366\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1725.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"d64c46d465108820ce12ed3dedce0ff6\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1729.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"b54fb9e321077eb41cd94001b1dc7d87\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1730.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"c98ae0d1adfca96dabc2ca4224feec2a\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1731.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"394dfe215673ad7fe5df991b0d57d96a\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1733.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"e7c86d1c463d8159e892384a14477b7f\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1734.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"bbb66af7eafdd3432dc2ed74cfcf0342\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1743.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"5b22d52ba601744c79a3d9a720521c97\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1746.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"9686337dc284a30625658a35069a92a5\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1763.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"a5abec91856b230c52d5659cd8befcb3\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1764.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"b4368571c149720a35d60924e507b5d7\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1766.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"ead25f67e37bd470093b8c5048872854\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1768.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"357836539ce78f56c2db9089998f8ea8\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1770.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"a531a460e1a5e48a6a4478b691bc46cc\";}s:55:\"wp-content/uploads/photo-gallery/.original/DSCN1771.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"5c7d27b14e1d831f6b9d3485a98deee8\";}s:38:\"wp-content/uploads/photo-gallery/2.JPG\";a:2:{s:1:\"d\";i:1490208137;s:1:\"h\";s:32:\"e8d26a37b6631f247a52e25a9a0a519a\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0481.JPG\";a:2:{s:1:\"d\";i:1490207654;s:1:\"h\";s:32:\"21b5a3a2c75dae12b436730ce81e78b6\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0482.JPG\";a:2:{s:1:\"d\";i:1490207654;s:1:\"h\";s:32:\"0db8a9e6383950e0f0683f12a66818c1\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0486.JPG\";a:2:{s:1:\"d\";i:1490207654;s:1:\"h\";s:32:\"2eaab5c61636ed52a4a0821d53efa379\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0487.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"3e34bf80d194e4b8e32b2f6b97c5652e\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0488.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"890e0281843bc142e993d517cd3a36f2\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0489.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"1a1948c04f0841740c08a64ba94825ac\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0492.JPG\";a:2:{s:1:\"d\";i:1490207656;s:1:\"h\";s:32:\"98d8335645d632a4217775dc23b888db\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0593.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"6e3d23532f3ad3c0e9a93dbfac18dcac\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0594.JPG\";a:2:{s:1:\"d\";i:1490207656;s:1:\"h\";s:32:\"74dc48846b50a2422a3aacf633f0a62d\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0601.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"d9518c0dd0e05343a891cfd43cd5a2df\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0603.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"1bb2ab0b6e4022bafce9a5439754f4d9\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0605.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"646307e12fc51a6309aed59632ad5613\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0606.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"f79c3a424663c7c44a0b70fa0feb4b69\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0628.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"224cb843545bdf722ba22023dd4e3b7e\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0629.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"ed542c824ac4012eb9e4beb371bdaf9f\";}s:45:\"wp-content/uploads/photo-gallery/DSCN0854.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"0cf1f3a0c546991a15da6bf016c8a57e\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1380.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"9e8cbaa5ee845e9f8fddf974da7925f7\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1643.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"332379ef2cd58da43a9988e3696995a1\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1647.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"6708e953fcfcba583bada4dfa4dc604b\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1651.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"a2fb07693a1563e0bb9acdc3b3794718\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1661.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"10c7b1fb452a342aaf2f95cbdeea27a1\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1678.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"d0001ad4f7ddf35d204aa7a0ecdf8739\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1695.JPG\";a:2:{s:1:\"d\";i:1490208137;s:1:\"h\";s:32:\"341cfdb12df49949ef99a35e30edce1e\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1701.JPG\";a:2:{s:1:\"d\";i:1490208137;s:1:\"h\";s:32:\"bed05968f486ded32a7e00b177e7361f\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1704.JPG\";a:2:{s:1:\"d\";i:1490208137;s:1:\"h\";s:32:\"664c54031fa5643cb1dad53b60183c30\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1709.JPG\";a:2:{s:1:\"d\";i:1490208137;s:1:\"h\";s:32:\"aa0bf63642614722320260af0ac76082\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1711.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"e38ceecf156b8773f45a89551a8d9366\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1725.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"d64c46d465108820ce12ed3dedce0ff6\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1729.JPG\";a:2:{s:1:\"d\";i:1490208556;s:1:\"h\";s:32:\"b54fb9e321077eb41cd94001b1dc7d87\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1730.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"c98ae0d1adfca96dabc2ca4224feec2a\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1731.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"394dfe215673ad7fe5df991b0d57d96a\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1733.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"e7c86d1c463d8159e892384a14477b7f\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1734.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"bbb66af7eafdd3432dc2ed74cfcf0342\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1743.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"5b22d52ba601744c79a3d9a720521c97\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1746.JPG\";a:2:{s:1:\"d\";i:1490208139;s:1:\"h\";s:32:\"9686337dc284a30625658a35069a92a5\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1763.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"a5abec91856b230c52d5659cd8befcb3\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1764.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"b4368571c149720a35d60924e507b5d7\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1766.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"ead25f67e37bd470093b8c5048872854\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1768.JPG\";a:2:{s:1:\"d\";i:1490208556;s:1:\"h\";s:32:\"357836539ce78f56c2db9089998f8ea8\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1770.JPG\";a:2:{s:1:\"d\";i:1490208556;s:1:\"h\";s:32:\"a531a460e1a5e48a6a4478b691bc46cc\";}s:45:\"wp-content/uploads/photo-gallery/DSCN1771.JPG\";a:2:{s:1:\"d\";i:1490208556;s:1:\"h\";s:32:\"5c7d27b14e1d831f6b9d3485a98deee8\";}s:44:\"wp-content/uploads/photo-gallery/thumb/2.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"a0fa912c4443208fa3fd0fc65c4a0c18\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0481.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"64f44e48015f908577ee1a2f90bdfaf2\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0482.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"ad0346d0a93775c5c9df522f7465b3a5\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0486.JPG\";a:2:{s:1:\"d\";i:1490207655;s:1:\"h\";s:32:\"afc45ab6b1bf3df9555f710a4493624c\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0487.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"baacf5544421d2474d4e3d7c7991e28e\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0488.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"68b603e039fb8adc75455d1fabd3b773\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0489.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"89f27090f1d558a31470e47911aa1344\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0492.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"bdb4b4a1ad2427e078c284671d9d01c1\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0593.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"c4a6ec37f0ee09dee772dab7b37975cf\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0594.JPG\";a:2:{s:1:\"d\";i:1490207657;s:1:\"h\";s:32:\"727974c1bfdfd0eb629d21ab590d363b\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0601.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"036df74a4133e6896507beb8706c6c3c\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0603.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"dd3ecb29df61730a72cd67135e9248d0\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0605.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"58e984bbd7f9a774a9b40ce433bb655b\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0606.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"051543de9d870c7f3feb821b2cc81d18\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0628.JPG\";a:2:{s:1:\"d\";i:1490207658;s:1:\"h\";s:32:\"3310fa2ce2b99210c1b9374922f0081c\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0629.JPG\";a:2:{s:1:\"d\";i:1490207659;s:1:\"h\";s:32:\"401244d56dc0b728822fdbb370280d2c\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN0854.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"82a0febac9ffb04eacec988d3ebfada0\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1380.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"474cf6478e94f342d545c62d064820df\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1643.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"2b4c37b81a1f734c58ee32a3140a8d00\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1647.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"509ca237f5c4d5004ee8db4a85078155\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1651.JPG\";a:2:{s:1:\"d\";i:1490207660;s:1:\"h\";s:32:\"68a2095facb2805377ad457ce04abf2b\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1661.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"8a3c30041f57b6705521904538d5fc47\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1678.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"2ab3fcb9555342baf985e5c54a4f6e9a\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1695.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"80d1f5aa2c04ba5cf47fcbb3b7d390fd\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1701.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"a0d87d499b0b7527c236149e401e9cee\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1704.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"5943545f28c904108a63afe6e92f7439\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1709.JPG\";a:2:{s:1:\"d\";i:1490208138;s:1:\"h\";s:32:\"a2244378ea3d5954da9a76d5e7cf89cb\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1711.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"48162ba4eba0e87f527496503b59a485\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1725.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"d3f160f38a3a18350b16221e521e0d81\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1729.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"df99a3eba4ad8c247295ceca343c8601\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1730.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"22b99c72524647826fedf17ac496a8de\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1731.JPG\";a:2:{s:1:\"d\";i:1490207661;s:1:\"h\";s:32:\"bfd676a08022761b50829d92d7a8385d\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1733.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"c85bdf7a1574838d6459cc04a9e39dae\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1734.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"88dfb8b0a5146d5dc56acb7da2abf40e\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1743.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"f04e1870085170a8350bac26d1cc7e5a\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1746.JPG\";a:2:{s:1:\"d\";i:1490208140;s:1:\"h\";s:32:\"3c8cd3e73dee292a84f16c36561f6840\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1763.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"49b33aab7c709a81450fa009f5f27471\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1764.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"5e4be6f3c25e7e160a9f7a15d0aa3e7b\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1766.JPG\";a:2:{s:1:\"d\";i:1490208141;s:1:\"h\";s:32:\"4cac56e4bf0680f9996ab80be36c8eba\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1768.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"a27008aaeb2ac3e0aa20a443a92dda71\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1770.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"882bd02e7c7964cf84bea7956c69b466\";}s:51:\"wp-content/uploads/photo-gallery/thumb/DSCN1771.JPG\";a:2:{s:1:\"d\";i:1490208557;s:1:\"h\";s:32:\"5a2a013b0cafa6918803ac6599745ea9\";}s:33:\"wp-content/w3tc-config/index.html\";a:2:{s:1:\"d\";i:1490249288;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:33:\"wp-content/w3tc-config/master.php\";a:2:{s:1:\"d\";i:1490249288;s:1:\"h\";s:32:\"253f6be0288ec7bc8bd443e9ad7549b6\";}s:11:\"wp-cron.php\";a:2:{s:1:\"d\";i:1487282268;s:1:\"h\";s:32:\"f28242f5766d6525b949f376813236d3\";}s:25:\"wp-includes/admin-bar.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"50d7b64a6bd73550e84529c18c8d2fd1\";}s:23:\"wp-includes/atomlib.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"83cf707b4178575abbcdf66d5e64ad2a\";}s:31:\"wp-includes/author-template.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"1a379e3f3c76d2936929cbf0c47a8482\";}s:33:\"wp-includes/bookmark-template.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"b4675b6c675004098ba08c353522ea81\";}s:24:\"wp-includes/bookmark.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"699621354a1e6c190b2428d0c2540bcd\";}s:21:\"wp-includes/cache.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"913d5df0ae82bf71b80dae3a21d712c6\";}s:25:\"wp-includes/canonical.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"24245a33170ab78622cf6ba9ceb55a9e\";}s:28:\"wp-includes/capabilities.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"397fe2803b36e192fde591cc751ceab0\";}s:33:\"wp-includes/category-template.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"dead7b832c77ebbb948ca7227362ed2d\";}s:24:\"wp-includes/category.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"65f4456db498c7784f5e31c87f901c6a\";}s:38:\"wp-includes/certificates/ca-bundle.crt\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"dd1c7bdebdfc411eb8a336e3d758692c\";}s:26:\"wp-includes/class-feed.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"cc29246ba6bf335c20a212b3f73245b6\";}s:26:\"wp-includes/class-http.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"b1c53837b235bf71092a15be19e20821\";}s:25:\"wp-includes/class-IXR.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"32ac76bea2307022852b2f7a62c60c2b\";}s:26:\"wp-includes/class-json.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"808a427ba07643d4deaf4dfdcf418e6d\";}s:28:\"wp-includes/class-oembed.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"3c5a8eea0006e4cac1a00e0858998d65\";}s:28:\"wp-includes/class-phpass.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"03191a210ccbea54cb07dedfedb7cc42\";}s:31:\"wp-includes/class-phpmailer.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"3eff9ed4b6cadf990b4f238ed91c5ade\";}s:26:\"wp-includes/class-pop3.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"154b5451c8a93a4f21a74054be961d79\";}s:30:\"wp-includes/class-requests.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"3965aca1181b2fb6ec75617ab4d4223c\";}s:31:\"wp-includes/class-simplepie.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"0dbef394a91127f068ac8fdd587d4895\";}s:26:\"wp-includes/class-smtp.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"12c62b22075a3c4b74ebc8ab3a98d295\";}s:28:\"wp-includes/class-snoopy.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"73b05cdec5859ff6edcfbcd22ebd0960\";}s:46:\"wp-includes/class-walker-category-dropdown.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"0991dfb6e6ff797684dd25602cadc96d\";}s:37:\"wp-includes/class-walker-category.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"395c33fe65447b3a1872a087f60e3d4a\";}s:36:\"wp-includes/class-walker-comment.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"952f0728639041515c1b8f88f7ea5316\";}s:37:\"wp-includes/class-walker-nav-menu.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"1501ee4ee5715b3b8beb9ee96498103a\";}s:42:\"wp-includes/class-walker-page-dropdown.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"4701bc7c46e09979fa82082957bab4f4\";}s:33:\"wp-includes/class-walker-page.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"04b3ed4b6c9af9b2f84e60e277df5468\";}s:34:\"wp-includes/class-wp-admin-bar.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"39c9dfd486b8f1d8d09468cf0857b89c\";}s:38:\"wp-includes/class-wp-ajax-response.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"215a169d146b9d894f6787a4f7177dfe\";}s:38:\"wp-includes/class-wp-comment-query.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"a201f578ce308f5a1614828c470c1974\";}s:32:\"wp-includes/class-wp-comment.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"2c67c5d546d7c43b9c1b6042679a8cb2\";}s:42:\"wp-includes/class-wp-customize-control.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"6582e9be9a1a295d3c82f0e19f4fccb0\";}s:42:\"wp-includes/class-wp-customize-manager.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"caaa25367210cbe8cfa02b1756ac0856\";}s:44:\"wp-includes/class-wp-customize-nav-menus.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"124cf54348945432ff0dc40e957ae6bd\";}s:40:\"wp-includes/class-wp-customize-panel.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"f18f315b81d92cb653a82d902e42dee4\";}s:42:\"wp-includes/class-wp-customize-section.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"e76fa8484fc120119f392d397f63a081\";}s:42:\"wp-includes/class-wp-customize-setting.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"5de72158fea22d6bb13922cdd9c390f9\";}s:42:\"wp-includes/class-wp-customize-widgets.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"48a131c8a41f01245e11a69aaf7f70a3\";}s:35:\"wp-includes/class-wp-dependency.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"1d09965ca6b8824d4846b63f46749e9b\";}s:31:\"wp-includes/class-wp-editor.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"ac02b009b8f86bea051aa1a3fadd231b\";}s:30:\"wp-includes/class-wp-embed.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"5cfaeb2963e48d6292e017276e04e4ac\";}s:30:\"wp-includes/class-wp-error.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"31cb0b54e528309bd8e75798148a3806\";}s:45:\"wp-includes/class-wp-feed-cache-transient.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"aaf72d33f3cd1fc7aba1bd95a9b01122\";}s:35:\"wp-includes/class-wp-feed-cache.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"ad629304ee561ad516423de478fd3dab\";}s:29:\"wp-includes/class-wp-hook.php\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"fafb8ce3c14998ebe00bc08c9a2e3138\";}s:36:\"wp-includes/class-wp-http-cookie.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"def187bf659eee2ea973faca88ed46d8\";}s:34:\"wp-includes/class-wp-http-curl.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"e41051adc047c1234a8952c3991c41ea\";}s:38:\"wp-includes/class-wp-http-encoding.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"6bd6106b97e662ea37e568da5e233cc0\";}s:40:\"wp-includes/class-wp-http-ixr-client.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"c1d5c63f0c6f615ad83b6cfe96bd11ec\";}s:35:\"wp-includes/class-wp-http-proxy.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"c03d899abae74d1a7ba338297605bb1c\";}s:44:\"wp-includes/class-wp-http-requests-hooks.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"6f1cda9f19f908a4d8440a46057f2d8c\";}s:47:\"wp-includes/class-wp-http-requests-response.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"73ea7b2c69d37b39a5caafc47acf2682\";}s:38:\"wp-includes/class-wp-http-response.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"cb145f4f0377f6090aec423d3c111b45\";}s:37:\"wp-includes/class-wp-http-streams.php\";a:2:{s:1:\"d\";i:1487282318;s:1:\"h\";s:32:\"daba5f5e6cf665ed31109661b3d795e8\";}s:40:\"wp-includes/class-wp-image-editor-gd.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"93b1a0a110ceabfa0edea8043640ab50\";}s:45:\"wp-includes/class-wp-image-editor-imagick.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"b7fca8c68836e43073f8794d6cba72a4\";}s:37:\"wp-includes/class-wp-image-editor.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"ceed2615f44d597a8f2c733dd6a3a46f\";}s:34:\"wp-includes/class-wp-list-util.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"be1a39c1f5451be0b1969be4999c5ba0\";}s:40:\"wp-includes/class-wp-locale-switcher.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"eca02c963d30481fc115c3135ab0c182\";}s:31:\"wp-includes/class-wp-locale.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"d86bab68d4d77871ff3fdc3b8a650f42\";}s:40:\"wp-includes/class-wp-matchesmapregex.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"5943d5a4f23c62ede93966d48e694665\";}s:35:\"wp-includes/class-wp-meta-query.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"1e8404e9ce36ac2197daadee7dc41870\";}s:44:\"wp-includes/class-wp-metadata-lazyloader.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"b7cbf9911d4690a12c9b31f7ccef81a5\";}s:38:\"wp-includes/class-wp-network-query.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"7cdc784893da3fe9238b387352997aee\";}s:32:\"wp-includes/class-wp-network.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"cc3ed1d2e2c47fb9c4efa84768c2da75\";}s:42:\"wp-includes/class-wp-oembed-controller.php\";a:2:{s:1:\"d\";i:1487282318;s:1:\"h\";s:32:\"393e9ec0ed404f381943c2f26d76e345\";}s:34:\"wp-includes/class-wp-post-type.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"3c83c77874ca8ba6c76f5ff943b9d5c4\";}s:29:\"wp-includes/class-wp-post.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"27737677e6c4f7b6e3bfc13264ed353f\";}s:30:\"wp-includes/class-wp-query.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"c6fdacc253ba3c6aeec26c780af71ad8\";}s:32:\"wp-includes/class-wp-rewrite.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"70af56f28004ed62f3333b476c42403a\";}s:29:\"wp-includes/class-wp-role.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"5e6d69020bd12aeb874ff64e74b2790c\";}s:30:\"wp-includes/class-wp-roles.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"51e11d99b14a3b85c2db1ee85e54be75\";}s:39:\"wp-includes/class-wp-session-tokens.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"668442c8b58333f3a940783bcf88c01f\";}s:39:\"wp-includes/class-wp-simplepie-file.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"c7ea687d769805c04fc68bf2376b8a5f\";}s:48:\"wp-includes/class-wp-simplepie-sanitize-kses.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"63551c5e5a80b6945d614c1bc49949a8\";}s:35:\"wp-includes/class-wp-site-query.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"74805ed750264694d05f47e7e3159ded\";}s:29:\"wp-includes/class-wp-site.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"dbf5a76d022ddcda004452bf2419da6f\";}s:34:\"wp-includes/class-wp-tax-query.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"da42e0ad13e157c565e023283705a339\";}s:33:\"wp-includes/class-wp-taxonomy.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"9f2ff9a9fe267df1fd2ea4821b30852d\";}s:35:\"wp-includes/class-wp-term-query.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"690520a1cd72a65d28135cb43da83c65\";}s:29:\"wp-includes/class-wp-term.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"5ba70badd0127c14dfcdeed67396ad58\";}s:50:\"wp-includes/class-wp-text-diff-renderer-inline.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"994486a99255b5b110d9551bbf763fc7\";}s:49:\"wp-includes/class-wp-text-diff-renderer-table.php\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"35f7d0339927a70b706479ab598f0ab9\";}s:30:\"wp-includes/class-wp-theme.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"12012427862b65d94185050ce9d1c6ea\";}s:49:\"wp-includes/class-wp-user-meta-session-tokens.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"aaf996e4d786c8029fac3f19adde1849\";}s:35:\"wp-includes/class-wp-user-query.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"a8acf2c89edb9ba5d6eb912b7c4b411c\";}s:29:\"wp-includes/class-wp-user.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"aa5cfda8768363c28ae2b71eb23775c2\";}s:31:\"wp-includes/class-wp-walker.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"3a57738fc768186f8cde37e12dbecc61\";}s:39:\"wp-includes/class-wp-widget-factory.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"f2a675bb7b4dfcd2a483335b03d989de\";}s:31:\"wp-includes/class-wp-widget.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"ab0b765a39af644f41d7c770d8c835fc\";}s:38:\"wp-includes/class-wp-xmlrpc-server.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"b3b3d805e44cc019fe39cc804aaca95f\";}s:24:\"wp-includes/class-wp.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"1a4ffa331a9b8b678490217c9f5383dc\";}s:37:\"wp-includes/class.wp-dependencies.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"5857761bdeda9fcfa1bbda934a7afbbb\";}s:32:\"wp-includes/class.wp-scripts.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"9ae3f634d1efb2f958284912bc7c5b97\";}s:31:\"wp-includes/class.wp-styles.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"8255de3a300af152c78468611dbf3604\";}s:32:\"wp-includes/comment-template.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"e3e9f072a57446ee8a3eb4ceb5986d62\";}s:23:\"wp-includes/comment.php\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"aa195fbd47a24b6be84ed40b82dcf563\";}s:22:\"wp-includes/compat.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"d888115e10240770b95f6be1a3458b01\";}s:20:\"wp-includes/cron.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"8648a64c31d3e2d6724224770f628e56\";}s:33:\"wp-includes/css/admin-bar-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"50dcb762647a492e4769ea0947b50248\";}s:37:\"wp-includes/css/admin-bar-rtl.min.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"1fdf9fead757cda46f53f3b79b55fe47\";}s:29:\"wp-includes/css/admin-bar.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"a2c05aeb1c11f06a8b3c1bc8888714f9\";}s:33:\"wp-includes/css/admin-bar.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"181a0de4f1c4252aebb47f2204f0c119\";}s:31:\"wp-includes/css/buttons-rtl.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"18cac60d5d31e37c3070817504c62af3\";}s:35:\"wp-includes/css/buttons-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"04203d21bcc20f3c309146e22db92332\";}s:27:\"wp-includes/css/buttons.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"5e4b2f1d423c73e86cc870546a3843a3\";}s:31:\"wp-includes/css/buttons.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"fa03516663b10fb9654af4e680ccc42b\";}s:41:\"wp-includes/css/customize-preview-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"514952b81c6dbef19b62b040e76484f9\";}s:45:\"wp-includes/css/customize-preview-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"cccb91a79bd1a1b14bdad769d3b04ff2\";}s:37:\"wp-includes/css/customize-preview.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"a5a052c8869b9f302405b069b1aa0613\";}s:41:\"wp-includes/css/customize-preview.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"69bfc88e3f3d46f116da818588e1c958\";}s:29:\"wp-includes/css/dashicons.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"cbd78303f0ab99bcf4470575b0f8a7ea\";}s:33:\"wp-includes/css/dashicons.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"cf3c0e8f26fe2025a0f22138ffe30d53\";}s:30:\"wp-includes/css/editor-rtl.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"66921114b83a2e737e69f2847b4c9cf3\";}s:34:\"wp-includes/css/editor-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"9fe3e6ba7eb849f83f99d4c157a9351f\";}s:26:\"wp-includes/css/editor.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"e97b439d9f0c638e88d8a4cc21823025\";}s:30:\"wp-includes/css/editor.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"d5b03f5ca13605379b6c565ebfa55570\";}s:40:\"wp-includes/css/jquery-ui-dialog-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"10939ff6a3629fba80e30e2e7c526901\";}s:44:\"wp-includes/css/jquery-ui-dialog-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"de1c2e841d52991cc738f4b029a4f249\";}s:36:\"wp-includes/css/jquery-ui-dialog.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"a0347ba6476ac6b646d145697970e81c\";}s:40:\"wp-includes/css/jquery-ui-dialog.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"dae18845cfc3c211c5c6de92401b2ad5\";}s:35:\"wp-includes/css/media-views-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"0f5b4dc649f5d2218067a8c37e7c1bab\";}s:39:\"wp-includes/css/media-views-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"473143467093228d834df66130904558\";}s:31:\"wp-includes/css/media-views.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"251ddd705433c207dac4dc90b01abbe3\";}s:35:\"wp-includes/css/media-views.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"2a1ab38629d6f10178a0d200e7edaad1\";}s:37:\"wp-includes/css/wp-auth-check-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"cceefa969cbff4bcacfa3a39ff48214c\";}s:41:\"wp-includes/css/wp-auth-check-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"5bbe4c2ecb541952ca408683e79fbb14\";}s:33:\"wp-includes/css/wp-auth-check.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"85752ca8c899aee3297e87479fd51994\";}s:37:\"wp-includes/css/wp-auth-check.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"d1f94f9a93f83b7dc4d924f04842d294\";}s:40:\"wp-includes/css/wp-embed-template-ie.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"eeb729369ef309d89ed0bc7120aacadf\";}s:44:\"wp-includes/css/wp-embed-template-ie.min.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"1aec3cac7756e9b405bcbf0ad39c7772\";}s:37:\"wp-includes/css/wp-embed-template.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"c01952804cd717c96afe10e9689bbd32\";}s:41:\"wp-includes/css/wp-embed-template.min.css\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"433386de4a64b9ca6d74e14756bdaff6\";}s:34:\"wp-includes/css/wp-pointer-rtl.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"8bb0bef9034c514f114e05ff9fc63840\";}s:38:\"wp-includes/css/wp-pointer-rtl.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"456e10f2561e65f2b76c1985b657ebdb\";}s:30:\"wp-includes/css/wp-pointer.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"82eeae4c68288d28c8809ef9fb1bc3ea\";}s:34:\"wp-includes/css/wp-pointer.min.css\";a:2:{s:1:\"d\";i:1487282352;s:1:\"h\";s:32:\"7e9fd782602ead0ddd91ecbe600bb078\";}s:69:\"wp-includes/customize/class-wp-customize-background-image-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"700fcf87fa150f061f909dd1747cce33\";}s:69:\"wp-includes/customize/class-wp-customize-background-image-setting.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"29d940877494fe6a123233b413e39d57\";}s:72:\"wp-includes/customize/class-wp-customize-background-position-control.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"0a5d93333c4c1228c9b0a870e8aa48ff\";}s:58:\"wp-includes/customize/class-wp-customize-color-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"7ef700003910fd1c2695639782759390\";}s:66:\"wp-includes/customize/class-wp-customize-cropped-image-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"188e5b572722f166ecf649de99a99f74\";}s:63:\"wp-includes/customize/class-wp-customize-custom-css-setting.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"46faad031295ecfb005acceaa6966516\";}s:59:\"wp-includes/customize/class-wp-customize-filter-setting.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"c8c2605676fd3e41b3a220e224b11ff7\";}s:65:\"wp-includes/customize/class-wp-customize-header-image-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"2be32db1c5fe68d5fdd4d0b3d7b9d0f9\";}s:65:\"wp-includes/customize/class-wp-customize-header-image-setting.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"33a7a6cf0c70fcac180247c9739230a4\";}s:58:\"wp-includes/customize/class-wp-customize-image-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"5569b414680e2dc9c0201b84f6ee4bf3\";}s:58:\"wp-includes/customize/class-wp-customize-media-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"72d9749d6a2b497138ee8636e1f0909d\";}s:70:\"wp-includes/customize/class-wp-customize-nav-menu-auto-add-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"0ab3b790f65a6dac64d535ae39813930\";}s:61:\"wp-includes/customize/class-wp-customize-nav-menu-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"19c4c58e91c6cebff06c9b3cd136c248\";}s:66:\"wp-includes/customize/class-wp-customize-nav-menu-item-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"fb6ed57f64ca505759ff5dd0191ad332\";}s:66:\"wp-includes/customize/class-wp-customize-nav-menu-item-setting.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"a74b69476dad500c6a8377a2641a3f8a\";}s:70:\"wp-includes/customize/class-wp-customize-nav-menu-location-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"21937ae7a6d44e486f3b1625b1a9eb3f\";}s:66:\"wp-includes/customize/class-wp-customize-nav-menu-name-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"7be860d996d35f933754a894c8a50833\";}s:61:\"wp-includes/customize/class-wp-customize-nav-menu-section.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"805cc39342700d6871c72754646fb740\";}s:61:\"wp-includes/customize/class-wp-customize-nav-menu-setting.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"78febf68a10e3fcfe9d7a53f5126178f\";}s:60:\"wp-includes/customize/class-wp-customize-nav-menus-panel.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"11bc9a75ec3a51269382849fc2925384\";}s:61:\"wp-includes/customize/class-wp-customize-new-menu-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"5b8bc62182f5b6415bac0d1d5a4cb4cd\";}s:61:\"wp-includes/customize/class-wp-customize-new-menu-section.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"e8d4fc64423b7f95c7ae0a4a87ed886d\";}s:52:\"wp-includes/customize/class-wp-customize-partial.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"258777a25990b9240cba91100ae1eb75\";}s:62:\"wp-includes/customize/class-wp-customize-selective-refresh.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"90b9afc33b576c82c8077dbf2a0d1ed2\";}s:60:\"wp-includes/customize/class-wp-customize-sidebar-section.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"21542b6361ceb246afb8a4b1ecc4d2eb\";}s:62:\"wp-includes/customize/class-wp-customize-site-icon-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"df850b34d66741ffd45db9ce47c03ce1\";}s:58:\"wp-includes/customize/class-wp-customize-theme-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"9225fc149f9d74a9b25fc90eb2c2f2c0\";}s:59:\"wp-includes/customize/class-wp-customize-themes-section.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"2eef141ca8a69cffc8d51eee31224156\";}s:59:\"wp-includes/customize/class-wp-customize-upload-control.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"4aeba7d8c346f71e79c5bea97240937b\";}s:64:\"wp-includes/customize/class-wp-widget-area-customize-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"d941ff8ed2cb1011e102f4f7df4329ff\";}s:64:\"wp-includes/customize/class-wp-widget-form-customize-control.php\";a:2:{s:1:\"d\";i:1487282366;s:1:\"h\";s:32:\"887fd01bd4eba2d0ecc4170d007d88a9\";}s:20:\"wp-includes/date.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"12204885ec0406c9dedc333d731a72e2\";}s:33:\"wp-includes/default-constants.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"4bff0b956f1268e29bb13d375fdaf053\";}s:31:\"wp-includes/default-filters.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"454973755d1ef9982236c0e00488b5fa\";}s:31:\"wp-includes/default-widgets.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"12a94f6954b830fc2a00da68fa2967bb\";}s:26:\"wp-includes/deprecated.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"ea4c18b0072a668d448949574db1b965\";}s:30:\"wp-includes/embed-template.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"880c0f3ebdef45564a7b3b1536ff212a\";}s:21:\"wp-includes/embed.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"abc2e670cd4ff615a391a1d506e4bbab\";}s:34:\"wp-includes/feed-atom-comments.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"2efa90f57308ebc0a4f6f950751793dc\";}s:25:\"wp-includes/feed-atom.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"dac1010014e22c7d35b37dc0437efce3\";}s:24:\"wp-includes/feed-rdf.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"7c15976464fe989a6136beaedd27de9a\";}s:24:\"wp-includes/feed-rss.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"4dc733d73fd9ebc810a067c12e0e420d\";}s:34:\"wp-includes/feed-rss2-comments.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"c1fb77ab52c09ed5ead32fc5824d17d9\";}s:25:\"wp-includes/feed-rss2.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"a409671e54cb7f9c300b7ce86d71ace7\";}s:20:\"wp-includes/feed.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"8b9507fcf985f1a829cb6a9959cc8017\";}s:31:\"wp-includes/fonts/dashicons.eot\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"30e410c715c6215fa7faa1c979b6480c\";}s:31:\"wp-includes/fonts/dashicons.svg\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"780e6968cd0e378b1f7723d89fa59ab5\";}s:31:\"wp-includes/fonts/dashicons.ttf\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"8fea1fce46bafe469ba2f101fdc583e2\";}s:32:\"wp-includes/fonts/dashicons.woff\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"0c1c1ad41c025f72592bca820e073bec\";}s:26:\"wp-includes/formatting.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"6b77f5df6b4de5c235ccb322af6f61fe\";}s:25:\"wp-includes/functions.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"b78445800d28f49d715c5e34b57b1055\";}s:36:\"wp-includes/functions.wp-scripts.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"fa0bd887583d897c7ddc0fb381258555\";}s:35:\"wp-includes/functions.wp-styles.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"e665e24a159238e25a805717db32fb98\";}s:32:\"wp-includes/general-template.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"92aa5a917b1a30bc313127f28a2304c8\";}s:20:\"wp-includes/http.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"5760a4faa941571a9561ca2c166174e6\";}s:30:\"wp-includes/ID3/getid3.lib.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"c52de7647222fe4b24e2ea04755f99b8\";}s:26:\"wp-includes/ID3/getid3.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"97bcd61856df7afa653d491775efda5c\";}s:38:\"wp-includes/ID3/license.commercial.txt\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"0a3b670896fc4a8067adb2c6d978418e\";}s:27:\"wp-includes/ID3/license.txt\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"35d98aadf8f7cc6851336651f7a66b98\";}s:42:\"wp-includes/ID3/module.audio-video.asf.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"286b1999c151b7ba01cfd57c24e134cf\";}s:42:\"wp-includes/ID3/module.audio-video.flv.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"6b834869b62c57fea91851b146dce3d3\";}s:47:\"wp-includes/ID3/module.audio-video.matroska.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"639aa5ae894b396a00fb53fc8069e74a\";}s:48:\"wp-includes/ID3/module.audio-video.quicktime.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"272dfd6e4c391f20611a11d921e66eeb\";}s:43:\"wp-includes/ID3/module.audio-video.riff.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"ee82540f026662197f7003474fd92de2\";}s:36:\"wp-includes/ID3/module.audio.ac3.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"e81c4500fb4c3b224fd2f9a78ba66427\";}s:36:\"wp-includes/ID3/module.audio.dts.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"f3ea566007c94c03372eb6f46c5d2001\";}s:37:\"wp-includes/ID3/module.audio.flac.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"055003ea7c0388fd73107113d3ed3bc3\";}s:36:\"wp-includes/ID3/module.audio.mp3.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"eb87257b2f0507f4ac5591d4226dfc86\";}s:36:\"wp-includes/ID3/module.audio.ogg.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"7bdc813a7fa95feceed4f6d4b37d3c97\";}s:37:\"wp-includes/ID3/module.tag.apetag.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"346c8c1b97caecba5592a91452fa3949\";}s:36:\"wp-includes/ID3/module.tag.id3v1.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"2b368be9e19051d00cac0e67341d051d\";}s:36:\"wp-includes/ID3/module.tag.id3v2.php\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"f26306a3858ad4074679d94f2aeead4e\";}s:38:\"wp-includes/ID3/module.tag.lyrics3.php\";a:2:{s:1:\"d\";i:1487282358;s:1:\"h\";s:32:\"1255f9fb3380ba93dd223981b21832ed\";}s:26:\"wp-includes/ID3/readme.txt\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"9396dfe1c69c938eb17f564c4e5bab18\";}s:28:\"wp-includes/images/blank.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"48bb2baaf4353109f7c2665d96aa390b\";}s:38:\"wp-includes/images/crystal/license.txt\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"f05db54c63e36918479b6651930dcfe7\";}s:36:\"wp-includes/images/down_arrow-2x.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"a073b8a1ee9b2482017f3628da40a861\";}s:33:\"wp-includes/images/down_arrow.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"65dcc85d3a75ff5776fbe3df0122b7e2\";}s:41:\"wp-includes/images/smilies/icon_arrow.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"bfcab5090b1280bbe495dbead4d2281f\";}s:43:\"wp-includes/images/smilies/icon_biggrin.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"c7597052fe2b16db307d6bd14e7b8c6b\";}s:44:\"wp-includes/images/smilies/icon_confused.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"7fefa473594650055a36b9e3062c9a91\";}s:40:\"wp-includes/images/smilies/icon_cool.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"96467eb5ae18dfa22ea1c0fa3e74380e\";}s:39:\"wp-includes/images/smilies/icon_cry.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"453e7a3f8bbb417008f06d576c41d060\";}s:39:\"wp-includes/images/smilies/icon_eek.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"a6c65fa6ff738ef6c46a4e80a65f7aa0\";}s:40:\"wp-includes/images/smilies/icon_evil.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"63bf101bd3d4f7564d3cf31822218d2e\";}s:43:\"wp-includes/images/smilies/icon_exclaim.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"5ce371458c1a2148595f5f3daf7b5fc8\";}s:40:\"wp-includes/images/smilies/icon_idea.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"bdb3226d2568b8c1edf8f453b1e872e6\";}s:39:\"wp-includes/images/smilies/icon_lol.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"d4f04dc65a387ca9b8c0f22ca8c0ec8c\";}s:39:\"wp-includes/images/smilies/icon_mad.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"d7be08b669651a63080cfe7b9004d330\";}s:43:\"wp-includes/images/smilies/icon_mrgreen.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"fde9e44a8aae0e89bd527792b4779aca\";}s:43:\"wp-includes/images/smilies/icon_neutral.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"8a95dbfaa99809b0150687ae0cb45aed\";}s:44:\"wp-includes/images/smilies/icon_question.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"d22775b2e32645907141f788c36d4e9d\";}s:40:\"wp-includes/images/smilies/icon_razz.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"17cbe5cbade2b4ec3d85be4ac9409add\";}s:43:\"wp-includes/images/smilies/icon_redface.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"1c6d8b101c821641f983175221346112\";}s:44:\"wp-includes/images/smilies/icon_rolleyes.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"afc8bbc65fcbd2b82a3e2c1ab41a216a\";}s:39:\"wp-includes/images/smilies/icon_sad.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"1a273db3c34f6afb3fed75417ca5e7b6\";}s:41:\"wp-includes/images/smilies/icon_smile.gif\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"b2984729c3b6cdc07508b88b5c0a4d1e\";}s:45:\"wp-includes/images/smilies/icon_surprised.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"299972b5cdd1f1e0690dd95e4038bd87\";}s:43:\"wp-includes/images/smilies/icon_twisted.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"62abd50ca92eb2381a7c60e351f64c46\";}s:40:\"wp-includes/images/smilies/icon_wink.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"d01a4f87055ac0fce8a66739d80434ba\";}s:33:\"wp-includes/images/spinner-2x.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"5c1371bcb4392968647852a9c9df5d6c\";}s:30:\"wp-includes/images/spinner.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"b0a3dde331637e27aa6476d476481871\";}s:32:\"wp-includes/images/wpspin-2x.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"7def33aad959cd289d49ddf2a41f076d\";}s:29:\"wp-includes/images/wpspin.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"dd4e6dd268a70ce4c1c5143b1a4092dd\";}s:29:\"wp-includes/images/xit-2x.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"8fb0729c541cbdc4609faf3f4ad02fc7\";}s:26:\"wp-includes/images/xit.gif\";a:2:{s:1:\"d\";i:1487282359;s:1:\"h\";s:32:\"e5012902a358fbb96031acdcf048d7ca\";}s:36:\"wp-includes/IXR/class-IXR-base64.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"ee2a36d606d508af44b654e6176599bb\";}s:36:\"wp-includes/IXR/class-IXR-client.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"51c4a34bce41cfb25dda8e75850e5951\";}s:45:\"wp-includes/IXR/class-IXR-clientmulticall.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"af10903340b8ebc353a5050a5face990\";}s:34:\"wp-includes/IXR/class-IXR-date.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"8aca0e3dff273d632ed8a7861ca16967\";}s:35:\"wp-includes/IXR/class-IXR-error.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"673622ac95ed755c2733bcb2ad9c628a\";}s:49:\"wp-includes/IXR/class-IXR-introspectionserver.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"325561be77e43cf849779170864f372d\";}s:37:\"wp-includes/IXR/class-IXR-message.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"772ab67bccb0682544ab0b6d72f4122c\";}s:37:\"wp-includes/IXR/class-IXR-request.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"25702e3c8d53c7a1ea99d47a31cfa204\";}s:36:\"wp-includes/IXR/class-IXR-server.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"91f377af5c147854983e9fca3aa7ff19\";}s:35:\"wp-includes/IXR/class-IXR-value.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"03929d66fb3ea8356ccdf86a0066e80c\";}s:27:\"wp-includes/js/admin-bar.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"d97a1899a7f641e693928f5a47c33de4\";}s:31:\"wp-includes/js/admin-bar.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"b2e733f0c117e30ac8974dcc69ab11d8\";}s:26:\"wp-includes/js/autosave.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"6cfac42246a04c9f37f0a0e5f0474ee4\";}s:30:\"wp-includes/js/autosave.min.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"c2366b7de7027d09661ecdde0c8d1025\";}s:30:\"wp-includes/js/backbone.min.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"9263ddbe52f85e7be13301ac26889c8e\";}s:29:\"wp-includes/js/colorpicker.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"f01017ca562067f4840eb2b6f99f2daf\";}s:33:\"wp-includes/js/colorpicker.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"e186209dc41a59f2fb627c24e640712d\";}s:31:\"wp-includes/js/comment-reply.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"14eac74ea4d8aeca08e8ef8d54d42600\";}s:35:\"wp-includes/js/comment-reply.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"56bc2726d829207bfa802f957aac0791\";}s:31:\"wp-includes/js/crop/cropper.css\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"6b79350bf46e0f692a4d1b2807ed0399\";}s:30:\"wp-includes/js/crop/cropper.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"1d97b296d918482e1273c56fbff6a8e2\";}s:36:\"wp-includes/js/crop/marqueeHoriz.gif\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"8cccae9c1ebafdb83be602e4d44c6f0a\";}s:35:\"wp-includes/js/crop/marqueeVert.gif\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"ae9accf100a4b9930639adff52d4dcc7\";}s:32:\"wp-includes/js/customize-base.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"8cade945b4a89d043762f80bcaed87aa\";}s:36:\"wp-includes/js/customize-base.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"1204a65bdca9b53b11e21b0a4006fed0\";}s:34:\"wp-includes/js/customize-loader.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"3735895ce4bc1061b033b00ddadc22de\";}s:38:\"wp-includes/js/customize-loader.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"07ffbac3f2ba98be80444078bf478e06\";}s:34:\"wp-includes/js/customize-models.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"3a799b747d1cc99f440ec4630a32e040\";}s:38:\"wp-includes/js/customize-models.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"e715ea6806c9fdb94aa4d56812dd0217\";}s:45:\"wp-includes/js/customize-preview-nav-menus.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"207399a4074c9ef066c5834c07e43f08\";}s:49:\"wp-includes/js/customize-preview-nav-menus.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"526952e7a87a339b276f5dcfc96c5176\";}s:43:\"wp-includes/js/customize-preview-widgets.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"436093edec320c9f9da76cee03deb3ac\";}s:47:\"wp-includes/js/customize-preview-widgets.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"5b40ade72a4e6add4ec2147a58859a4b\";}s:35:\"wp-includes/js/customize-preview.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"206c000a3d0c598ec471af58684f43e1\";}s:39:\"wp-includes/js/customize-preview.min.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"b9f62643c2bd209ffd28c665d16c7d3f\";}s:45:\"wp-includes/js/customize-selective-refresh.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"82eba93b7a9b05a56acfded2d3ce65e5\";}s:49:\"wp-includes/js/customize-selective-refresh.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"9f99120370b704e6c7d40f9a5705e823\";}s:33:\"wp-includes/js/customize-views.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"5abea7b6d9a2556fb8cbfcd3f8d1c0ff\";}s:37:\"wp-includes/js/customize-views.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"c5f0abb73e687faebc9bf225a1e0824e\";}s:27:\"wp-includes/js/heartbeat.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"4714400d54b96a2c380b245300a5be5a\";}s:31:\"wp-includes/js/heartbeat.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"126cc4d1e35b74edb525b06e3788e0f2\";}s:29:\"wp-includes/js/hoverIntent.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"cab3598b438a9e63984f1c6e9dd79b01\";}s:33:\"wp-includes/js/hoverIntent.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"ca500ade854c31417faf5762e31b9d00\";}s:34:\"wp-includes/js/imagesloaded.min.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"d0c2c0d7e37652e66657c8c8d6376442\";}s:46:\"wp-includes/js/imgareaselect/border-anim-h.gif\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"5ac3c42cc86e745a5e36b67b4c70a134\";}s:46:\"wp-includes/js/imgareaselect/border-anim-v.gif\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"20c97a21993cf137ead9fdbecbc42aa8\";}s:46:\"wp-includes/js/imgareaselect/imgareaselect.css\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"7d28cad92829b3d633a087b5f3b595af\";}s:52:\"wp-includes/js/imgareaselect/jquery.imgareaselect.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"7a0e1bfc429252530cfb8318f53a5986\";}s:56:\"wp-includes/js/imgareaselect/jquery.imgareaselect.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"25f42e049e65ee16d442799755724025\";}s:30:\"wp-includes/js/jcrop/Jcrop.gif\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"5a8bfd37651305bdafbcf2cd51b0254b\";}s:41:\"wp-includes/js/jcrop/jquery.Jcrop.min.css\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"56cc9ea201dc2f4b910e78bfacac9211\";}s:40:\"wp-includes/js/jcrop/jquery.Jcrop.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"2f61ab984c177275c71e34ff1a17c102\";}s:39:\"wp-includes/js/jquery/jquery-migrate.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"6c57b762589f13ea5b3579ca5e6c369b\";}s:43:\"wp-includes/js/jquery/jquery-migrate.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"7121994eec5320fbe6586463bf9651c2\";}s:41:\"wp-includes/js/jquery/jquery.color.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"ff2db8dbf145ce47f31781eef33e764a\";}s:36:\"wp-includes/js/jquery/jquery.form.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"e5afd8e41d2ec22c19932b068cd90a71\";}s:40:\"wp-includes/js/jquery/jquery.form.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"dbc3808473def00fce45fe564dc72dcb\";}s:39:\"wp-includes/js/jquery/jquery.hotkeys.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"e29483a8ca26a0dd8b0d1146c6b0a6e9\";}s:43:\"wp-includes/js/jquery/jquery.hotkeys.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"e353217d4555ab5c62b367be6889813d\";}s:31:\"wp-includes/js/jquery/jquery.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"8610f03fe77640dee8c4cc924e060f12\";}s:43:\"wp-includes/js/jquery/jquery.masonry.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"cd0eb3406096ff80266e7c9d7d419186\";}s:37:\"wp-includes/js/jquery/jquery.query.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"3bcc587af2c7b01fc6fbc9c077050143\";}s:40:\"wp-includes/js/jquery/jquery.schedule.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"0426b39754aa6bc766d89ea4c41bbd06\";}s:48:\"wp-includes/js/jquery/jquery.serialize-object.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"d15c29a18d9ffa8b9b4ae86c3c0cfa22\";}s:45:\"wp-includes/js/jquery/jquery.table-hotkeys.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"a706ead694231e74fd6750b1670580a5\";}s:49:\"wp-includes/js/jquery/jquery.table-hotkeys.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"e56f81676f199db7bf937e69a64909fa\";}s:46:\"wp-includes/js/jquery/jquery.ui.touch-punch.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"4cc86d1003c45134d6838f13e3885db1\";}s:32:\"wp-includes/js/jquery/suggest.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"3a2474569145d51ecabf7fc4fb078982\";}s:36:\"wp-includes/js/jquery/suggest.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"7311075c2b411b299c94e36e2e3bab89\";}s:41:\"wp-includes/js/jquery/ui/accordion.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"334c2ffb0b086ffc0f6f192ea120f3c2\";}s:44:\"wp-includes/js/jquery/ui/autocomplete.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"d0ff3eba6258651773c3a5cc909efde6\";}s:38:\"wp-includes/js/jquery/ui/button.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"2ce99e1ed08df351e6a58eb4b6bcbfa9\";}s:36:\"wp-includes/js/jquery/ui/core.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"9ce4e157448487d4efe0ca538f656a71\";}s:42:\"wp-includes/js/jquery/ui/datepicker.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"cfb63dc18fde53fef4d4fdc19ddfdcd6\";}s:38:\"wp-includes/js/jquery/ui/dialog.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"3ecd9590aac778514f4e69975ed91a62\";}s:41:\"wp-includes/js/jquery/ui/draggable.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"443c277789baf69c490019d59c1b36ed\";}s:41:\"wp-includes/js/jquery/ui/droppable.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"debf5224c4162887d1a6e3198ed953d8\";}s:44:\"wp-includes/js/jquery/ui/effect-blind.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"addbe09f173c4f1bd86d41ac5f3b4f4c\";}s:45:\"wp-includes/js/jquery/ui/effect-bounce.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"4bc4c97924bea4bf7b04d7b46ff4f64c\";}s:43:\"wp-includes/js/jquery/ui/effect-clip.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"c7939457e8ab231b951713475a056173\";}s:43:\"wp-includes/js/jquery/ui/effect-drop.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"57fe560887cac7a5b2598188463290e8\";}s:46:\"wp-includes/js/jquery/ui/effect-explode.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"c0df625cca418cfd803a11514a3dd1e6\";}s:43:\"wp-includes/js/jquery/ui/effect-fade.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"9f6fd64f4f5ff5893b7b72a235246d0c\";}s:43:\"wp-includes/js/jquery/ui/effect-fold.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"8d365ec1b3a7ee82f93c9afd441e456c\";}s:48:\"wp-includes/js/jquery/ui/effect-highlight.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"95e8ebe62adf187fb4c3b84eb5bef821\";}s:43:\"wp-includes/js/jquery/ui/effect-puff.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"fe496d6c9d63bc47854084c8b3fc20d6\";}s:46:\"wp-includes/js/jquery/ui/effect-pulsate.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"bf836f20530440115a2a8487ca7021c5\";}s:44:\"wp-includes/js/jquery/ui/effect-scale.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"d57d0830652c29c3e0e301b02b6db754\";}s:44:\"wp-includes/js/jquery/ui/effect-shake.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"260cbafcbcedc23348a371cb80083112\";}s:43:\"wp-includes/js/jquery/ui/effect-size.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"b00e3dfd6eebccd5ea9aeb3293d85a25\";}s:44:\"wp-includes/js/jquery/ui/effect-slide.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"fa23475fb01c8f4d56da98ca0c1179b5\";}s:47:\"wp-includes/js/jquery/ui/effect-transfer.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"07e5b0dea800777dd2108788b56ef90b\";}s:38:\"wp-includes/js/jquery/ui/effect.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"3f7161cf139d5a2c5e6d34e1c0026f9d\";}s:36:\"wp-includes/js/jquery/ui/menu.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"c91cfff50715441295fe7463bb5d3894\";}s:37:\"wp-includes/js/jquery/ui/mouse.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"82835a8960ddd73020389dbfa45c39a0\";}s:40:\"wp-includes/js/jquery/ui/position.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"1c4a13edec1958817e83433aeaa42f62\";}s:43:\"wp-includes/js/jquery/ui/progressbar.min.js\";a:2:{s:1:\"d\";i:1487282344;s:1:\"h\";s:32:\"b94d71da54d9b4413ffa4c7d792269c5\";}s:41:\"wp-includes/js/jquery/ui/resizable.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"a5001032177c492cf0ff7c86bc01169f\";}s:42:\"wp-includes/js/jquery/ui/selectable.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"b632add191ecae92e6a7b6b97212a640\";}s:42:\"wp-includes/js/jquery/ui/selectmenu.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"cb7db4cbaa328e395a680c78692236f0\";}s:38:\"wp-includes/js/jquery/ui/slider.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"9408efe2ce5a6b4364f34cbda02f814b\";}s:40:\"wp-includes/js/jquery/ui/sortable.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"2896e90cc17e9abc160ed96bb86b07e3\";}s:39:\"wp-includes/js/jquery/ui/spinner.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"3acf32da612bf35221c09394856591dc\";}s:36:\"wp-includes/js/jquery/ui/tabs.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"5330c83425ab1b8f67ce63f741427adb\";}s:39:\"wp-includes/js/jquery/ui/tooltip.min.js\";a:2:{s:1:\"d\";i:1487282346;s:1:\"h\";s:32:\"443f68690d84eee42cf3019071340730\";}s:38:\"wp-includes/js/jquery/ui/widget.min.js\";a:2:{s:1:\"d\";i:1487282345;s:1:\"h\";s:32:\"8cf7f36bbd79bc0664b6113f7a7837fe\";}s:23:\"wp-includes/js/json2.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"73a1d77b4e827c45061f4fab041030a9\";}s:27:\"wp-includes/js/json2.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"35d899a81986173f44f9bbe686cc583c\";}s:29:\"wp-includes/js/masonry.min.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"5420b6516c14245b504e7240a8310f2c\";}s:26:\"wp-includes/js/mce-view.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"134875901c4aeec9dd4d791828e635a1\";}s:30:\"wp-includes/js/mce-view.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"26a64b5857f1fa98167856ac39b0a268\";}s:34:\"wp-includes/js/media-audiovideo.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"f256503caa6bc23b44c82e3f46b6b23b\";}s:38:\"wp-includes/js/media-audiovideo.min.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"f093100d539f03b5d1d31f1e74029b44\";}s:30:\"wp-includes/js/media-editor.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"4c69a1599bd6868a31cd43b7f899964d\";}s:34:\"wp-includes/js/media-editor.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"79cf51bae2593b7ac27b73789e43646d\";}s:28:\"wp-includes/js/media-grid.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"846bbf2e3acc156ce4d6deb772c703b3\";}s:32:\"wp-includes/js/media-grid.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"76fe68861654653491ec8a68ceb2da4c\";}s:30:\"wp-includes/js/media-models.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"9dbd7395fac0f6f1065bd5231d14941f\";}s:34:\"wp-includes/js/media-models.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"eed9813bad592d4287be0eb0ebb68497\";}s:29:\"wp-includes/js/media-views.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"6fad095c6f295131844afbfb089956d3\";}s:33:\"wp-includes/js/media-views.min.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"e501be91f82cbda570582d00ce43c054\";}s:39:\"wp-includes/js/mediaelement/bigplay.svg\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"746c3af7a145a09239a36e5ef61cfea0\";}s:40:\"wp-includes/js/mediaelement/controls.svg\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"40f56f5a736da4effeb790cedb8a52f0\";}s:49:\"wp-includes/js/mediaelement/flashmediaelement.swf\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"2efe1fabfea04432f090ecb3153b10a1\";}s:45:\"wp-includes/js/mediaelement/froogaloop.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"2a8742c0ac1cdbec23be44a7d4e9a3c9\";}s:39:\"wp-includes/js/mediaelement/loading.gif\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"76b326f4d44222126fee21076595bef5\";}s:58:\"wp-includes/js/mediaelement/mediaelement-and-player.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"8970e6e672a1d312c8d8ef471ffb7d5f\";}s:54:\"wp-includes/js/mediaelement/mediaelementplayer.min.css\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"0687e33e84a860c33a3a885193a6d937\";}s:55:\"wp-includes/js/mediaelement/silverlightmediaelement.xap\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"d0e44fd6ecebca46f36d734b3012aa2c\";}s:47:\"wp-includes/js/mediaelement/wp-mediaelement.css\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"00f8eb37d4873aff33559be1ab3a5da0\";}s:46:\"wp-includes/js/mediaelement/wp-mediaelement.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"1d889c99f04a39573d4be5b346c6272f\";}s:51:\"wp-includes/js/mediaelement/wp-mediaelement.min.css\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"74ca084f6791af45527be4b531909512\";}s:50:\"wp-includes/js/mediaelement/wp-mediaelement.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"8e7a4405d35139f62871a539516679a1\";}s:42:\"wp-includes/js/mediaelement/wp-playlist.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"aaf77f7481f419f5f8c46ae338820443\";}s:46:\"wp-includes/js/mediaelement/wp-playlist.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"264563e94e2d16b1066bd413ebc592de\";}s:35:\"wp-includes/js/plupload/handlers.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"06e4d64e099466eaa3185f1850884821\";}s:39:\"wp-includes/js/plupload/handlers.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"3ea40ab7c27b75d20c3da22f097d6614\";}s:35:\"wp-includes/js/plupload/license.txt\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"751419260aa954499f7abaabaa882bbe\";}s:42:\"wp-includes/js/plupload/plupload.flash.swf\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"370d768e45524f47fbd2988974d3d76c\";}s:44:\"wp-includes/js/plupload/plupload.full.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"4a431fb4049b24566d27c12e2793d818\";}s:48:\"wp-includes/js/plupload/plupload.silverlight.xap\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"747100c185cf33f6588930a5941d62f7\";}s:38:\"wp-includes/js/plupload/wp-plupload.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"2b6f0cc54e381fd52f3a3726e09c1d07\";}s:42:\"wp-includes/js/plupload/wp-plupload.min.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"7c74a0f866c5dfd1dc9a45474651f6ef\";}s:27:\"wp-includes/js/quicktags.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"481e904dd706f51af4bf2faa4070165b\";}s:31:\"wp-includes/js/quicktags.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"6a365c2fcd52566ae9fd3db9a28c673d\";}s:27:\"wp-includes/js/shortcode.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"fc8cb580e0edc5cda1a550747d0de6c9\";}s:31:\"wp-includes/js/shortcode.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"b342d56a90b09adfad6d95a4717c0b24\";}s:27:\"wp-includes/js/swfobject.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"9ffdba2cff497d701684657e329871f5\";}s:36:\"wp-includes/js/swfupload/handlers.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"14b2d04fdb85bc1f171cf3dfb2987dca\";}s:40:\"wp-includes/js/swfupload/handlers.min.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"96592c6b3fad580ce04e12bc3047ef3b\";}s:36:\"wp-includes/js/swfupload/license.txt\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"cbe05bb060c85e07882dc06ff751577a\";}s:53:\"wp-includes/js/swfupload/plugins/swfupload.cookies.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"7fa57ec00dda88dd6b5c2037ccb4d5cf\";}s:51:\"wp-includes/js/swfupload/plugins/swfupload.queue.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"9953522fbd4a1b02bbf635a92d76cd8f\";}s:51:\"wp-includes/js/swfupload/plugins/swfupload.speed.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"415a3787846bb6c2d745602c2afb73ac\";}s:55:\"wp-includes/js/swfupload/plugins/swfupload.swfobject.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"ccb51571a75637db08545caaf2ed9e73\";}s:37:\"wp-includes/js/swfupload/swfupload.js\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"6cd370bfd4d86c44ac155fd913e971ac\";}s:38:\"wp-includes/js/swfupload/swfupload.swf\";a:2:{s:1:\"d\";i:1487282347;s:1:\"h\";s:32:\"bd5a25f23589652ca472d41fe1484f0c\";}s:44:\"wp-includes/js/thickbox/loadingAnimation.gif\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"ce2268030dd2151b63cdf4ffc2f626ba\";}s:36:\"wp-includes/js/thickbox/thickbox.css\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"805aa150a391e44e3245f25ea83bdfcb\";}s:35:\"wp-includes/js/thickbox/thickbox.js\";a:2:{s:1:\"d\";i:1487282343;s:1:\"h\";s:32:\"d5d248a8730754587b4224c2d9ad36c7\";}s:43:\"wp-includes/js/tinymce/langs/wp-langs-en.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"08f8669f7453b17563a62e6bbb376137\";}s:34:\"wp-includes/js/tinymce/license.txt\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"045d04e17422d99e338da75b9c749b7c\";}s:48:\"wp-includes/js/tinymce/plugins/charmap/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"d995aeaef8197c23cb1e14e3a479bc00\";}s:52:\"wp-includes/js/tinymce/plugins/charmap/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"bc5a8cc213bb3fe51b5673b64dd9d408\";}s:52:\"wp-includes/js/tinymce/plugins/colorpicker/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"22538c49f524050bd8300b44526abc2a\";}s:56:\"wp-includes/js/tinymce/plugins/colorpicker/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"1581bb02286f54b4fb0cce52d2ef61c7\";}s:54:\"wp-includes/js/tinymce/plugins/compat3x/css/dialog.css\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"e5313168fb2b657a4bd2f5e06b931a22\";}s:49:\"wp-includes/js/tinymce/plugins/compat3x/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"5210cc9135346dcc15c9258eae55868a\";}s:53:\"wp-includes/js/tinymce/plugins/compat3x/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"5798e3d2fb0180a9179b8bd7cf728eae\";}s:55:\"wp-includes/js/tinymce/plugins/directionality/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"5f21385b1f4513568d611d595040d141\";}s:59:\"wp-includes/js/tinymce/plugins/directionality/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"60de57253ca9143a6f1e4aff10fc39d2\";}s:51:\"wp-includes/js/tinymce/plugins/fullscreen/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"ae983b9a7a8d0ad43cad5ef5ad85c1ab\";}s:55:\"wp-includes/js/tinymce/plugins/fullscreen/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"ba1ad4bc43e2aa43661307a5599b48c5\";}s:43:\"wp-includes/js/tinymce/plugins/hr/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"428c9fb47a7b83fa0440a15886d0b11a\";}s:47:\"wp-includes/js/tinymce/plugins/hr/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"5c23255ad2d11db3f72c33b649f1389a\";}s:46:\"wp-includes/js/tinymce/plugins/image/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"4584af9ba8c439604e4199168176a7b7\";}s:50:\"wp-includes/js/tinymce/plugins/image/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"55065b4d900692d4308d97e79a0fa023\";}s:46:\"wp-includes/js/tinymce/plugins/lists/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"ebb03e951bb87f4aa69a1328da082522\";}s:50:\"wp-includes/js/tinymce/plugins/lists/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"c5646744ede702b668fb314569b37a51\";}s:52:\"wp-includes/js/tinymce/plugins/media/moxieplayer.swf\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"4e59d34efb2da0b9a033596a85e4b1ef\";}s:46:\"wp-includes/js/tinymce/plugins/media/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"0966da48749b6e089014a3782c329999\";}s:50:\"wp-includes/js/tinymce/plugins/media/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"b15b0fedf40436964822d4c225e36bdb\";}s:46:\"wp-includes/js/tinymce/plugins/paste/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"6a65f345c92e1b3b2c52e323a739a03f\";}s:50:\"wp-includes/js/tinymce/plugins/paste/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"69a65927466dab834f5d48c28c8c23bb\";}s:49:\"wp-includes/js/tinymce/plugins/tabfocus/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"6a5d784c2ac2ce5f64e0968c35492f03\";}s:53:\"wp-includes/js/tinymce/plugins/tabfocus/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"f197cd93b28210923e3590c4438eb896\";}s:50:\"wp-includes/js/tinymce/plugins/textcolor/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"5272a99516c467771ef3076422beb18f\";}s:54:\"wp-includes/js/tinymce/plugins/textcolor/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"68c99b9ceacf91b4e3c3b471ba349cf2\";}s:50:\"wp-includes/js/tinymce/plugins/wordpress/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"db762695fd5a8d769b6a6002451db2bc\";}s:54:\"wp-includes/js/tinymce/plugins/wordpress/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"20c2ac6dc65464192456606dae06eae4\";}s:53:\"wp-includes/js/tinymce/plugins/wpautoresize/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"640cbc0058638c4fb0400370dbcf25a3\";}s:57:\"wp-includes/js/tinymce/plugins/wpautoresize/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"8607e87dcbb351d067d1a54485e8a357\";}s:50:\"wp-includes/js/tinymce/plugins/wpdialogs/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"06f7aecb5bdfa28739eea0a498d15a81\";}s:54:\"wp-includes/js/tinymce/plugins/wpdialogs/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"eafbb1478981e337981d287474e240b8\";}s:52:\"wp-includes/js/tinymce/plugins/wpeditimage/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"4738b8261ae8b11da71d10be56c25807\";}s:56:\"wp-includes/js/tinymce/plugins/wpeditimage/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"eaa208851b66085620779cbf3d30fefb\";}s:48:\"wp-includes/js/tinymce/plugins/wpembed/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"cf382af5522fa9a0bb3f049225de14ef\";}s:52:\"wp-includes/js/tinymce/plugins/wpembed/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"7ec45bcbe992c74c095a75bb2d2cf0ff\";}s:48:\"wp-includes/js/tinymce/plugins/wpemoji/plugin.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"f77a6131c150653ddfa17a568a1962d0\";}s:52:\"wp-includes/js/tinymce/plugins/wpemoji/plugin.min.js\";a:2:{s:1:\"d\";i:1487282349;s:1:\"h\";s:32:\"c6cc2ce4842cf34494b20855418ec7ee\";}s:50:\"wp-includes/js/tinymce/plugins/wpgallery/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"9d48345044e6111fbeb9d2fb444d5c49\";}s:54:\"wp-includes/js/tinymce/plugins/wpgallery/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"04fb37608ef94f9a747901b2f98b4fce\";}s:47:\"wp-includes/js/tinymce/plugins/wplink/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"5bd6d9dcdfa64309a4f474e3c103c87d\";}s:51:\"wp-includes/js/tinymce/plugins/wplink/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"9a65c6f6979ef70401b0b919b02e83ec\";}s:54:\"wp-includes/js/tinymce/plugins/wptextpattern/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"bbe31109bb4a2955ac73c0b0ac1e8d8c\";}s:58:\"wp-includes/js/tinymce/plugins/wptextpattern/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"a92e4569e92450776f18e0bb6ddae1b1\";}s:47:\"wp-includes/js/tinymce/plugins/wpview/plugin.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"273623256ba39ea22d7706e94fa7a706\";}s:51:\"wp-includes/js/tinymce/plugins/wpview/plugin.min.js\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"36cbcbb2f625bb726dfccd3f5b47f253\";}s:61:\"wp-includes/js/tinymce/skins/lightgray/content.inline.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"9651c10838a77fb4cca900b47d9d331c\";}s:54:\"wp-includes/js/tinymce/skins/lightgray/content.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"a1207b432127ddc0c383acfb711b5a78\";}s:54:\"wp-includes/js/tinymce/skins/lightgray/fonts/readme.md\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"7a0f64800cf38b2be8d3dc4540ec31dd\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.eot\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"12d26c285b71d790f4b0c94423ef1f99\";}s:63:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.json\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"fcf1ab0bbad7d5be115cac9ffb360a2b\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.svg\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"a2a1f732cc34764c684ed521c6f3327c\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.ttf\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"28806940c647cf671bebf4ae0630e570\";}s:63:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.woff\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"7e0c88f02dcaf2f78c90b4dc7827b709\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.eot\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"240310067afb33df60639d7fd1fa132e\";}s:57:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.json\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"899efe22d79dd0d675c106a242e18858\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.svg\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"ede808f6f04604681b25f843069de379\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.ttf\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"1fb250c3b9bc34fd53cd883070e3dffd\";}s:57:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.woff\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"6b0c3754b1cd1f90566e174098fae8f8\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/anchor.gif\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"abd3613571800fdcc891181d5f34f840\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/loader.gif\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"394bafc3cc4dfb3a0ee48c1f54669539\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/object.gif\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"f3726450d7457d750a2f4d9441c7ee20\";}s:52:\"wp-includes/js/tinymce/skins/lightgray/img/trans.gif\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"12bf9e19374920de3146a64775f46a5e\";}s:55:\"wp-includes/js/tinymce/skins/lightgray/skin.ie7.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"1ab68a0c95f250189323b986a707f70a\";}s:51:\"wp-includes/js/tinymce/skins/lightgray/skin.min.css\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"365dc556b970abfe2840e817186cdf42\";}s:53:\"wp-includes/js/tinymce/skins/wordpress/wp-content.css\";a:2:{s:1:\"d\";i:1487282350;s:1:\"h\";s:32:\"78532b5f1feda917ca31dc124122036a\";}s:45:\"wp-includes/js/tinymce/themes/inlite/theme.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"fb14698a360d5a3d7857397104fc556c\";}s:49:\"wp-includes/js/tinymce/themes/inlite/theme.min.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"cc88f336999397d383b5fa434294a258\";}s:45:\"wp-includes/js/tinymce/themes/modern/theme.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"d502a6ac28bb48a7d91a89ba9b5710c0\";}s:49:\"wp-includes/js/tinymce/themes/modern/theme.min.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"e3b7cec28cad5caa5fcbcc2a15cebae7\";}s:37:\"wp-includes/js/tinymce/tinymce.min.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"bb16520a021ae170a7019675f2f5f81f\";}s:40:\"wp-includes/js/tinymce/tiny_mce_popup.js\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"dbe62082422b75d89ecb983409ec966d\";}s:48:\"wp-includes/js/tinymce/utils/editable_selects.js\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"eb642a0aba7a8666a7b1472230fcb374\";}s:42:\"wp-includes/js/tinymce/utils/form_utils.js\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"f9c61354383f5a50a9a77b902dfdae7f\";}s:38:\"wp-includes/js/tinymce/utils/mctabs.js\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"b9b50ddbe07c754a6b656b0fdada3500\";}s:40:\"wp-includes/js/tinymce/utils/validate.js\";a:2:{s:1:\"d\";i:1487282351;s:1:\"h\";s:32:\"c42b5160bdbefd1293d76b30520757f4\";}s:39:\"wp-includes/js/tinymce/wp-tinymce.js.gz\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"9b37eea472171dbe52aceb909b81c292\";}s:37:\"wp-includes/js/tinymce/wp-tinymce.php\";a:2:{s:1:\"d\";i:1487282348;s:1:\"h\";s:32:\"8a620ab81dc7307f7072b1d312924876\";}s:25:\"wp-includes/js/tw-sack.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"b989a5bd84f6ebcbc1393ec003e6e991\";}s:29:\"wp-includes/js/tw-sack.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"bc4487194e1f88126b8a500ad47e6889\";}s:25:\"wp-includes/js/twemoji.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"be2f6b80d0307857a83d0b17b9f24d2d\";}s:29:\"wp-includes/js/twemoji.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"467ef54bff10851a04064eebc9837d52\";}s:32:\"wp-includes/js/underscore.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"6a3a434a1360cc744341e97de9177bc6\";}s:23:\"wp-includes/js/utils.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"19ea0da213eda9c7bc4360f1d4c18b3c\";}s:27:\"wp-includes/js/utils.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"f6e3d57217de41fa3243331155452bb1\";}s:25:\"wp-includes/js/wp-a11y.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"201a720227378280081f67809d781ab2\";}s:29:\"wp-includes/js/wp-a11y.min.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"fadd746cdddaafb9978cbab2e4e4580f\";}s:34:\"wp-includes/js/wp-ajax-response.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"c404d2ebab29a76e5a4eef0a23c3eb10\";}s:38:\"wp-includes/js/wp-ajax-response.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"d37497d8ac9cc91eacc91b76cbff30cc\";}s:24:\"wp-includes/js/wp-api.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"4cca1500e61bd40abe7b543fd76a5a06\";}s:28:\"wp-includes/js/wp-api.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"146b14e8c7935d8bd14eb521fb616a5e\";}s:31:\"wp-includes/js/wp-auth-check.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"99500dd54adc76769e1a798a9725d765\";}s:35:\"wp-includes/js/wp-auth-check.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"99c97a7d6ad9e1ba06bbd76f29ecaad6\";}s:29:\"wp-includes/js/wp-backbone.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"ff08a91eba7f4fb95be7d5eb4a072d76\";}s:33:\"wp-includes/js/wp-backbone.min.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"b978d3c20a25ca1d36c1688c298c8239\";}s:34:\"wp-includes/js/wp-custom-header.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"6e62551d535dc3b007870e89f881ee21\";}s:38:\"wp-includes/js/wp-custom-header.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"802bee0e5f600483e0247f59b3b329b4\";}s:35:\"wp-includes/js/wp-embed-template.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"d6c3fb049f657928eac2cd9c7eef6925\";}s:39:\"wp-includes/js/wp-embed-template.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"c05d678a8197a72c4a44bf540017278a\";}s:26:\"wp-includes/js/wp-embed.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"b8d94a6648c7a70c0496257bb2699599\";}s:30:\"wp-includes/js/wp-embed.min.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"5a03f97cc479b9f5d7efdaccec31bc17\";}s:33:\"wp-includes/js/wp-emoji-loader.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"1e34797cb4169e053e6d526294921d66\";}s:37:\"wp-includes/js/wp-emoji-loader.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"f3ec21904cc0cf5d899f29e35b0b4612\";}s:38:\"wp-includes/js/wp-emoji-release.min.js\";a:2:{s:1:\"d\";i:1487282339;s:1:\"h\";s:32:\"cb6284b70da03a43468244be7eafa362\";}s:26:\"wp-includes/js/wp-emoji.js\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"ddc49ad0e4b146cc8ff73d976f1298bb\";}s:30:\"wp-includes/js/wp-emoji.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"1acdd0cd523695bd920ccc418b0678c9\";}s:35:\"wp-includes/js/wp-list-revisions.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"47510d7560d22a974c8c0eec6e24bcbd\";}s:39:\"wp-includes/js/wp-list-revisions.min.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"d252f431d400b696e25ca9fec9a1113e\";}s:26:\"wp-includes/js/wp-lists.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"a3ad4f080bd61da2b9f2f9390b1533d1\";}s:30:\"wp-includes/js/wp-lists.min.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"7df18b42cbd5cbaa5067c06f57aa876b\";}s:28:\"wp-includes/js/wp-pointer.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"35cb8b380bbd1f2eaa723ac49ba5f3f0\";}s:32:\"wp-includes/js/wp-pointer.min.js\";a:2:{s:1:\"d\";i:1487282337;s:1:\"h\";s:32:\"368f987c644d70580097e48066c99082\";}s:25:\"wp-includes/js/wp-util.js\";a:2:{s:1:\"d\";i:1487282342;s:1:\"h\";s:32:\"91c322750bc80f1cacfd4f991e65a415\";}s:29:\"wp-includes/js/wp-util.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"83118aa939b5832dd4e1cad8b186012c\";}s:26:\"wp-includes/js/wpdialog.js\";a:2:{s:1:\"d\";i:1487282335;s:1:\"h\";s:32:\"72e8395fd44d4039009c5396888fa6ba\";}s:30:\"wp-includes/js/wpdialog.min.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"d22d9fa5bb00ba0667080da846c4a1be\";}s:24:\"wp-includes/js/wplink.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"f955840763cec05064af68c3505fc98a\";}s:28:\"wp-includes/js/wplink.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"59b4b46ffe146371aae9fcc50c7e1930\";}s:30:\"wp-includes/js/zxcvbn-async.js\";a:2:{s:1:\"d\";i:1487282341;s:1:\"h\";s:32:\"97a79e96a815b200139356055d752333\";}s:34:\"wp-includes/js/zxcvbn-async.min.js\";a:2:{s:1:\"d\";i:1487282336;s:1:\"h\";s:32:\"3196e9b61f703909e139ce7e049a7ffd\";}s:28:\"wp-includes/js/zxcvbn.min.js\";a:2:{s:1:\"d\";i:1487282338;s:1:\"h\";s:32:\"a14cd5113bd0d57563c1a9b63cae05f8\";}s:20:\"wp-includes/kses.php\";a:2:{s:1:\"d\";i:1487282323;s:1:\"h\";s:32:\"a5b472304e6791a689898b353ca7ddc9\";}s:20:\"wp-includes/l10n.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"6864ccca7d1a1fd815f5442c76a4f73d\";}s:29:\"wp-includes/link-template.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"592aba670ddc2508b4e99c6693dbc349\";}s:20:\"wp-includes/load.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"c7f3d53d854b2c49b8d1bfe5a1b2ddf9\";}s:22:\"wp-includes/locale.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"5fac3f3e6e59e2ba781546e0e287f1ae\";}s:30:\"wp-includes/media-template.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"3463795b4d006436e0575cedea61466c\";}s:21:\"wp-includes/media.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"84d329546b9b16276296ee8f8d415823\";}s:20:\"wp-includes/meta.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"56da8783f7a3dacbc4b04c4d77867da3\";}s:24:\"wp-includes/ms-blogs.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"8f1f656221354c70cb9c3d62c2ee7228\";}s:36:\"wp-includes/ms-default-constants.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"b4e2d441bed3fd59246f9d8d4df76977\";}s:34:\"wp-includes/ms-default-filters.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"c566b5722ef34cdbe75cb0e89280c069\";}s:29:\"wp-includes/ms-deprecated.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"dcf0a4567768c74f2f5038ebee4967bc\";}s:24:\"wp-includes/ms-files.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"6e5192e9e3bfbebedc13c62db1f9a013\";}s:28:\"wp-includes/ms-functions.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"b46f2e627ed10ebacda5beb93d7848f6\";}s:23:\"wp-includes/ms-load.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"6ecee997dc34647439c978627cae4f3d\";}s:27:\"wp-includes/ms-settings.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"3fc17d4f9a78266e41cc6261e2e80188\";}s:33:\"wp-includes/nav-menu-template.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"7d76833acaa4d38be4160b0d0f060f38\";}s:24:\"wp-includes/nav-menu.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"1d006bde02be15163ed480fe389f4778\";}s:22:\"wp-includes/option.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"afbcb9f197a4a3acbece4273287fea66\";}s:36:\"wp-includes/pluggable-deprecated.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"e463b18764f9a900ccfe7eb7356a12c3\";}s:25:\"wp-includes/pluggable.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"18a082373f1134eaef2b2fd585786977\";}s:22:\"wp-includes/plugin.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"7af5db46a978ac913f8482108d4ec4a2\";}s:26:\"wp-includes/pomo/entry.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"ed9d811ef0cb13bdc0fa60b8314c8d61\";}s:23:\"wp-includes/pomo/mo.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"1ae9794ce9ca84552e5e7a332f168f65\";}s:23:\"wp-includes/pomo/po.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"0ad8053b19fc235615e1569b977c6fc6\";}s:28:\"wp-includes/pomo/streams.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"beac73a17cc41d2d138d3c69f1967080\";}s:33:\"wp-includes/pomo/translations.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"d1f31b54f938c2e5361a9542fdb55210\";}s:28:\"wp-includes/post-formats.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"824ae252f1d6934c172a51293e1bcfdd\";}s:29:\"wp-includes/post-template.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"c69b77baea896fd3ac4dcaa3ea6427a5\";}s:39:\"wp-includes/post-thumbnail-template.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"cd0d2fcf22d2d8a6e08ac3759ffd3bbc\";}s:20:\"wp-includes/post.php\";a:2:{s:1:\"d\";i:1487282320;s:1:\"h\";s:32:\"4f3da152abaac6c1456619a2d0796d17\";}s:21:\"wp-includes/query.php\";a:2:{s:1:\"d\";i:1487282328;s:1:\"h\";s:32:\"3186a59af5c093f04cdd8e3aba5c81df\";}s:47:\"wp-includes/random_compat/byte_safe_strings.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"fc75c18c95d974a9fdb1b101f66f7969\";}s:41:\"wp-includes/random_compat/cast_to_int.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"fa5f76745ac2d63b9466f130d35c7fb1\";}s:44:\"wp-includes/random_compat/error_polyfill.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"c25954e57e1ae32722fa6c840a55658c\";}s:36:\"wp-includes/random_compat/random.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"878595e91ef1477c8c315b085f73319a\";}s:53:\"wp-includes/random_compat/random_bytes_com_dotnet.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"1e6572bde34c56cbc47374721ce19ede\";}s:54:\"wp-includes/random_compat/random_bytes_dev_urandom.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"503c21cb3db02ded66e01ff8614468bc\";}s:52:\"wp-includes/random_compat/random_bytes_libsodium.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"818c88a4f866d417fadb7d1907f7ab3e\";}s:59:\"wp-includes/random_compat/random_bytes_libsodium_legacy.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"f47e469a9c2ddee526ca362c87e18551\";}s:49:\"wp-includes/random_compat/random_bytes_mcrypt.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"256cf4e9312f73c5806c8b291677d269\";}s:50:\"wp-includes/random_compat/random_bytes_openssl.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"b369564bffc76d82449527930b638dba\";}s:40:\"wp-includes/random_compat/random_int.php\";a:2:{s:1:\"d\";i:1487282365;s:1:\"h\";s:32:\"90e6daf85d6d0d6956692bd49033ed38\";}s:38:\"wp-includes/registration-functions.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"1c4b69ca4cd9b8538714b2483d0e5995\";}s:28:\"wp-includes/registration.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"d4f39e983366ea5c1b3fd4644b19ae06\";}s:35:\"wp-includes/Requests/Auth/Basic.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"67fdd878cc84df15093455d6096b2143\";}s:29:\"wp-includes/Requests/Auth.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"3197d2529dd957b2acc3944f5bfcd64a\";}s:35:\"wp-includes/Requests/Cookie/Jar.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"e9300c5fb1f52670a0b52234d95c9510\";}s:31:\"wp-includes/Requests/Cookie.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"d19d43afe99bc52881322b927960a4d3\";}s:43:\"wp-includes/Requests/Exception/HTTP/304.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"d33b4634ce4113db49ef9dddedf754ab\";}s:43:\"wp-includes/Requests/Exception/HTTP/305.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"58f8f700904bebe62f60a11c2cfbab26\";}s:43:\"wp-includes/Requests/Exception/HTTP/306.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"57737a071fa1754e50db6adcc9f25875\";}s:43:\"wp-includes/Requests/Exception/HTTP/400.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"51e56e878cbb564ab852c978fb35fcd0\";}s:43:\"wp-includes/Requests/Exception/HTTP/401.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"3b2ab80eb9cbfd87baa23fc1648e9940\";}s:43:\"wp-includes/Requests/Exception/HTTP/402.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"60f859d55150da0b0a7a959ac9f347d6\";}s:43:\"wp-includes/Requests/Exception/HTTP/403.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"bcd160e8f70dc76ffbbf6b33b7fe31df\";}s:43:\"wp-includes/Requests/Exception/HTTP/404.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"1ed416cc6311835900857973f8923c4d\";}s:43:\"wp-includes/Requests/Exception/HTTP/405.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"dd38d182de6d21b2d2ac18b381adf97f\";}s:43:\"wp-includes/Requests/Exception/HTTP/406.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"4bc8cb6cef688c729edc3990220006ac\";}s:43:\"wp-includes/Requests/Exception/HTTP/407.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"c2c817e9f5d8768bbde4d66a26e6c6b5\";}s:43:\"wp-includes/Requests/Exception/HTTP/408.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"403e3164844958c5144f98ecc8b77689\";}s:43:\"wp-includes/Requests/Exception/HTTP/409.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"995a1dc469e67e2a3d0b8f9bebfea9b6\";}s:43:\"wp-includes/Requests/Exception/HTTP/410.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"71be4f3437dfbadda52f38582184e19b\";}s:43:\"wp-includes/Requests/Exception/HTTP/411.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"27a552a1e4160c4df61b2eca5a604796\";}s:43:\"wp-includes/Requests/Exception/HTTP/412.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"25b88449dcb7a1a83dd906378aa556c7\";}s:43:\"wp-includes/Requests/Exception/HTTP/413.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"e9963cc15dc99059b7d9ff584c17bfd8\";}s:43:\"wp-includes/Requests/Exception/HTTP/414.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"bca65d55e2409ef6a5291ed8e6a12368\";}s:43:\"wp-includes/Requests/Exception/HTTP/415.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"0258cc0fb05462ea8f11ccaea34a55c3\";}s:43:\"wp-includes/Requests/Exception/HTTP/416.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"f931824e39e39617c9aac661804478f8\";}s:43:\"wp-includes/Requests/Exception/HTTP/417.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"4270026a1b8e684f5ec0635c47201c23\";}s:43:\"wp-includes/Requests/Exception/HTTP/418.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"4a21bae298f1c9feda5b0e93fe348af3\";}s:43:\"wp-includes/Requests/Exception/HTTP/428.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"9a97bb0369f70142e4e57da75eae742a\";}s:43:\"wp-includes/Requests/Exception/HTTP/429.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"53f0dd257c04462ec3a05a6485b38fcc\";}s:43:\"wp-includes/Requests/Exception/HTTP/431.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"e0e3737c622417ca08d5d1933c1489d9\";}s:43:\"wp-includes/Requests/Exception/HTTP/500.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"c0afa9c66b6d830a094815f2124dffda\";}s:43:\"wp-includes/Requests/Exception/HTTP/501.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"650cdab83034f22d3fe803f5d791a835\";}s:43:\"wp-includes/Requests/Exception/HTTP/502.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"7cc83a6c80cf7af9d5217b17fb47ff69\";}s:43:\"wp-includes/Requests/Exception/HTTP/503.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"3906f7520861c39f43f46000d45554b4\";}s:43:\"wp-includes/Requests/Exception/HTTP/504.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"02d76d8cccaa446293201112908a2aa5\";}s:43:\"wp-includes/Requests/Exception/HTTP/505.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"8e5d4109053303e65b2f4364c1ac12de\";}s:43:\"wp-includes/Requests/Exception/HTTP/511.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"03756e9a4e3c4b77f8d09bb9918fd140\";}s:47:\"wp-includes/Requests/Exception/HTTP/Unknown.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"da646c02e1ab81b632af41fbcf0a57ac\";}s:39:\"wp-includes/Requests/Exception/HTTP.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"e8d5fc68b3c6fa15e4526c161172dae5\";}s:49:\"wp-includes/Requests/Exception/Transport/cURL.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"853654cd672a1a9b3a09af077837dfe1\";}s:44:\"wp-includes/Requests/Exception/Transport.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"abbb6cf8da7ae8ea204a0118ab5ed101\";}s:34:\"wp-includes/Requests/Exception.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"879bac9efa180085ab33e90e1acc5249\";}s:31:\"wp-includes/Requests/Hooker.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"0f08c5401425a9615bd19e2f34a5e107\";}s:30:\"wp-includes/Requests/Hooks.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"2c15a0a520b9a8976778a169ceebd919\";}s:36:\"wp-includes/Requests/IDNAEncoder.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"d77dada232f0079b1412e0d050b4d8b1\";}s:29:\"wp-includes/Requests/IPv6.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"a5df4b884e8a07e81703f1ac6b6e54b1\";}s:28:\"wp-includes/Requests/IRI.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"183508325d839c7bf27db5f909600e58\";}s:35:\"wp-includes/Requests/Proxy/HTTP.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"ffd0e62f32db05bdbda6bca407d7f029\";}s:30:\"wp-includes/Requests/Proxy.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"b5406b1037b500d7d374b85c2a879947\";}s:41:\"wp-includes/Requests/Response/Headers.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"1ad7c382d2b68f19412da7f43e63a960\";}s:33:\"wp-includes/Requests/Response.php\";a:2:{s:1:\"d\";i:1487282360;s:1:\"h\";s:32:\"11ce7086bbb7ae52e6abb7c4fd270b47\";}s:32:\"wp-includes/Requests/Session.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"37f8cadd86fcbfce9602b5bcf67d6c8e\";}s:28:\"wp-includes/Requests/SSL.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"265067eb274136ac28be300b37540c4f\";}s:39:\"wp-includes/Requests/Transport/cURL.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"0ee4801d08da383712136160435ae0d1\";}s:44:\"wp-includes/Requests/Transport/fsockopen.php\";a:2:{s:1:\"d\";i:1487282362;s:1:\"h\";s:32:\"1d21ee4a4f60ad1afc48f118483fb73f\";}s:34:\"wp-includes/Requests/Transport.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"019c993bce6bed178baf4b5c566cc617\";}s:58:\"wp-includes/Requests/Utility/CaseInsensitiveDictionary.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"b5f03ac8c752b34b9e726f04d548327a\";}s:49:\"wp-includes/Requests/Utility/FilteredIterator.php\";a:2:{s:1:\"d\";i:1487282361;s:1:\"h\";s:32:\"10f9a2d9618ed678b72541aa9e0579d3\";}s:46:\"wp-includes/rest-api/class-wp-rest-request.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"4fbc60031593159f704c99d8c3dbde1d\";}s:47:\"wp-includes/rest-api/class-wp-rest-response.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"08796d0cda636c6a24bcebbb73ef2c98\";}s:45:\"wp-includes/rest-api/class-wp-rest-server.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"7301a34137557ef9055ff09fce9989d4\";}s:71:\"wp-includes/rest-api/endpoints/class-wp-rest-attachments-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"48a54973cfa2391245e05b9d29b7dc3a\";}s:68:\"wp-includes/rest-api/endpoints/class-wp-rest-comments-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"b4ebf121d502f40f2bf39dc6682930c9\";}s:59:\"wp-includes/rest-api/endpoints/class-wp-rest-controller.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"e537a25018f4556a4a3a73e60fc7e409\";}s:73:\"wp-includes/rest-api/endpoints/class-wp-rest-post-statuses-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"7d48bc4a38f3cf29197747e7177b9a25\";}s:70:\"wp-includes/rest-api/endpoints/class-wp-rest-post-types-controller.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"01c72b885d4628f5288cd064f8419a42\";}s:65:\"wp-includes/rest-api/endpoints/class-wp-rest-posts-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"b09b0694412400b5d50890b1c9935b4c\";}s:69:\"wp-includes/rest-api/endpoints/class-wp-rest-revisions-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"51aafa197ad695de2c4eceb7491677af\";}s:68:\"wp-includes/rest-api/endpoints/class-wp-rest-settings-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"08a7dd22a433706834ee9268a98d8c95\";}s:70:\"wp-includes/rest-api/endpoints/class-wp-rest-taxonomies-controller.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"f109b15ea7dab111e098d503a76b4d30\";}s:65:\"wp-includes/rest-api/endpoints/class-wp-rest-terms-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"9d8f9274be596fdef0038cc5265c1876\";}s:65:\"wp-includes/rest-api/endpoints/class-wp-rest-users-controller.php\";a:2:{s:1:\"d\";i:1487282356;s:1:\"h\";s:32:\"fbd03fc6811db1a5ebb66db48dd6f673\";}s:65:\"wp-includes/rest-api/fields/class-wp-rest-comment-meta-fields.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"414a3d6a753faa994d79a478de937e4a\";}s:57:\"wp-includes/rest-api/fields/class-wp-rest-meta-fields.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"a017a8b39d5eb32722005bd8cd97c1f3\";}s:62:\"wp-includes/rest-api/fields/class-wp-rest-post-meta-fields.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"0fb48cc8f80cee5263765dbc44915f58\";}s:62:\"wp-includes/rest-api/fields/class-wp-rest-term-meta-fields.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"f7cf58a5ece889c1722de7f092364f68\";}s:62:\"wp-includes/rest-api/fields/class-wp-rest-user-meta-fields.php\";a:2:{s:1:\"d\";i:1487282357;s:1:\"h\";s:32:\"fd80640aa3158963cd554be3584aaf0e\";}s:24:\"wp-includes/rest-api.php\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"faf207b2cbb40057c2b68d85b9b6f65c\";}s:24:\"wp-includes/revision.php\";a:2:{s:1:\"d\";i:1487282327;s:1:\"h\";s:32:\"a64aac575856cde32fef754fba8df20e\";}s:23:\"wp-includes/rewrite.php\";a:2:{s:1:\"d\";i:1487282330;s:1:\"h\";s:32:\"7fdb1e49efcad59217d02b5849f237b2\";}s:29:\"wp-includes/rss-functions.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"19ff1fae31fd2d0338c7601bcb4baf58\";}s:19:\"wp-includes/rss.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"c21d6d86e75bef00fa6c4a0ec5e1ca3b\";}s:29:\"wp-includes/script-loader.php\";a:2:{s:1:\"d\";i:1487282324;s:1:\"h\";s:32:\"c87013aca5f9fb6c73711288eb831561\";}s:23:\"wp-includes/session.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"d94561cea0c5c13a609b9cde5a7635d4\";}s:26:\"wp-includes/shortcodes.php\";a:2:{s:1:\"d\";i:1487282322;s:1:\"h\";s:32:\"fe2f596608a20e34fed045e19065e819\";}s:32:\"wp-includes/SimplePie/Author.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"348071ed105ff0418b25964e771ba331\";}s:36:\"wp-includes/SimplePie/Cache/Base.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"9443eda189bbd9325d0c9c045d237c6a\";}s:34:\"wp-includes/SimplePie/Cache/DB.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"0659bf084f55a303f5922edc62bcfbf6\";}s:36:\"wp-includes/SimplePie/Cache/File.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"a33dbb0540ecc29cc6425b14100953d1\";}s:40:\"wp-includes/SimplePie/Cache/Memcache.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"f69d4a55b2a1168531535107ab843fb6\";}s:37:\"wp-includes/SimplePie/Cache/MySQL.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"e8911ece15df42ca43991a48d5785687\";}s:31:\"wp-includes/SimplePie/Cache.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"79fc9017a23a836f4d0f68f7764ca734\";}s:33:\"wp-includes/SimplePie/Caption.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"bdbabcdcca426a4dadf6675bc4c4ebe9\";}s:34:\"wp-includes/SimplePie/Category.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"ba7ec8cc3f13d4f27f2e0adcaf64bb2a\";}s:46:\"wp-includes/SimplePie/Content/Type/Sniffer.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"7c72c3f369855562d96c77ece1c7db33\";}s:35:\"wp-includes/SimplePie/Copyright.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"bd7fbf68b954a9d50955cc808db7cb6a\";}s:30:\"wp-includes/SimplePie/Core.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"a4ae19a923b890f2dcf7e2d415fd1ad2\";}s:32:\"wp-includes/SimplePie/Credit.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"0385e4a14de78c8b2a167f3e0aea197c\";}s:46:\"wp-includes/SimplePie/Decode/HTML/Entities.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"45975e2fcf0d428691a55a2394252f61\";}s:35:\"wp-includes/SimplePie/Enclosure.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"122e861f42eb6e01ce8d4b0f11fb735d\";}s:35:\"wp-includes/SimplePie/Exception.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"094bfd76269c9fcc3c5cda8f05d05335\";}s:30:\"wp-includes/SimplePie/File.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"aeba08ad6b558736ea0aaf2beb2925b7\";}s:34:\"wp-includes/SimplePie/gzdecode.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"c538e2bc0e866197db616c17841134d4\";}s:37:\"wp-includes/SimplePie/HTTP/Parser.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"5725c7d0fb347f1c08df3690a58f3609\";}s:29:\"wp-includes/SimplePie/IRI.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"6e16ff20d3e68692cf3b617b875f36f5\";}s:30:\"wp-includes/SimplePie/Item.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"104510e221fa08437aec008e633cdca7\";}s:33:\"wp-includes/SimplePie/Locator.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"8073a4c6da1bb33b877576665ef5eab5\";}s:30:\"wp-includes/SimplePie/Misc.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"cecde679c62dd50207d8d25ece1a4b89\";}s:34:\"wp-includes/SimplePie/Net/IPv6.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"a546790e216abdd9801795949fb6b40f\";}s:36:\"wp-includes/SimplePie/Parse/Date.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"ee82d2e70dc8afc6b96510d2b9cff45e\";}s:32:\"wp-includes/SimplePie/Parser.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"52bb2ee462e7e414a77efdc7ebf52bcc\";}s:32:\"wp-includes/SimplePie/Rating.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"3d7013a46d09c74b0ee3d8af617412fb\";}s:34:\"wp-includes/SimplePie/Registry.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"1cc8a2e6c0b5dd3176398d6400f0d9b8\";}s:37:\"wp-includes/SimplePie/Restriction.php\";a:2:{s:1:\"d\";i:1487282354;s:1:\"h\";s:32:\"2a191e7168116418817388113bd57914\";}s:34:\"wp-includes/SimplePie/Sanitize.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"42d8b8c0cf46b5d8a511e0ae48b88f75\";}s:32:\"wp-includes/SimplePie/Source.php\";a:2:{s:1:\"d\";i:1487282353;s:1:\"h\";s:32:\"8e83bb1de3e018f0537bb32a8c9617ff\";}s:48:\"wp-includes/SimplePie/XML/Declaration/Parser.php\";a:2:{s:1:\"d\";i:1487282355;s:1:\"h\";s:32:\"8fb1da7028c385bb9d4203c9f6732362\";}s:24:\"wp-includes/taxonomy.php\";a:2:{s:1:\"d\";i:1487282332;s:1:\"h\";s:32:\"23f0644b73d6b5c493b747dfbbae2023\";}s:31:\"wp-includes/template-loader.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"a745024f45f018741479bdcf5518f59b\";}s:24:\"wp-includes/template.php\";a:2:{s:1:\"d\";i:1487282321;s:1:\"h\";s:32:\"c178e46faba05bd56821ca7809703568\";}s:39:\"wp-includes/Text/Diff/Engine/native.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"e5ad272a18821212bee3c3df2ae8780e\";}s:38:\"wp-includes/Text/Diff/Engine/shell.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"75ab41dc91cd7e4aaa5e74a5f9e6eeba\";}s:39:\"wp-includes/Text/Diff/Engine/string.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"3a11b1933d17fc4da9c3000cacef6929\";}s:38:\"wp-includes/Text/Diff/Engine/xdiff.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"d6b91fc8628a0c0474ad58389a475815\";}s:41:\"wp-includes/Text/Diff/Renderer/inline.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"880ae56e35b150b4b2c7e9d94227e81e\";}s:34:\"wp-includes/Text/Diff/Renderer.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"fc8720df4330b50f59374fdc40d94753\";}s:25:\"wp-includes/Text/Diff.php\";a:2:{s:1:\"d\";i:1487282368;s:1:\"h\";s:32:\"6c70d59e9e9a6e9bd11537719313e32a\";}s:37:\"wp-includes/theme-compat/comments.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"1822ba9f62e4bf3d510a7e4306e67d4b\";}s:38:\"wp-includes/theme-compat/embed-404.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"8fab25000fafee699fb4e76871ed02f4\";}s:42:\"wp-includes/theme-compat/embed-content.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"8d56b68c3883df89dc813b2eafa2901c\";}s:34:\"wp-includes/theme-compat/embed.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"72b64c89bf45f2760c6133f7a3dd3649\";}s:41:\"wp-includes/theme-compat/footer-embed.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"16841cf55adc04ab84f22e932b96196a\";}s:35:\"wp-includes/theme-compat/footer.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"8c5ff873dc3098a5e46ccbbf909c377e\";}s:41:\"wp-includes/theme-compat/header-embed.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"67962ba2c878829d26817766d258dcc0\";}s:35:\"wp-includes/theme-compat/header.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"304c40bba1dd25870a0bceffefc25024\";}s:36:\"wp-includes/theme-compat/sidebar.php\";a:2:{s:1:\"d\";i:1487282367;s:1:\"h\";s:32:\"8087f37304ad86ff1748b4446c9a2c0a\";}s:21:\"wp-includes/theme.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"3408d9c18f94c290c92284133a619eb4\";}s:22:\"wp-includes/update.php\";a:2:{s:1:\"d\";i:1487282334;s:1:\"h\";s:32:\"1bb7ae9151520e3ec8af790b39168da1\";}s:20:\"wp-includes/user.php\";a:2:{s:1:\"d\";i:1487282331;s:1:\"h\";s:32:\"7530eb886edb4a1cc488f12d582f14e4\";}s:20:\"wp-includes/vars.php\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"cdd1939efca2d5bad7e9ec8d4a82cf80\";}s:23:\"wp-includes/version.php\";a:2:{s:1:\"d\";i:1487282325;s:1:\"h\";s:32:\"7de81a6d25dedb6d53d1d970368a4318\";}s:48:\"wp-includes/widgets/class-wp-nav-menu-widget.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"afbf19ad014dc6023920e44a101c4441\";}s:48:\"wp-includes/widgets/class-wp-widget-archives.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"acfdcfd10301a0571225ec3145e241d2\";}s:48:\"wp-includes/widgets/class-wp-widget-calendar.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"d631fe8ecd841da8184557266ff63add\";}s:50:\"wp-includes/widgets/class-wp-widget-categories.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"cafd5f12e49b19f873e2ac26c2d12d26\";}s:45:\"wp-includes/widgets/class-wp-widget-links.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"985f5c6f8a40f67f73db1532f5eeec53\";}s:44:\"wp-includes/widgets/class-wp-widget-meta.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"f78ae934c6f1921ae6de84a44574c355\";}s:45:\"wp-includes/widgets/class-wp-widget-pages.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"8f60df1f5783a04980e94b19b027a632\";}s:55:\"wp-includes/widgets/class-wp-widget-recent-comments.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"0befe107628f60d955235857b3a60f7a\";}s:52:\"wp-includes/widgets/class-wp-widget-recent-posts.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"fd62c7f12f4f0187163736053e6de33c\";}s:43:\"wp-includes/widgets/class-wp-widget-rss.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"995ce71359deade3012b50d860499e27\";}s:46:\"wp-includes/widgets/class-wp-widget-search.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"e056a6eb7ea3d066e5e3e7fb92328d1b\";}s:49:\"wp-includes/widgets/class-wp-widget-tag-cloud.php\";a:2:{s:1:\"d\";i:1487282364;s:1:\"h\";s:32:\"48f6469307be6cf9887de1b4e36c6c68\";}s:44:\"wp-includes/widgets/class-wp-widget-text.php\";a:2:{s:1:\"d\";i:1487282363;s:1:\"h\";s:32:\"9eed6662626ed3dec07d9bb180dc956e\";}s:23:\"wp-includes/widgets.php\";a:2:{s:1:\"d\";i:1487282333;s:1:\"h\";s:32:\"29db8f190ada723ae62348ef2279dbe2\";}s:27:\"wp-includes/wlwmanifest.xml\";a:2:{s:1:\"d\";i:1487282319;s:1:\"h\";s:32:\"dfd490b6f383ea02a269031ff05e8896\";}s:21:\"wp-includes/wp-db.php\";a:2:{s:1:\"d\";i:1487282326;s:1:\"h\";s:32:\"9318dde9830ed7c02e46356ca763b583\";}s:23:\"wp-includes/wp-diff.php\";a:2:{s:1:\"d\";i:1487282329;s:1:\"h\";s:32:\"b8d2a2f2f34943b684b7e0250d342c2e\";}s:17:\"wp-links-opml.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"55f5eeda4f64271322d249c14685c162\";}s:11:\"wp-load.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"0c9f44118dae384e454723318492af4f\";}s:12:\"wp-login.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"d9f30d35359ff1b8865b2d961146f22f\";}s:11:\"wp-mail.php\";a:2:{s:1:\"d\";i:1487282268;s:1:\"h\";s:32:\"8d6c9e4dab7697a044a22a96cd787068\";}s:15:\"wp-settings.php\";a:2:{s:1:\"d\";i:1487282268;s:1:\"h\";s:32:\"02747bcc69d839c69919c3231d6f8b33\";}s:13:\"wp-signup.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"496a6629f2afd9e8274a180cb5ca0ef1\";}s:22:\"wp-snapshots/.htaccess\";a:2:{s:1:\"d\";i:1490250586;s:1:\"h\";s:32:\"99d22d1d8cc37a6376ff8d7b4023a894\";}s:23:\"wp-snapshots/dtoken.php\";a:2:{s:1:\"d\";i:1490250586;s:1:\"h\";s:32:\"aa31868ef61b3fc3f7d47c264daf2498\";}s:22:\"wp-snapshots/index.php\";a:2:{s:1:\"d\";i:1490250586;s:1:\"h\";s:32:\"aa31868ef61b3fc3f7d47c264daf2498\";}s:23:\"wp-snapshots/robots.txt\";a:2:{s:1:\"d\";i:1490250586;s:1:\"h\";s:32:\"95c77927d3abdef0e08dd0d5c2ef5147\";}s:61:\"wp-snapshots/Vynara_58b6925a91dba8291170301092026_archive.zip\";a:2:{s:1:\"d\";i:1488360113;s:1:\"h\";s:32:\"80c4fc586d320dd0d6670c8e92f13972\";}s:62:\"wp-snapshots/Vynara_58b6925a91dba8291170301092026_database.sql\";a:2:{s:1:\"d\";i:1488360042;s:1:\"h\";s:32:\"bb60cdd5688e3ddb4229e856eb9ec508\";}s:63:\"wp-snapshots/Vynara_58b6925a91dba8291170301092026_installer.php\";a:2:{s:1:\"d\";i:1488360113;s:1:\"h\";s:32:\"f2fed6388c0c0e713e935cf73360cdad\";}s:59:\"wp-snapshots/Vynara_58b6925a91dba8291170301092026_scan.json\";a:2:{s:1:\"d\";i:1488360030;s:1:\"h\";s:32:\"ce700970e06d8d59a62f1b9ac7c92ebe\";}s:16:\"wp-trackback.php\";a:2:{s:1:\"d\";i:1487282270;s:1:\"h\";s:32:\"253cb636365bfd99af1e73462286437f\";}s:10:\"xmlrpc.php\";a:2:{s:1:\"d\";i:1487282269;s:1:\"h\";s:32:\"6c53e2ff076280c5cfc410a3c632c785\";}}s:7:\"removed\";a:0:{}s:7:\"changed\";a:0:{}s:6:\"memory\";d:4.0800000000000000710542735760100185871124267578125;}");
INSERT INTO `wp_itsec_log` VALUES("2", "four_oh_four", "404 Error", "3", "2017-03-23 06:35:44", "2017-03-23 06:35:44", "::1", "", "0", "/wordpress/wordpress/wp-content/uploads/2017/02/cook-150x150.jpg", "https://localhost/wordpress/wordpress/", "a:1:{s:12:\"query_string\";s:0:\"\";}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/wordpress/wordpress", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/wordpress/wordpress", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Vynara", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "userswrk@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:208:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:7:\"team/?$\";s:24:\"index.php?post_type=team\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=team&paged=$matches[1]\";s:15:\"photogallery/?$\";s:32:\"index.php?post_type=photogallery\";s:45:\"photogallery/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=photogallery&feed=$matches[1]\";s:40:\"photogallery/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=photogallery&feed=$matches[1]\";s:32:\"photogallery/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=photogallery&paged=$matches[1]\";s:10:\"ourmenu/?$\";s:27:\"index.php?post_type=ourmenu\";s:40:\"ourmenu/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=ourmenu&feed=$matches[1]\";s:35:\"ourmenu/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=ourmenu&feed=$matches[1]\";s:27:\"ourmenu/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=ourmenu&paged=$matches[1]\";s:14:\"testimonial/?$\";s:31:\"index.php?post_type=testimonial\";s:44:\"testimonial/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:39:\"testimonial/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:31:\"testimonial/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=testimonial&paged=$matches[1]\";s:56:\"gallerycategory/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gallerycategory=$matches[1]&feed=$matches[2]\";s:51:\"gallerycategory/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gallerycategory=$matches[1]&feed=$matches[2]\";s:32:\"gallerycategory/([^/]+)/embed/?$\";s:48:\"index.php?gallerycategory=$matches[1]&embed=true\";s:44:\"gallerycategory/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?gallerycategory=$matches[1]&paged=$matches[2]\";s:26:\"gallerycategory/([^/]+)/?$\";s:37:\"index.php?gallerycategory=$matches[1]\";s:53:\"menucategory/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?menucategory=$matches[1]&feed=$matches[2]\";s:48:\"menucategory/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?menucategory=$matches[1]&feed=$matches[2]\";s:29:\"menucategory/([^/]+)/embed/?$\";s:45:\"index.php?menucategory=$matches[1]&embed=true\";s:41:\"menucategory/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?menucategory=$matches[1]&paged=$matches[2]\";s:23:\"menucategory/([^/]+)/?$\";s:34:\"index.php?menucategory=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"photogallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"photogallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"photogallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"photogallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"photogallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"photogallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"photogallery/([^/]+)/embed/?$\";s:45:\"index.php?photogallery=$matches[1]&embed=true\";s:33:\"photogallery/([^/]+)/trackback/?$\";s:39:\"index.php?photogallery=$matches[1]&tb=1\";s:53:\"photogallery/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?photogallery=$matches[1]&feed=$matches[2]\";s:48:\"photogallery/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?photogallery=$matches[1]&feed=$matches[2]\";s:41:\"photogallery/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?photogallery=$matches[1]&paged=$matches[2]\";s:48:\"photogallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?photogallery=$matches[1]&cpage=$matches[2]\";s:37:\"photogallery/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?photogallery=$matches[1]&page=$matches[2]\";s:29:\"photogallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"photogallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"photogallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"photogallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"photogallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"photogallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"ourmenu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"ourmenu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"ourmenu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"ourmenu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"ourmenu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"ourmenu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"ourmenu/([^/]+)/embed/?$\";s:40:\"index.php?ourmenu=$matches[1]&embed=true\";s:28:\"ourmenu/([^/]+)/trackback/?$\";s:34:\"index.php?ourmenu=$matches[1]&tb=1\";s:48:\"ourmenu/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?ourmenu=$matches[1]&feed=$matches[2]\";s:43:\"ourmenu/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?ourmenu=$matches[1]&feed=$matches[2]\";s:36:\"ourmenu/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?ourmenu=$matches[1]&paged=$matches[2]\";s:43:\"ourmenu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?ourmenu=$matches[1]&cpage=$matches[2]\";s:32:\"ourmenu/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?ourmenu=$matches[1]&page=$matches[2]\";s:24:\"ourmenu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"ourmenu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"ourmenu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"ourmenu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"ourmenu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"ourmenu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:52:\"testimonial/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:47:\"testimonial/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"rtb-booking/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"rtb-booking/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"rtb-booking/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"rtb-booking/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"rtb-booking/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"rtb-booking/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"rtb-booking/([^/]+)/embed/?$\";s:44:\"index.php?rtb-booking=$matches[1]&embed=true\";s:32:\"rtb-booking/([^/]+)/trackback/?$\";s:38:\"index.php?rtb-booking=$matches[1]&tb=1\";s:40:\"rtb-booking/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?rtb-booking=$matches[1]&paged=$matches[2]\";s:47:\"rtb-booking/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?rtb-booking=$matches[1]&cpage=$matches[2]\";s:36:\"rtb-booking/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?rtb-booking=$matches[1]&page=$matches[2]\";s:28:\"rtb-booking/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"rtb-booking/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"rtb-booking/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"rtb-booking/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"rtb-booking/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"rtb-booking/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:14:{i:0;s:19:\"akismet/akismet.php\";i:1;s:41:\"better-wp-security/better-wp-security.php\";i:2;s:60:\"cf7-conditional-fields/contact-form-7-conditional-fields.php\";i:3;s:55:\"contact-form-7-datepicker/contact-form-7-datepicker.php\";i:4;s:34:\"contact-form-7-style/cf7-style.php\";i:5;s:58:\"contact-form-7-to-database-extension/contact-form-7-db.php\";i:6;s:36:\"contact-form-7/wp-contact-form-7.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:44:\"jquery-collapse-o-matic/collapse-o-matic.php\";i:9;s:19:\"members/members.php\";i:10;s:31:\"photo-gallery/photo-gallery.php\";i:11;s:47:\"tabby-responsive-tabs/tabby-responsive-tabs.php\";i:12;s:33:\"w3-total-cache/w3-total-cache.php\";i:13;s:25:\"wp-members/wp-members.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:105:\"C:\\xampp\\htdocs\\wordpress\\wordpress/wp-content/plugins/contact-form-7/includes/contact-form-functions.php\";i:2;s:85:\"C:\\xampp\\htdocs\\wordpress\\wordpress/wp-content/plugins/contact-form-7/admin/admin.php\";i:3;s:91:\"C:\\xampp\\htdocs\\wordpress\\wordpress/wp-content/plugins/contact-form-7/wp-contact-form-7.php\";i:4;s:89:\"C:\\xampp\\htdocs\\wordpress\\wordpress/wp-content/plugins/contact-form-7-style/cf7-style.php\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "skt-restaurant-pro", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "skt-restaurant-pro", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_bookings\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:16:\"restrict_content\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"manage_bookings\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:19:\"rtb_booking_manager\";a:2:{s:4:\"name\";s:15:\"Booking Manager\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:15:\"manage_bookings\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"meta-2\";i:1;s:17:\"recent-comments-2\";}s:12:\"sidebar-main\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";i:4;s:22:\"members-widget-login-2\";}s:9:\"sidebar-1\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:6:{i:1490256439;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"a5918cdf5772b6402152daa1c2c4ca61\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:281;}}}}i:1490256731;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1ad62e4e7797c883c719a4cbb5a76b8f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:282;}}}}i:1490263280;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1490306492;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1490336017;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("105", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1487282523;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("109", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.7.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.7.3-partial-2.zip\";s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.7.3\";s:7:\"version\";s:5:\"4.7.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:5:\"4.7.2\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.7.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.7.3-partial-2.zip\";s:8:\"rollback\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.7.3-rollback-2.zip\";}s:7:\"current\";s:5:\"4.7.3\";s:7:\"version\";s:5:\"4.7.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:5:\"4.7.2\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1490250581;s:15:\"version_checked\";s:5:\"4.7.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("119", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("124", "current_theme", "SKT Restaurant Pro", "yes");
INSERT INTO `wp_options` VALUES("125", "theme_mods_restaurant-lite", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1487334234;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("142", "_site_transient_timeout_wporg_theme_feature_list", "1487344971", "no");
INSERT INTO `wp_options` VALUES("143", "_site_transient_wporg_theme_feature_list", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("145", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1490250592;s:7:\"checked\";a:1:{s:18:\"skt-restaurant-pro\";s:6:\"pro2.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("146", "theme_mods_skt-restaurant-pro", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:128;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:2;}}", "yes");
INSERT INTO `wp_options` VALUES("147", "skt_restaurant_pro", "a:204:{s:4:\"logo\";s:81:\"http://localhost/wordpress/wordpress/wp-content/uploads/2017/03/Vynaranewlogo.png\";s:10:\"logoheight\";s:2:\"36\";s:6:\"style2\";s:0:\"\";s:9:\"headstick\";s:1:\"1\";s:12:\"bodyfontface\";s:5:\"Arial\";s:12:\"logofontface\";s:8:\"Playball\";s:11:\"navfontface\";s:16:\"Roboto Condensed\";s:12:\"headfontface\";s:8:\"Playball\";s:12:\"bodyfontsize\";s:4:\"13px\";s:12:\"logofontsize\";s:4:\"36px\";s:11:\"navfontsize\";s:4:\"15px\";s:14:\"rohboxfontsize\";s:4:\"14px\";s:12:\"sectitlesize\";s:4:\"34px\";s:9:\"spbxtitle\";s:4:\"44px\";s:10:\"ftfontsize\";s:4:\"24px\";s:13:\"bodyfontcolor\";s:7:\"#5c5c5c\";s:13:\"logofontcolor\";s:7:\"#cc00cd\";s:13:\"sectitlecolor\";s:7:\"#000000\";s:11:\"rohboxcolor\";s:7:\"#ffffff\";s:12:\"navfontcolor\";s:7:\"#ffffff\";s:13:\"navhovercolor\";s:7:\"#cc16cc\";s:11:\"spclbxtitle\";s:7:\"#ffffff\";s:13:\"spclhvbxtitle\";s:7:\"#cc16cc\";s:11:\"ourmenudesc\";s:7:\"#ffffff\";s:15:\"wdgttitleccolor\";s:7:\"#2c2c2c\";s:14:\"foottitlecolor\";s:7:\"#fdfdf1\";s:13:\"footdesccolor\";s:7:\"#ffffff\";s:15:\"footermenucolor\";s:7:\"#ffffff\";s:17:\"footermenucurrent\";s:7:\"#cc00cd\";s:9:\"copycolor\";s:7:\"#ffffff\";s:11:\"designcolor\";s:7:\"#ffffff\";s:9:\"linkcolor\";s:7:\"#ffa200\";s:14:\"linkhovercolor\";s:7:\"#a2a2a2\";s:11:\"btntxtcolor\";s:7:\"#ffffff\";s:13:\"btntxthvcolor\";s:7:\"#ffffff\";s:16:\"sidebarfontcolor\";s:7:\"#5c5c5c\";s:16:\"booknowfontcolor\";s:7:\"#000000\";s:11:\"hmmenutitle\";s:7:\"#ffffff\";s:12:\"ourmenuhover\";s:7:\"#dd3333\";s:11:\"togglecolor\";s:7:\"#3d3d3d\";s:12:\"toggleactive\";s:7:\"#cc00cd\";s:17:\"glfilterfontcolor\";s:7:\"#5c5c5c\";s:19:\"glfilterfontcolorhv\";s:7:\"#cc00cd\";s:8:\"headerbg\";s:7:\"#000000\";s:15:\"headerbgopacity\";s:3:\"0.3\";s:8:\"twoboxbg\";s:7:\"#cc00cd\";s:15:\"twoboxbgopacity\";s:3:\"0.7\";s:8:\"btncolor\";s:7:\"#cc00cd\";s:10:\"btnhvcolor\";s:7:\"#2f241e\";s:13:\"footerbgcolor\";s:7:\"#272727\";s:11:\"copybgcolor\";s:7:\"#131313\";s:10:\"galhvcolor\";s:7:\"#cc00cd\";s:13:\"filterbgcolor\";s:7:\"#f2f2f2\";s:7:\"booknow\";s:7:\"#ffffff\";s:18:\"menubgonresponsive\";s:7:\"#a2a2a2\";s:10:\"slidecaph2\";s:7:\"#000000\";s:11:\"slidecapdes\";s:7:\"#000000\";s:15:\"slidetitlecolor\";s:7:\"#cc00cd\";s:14:\"slidedesccolor\";s:7:\"#ffffff\";s:18:\"slidetitlefontsize\";s:4:\"40px\";s:17:\"slidedescfontsize\";s:4:\"14px\";s:15:\"slidecapopacity\";s:3:\"0.3\";s:8:\"sldnavbg\";s:7:\"#170f09\";s:9:\"sldpagebg\";s:7:\"#170f09\";s:11:\"sldpagehvbg\";s:7:\"#cc00cd\";s:14:\"navhoverborder\";s:7:\"#cc16cc\";s:13:\"newsboxborder\";s:7:\"#ecebeb\";s:15:\"wdgtbordercolor\";s:7:\"#cccccc\";s:8:\"ohborder\";s:7:\"#cc00cd\";s:15:\"foottitleborder\";s:7:\"#333333\";s:12:\"footerborder\";s:7:\"#131313\";s:11:\"socialcolor\";s:7:\"#ffffff\";s:13:\"socialhvcolor\";s:7:\"#cc00cd\";s:12:\"singlelayout\";s:11:\"singleright\";s:16:\"woocomercelayout\";s:18:\"woocomercesitefull\";s:14:\"menuwordchange\";s:6:\"Vynara\";s:16:\"blogreadmoretext\";s:12:\"Read More »\";s:21:\"hmlatestpostsreadmore\";s:12:\"Read More...\";s:19:\"hmlatestpostslength\";s:2:\"25\";s:21:\"testimonialwordlength\";s:2:\"60\";s:17:\"blogexcerptlength\";s:2:\"50\";s:17:\"teamexcerptlength\";s:2:\"25\";s:17:\"menuexcerptlength\";s:2:\"18\";s:10:\"numsection\";s:1:\"7\";s:13:\"sectiontitle1\";s:0:\"\";s:10:\"menutitle1\";s:13:\"ourrestaurant\";s:15:\"sectionbgcolor1\";s:7:\"#ffffff\";s:15:\"sectionbgimage1\";s:0:\"\";s:13:\"sectionclass1\";s:14:\"our-restaurant\";s:8:\"hidesec1\";b:0;s:15:\"sectioncontent1\";s:69407:\"[column_content type=\"one_half\"]<img src=\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/welcome-restaurant.png\" />[/column_content][column_content type=\"one_half_last\"]\r\n<h2>Welcome to Vynara</h2>\r\n<!-- [if gte mso 9]><xml>\r\n<o:OfficeDocumentSettings>\r\n<o:AllowPNG/>\r\n</o:OfficeDocumentSettings>\r\n</xml><![endif]-->\r\n\r\n<!-- [if gte mso 9]><xml>\r\n<w:WordDocument>\r\n<w:View>Normal</w:View>\r\n<w:Zoom>0</w:Zoom>\r\n<w:TrackMoves/>\r\n<w:TrackFormatting/>\r\n<w:PunctuationKerning/>\r\n<w:ValidateAgainstSchemas/>\r\n<w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid>\r\n<w:IgnoreMixedContent>false</w:IgnoreMixedContent>\r\n<w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText>\r\n<w:DoNotPromoteQF/>\r\n<w:LidThemeOther>EN-US</w:LidThemeOther>\r\n<w:LidThemeAsian>X-NONE</w:LidThemeAsian>\r\n<w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript>\r\n<w:Compatibility>\r\n<w:BreakWrappedTables/>\r\n<w:SnapToGridInCell/>\r\n<w:WrapTextWithPunct/>\r\n<w:UseAsianBreakRules/>\r\n<w:DontGrowAutofit/>\r\n<w:SplitPgBreakAndParaMark/>\r\n<w:EnableOpenTypeKerning/>\r\n<w:DontFlipMirrorIndents/>\r\n<w:OverrideTableStyleHps/>\r\n</w:Compatibility>\r\n<m:mathPr>\r\n<m:mathFont m:val=\"Cambria Math\"/>\r\n<m:brkBin m:val=\"before\"/>\r\n<m:brkBinSub m:val=\"&#45;-\"/>\r\n<m:smallFrac m:val=\"off\"/>\r\n<m:dispDef/>\r\n<m:lMargin m:val=\"0\"/>\r\n<m:rMargin m:val=\"0\"/>\r\n<m:defJc m:val=\"centerGroup\"/>\r\n<m:wrapIndent m:val=\"1440\"/>\r\n<m:intLim m:val=\"subSup\"/>\r\n<m:naryLim m:val=\"undOvr\"/>\r\n</m:mathPr></w:WordDocument>\r\n</xml><![endif]--><!-- [if gte mso 9]><xml>\r\n<w:LatentStyles DefLockedState=\"false\" DefUnhideWhenUsed=\"false\" DefSemiHidden=\"false\" DefQFormat=\"false\" DefPriority=\"99\" LatentStyleCount=\"371\">\r\n<w:LsdException Locked=\"false\" Priority=\"0\" QFormat=\"true\" Name=\"Normal\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 7\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 8\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 9\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 9\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 7\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 8\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 9\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footnote text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"header\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footer\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index heading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"35\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"caption\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"table of figures\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"envelope address\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"envelope return\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footnote reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"line number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"page number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"endnote reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"endnote text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"table of authorities\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"macro\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toa heading\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"10\" QFormat=\"true\" Name=\"Title\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Closing\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Signature\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"1\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Default Paragraph Font\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Message Header\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"11\" QFormat=\"true\" Name=\"Subtitle\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Salutation\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Date\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text First Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text First Indent 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Note Heading\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Block Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Hyperlink\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"FollowedHyperlink\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"22\" QFormat=\"true\" Name=\"Strong\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"20\" QFormat=\"true\" Name=\"Emphasis\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Document Map\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Plain Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"E-mail Signature\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Top of Form\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Bottom of Form\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal (Web)\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Acronym\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Address\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Cite\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Code\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Definition\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Keyboard\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Preformatted\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Sample\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Typewriter\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Variable\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal Table\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation subject\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"No List\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Contemporary\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Elegant\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Professional\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Subtle 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Subtle 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Balloon Text\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" Name=\"Table Grid\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Theme\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" Name=\"Placeholder Text\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"1\" QFormat=\"true\" Name=\"No Spacing\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" Name=\"Revision\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"34\" QFormat=\"true\" Name=\"List Paragraph\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"29\" QFormat=\"true\" Name=\"Quote\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"30\" QFormat=\"true\" Name=\"Intense Quote\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"19\" QFormat=\"true\" Name=\"Subtle Emphasis\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"21\" QFormat=\"true\" Name=\"Intense Emphasis\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"31\" QFormat=\"true\" Name=\"Subtle Reference\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"32\" QFormat=\"true\" Name=\"Intense Reference\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"33\" QFormat=\"true\" Name=\"Book Title\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"37\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Bibliography\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"TOC Heading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"41\" Name=\"Plain Table 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"42\" Name=\"Plain Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"43\" Name=\"Plain Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"44\" Name=\"Plain Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"45\" Name=\"Plain Table 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"40\" Name=\"Grid Table Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 6\"/>\r\n</w:LatentStyles>\r\n</xml><![endif]--><!-- [if gte mso 10]>\r\n\r\n<style>\r\n /* Style Definitions */<br /> table.MsoNormalTable<br />	{mso-style-name:\"Table Normal\";<br />	mso-tstyle-rowband-size:0;<br />	mso-tstyle-colband-size:0;<br />	mso-style-noshow:yes;<br />	mso-style-priority:99;<br />	mso-style-parent:\"\";<br />	mso-padding-alt:0in 5.4pt 0in 5.4pt;<br />	mso-para-margin-top:0in;<br />	mso-para-margin-right:0in;<br />	mso-para-margin-bottom:8.0pt;<br />	mso-para-margin-left:0in;<br />	line-height:107%;<br />	mso-pagination:widow-orphan;<br />	font-size:11.0pt;<br />	font-family:\"Calibri\",\"sans-serif\";<br />	mso-ascii-font-family:Calibri;<br />	mso-ascii-theme-font:minor-latin;<br />	mso-hansi-font-family:Calibri;<br />	mso-hansi-theme-font:minor-latin;}<br /></style><![endif]--><!-- [if gte mso 9]><xml>\r\n<o:OfficeDocumentSettings>\r\n<o:AllowPNG/>\r\n</o:OfficeDocumentSettings>\r\n</xml><![endif]-->\r\n\r\n<!-- [if gte mso 9]><xml>\r\n<w:WordDocument>\r\n<w:View>Normal</w:View>\r\n<w:Zoom>0</w:Zoom>\r\n<w:TrackMoves/>\r\n<w:TrackFormatting/>\r\n<w:PunctuationKerning/>\r\n<w:ValidateAgainstSchemas/>\r\n<w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid>\r\n<w:IgnoreMixedContent>false</w:IgnoreMixedContent>\r\n<w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText>\r\n<w:DoNotPromoteQF/>\r\n<w:LidThemeOther>EN-US</w:LidThemeOther>\r\n<w:LidThemeAsian>X-NONE</w:LidThemeAsian>\r\n<w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript>\r\n<w:Compatibility>\r\n<w:BreakWrappedTables/>\r\n<w:SnapToGridInCell/>\r\n<w:WrapTextWithPunct/>\r\n<w:UseAsianBreakRules/>\r\n<w:DontGrowAutofit/>\r\n<w:SplitPgBreakAndParaMark/>\r\n<w:EnableOpenTypeKerning/>\r\n<w:DontFlipMirrorIndents/>\r\n<w:OverrideTableStyleHps/>\r\n</w:Compatibility>\r\n<m:mathPr>\r\n<m:mathFont m:val=\"Cambria Math\"/>\r\n<m:brkBin m:val=\"before\"/>\r\n<m:brkBinSub m:val=\"&#45;-\"/>\r\n<m:smallFrac m:val=\"off\"/>\r\n<m:dispDef/>\r\n<m:lMargin m:val=\"0\"/>\r\n<m:rMargin m:val=\"0\"/>\r\n<m:defJc m:val=\"centerGroup\"/>\r\n<m:wrapIndent m:val=\"1440\"/>\r\n<m:intLim m:val=\"subSup\"/>\r\n<m:naryLim m:val=\"undOvr\"/>\r\n</m:mathPr></w:WordDocument>\r\n</xml><![endif]--><!-- [if gte mso 9]><xml>\r\n<w:LatentStyles DefLockedState=\"false\" DefUnhideWhenUsed=\"false\" DefSemiHidden=\"false\" DefQFormat=\"false\" DefPriority=\"99\" LatentStyleCount=\"371\">\r\n<w:LsdException Locked=\"false\" Priority=\"0\" QFormat=\"true\" Name=\"Normal\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" QFormat=\"true\" Name=\"heading 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 7\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 8\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"9\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"heading 9\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index 9\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 7\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 8\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toc 9\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footnote text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"header\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footer\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"index heading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"35\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"caption\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"table of figures\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"envelope address\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"envelope return\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"footnote reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"line number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"page number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"endnote reference\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"endnote text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"table of authorities\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"macro\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"toa heading\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Bullet 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Number 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"10\" QFormat=\"true\" Name=\"Title\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Closing\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Signature\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"1\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Default Paragraph Font\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"List Continue 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Message Header\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"11\" QFormat=\"true\" Name=\"Subtitle\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Salutation\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Date\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text First Indent\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text First Indent 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Note Heading\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Body Text Indent 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Block Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Hyperlink\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"FollowedHyperlink\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"22\" QFormat=\"true\" Name=\"Strong\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"20\" QFormat=\"true\" Name=\"Emphasis\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Document Map\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Plain Text\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"E-mail Signature\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Top of Form\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Bottom of Form\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal (Web)\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Acronym\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Address\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Cite\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Code\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Definition\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Keyboard\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Preformatted\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Sample\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Typewriter\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"HTML Variable\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Normal Table\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"annotation subject\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"No List\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Outline List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Simple 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Classic 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Colorful 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Columns 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Grid 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 4\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 5\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 6\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 7\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table List 8\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table 3D effects 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Contemporary\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Elegant\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Professional\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Subtle 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Subtle 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 2\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Web 3\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Balloon Text\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" Name=\"Table Grid\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Table Theme\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" Name=\"Placeholder Text\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"1\" QFormat=\"true\" Name=\"No Spacing\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" SemiHidden=\"true\" Name=\"Revision\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"34\" QFormat=\"true\" Name=\"List Paragraph\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"29\" QFormat=\"true\" Name=\"Quote\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"30\" QFormat=\"true\" Name=\"Intense Quote\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"60\" Name=\"Light Shading Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"61\" Name=\"Light List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"62\" Name=\"Light Grid Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"63\" Name=\"Medium Shading 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"64\" Name=\"Medium Shading 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"65\" Name=\"Medium List 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"66\" Name=\"Medium List 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"67\" Name=\"Medium Grid 1 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"68\" Name=\"Medium Grid 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"69\" Name=\"Medium Grid 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"70\" Name=\"Dark List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"71\" Name=\"Colorful Shading Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"72\" Name=\"Colorful List Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"73\" Name=\"Colorful Grid Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"19\" QFormat=\"true\" Name=\"Subtle Emphasis\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"21\" QFormat=\"true\" Name=\"Intense Emphasis\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"31\" QFormat=\"true\" Name=\"Subtle Reference\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"32\" QFormat=\"true\" Name=\"Intense Reference\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"33\" QFormat=\"true\" Name=\"Book Title\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"37\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" Name=\"Bibliography\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"39\" SemiHidden=\"true\" UnhideWhenUsed=\"true\" QFormat=\"true\" Name=\"TOC Heading\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"41\" Name=\"Plain Table 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"42\" Name=\"Plain Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"43\" Name=\"Plain Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"44\" Name=\"Plain Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"45\" Name=\"Plain Table 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"40\" Name=\"Grid Table Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"Grid Table 1 Light Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"Grid Table 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"Grid Table 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"Grid Table 4 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"Grid Table 5 Dark Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"Grid Table 6 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"Grid Table 7 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 1\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 2\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 3\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 4\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 5\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"46\" Name=\"List Table 1 Light Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"47\" Name=\"List Table 2 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"48\" Name=\"List Table 3 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"49\" Name=\"List Table 4 Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"50\" Name=\"List Table 5 Dark Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"51\" Name=\"List Table 6 Colorful Accent 6\"/>\r\n<w:LsdException Locked=\"false\" Priority=\"52\" Name=\"List Table 7 Colorful Accent 6\"/>\r\n</w:LatentStyles>\r\n</xml><![endif]--><!-- [if gte mso 10]>\r\n\r\n<style>\r\n /* Style Definitions */<br /> table.MsoNormalTable<br />	{mso-style-name:\"Table Normal\";<br />	mso-tstyle-rowband-size:0;<br />	mso-tstyle-colband-size:0;<br />	mso-style-noshow:yes;<br />	mso-style-priority:99;<br />	mso-style-parent:\"\";<br />	mso-padding-alt:0in 5.4pt 0in 5.4pt;<br />	mso-para-margin-top:0in;<br />	mso-para-margin-right:0in;<br />	mso-para-margin-bottom:8.0pt;<br />	mso-para-margin-left:0in;<br />	line-height:107%;<br />	mso-pagination:widow-orphan;<br />	font-size:11.0pt;<br />	font-family:\"Calibri\",\"sans-serif\";<br />	mso-ascii-font-family:Calibri;<br />	mso-ascii-theme-font:minor-latin;<br />	mso-hansi-font-family:Calibri;<br />	mso-hansi-theme-font:minor-latin;}<br /></style><![endif]-->\r\n\r\nThanks for dropping by our website.<strong> Vynara is a full-service bakery and confectionery with various branches in Nigeria.</strong> We are passionate about providing our clients with delicious fresh daily baked pastries, beautiful cakes and individual desserts, amazing wedding cakes, and other quality sweet treats that tantalize your taste buds. All of our desserts are made from scratch and always kept fresh, and using only the best ingredients.\r\n\r\nOur bakers and cake artists have many years of experience and are taking new classes and workshops to keep their skills fresh and exciting for you! The cake artists always enjoy a challenge, so bring us your best ideas and watch them transform into an amazing cake that will impress your friends and family. We will also happily bake any family recipe for you, so you can enjoy all the rewards without any hard work!\r\n\r\nYour word of mouth promotion for us has gone a long way as we enter into our fifth year of serving you.\r\n\r\n<a class=\"button\" href=\"http://vynara.com/about-us\">Read More...</a>[/column_content]\";s:13:\"sectiontitle2\";s:16:\"Customized Cakes\";s:10:\"menutitle2\";s:12:\"todayspecial\";s:15:\"sectionbgcolor2\";s:7:\"#f7f7f7\";s:15:\"sectionbgimage2\";s:0:\"\";s:13:\"sectionclass2\";s:12:\"todayspecial\";s:8:\"hidesec2\";b:0;s:15:\"sectioncontent2\";s:466:\"[todayspecial title=\"Birthdays\" icon=\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/food.jpg\" link=\"#\"][/todayspecial][todayspecial title=\"Weddings\" icon=\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/drink.jpg\" link=\"#\"][/todayspecial][todayspecial title=\"Special Events\" icon=\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/desert.jpg\" link=\"#\"][/todayspecial]\";s:13:\"sectiontitle3\";s:0:\"\";s:10:\"menutitle3\";s:9:\"hmourmenu\";s:15:\"sectionbgcolor3\";s:0:\"\";s:15:\"sectionbgimage3\";s:85:\"http://localhost/wordpress/wordpress/wp-content/uploads/2017/03/NEWbread-on-chelf.jpg\";s:13:\"sectionclass3\";s:9:\"hmourmenu\";s:8:\"hidesec3\";b:0;s:15:\"sectioncontent3\";s:468:\"[column_content type=\"one_half\"][ourmenu show=\"6\"][/column_content][column_content type=\"one_half_last\"]\r\n<h2>Vynara Bread Varieties</h2>\r\n[area class=\"MenuDesc\"]\r\n\r\nAt Vynara, we deliver more than 6 varieties of fresh baked breads across the country. With more than 5 years of existence, we have gained a reputation as one of the trusted bread companies in Nigeria.\r\n\r\n[/area]<a class=\"button\" href=\"http://vynara.com/gallery\">View other Products</a>[/column_content]\";s:13:\"sectiontitle4\";s:15:\"News and Events\";s:10:\"menutitle4\";s:4:\"news\";s:15:\"sectionbgcolor4\";s:7:\"#ffffff\";s:15:\"sectionbgimage4\";s:0:\"\";s:13:\"sectionclass4\";s:11:\"latest-news\";s:8:\"hidesec4\";b:0;s:15:\"sectioncontent4\";s:22:\"[latestposts show=\"4\"]\";s:13:\"sectiontitle5\";s:16:\"Our Testimonials\";s:10:\"menutitle5\";s:12:\"testimonials\";s:15:\"sectionbgcolor5\";s:7:\"#f7f7f7\";s:15:\"sectionbgimage5\";s:0:\"\";s:13:\"sectionclass5\";s:12:\"testimonials\";s:8:\"hidesec5\";b:0;s:15:\"sectioncontent5\";s:14:\"[testimonials]\";s:13:\"sectiontitle6\";s:0:\"\";s:10:\"menutitle6\";s:11:\"reservation\";s:15:\"sectionbgcolor6\";s:0:\"\";s:15:\"sectionbgimage6\";s:80:\"http://localhost/wordpress/wordpress/wp-content/uploads/2017/03/reservationx.jpg\";s:13:\"sectionclass6\";s:10:\"officehour\";s:8:\"hidesec6\";b:0;s:15:\"sectioncontent6\";s:964:\"[column_content type=\"one_half\"]\r\n<h2>Reservations</h2>\r\n[area class=\"commonbox\"]\r\n\r\n<span class=\"textstyle1\">To make your reservations, simply fill our short form and we will give you a call to confirm your reservation and get any additional details within 24 hours.</span>\r\n\r\n<a class=\"button2\" href=\"http://vynara.com/reservation\">Book Now</a>[/area][/column_content]\r\n\r\n[column_content type=\"one_half_last\"]\r\n<h2>Opening Hours</h2>\r\n[area class=\"commonbox lstbx\"][time_table]\r\n[time_table_row title=\"Monday\" start=\"07:30 am - to - 06:00pm\"]\r\n[time_table_row title=\"Tuesday\" start=\"07:30 pm - to - 06:00pm\"]\r\n[time_table_row title=\"Wednesday\" start=\"07:30 am - to - 06:00pm\"]\r\n[time_table_row title=\"Thursday\" start=\"07:30 am - to - 06:00pm\"]\r\n[time_table_row title=\"Friday\" start=\"07:30 am - to - 06:00pm\"]\r\n[time_table_row title=\"Saturday\" start=\"09:00 am - to - 06:00pm\"]\r\n[time_table_row title=\"Sunday\" start=\"Closed\"]\r\n[/time_table][/area][/column_content]\";s:13:\"sectiontitle7\";s:13:\"Photo Gallery\";s:10:\"menutitle7\";s:10:\"ourgallery\";s:15:\"sectionbgcolor7\";s:7:\"#ffffff\";s:15:\"sectionbgimage7\";s:0:\"\";s:13:\"sectionclass7\";s:12:\"our-projects\";s:8:\"hidesec7\";b:0;s:15:\"sectioncontent7\";s:151:\"[photogallery filter=\"false\"] [blankspace height=\"50\"]\r\n\r\n<center><a class=\"button\" href=\"http://vynara.com/gallery\">View Our Full Gallery</a></center>\";s:15:\"innerpagebanner\";s:75:\"http://localhost/wordpress/wordpress/wp-content/uploads/2017/03/headerx.jpg\";s:10:\"slideefect\";s:4:\"fade\";s:9:\"slideanim\";s:3:\"500\";s:10:\"slidepause\";s:4:\"3000\";s:8:\"slidenav\";s:4:\"true\";s:9:\"slidepage\";s:5:\"false\";s:15:\"slidepausehover\";s:5:\"false\";s:15:\"slidershortcode\";s:0:\"\";s:6:\"slide1\";s:99:\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/slides/slider1.jpg\";s:11:\"slidetitle1\";s:22:\"Vynara Confectionaries\";s:10:\"slidedesc1\";s:124:\"Our mission is to cater fresh baked products with dedication to quality and consistency at the best price among competitors.\";s:12:\"slidebutton1\";s:12:\"Read More »\";s:9:\"slideurl1\";s:27:\"http://vynara.com/about-us/\";s:6:\"slide2\";s:99:\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/slides/slider2.jpg\";s:11:\"slidetitle2\";s:22:\"Vynara Confectionaries\";s:10:\"slidedesc2\";s:117:\"To bring satisfaction and to make special occasion truly exceptional through our handmade cake with unbeatable taste.\";s:12:\"slidebutton2\";s:12:\"Read More »\";s:9:\"slideurl2\";s:27:\"http://vynara.com/about-us/\";s:6:\"slide3\";s:99:\"http://localhost/wordpress/wordpress/wp-content/themes/skt-restaurant-pro/images/slides/slider3.jpg\";s:11:\"slidetitle3\";s:22:\"Vynara Confectionaries\";s:10:\"slidedesc3\";s:139:\"Every customer is treated with friendly and attentive service. Our staffs will always be happy to sit down with you, listen to your need...\";s:12:\"slidebutton3\";s:12:\"Read More »\";s:9:\"slideurl3\";s:27:\"http://vynara.com/about-us/\";s:6:\"slide4\";s:0:\"\";s:11:\"slidetitle4\";s:0:\"\";s:10:\"slidedesc4\";s:0:\"\";s:12:\"slidebutton4\";s:0:\"\";s:9:\"slideurl4\";s:0:\"\";s:6:\"slide5\";s:0:\"\";s:11:\"slidetitle5\";s:0:\"\";s:10:\"slidedesc5\";s:0:\"\";s:12:\"slidebutton5\";s:0:\"\";s:9:\"slideurl5\";s:0:\"\";s:6:\"slide6\";s:0:\"\";s:11:\"slidetitle6\";s:0:\"\";s:10:\"slidedesc6\";s:0:\"\";s:12:\"slidebutton6\";s:0:\"\";s:9:\"slideurl6\";s:0:\"\";s:6:\"slide7\";s:0:\"\";s:11:\"slidetitle7\";s:0:\"\";s:10:\"slidedesc7\";s:0:\"\";s:12:\"slidebutton7\";s:0:\"\";s:9:\"slideurl7\";s:0:\"\";s:6:\"slide8\";s:0:\"\";s:11:\"slidetitle8\";s:0:\"\";s:10:\"slidedesc8\";s:0:\"\";s:12:\"slidebutton8\";s:0:\"\";s:9:\"slideurl8\";s:0:\"\";s:6:\"slide9\";s:0:\"\";s:11:\"slidetitle9\";s:0:\"\";s:10:\"slidedesc9\";s:0:\"\";s:12:\"slidebutton9\";s:0:\"\";s:9:\"slideurl9\";s:0:\"\";s:7:\"slide10\";s:0:\"\";s:12:\"slidetitle10\";s:0:\"\";s:11:\"slidedesc10\";s:0:\"\";s:13:\"slidebutton10\";s:0:\"\";s:10:\"slideurl10\";s:0:\"\";s:11:\"footerstyle\";s:6:\"italic\";s:14:\"footerabttitle\";s:9:\"Main Menu\";s:15:\"philosophytitle\";s:14:\"Our Philosophy\";s:13:\"footerabttext\";s:280:\"Baking with passion! That is how we start the business. We make our product with love and an eye for detail - baked to perfection. We treated our freshly baked breads, cookies, and cakes <br> <br><a class=\"readmore\" href=\"http://vynara.com/about-us/\">Read <span>More...</span></a>\";s:13:\"followustitle\";s:9:\"Follow Us\";s:17:\"footersocialicons\";s:480:\"[social_area]\r\n    [social icon=\"facebook\" link=\"#\"]\r\n    [social icon=\"twitter\" link=\"#\"]\r\n    [social icon=\"linkedin\" link=\"#\"]\r\n    [social icon=\"pinterest\" link=\"#\"]\r\n    [social icon=\"rss\" link=\"#\"]\r\n    [social icon=\"youtube\" link=\"#\"]\r\n    [social icon=\"google-plus\" link=\"#\"]\r\n    [social icon=\"instagram\" link=\"#\"]\r\n    [social icon=\"wordpress\" link=\"#\"]	\r\n	[social icon=\"skype\" link=\"#\"]\r\n	[social icon=\"yahoo\" link=\"#\"]\r\n	[social icon=\"flickr\" link=\"#\"]\r\n[/social_area]\";s:12:\"addresstitle\";s:10:\"Contact Us\";s:7:\"address\";s:62:\"7, Kolda street, off Adetokunbo Ademola Cresent, Wuse 2, Abuja\";s:5:\"phone\";s:17:\"+234 813 470 0737\";s:5:\"email\";s:15:\"info@vynara.com\";s:7:\"weblink\";s:14:\"www.vynara.com\";s:8:\"copytext\";s:71:\"&copy; 2017 <a href=\"#\">Vynara Confectionaries</a>. All Rights Reserved\";s:6:\"ftlink\";s:77:\"Design by <a href=\"http://path7networks.com\" target=\"_blank\">GreenBuckett</a>\";}", "yes");
INSERT INTO `wp_options` VALUES("218", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("255", "recently_activated", "a:2:{s:51:\"restaurant-reservations/restaurant-reservations.php\";i:1490210476;s:50:\"contact-form-7/includes/contact-form-functions.php\";i:1490064766;}", "yes");
INSERT INTO `wp_options` VALUES("266", "widget_rtb_booking_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("267", "rtb-settings", "a:30:{s:13:\"schedule-open\";a:1:{i:0;a:1:{s:8:\"weekdays\";a:7:{s:6:\"monday\";s:1:\"1\";s:7:\"tuesday\";s:1:\"1\";s:9:\"wednesday\";s:1:\"1\";s:8:\"thursday\";s:1:\"1\";s:6:\"friday\";s:1:\"1\";s:8:\"saturday\";s:1:\"1\";s:6:\"sunday\";s:1:\"1\";}}}s:15:\"schedule-closed\";a:2:{i:0;a:1:{s:4:\"date\";s:10:\"2017/04/16\";}i:1;a:1:{s:4:\"date\";s:10:\"2017/12/25\";}}s:14:\"early-bookings\";s:0:\"\";s:13:\"late-bookings\";s:0:\"\";s:11:\"date-onload\";s:0:\"\";s:13:\"time-interval\";s:0:\"\";s:10:\"week-start\";s:1:\"0\";s:13:\"reply-to-name\";s:0:\"\";s:16:\"reply-to-address\";s:0:\"\";s:18:\"admin-email-option\";s:1:\"1\";s:19:\"admin-email-address\";s:0:\"\";s:25:\"template-tags-description\";s:0:\"\";s:21:\"subject-booking-admin\";s:0:\"\";s:22:\"template-booking-admin\";s:217:\"A new booking request has been made at {site_name}:\r\n\r\n{user_name}\r\n{party} people\r\n{date}\r\n\r\n{bookings_link}\r\n{confirm_link}\r\n{close_link}\r\n\r\n&nbsp;\r\n\r\n<em>This message was sent by {site_link} on {current_time}.</em>\";s:20:\"subject-booking-user\";s:0:\"\";s:21:\"template-booking-user\";s:477:\"Thanks {user_name},\r\n\r\nYour booking request is <strong>waiting to be confirmed</strong>.\r\n\r\nGive us a few moments to make sure that we\'ve got space for you. You will receive another email from us soon. If this request was made outside of our normal working hours, we may not be able to confirm it until we\'re open again.\r\n\r\n<strong>Your request details:</strong>\r\n{user_name}\r\n{party} people\r\n{date}\r\n\r\n&nbsp;\r\n\r\n<em>This message was sent by {site_link} on {current_time}.</em>\";s:22:\"subject-confirmed-user\";s:0:\"\";s:23:\"template-confirmed-user\";s:261:\"Hi {user_name},\r\n\r\nYour booking request has been <strong>confirmed</strong>. We look forward to seeing you soon.\r\n\r\n<strong>Your booking:</strong>\r\n{user_name}\r\n{party} people\r\n{date}\r\n\r\n&nbsp;\r\n\r\n<em>This message was sent by {site_link} on {current_time}.</em>\";s:21:\"subject-rejected-user\";s:0:\"\";s:22:\"template-rejected-user\";s:238:\"Hi {user_name},\r\n\r\nSorry, we could not accomodate your booking request. We\'re full or not open at the time you requested:\r\n\r\n{user_name}\r\n{party} people\r\n{date}\r\n\r\n&nbsp;\r\n\r\n<em>This message was sent by {site_link} on {current_time}.</em>\";s:20:\"subject-admin-notice\";s:0:\"\";s:12:\"booking-page\";i:0;s:14:\"party-size-min\";s:1:\"1\";s:10:\"party-size\";s:0:\"\";s:15:\"success-message\";s:0:\"\";s:11:\"date-format\";s:0:\"\";s:11:\"time-format\";s:0:\"\";s:3:\"i8n\";s:0:\"\";s:10:\"ban-emails\";s:0:\"\";s:7:\"ban-ips\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("281", "menucategory_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("286", "wpcf7", "a:1:{s:7:\"version\";s:3:\"4.7\";}", "yes");
INSERT INTO `wp_options` VALUES("292", "widget_pirate_forms_contact_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("293", "pirate_forms_settings_array", "a:35:{s:14:\"header_options\";s:0:\"\";s:20:\"pirateformsopt_email\";s:18:\"nejobest@gmail.com\";s:31:\"pirateformsopt_email_recipients\";s:18:\"nejobest@gmail.com\";s:20:\"pirateformsopt_store\";s:3:\"yes\";s:20:\"pirateformsopt_nonce\";s:3:\"yes\";s:28:\"pirateformsopt_confirm_email\";s:0:\"\";s:28:\"pirateformsopt_thank_you_url\";s:0:\"\";s:13:\"header_fields\";s:0:\"\";s:25:\"pirateformsopt_name_field\";s:3:\"req\";s:26:\"pirateformsopt_email_field\";s:3:\"req\";s:28:\"pirateformsopt_subject_field\";s:3:\"req\";s:28:\"pirateformsopt_message_field\";s:3:\"req\";s:30:\"pirateformsopt_recaptcha_field\";s:3:\"yes\";s:32:\"pirateformsopt_recaptcha_sitekey\";s:0:\"\";s:34:\"pirateformsopt_recaptcha_secretkey\";s:0:\"\";s:31:\"pirateformsopt_attachment_field\";s:0:\"\";s:13:\"header_labels\";s:0:\"\";s:25:\"pirateformsopt_label_name\";s:9:\"Your Name\";s:26:\"pirateformsopt_label_email\";s:10:\"Your Email\";s:28:\"pirateformsopt_label_subject\";s:7:\"Subject\";s:28:\"pirateformsopt_label_message\";s:12:\"Your message\";s:31:\"pirateformsopt_label_submit_btn\";s:12:\"Send Message\";s:15:\"header_messages\";s:0:\"\";s:29:\"pirateformsopt_label_err_name\";s:15:\"Enter your name\";s:30:\"pirateformsopt_label_err_email\";s:19:\"Enter a valid email\";s:32:\"pirateformsopt_label_err_subject\";s:22:\"Please enter a subject\";s:35:\"pirateformsopt_label_err_no_content\";s:30:\"Enter your question or comment\";s:27:\"pirateformsopt_label_submit\";s:41:\"Thanks, your email was sent successfully!\";s:11:\"header_smtp\";s:0:\"\";s:23:\"pirateformsopt_use_smtp\";s:0:\"\";s:24:\"pirateformsopt_smtp_host\";s:0:\"\";s:24:\"pirateformsopt_smtp_port\";s:0:\"\";s:38:\"pirateformsopt_use_smtp_authentication\";s:3:\"yes\";s:28:\"pirateformsopt_smtp_username\";s:0:\"\";s:28:\"pirateformsopt_smtp_password\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("303", "_site_transient_timeout_browser_8027a9bbe7d325857442871a6dc18ae5", "1488186568", "no");
INSERT INTO `wp_options` VALUES("304", "_site_transient_browser_8027a9bbe7d325857442871a6dc18ae5", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"43.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("313", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("370", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.34\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("371", "duplicator_version_plugin", "1.1.34", "yes");
INSERT INTO `wp_options` VALUES("372", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-23 06:37:32\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"10.1.9\";s:10:\"VersionPHP\";s:5:\"7.0.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:6:\"Vynara\";s:4:\"Hash\";s:29:\"58d36d2ca44f03548170323063732\";s:8:\"NameHash\";s:36:\"Vynara_58d36d2ca44f03548170323063732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://localhost/wordpress/wordpress/wp-snapshots/\";s:8:\"ScanFile\";s:46:\"Vynara_58d36d2ca44f03548170323063732_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"C:/xampp/htdocs/wordpress/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-23 06:37:32\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"10.1.9\";s:10:\"VersionPHP\";s:5:\"7.0.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:6:\"Vynara\";s:4:\"Hash\";s:29:\"58d36d2ca44f03548170323063732\";s:8:\"NameHash\";s:36:\"Vynara_58d36d2ca44f03548170323063732\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:52:\"C:/xampp/htdocs/wordpress/wordpress/wp-snapshots/tmp\";s:8:\"StoreURL\";s:50:\"http://localhost/wordpress/wordpress/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:31:\"mariadb.org binary distribution\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");
INSERT INTO `wp_options` VALUES("415", "wd_bwg_version", "1.3.30", "no");
INSERT INTO `wp_options` VALUES("416", "wd_bwg_theme_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("417", "widget_bwp_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("418", "widget_bwp_gallery_slideshow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("419", "bwg_admin_notice", "a:3:{s:15:\"ecommerce_promo\";a:3:{s:5:\"start\";s:8:\"3/7/2017\";s:3:\"int\";i:3;s:9:\"dismissed\";i:1;}s:15:\"two_week_review\";a:3:{s:5:\"start\";s:9:\"3/18/2017\";s:3:\"int\";i:14;s:9:\"dismissed\";i:1;}s:16:\"one_week_support\";a:3:{s:5:\"start\";s:9:\"3/11/2017\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("438", "cf7_style_no_temps", "show_box", "yes");
INSERT INTO `wp_options` VALUES("439", "cf7_style_welcome", "show_box", "yes");
INSERT INTO `wp_options` VALUES("440", "cf7_style_update_saved", "no", "yes");
INSERT INTO `wp_options` VALUES("441", "cf7_style_allow_tracking", "1", "yes");
INSERT INTO `wp_options` VALUES("442", "cf7_style_add_categories", "1", "yes");
INSERT INTO `wp_options` VALUES("443", "cf7_style_plugin_version", "3.1.1", "yes");
INSERT INTO `wp_options` VALUES("446", "style_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("447", "cf7_style_cookie", "1", "yes");
INSERT INTO `wp_options` VALUES("450", "CF7DBPlugin_NoSaveFields", "/.*wpcf7.*/,_wpnonce", "yes");
INSERT INTO `wp_options` VALUES("451", "CF7DBPlugin__version", "2.10.30", "yes");
INSERT INTO `wp_options` VALUES("452", "CF7DBPlugin__installed", "1", "yes");
INSERT INTO `wp_options` VALUES("453", "CF7DBPlugin_IntegrateWithCF7", "true", "yes");
INSERT INTO `wp_options` VALUES("454", "CF7DBPlugin_GenerateSubmitTimeInCF7Email", "false", "yes");
INSERT INTO `wp_options` VALUES("455", "CF7DBPlugin_IntegrateWithFSCF", "true", "yes");
INSERT INTO `wp_options` VALUES("456", "CF7DBPlugin_IntegrateWithJetPackContactForm", "true", "yes");
INSERT INTO `wp_options` VALUES("457", "CF7DBPlugin_IntegrateWithGravityForms", "true", "yes");
INSERT INTO `wp_options` VALUES("458", "CF7DBPlugin_IntegrateWithFormidableForms", "true", "yes");
INSERT INTO `wp_options` VALUES("459", "CF7DBPlugin_IntegrateWithWrContactForms", "true", "yes");
INSERT INTO `wp_options` VALUES("460", "CF7DBPlugin_IntegrateWithQuform", "true", "yes");
INSERT INTO `wp_options` VALUES("461", "CF7DBPlugin_IntegrateWithNinjaForms", "true", "yes");
INSERT INTO `wp_options` VALUES("462", "CF7DBPlugin_IntegrateWithCalderaForms", "true", "yes");
INSERT INTO `wp_options` VALUES("463", "CF7DBPlugin_IntegrateWithEnfoldThemForms", "true", "yes");
INSERT INTO `wp_options` VALUES("464", "CF7DBPlugin_IntegrateWithCFormsII", "true", "yes");
INSERT INTO `wp_options` VALUES("465", "CF7DBPlugin_IntegrateWithFormCraft", "true", "yes");
INSERT INTO `wp_options` VALUES("466", "CF7DBPlugin_IntegrateWithVerySimpleContactForm", "true", "yes");
INSERT INTO `wp_options` VALUES("467", "CF7DBPlugin_IntegrateWithFMS", "true", "yes");
INSERT INTO `wp_options` VALUES("468", "CF7DBPlugin_HideAdminPanelFromNonAdmins", "true", "yes");
INSERT INTO `wp_options` VALUES("513", "_site_transient_timeout_browser_9f9e25ceaeaa1fb01bdd1c917128134e", "1490625046", "no");
INSERT INTO `wp_options` VALUES("514", "_site_transient_browser_9f9e25ceaeaa1fb01bdd1c917128134e", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"51.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("516", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1490063476", "no");
INSERT INTO `wp_options` VALUES("517", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2017 18:14:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-40293\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.3 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/03/wordpress-4-7-3-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Mar 2017 17:53:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4696\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:396:\"WordPress 4.7.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7.2 and earlier are affected by six security issues: Cross-site scripting (XSS) via media file metadata.  Reported by Chris Andrè Dale, Yorick Koster, and Simon P. Briggs. Control characters can trick redirect [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"James Nylen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6191:\"<p>WordPress 4.7.3 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7.2 and earlier are affected by six security issues:</p>\n<ol>\n<li>Cross-site scripting (XSS) via media file metadata.  Reported by <a href=\"https://www.securesolutions.no/\">Chris Andrè Dale</a>, <a href=\"https://twitter.com/yorickkoster\">Yorick Koster</a>, and Simon P. Briggs.</li>\n<li>Control characters can trick redirect URL validation.  Reported by <a href=\"http://www.danielchatfield.com/\">Daniel Chatfield</a>.</li>\n<li>Unintended files can be deleted by administrators using the plugin deletion functionality.  Reported by <a href=\"https://hackerone.com/triginc\">TrigInc</a> and <a href=\"http://b.360.cn/\">xuliang</a>.</li>\n<li>Cross-site scripting (XSS) via video URL in YouTube embeds.  Reported by <a href=\"https://twitter.com/marcs0h\">Marc Montpas</a>.</li>\n<li>Cross-site scripting (XSS) via taxonomy term names.  Reported by <a href=\"https://profiles.wordpress.org/deltamgm2\">Delta</a>.</li>\n<li>Cross-site request forgery (CSRF) in Press This leading to excessive use of server resources.  Reported by Sipke Mellema.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.3 contains 39 maintenance fixes to the 4.7 release series. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.7.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=component&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=keywords&amp;order=priority\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.3.</p>\n<p>Thanks to everyone who contributed to 4.7.3: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/asalce/\">asalce</a>, <a href=\"https://profiles.wordpress.org/blobfolio/\">blobfolio</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a>, <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a>, <a href=\"https://profiles.wordpress.org/bhargavbhandari90/\">Bunty</a>, <a href=\"https://profiles.wordpress.org/ccprog/\">ccprog</a>, <a href=\"https://profiles.wordpress.org/ketuchetan/\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jazbek/\">jazbek</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/matheusgimenez/\">MatheusGimenez</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/codegeass/\">Muhammet Arslan</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/reldev/\">reldev</a>, <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O&#8217;Rourke</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/triplejumper12/\">triplejumper12</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, and <a href=\"https://profiles.wordpress.org/wpfo/\">wpfo</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4696\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.7.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 19:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4676\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 4.7.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7.1 and earlier are affected by three security issues: The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2142:\"<p>WordPress 4.7.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7.1 and earlier are affected by three security issues:</p>\n<ol>\n<li>The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. Reported by David Herrera of <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>\n<li><code>WP_Query</code> is vulnerable to a SQL injection (SQLi) when passing unsafe data. WordPress core is not directly vulnerable to this issue, but we&#8217;ve added hardening to prevent plugins and themes from accidentally causing a vulnerability. Reported by <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>\n<li>A cross-site scripting (XSS) vulnerability was discovered in the posts list table. Reported by <a href=\"https://iandunn.name/\">Ian Dunn</a> of the WordPress Security Team.</li>\n<li>An unauthenticated privilege escalation vulnerability was discovered in a REST API endpoint. Reported by <a href=\"https://twitter.com/MarcS0h\">Marc-Alexandre Montpas</a> of Sucuri Security. *</li>\n</ol>\n<p>Thank you to the reporters of these issues for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.2.</p>\n<p>Thanks to everyone who contributed to 4.7.2.</p>\n<p>* Update: An additional serious vulnerability was fixed in this release and public disclosure was delayed. For more information on this vulnerability, additional mitigation steps taken, and an explanation for why disclosure was delayed, please read <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\">Disclosure of Additional Security Fix in WordPress 4.7.2</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45507:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">akshayvinchurkar</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">binarymoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">M&#225;rio Valney</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/krstarica\">net</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">Robert Jolly</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">WraithKenny</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 20 Mar 2017 14:31:15 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 10 Mar 2017 18:14:55 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}}s:5:\"build\";s:14:\"20170216215914\";}", "no");
INSERT INTO `wp_options` VALUES("518", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1490063476", "no");
INSERT INTO `wp_options` VALUES("519", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1490020276", "no");
INSERT INTO `wp_options` VALUES("520", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1490063484", "no");
INSERT INTO `wp_options` VALUES("521", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Donncha: How to Auto Schedule WordPress Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://odd.blog/?p=89500175\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://odd.blog/2017/03/18/how-to-auto-schedule-wordpress-posts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2759:\"<p>If you post to a WordPress blog on a regular basis like I do on <a href=\"https://inphotos.org/\">In Photos dot Org</a> you&#8217;ll no doubt recognise the fatigue that comes from adjusting the publish date every single time on a new post so it appears a day later. If you have multiple posts like on a daily photoblog you have to remember what day the last post was made and adjust the date accordingly. </p>\n<p>A few years ago I wrote a small plugin that I never released to help schedule posts. In the media uploader you could select multiple photos and click a few buttons to be brought to a new page where you could enter title, content and tags for each image. Based on this experience, I suggested it as an idea to one of the teams at Automattic who built <a href=\"https://postbot.co/\">Post Bot</a>. I used that for a long time and it has its strengths. If you&#8217;re posting content that has the same or similar tags you can copy and paste the tags from one post to another. I posted lots of black and white street images from my home town this way and it was super useful! </p>\n<p>I got tired of manually typing out tags, and unfortunately the site broke a few times, with posts not scheduling or one time they scheduled all in one go. Luckily the problems were quickly fixed. However, I started using the WordPress post editor again and scheduling a bunch of photos that way.</p>\n<p>Manually editing the publish date quickly became a chore. Lazarus, the form saver Chrome extension, would sometimes popup if I didn&#8217;t click exactly on the date, or as I said before I had to remember when the last post was made. They say there&#8217;s a plugin for everything, and there is for this too. Check out <a href=\"https://wordpress.org/plugins/publish-to-schedule/\">Publish to Schedule</a>.</p>\n<p>You tell &#8220;Publish to Schedule&#8221; which days and how many posts should be published and when you go into the post editor the next available date is picked for you! The date doesn&#8217;t change until you hit Publish but I already used it to schedule a number of posts and it works really well.</p>\n<p><a href=\"https://odd.blog/files/2017/03/Screen-Shot-2017-03-14-at-17.21.11.png\"><img /></a></p>\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"https://odd.blog/2010/09/07/odd-games-of-bad-company-2/\" rel=\"bookmark\" title=\"Permanent Link: Odd games of bad company 2!\">Odd games of bad company 2!</a></li><li> <a href=\"https://odd.blog/2010/12/28/im-on-top-of-the-world/\" rel=\"bookmark\" title=\"Permanent Link: I&#8217;m on top of the world\">I&#8217;m on top of the world</a></li><li> <a href=\"https://odd.blog/2010/09/03/rage-quit-in-cod-4/\" rel=\"bookmark\" title=\"Permanent Link: Rage quit in COD 4!\">Rage quit in COD 4!</a></li></ul></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Mar 2017 16:50:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: GitHub Adds Plain English Explanations to License Pages for Open Source Projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67550\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/github-adds-plain-english-explanations-to-license-pages-for-open-source-projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2475:\"<p>GitHub took another step towards beefing up its support for open source projects this week with <a href=\"https://github.com/blog/2335-open-source-license-descriptions-and-metadata\" target=\"_blank\">a new feature that makes it easier to understand a project&#8217;s license</a>. If the project is using a popular open source license, GitHub will automatically add a short, plain-English description of the license and its permissions, conditions, and limitations. This allows GitHub users to see the implications of a project&#8217;s license at a glance.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/03/github-license-display.png?ssl=1\"><img /></a></p>\n<p>GitHub pulls this data from <a href=\"http://ChooseALicense.com\" target=\"_blank\">ChooseALicense.com</a>, the site it created in 2013 to help developers understand and select an open source license. The license descriptions and metadata are also open source and developers can incorporate them into their own projects using GithUb&#8217;s <a href=\"https://developer.github.com/v3/licenses/#get-an-individual-license\" target=\"_blank\">License API</a>.</p>\n<p>This new feature follows GitHub&#8217;s release of <a href=\"https://opensource.guide/\" target=\"_blank\">Open Source Guides</a> in February. The guides are a collection of 10 resources to help people get involved in open source, start their own open source projects, and manage large communities. The documents include helpful stories and tips from maintainers of successful open source projects.</p>\n<p>It was around this time last year that GitHub was <a href=\"https://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" target=\"_blank\">confronted by open source project maintainers with an open letter</a> of complaints regarding issue management. Nearly 2,000 maintainers signed the letter, requesting that GitHub prioritize features that open source project maintainers need. The company dragged its feet before eventually responding, while competing code hosting service GitLab capitalized on the situation with a new initiative focused on “<a href=\"https://gitlab.com/gitlab-org/gitlab-ce/issues/8938\" target=\"_blank\">making GitLab the best place for big open source projects</a>.” Over the past year, GitHub has consistently released new features and improved existing ones in affirmation of its continued support for open source projects.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Mar 2017 03:03:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: In Case You Missed It – Issue 19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=67590&preview=true&preview_id=67590\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wptavern.com/in-case-you-missed-it-issue-19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5660:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?ssl=1\" rel=\"attachment wp-att-50955\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>Apple Pay for WooCommerce</h2>\n<p>WooCommerce <a href=\"https://woocommerce.com/2017/03/apple-pay-woocommerce/\">announced</a> that Apple Pay is now available for stores accepting payments using Stripe. According to Marina Pape, WooCommerce is the first open source platform to integrate with Apple Pay.</p>\n<blockquote><p>We’re also proud to be the first open source platform to integrate with Apple Pay. Open source is the default for us, but it’s exciting to continue that level of openness with such an important payment solution.</p></blockquote>\n<h2>Human Made Makes Two Big Hires</h2>\n<p><a href=\"https://hmn.md/\">Human Made</a>, a web development agency based in the UK recently announced two big hires. The first is <a href=\"https://hmn.md/2017/03/16/mike-little-joins-human-made/\">Mike Little</a>, co-creator of the WordPress open source project, as a WordPress Specialist. The second is <a href=\"https://hmn.md/2017/03/17/jenny-beaumont-joins-human-made/\">Jenny Beaumont</a>, who will take on the role of Senior Project Manager.</p>\n<h2>Editor User Experience Survey</h2>\n<p>The WordPress core development team has <a href=\"https://make.wordpress.org/core/2017/03/15/editor-experience-survey/\">published a survey</a> seeking feedback and data on how people use the editor. The editor is likely the most commonly used feature in WordPress. This is an opportunity for those who use it to provide feedback.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://make.wordpress.org/core/2017/03/15/editor-experience-survey/\">Editor Experience Survey</a></p></blockquote>\n<p></p>\n<h2>Behind the Scenes of how Search works on the New WordPress Plugin Directory</h2>\n<p>Greg Brown <a href=\"https://data.blog/2017/03/15/improving-relevance-and-elasticsearch-query-patterns/\">published details</a> on Data.blog on how he improved the search relevancy for the new WordPress plugin directory using Elasticsearch. The post is technical in nature but provides great background information into how it works.</p>\n<blockquote><p>In improving the fidelity of search results, it’s not just a question of how we satisfy a single user’s search query, but how we satisfy thousands of users for each unique search term: which plugins will support that volume of users and their requests for support? Which are most likely to give all of these users a great WordPress experience?</p></blockquote>\n<h1 class=\"entry-title\">NextGEN Gallery Surpasses 17 Million Downloads</h1>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">NextGEN Gallery just reached over 17 million downloads. <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a></p>\n<p>&mdash; Imagely (@imagely) <a href=\"https://twitter.com/imagely/status/842532503265185792\">March 17, 2017</a></p></blockquote>\n<p></p>\n<h2>MainWP Reaches 1K Five-star Reviews</h2>\n<p>After three years of being on the <a href=\"https://wordpress.org/support/plugin/mainwp/reviews/?filter=5\">WordPress plugin directory</a>, the MainWP plugin has received <a href=\"https://mainwp.com/mainwp-reaches-1000-5-star-reviews/\">1,000 five-star reviews</a>.</p>\n<h2>Heather Burns HeroPress Essay</h2>\n<p>Heather Burns, founder of <a href=\"https://webdevlaw.uk/\">WebDevLaw</a>, published an <a href=\"https://heropress.com/essays/going-back-roots/?utm_source=twitter&utm_medium=hand-made&utm_term=going-back-roots&utm_content=first-tweet\">incredible essay</a> on HeroPress this week. Burns describes the hardships encountered with her first job and how it and other circumstances led her down the path of discovering WordPress.</p>\n<blockquote><p>By this point I’d started playing around with WordPress, and I learned about a local meetup group. I tiptoed in one night and awkwardly introduced myself and was welcomed right in.</p>\n<p>I realized over time that this was a very different sort of group. Everyone was grassroots volunteers, putting in the effort because they wanted to learn, not because they wanted social status. There was no tiresome hierarchy, no obsession with &#8216;prestige&#8217;, no kowtowing to the person with the sexiest car (in fact, we all took the bus.) If you had a question, you could ask it without being laughed out the room. No one was obliged to give anything more than they were able to give.</p></blockquote>\n<h2>HeroPress Wapuu!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project.</p>\n<img />HeroPress Wapuu\n<p>&nbsp;</p>\n<p>I present HeroPress Wapuu in celebration of HeroPress recently publishing <a href=\"https://heropress.com/heropress-at-100/\">its 100th essay. </a>If you&#8217;re a fan of HeroPress and want to see it flourish, please consider <a href=\"https://heropress.com/sponsorship/\">being a sponsor</a>.</p>\n<p>That&#8217;s it for issue nineteen. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Mar 2017 21:52:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Take the WordPress Editor Experience Survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67499\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/take-the-wordpress-editor-experience-survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2410:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/03/two-pencils.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/TBLSDTI1UL\">Joanna Kosinska</a>\n<p>WordPress core contributors have published a <a href=\"http://wordpressdotorg.polldaddy.com/s/editor-survey\" target=\"_blank\">survey</a> to collect feedback on how people are using the editor. The results of the short 15-question survey will assist the team in redesigning the editing experience in the WordPress admin.</p>\n<p>Participants are asked to identify how they use WordPress and if they use certain features like formatting buttons and distraction-free writing. The survey also asks how easy-to-use they consider the current editor to be and how organized it is. Users are also asked if they have ever installed a plugin that adds features to the editor, presumably to determine if there are features missing that should be considered for core.</p>\n<p>One question asks participants if they use any assistive technologies along with a screen reader. WordPress Accessibility team member Amanda Rush <a href=\"https://www.customerservant.com/wordpress-editor-experience-survey/\" target=\"_blank\">published some tips for screen reader users who want to take the survey</a>. It includes several questions with radio buttons and screenshots that are not so friendly to screen readers. Rush provides a general walk-through with more explanation for those who are using screen readers to participate.</p>\n<p>So far, this survey has been more widely shared than the design team&#8217;s recent customizer survey, which was <a href=\"https://wptavern.com/initial-customizer-survey-results-reveal-majority-of-respondents-dont-use-it\" target=\"_blank\">published after receiving just 50 results</a>. WordPress contributors rely heavily on these surveys to make decisions about projects they are working on, as they do not have any telemetry data about what features people are using or not using. This is one example where data could quickly demonstrate how widely the distraction-free writing mode has been adopted and show what editor formatting buttons people are using.</p>\n<p>If you have a few minutes over the weekend and want to contribute to the future of WordPress, take the <a href=\"http://wordpressdotorg.polldaddy.com/s/editor-survey\" target=\"_blank\">Editor Experience Survey</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Mar 2017 21:01:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: How to View Upcoming WordCamps in the WordPress Dashboard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/how-to-view-upcoming-wordcamps-in-the-wordpress-dashboard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2067:\"<p>Over the course of a year, WordCamps take place nearly every weekend. Although you can view <a href=\"https://central.wordcamp.org/schedule/\">upcoming events</a> on WordCamp Central, a relatively new plugin exist that enables you to see upcoming WordCamps on the WordPress Dashboard.</p>\n<p>It&#8217;s called <a href=\"https://wordpress.org/plugins/wc-dashboard-widget/\">WordCamp Dashboard Widget</a> developed by <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>. Once activated, a new widget appears on the dashboard that lists upcoming WordCamps. Data is retrieved by using the public <a href=\"https://central.wordcamp.org/wp-json/posts?type=wordcamp%29\">JSON API</a> available on WordCamp Central, is stored in a transient, and refreshed every day to reflect new data.</p>\n<img />Upcoming WordCamps Widget\n<p>Users can adjust the number of camps shown per page, sort events by location, date, or Twitter information. You can also display this information on any post or page using the [wordcamps] shortcode. The locations are linked to the event&#8217;s official WordCamp page. The @ symbol links to the official Twitter account associated with the event and the # symbol links to the official hashtag.</p>\n<p>During testing I noticed that the Twitter account for some events was either missing or incorrect. For example, WordCamp London links to <a href=\"https://twitter.com/wcldn\">@wcldn</a> when it should link to <a href=\"https://twitter.com/WordCampLondon\">@WordCampLondon</a>. I&#8217;m not a fan of the way dates are presented in a Day/Month/Year format as I prefer Month/Day/Year.</p>\n<p>Bohra is continuing to improve the plugin with an option to refresh data, improve data fetching, and more filtering options for 1.0. I tested the plugin on a site running WordPress 4.8 alpha and didn&#8217;t encounter any issues. If you encounter a bug or have feedback, you can submit a new issue on the <a href=\"https://github.com/lubusIN/wordcamp-dashboard-widget/issues\">project&#8217;s GitHub page. </a></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Mar 2017 20:09:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"WPTavern: Jetpack Introduces Theme Installation from WordPress.com, Sparks Controversy with Alternative Marketplace for Free Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67531\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"https://wptavern.com/jetpack-introduces-theme-installation-from-wordpress-com-sparks-controversy-with-alternative-marketplace-for-free-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12403:\"<p>Today Jetpack <a href=\"https://jetpack.com/2017/03/16/165-beautiful-free-themes/\" target=\"_blank\">announced</a> that its users now have access to a collection of 165 free themes from WordPress.com. Jetpack users can browse, preview, and activate themes by visiting the <a href=\"https://wordpress.com/design\" target=\"_blank\">WordPress.com Theme Showcase</a>. WordPress.com has also added the ability for Jetpack users to upload a theme from its interface as well, a feature that targets those who are heavily using Jetpack Manage instead of the WordPress admin.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/03/jetpack-theme-install.png?ssl=1\"><img /></a></p>\n<p>Many of the free themes are already available from <a href=\"https://wordpress.org/themes/author/automattic/\" target=\"_blank\">Automattic&#8217;s account</a> on the WordPress.org Themes Directory, but the limitations of the preview functionality doesn&#8217;t present themes in their best light. The Theme Review Team added a new rule last year that theme authors can only upload one theme at a time and will have to wait for it to pass through the queue before submitting another. This severely restricts individuals and companies that are prolific theme authors, requiring them to wait months in the queue. Authors can realistically expect to only publish one or two themes per year on WordPress.org.</p>\n<p>After Zerif Lite, one of the most popular themes on WordPress.org, was <a href=\"https://wptavern.com/zerif-lite-returns-to-wordpress-org-after-5-month-suspension-and-63-decline-in-revenue\" target=\"_blank\">suspended for five months</a> for violations of content portability requirements, Matt Mullenweg was one of the most vocal opponents of what he <a href=\"https://wptavern.com/zerif-lite-returns-to-wordpress-org-after-5-month-suspension-and-63-decline-in-revenue#comment-210935\" target=\"_blank\">called</a> &#8220;draconian requirements.&#8221; In 2015, Mullenweg went so far to <a href=\"https://wordpress.slack.com/archives/themereview/p1432861605003292\" target=\"_blank\">say</a> that he is &#8220;completely okay with having something in the directory that breaks every guideline, as long as it’s interesting.&#8221;</p>\n<p>The Theme Review Team has not made significant changes that would give authors more freedom. Instead, much of the Team&#8217;s time seems to be spent looking for ways to reduce the queue. It&#8217;s no wonder that a company like Automattic, with the infrastructure of Jetpack Manage and WordPress.com, would choose to distribute themes via a more efficient route. However, this move has left some WordPress.org theme authors wondering if WordPress.org improvements will be less of a priority in the future.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Can you blame him? No. They (he?) needs to wrangle in the experience, avoid fragmentation, compete with other consumer hosted platforms.</p>\n<p>&mdash; Matt Medeiros (@mattmedeiros) <a href=\"https://twitter.com/mattmedeiros/status/842406199551221760\">March 16, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">But what does it all mean for us surviving off of the .org distribution? Tough cookies, that\'s what.</p>\n<p>&mdash; Matt Medeiros (@mattmedeiros) <a href=\"https://twitter.com/mattmedeiros/status/842406347324948481\">March 16, 2017</a></p></blockquote>\n<p></p>\n<p>&#8220;Today&#8217;s announcement is the glue that holds together Matt&#8217;s vision for the future .org experience, delivered via Jetpack,&#8221; WordPress.org theme author <a href=\"http://mattreport.com\" target=\"_blank\">Matt Medeiros</a> said. &#8220;Solving the dark cloud above the repo seems a lot less critical when we can throw Jetpack in front of users as an alternative. It&#8217;s a calculated measure to control the on-boarding experience of new users, which WP desperately needs for continued growth amidst a field of competitors like Wix and Squarespace.&#8221;</p>\n<p>According to Jetpack team member Richard Muscat, WordPress.com has &#8220;no immediate plans to sell themes at this time.&#8221; Jetpack users have access to free themes but will not, in the foreseeable future, be invited to purchase WordPress.com&#8217;s commercial themes. The team also plans to continue its presence on WordPress.org.</p>\n<p>&#8220;We have no plans to stop releasing themes into the .org directory,&#8221; Muscat said. &#8220;We just believe this makes an even nicer, more integrated experience for accessing the themes we offer on the WordPress.com side of things.&#8221;</p>\n<p>Jetpack&#8217;s announcement has also reignited fears of what the plugin&#8217;s commercialization might do to the WordPress ecosystem. In the past, Mullenweg has <a href=\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\" target=\"_blank\">identified both Jetpack and WooCommerce as &#8220;multi-billion dollar opportunities&#8221;</a> that could each individually be larger than WordPress.com. If WordPress.org is failing to attract new users with its theme previews, then Jetpack/WordPress.com is likely to pull even more eyes away with its separate marketplace.</p>\n<p>&#8220;As a small business (a label that&#8217;s critical) product creator, I see this as a motion in the direction to increase the visibility of Jetpack&#8217;s free/paid feature set, above the rest of us trying to desperately make a living out here,&#8221; Medeiros said. &#8220;Jetpack will be marketed as the one-stop-solution for all of your small business website needs, if that hasn&#8217;t already been woven into the fabric of it&#8217;s current messaging. It is ultimately positioning itself as the trusted source of functionality for new users, versus us &#8216;third-party&#8217; plugins. After all, who wouldn&#8217;t trust the company &#8216;behind WordPress?\'&#8221;</p>\n<p>Ionut Neagu, CEO at <a href=\"https://themeisle.com/\" target=\"_blank\">Themeisle.com</a>, and the author of Zerif Lite, shares Medeiros&#8217; concerns about Jetpack&#8217;s more recent commercialization efforts.</p>\n<p>“What worries me more is the speed at which Automattic is pushing Jetpack,&#8221; Neagu said. &#8220;The Personal plan was introduced, and yesterday I got a cold email from some company they work with promoting their affiliate program. Today themes were introduced. It makes me wonder how far they plan to go and how this will affect theme and plugin developers.&#8221;</p>\n<p>However, Neagu takes a more optimistic stance on self-hosted users installing themes from WordPress.com.</p>\n<p>&#8220;As a theme author, I am not that worried about this particular aspect. Right now those themes are quite hard to find (it took me 10 minutes), are more targeted towards people using Jetpack Manage, and as far as I can see lots of them are looking a bit outdated.&#8221;</p>\n<p>Neagu sees a disconnect between what WordPress.org thinks users want and what they are actually looking for. Based on his research and experience selling themes, Neagu has found that users still expect complete solutions from themes. WordPress has grown beyond being just a blogging platform. Neagu said he hopes WordPress.org&#8217;s research for the new editor will reveal how many people are actually using the software for business.</p>\n<p>&#8220;We run a themes directory as well and we did extensive heatmaps to understand what kind of themes/screenshots users click on/ like,&#8221; Neagu said. &#8220;Looking at the results of a &#8216;business&#8217; query, I am quite sure that users won’t be excited.&#8221;</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/03/business-themes.png?ssl=1\"><img /></a></p>\n<p>This is likely the first iteration, and data from more Jetpack users should help WordPress.com refine the queries to present a mix of newer and popular themes. At the moment it looks to be simply a way to offer all of their available themes without the red tape of WordPress.org.</p>\n<h3>Automattic Addresses Confusion Over WordPress.org Plugin Directory Guideline Regarding Executable Code and Installs</h3>\n<p>The news of WordPress.com installing and updating themes for Jetpack users gave rise to speculation about whether or not this move is a violation of the <a href=\"https://developer.wordpress.org/plugins/wordpress-org/detailed-plugin-guidelines/\" target=\"_blank\">plugin directory guidelines</a>. Discussions centered around guideline #8, which states that plugins may not send executable code via third-party systems:</p>\n<blockquote><p>Serving updates or otherwise installing plugins, themes, or add-ons from servers other than WordPress.org’s.</p></blockquote>\n<p>Jetpack representative Richard Muscat gave us the following statement on behalf of Automattic:</p>\n<blockquote><p>The guidelines prohibit _plugins_ from installing third party code directly but Jetpack doesn’t do that for this feature. The guidelines state that: “Executing outside code within a plugin *when not acting as a service* is not allowed.”</p>\n<p>The service Jetpack provides with respect to themes is via WordPress.com which _is_ acting as a service. This is identical to how Akismet operates with respect to spam-filtering and other Jetpack services such as data sync and backup, content delivery (Photon), and plugin installation/updates.</p>\n<p>We ask users to opt-in to WordPress.com services when connecting Jetpack and all our services follow established guidelines.</p></blockquote>\n<p>The public discussions also prompted WordPress.org Plugin Directory representatives to <a href=\"https://make.wordpress.org/plugins/2017/03/16/clarification-of-guideline-8-executable-code-and-installs/\" target=\"_blank\">post</a> an article clarifying that Jetpack is not in violation for installing themes.</p>\n<p>&#8220;The trick here, and this is what is about to sound like hair splitting, is that it’s not the plugin UI on your site that does the install,&#8221; Mika Epstein said. &#8220;In order for Manage WP and Jetpack to work, you have to go to your panel on their sites and install the items.&#8221;</p>\n<p>As SaaS products have not yet been used extensively in the WordPress ecosystem, developers are still figuring out how this type of implementation can interact with WordPress sites via plugins installed from the official directory. The plugin team clarified that if you are pushing plugin or theme installs or updates from a third-party service on its website, then it is no longer a third-party service but rather a first-party service where you are directly initiating those actions.</p>\n<p>However, not all developers agree that this distinction makes any difference.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/daljo628\">@daljo628</a> <a href=\"https://twitter.com/TheJeffMatson\">@thejeffmatson</a> <a href=\"https://twitter.com/williamsba\">@williamsba</a> <a href=\"https://twitter.com/chriswallace\">@chriswallace</a> <a href=\"https://twitter.com/mattmedeiros\">@mattmedeiros</a> Saying SaaS can install plugins but plugin cannot install plugins is silly.</p>\n<p>&mdash; Carl Hancock <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> (@carlhancock) <a href=\"https://twitter.com/carlhancock/status/842485294863712256\">March 16, 2017</a></p></blockquote>\n<p></p>\n<p>Gravity Forms founder Carl Hancock contends that ManageWP is different in that it doesn&#8217;t provide users with themes and plugins &#8211; it&#8217;s just a service for managing your sites.</p>\n<p>&#8220;You can install plugins from the WordPress.org plugin and theme repository, you can connect your Dropbox account and install plugins from your Dropbox account, or you can upload your own plugins,&#8221; Hancock said. &#8220;The key is it’s either plugins and themes from WordPress.org OR bring your own. Just like WordPress itself.</p>\n<p>&#8220;They [ManageWP] do not provide an alternative repository of themes and/or plugins that competes with the WordPress.org repos.&#8221;</p>\n<p>This is where much of the controversy lies for WordPress.org theme authors who depend on the official directory for distribution. Competing with equally free themes that are hosted on WordPress.com with a much better sorting UI and preview functionality is a new challenge they will have to embrace.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Mar 2017 00:08:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"WPTavern: U.S. Department of Defense Launches Code.mil Open Source Initiative, First Release Tests Impact of AGPL Licensing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67451\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://wptavern.com/u-s-department-of-defense-launches-code-mil-open-source-initiative-first-release-tests-impact-of-agpl-licensing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7190:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/03/department-of-defense.jpg?ssl=1\"><img /></a>A U.S. Air Force F-15E Strike Eagle aircraft flies over northern Iraq Sept. 23, 2014, after conducting airstrikes in Syria. &#8211; photo credit: <a href=\"https://www.flickr.com/photos/39955793@N07/15172530147/\">U.S. Department of Defense</a>\n<p>The U.S. Department of Defense (DoD) is <a href=\"https://www.defense.gov/News/News-Releases/News-Release-View/Article/1092364/dod-announces-the-launch-of-codemil-an-experiment-in-open-source\" target=\"_blank\">experimenting with open sourcing more of its code</a> on GitHub. <a href=\"http://Code.mil\" target=\"_blank\">Code.mil</a> invites developers from around the world to collaborate with federal employees on unclassified code. The Defense Digital Service (DDS), which brings in experts from top technology companies like Google, Amazon, and Netflix for short assignments, is organizing the initiative to open source more government code.</p>\n<p>&#8220;Open source and free software (which refers to software freedom, not free of cost) are industry best practices and integral parts of modern software development,&#8221; the department said in a <a href=\"https://www.defense.gov/News/News-Releases/News-Release-View/Article/1092364/dod-announces-the-launch-of-codemil-an-experiment-in-open-source\" target=\"_blank\">statement</a> announcing the initiative. &#8220;They, however, are concepts yet to be widely adopted within the department. With Code.mil, DoD can access a depth and breadth of technical skill previously underutilized while offering software tools created by the government for free public use.&#8221;</p>\n<p>The FAQ document for the initiative states that &#8220;modern software is open sourced software&#8221; and that the department is aiming to more actively participate in the open source and free software communities.</p>\n<p>Licensing is one of the unique challenges of making government code open source, as code written by federal employees is not protected by copyright under U.S. laws. After consulting the Open Source Initiative and Free Software Foundation, the DoD devised an open source licensing strategy where code written by federal employees will fall under the public domain with no restrictions. DDS developed a GitHub webhook to ensure commits from government employees follow the <a href=\"https://developercertificate.org/\" target=\"_blank\">Developer Certificate of Origin</a> process. Private sector contributions will be protected by standard OSS licenses. This is outlined in the <a href=\"https://github.com/deptofdefense/code.mil/blob/master/Proposal/INTENT.md\" target=\"_blank\">INTENT.md</a> document on the Code.mil repository.</p>\n<h3>Code.mil&#8217;s First Open Source Project Released Under AGPL to &#8220;Test GPL as an Approach&#8221;</h3>\n<p>In addressing one person&#8217;s <a href=\"https://github.com/deptofdefense/code.mil/issues/19#issuecomment-282333798\" target=\"_blank\">feedback</a> advocating for all Code.mil projects to be MIT-licensed, DDS engineer Tom Bereknyei confirmed that the team will leave this decision to each project&#8217;s leadership.</p>\n<p>&#8220;We&#8217;ve had these same discussions internally,&#8221; Bereknyei said. &#8220;We did not want to endorse a particular license and we intend each project to decide which license is appropriate for them. Some may choose MIT, BSD, Apache, or eventually GPL. We did not want to take that choice away from them.&#8221;</p>\n<p><a href=\"https://github.com/deptofdefense/eMCM\" target=\"_blank\">eMCM</a>, a web-based viewer for the Manual for Courts-Martial (MCM), is the first open source project to be released on Code.mil. It provides a canonical &#8220;live&#8221; edition of the manual that is easier to access and maintain than previous versions. eMCM was released this week under the AGPL license.</p>\n<p>&#8220;We chose to use the Affero General Public License (AGPL) for the eMCM because every military member has the right to know how the raw legal code (i.e., MCM) will be transformed or manipulated by the eMCM,&#8221; the Defense Digital Service stated in the <a href=\"https://medium.com/@DefenseDigitalService/code-mil-an-open-source-initiative-at-the-pentagon-5ae4986b79bc#.f9bw1s2ha\" target=\"_blank\">announcement</a>. &#8220;Applying the AGPL is a small but important way to help ensure the public has that freedom and transparency to the process.&#8221;</p>\n<p>In the pull-request for <a href=\"https://github.com/deptofdefense/eMCM/pull/5\" target=\"_blank\">updating the license on the project</a>, Bereknyei explained why he proposed the AGPL:</p>\n<blockquote><p>It&#8217;s a user-facing project, not a library. Ultimately it would be good to preserve the rights of the public to inspect how the raw MCM is transformed by the viewer.</p>\n<p>Among the projects we have, this seems to be the best candidate for a GPL test. It is fairly self contained, doesn&#8217;t integrate with any systems, front-end heavy, small enough that a corporate rewrite is easy, and uses only a few libraries. My goal is only to test GPL as an approach. If this project isn&#8217;t suited, I&#8217;m sure we can find another.</p></blockquote>\n<p>When Bereknyei was questioned by DDS colleague Nicholas Small about why he opted for AGPL over MIT, he said he wanted to protect the code from being redistributed as closed-source.</p>\n<p>&#8220;MIT would allow someone to fork, improve, and release closed-source,&#8221; Bereknyei said. &#8220;The rule of thumb I am trying to apply is that when the rights/convenience for developers are more important, go with MIT/BSD/ISC. When the rights/convenience for users are more important, go with GPL.&#8221;</p>\n<p>Historically, the DoD has <a href=\"http://dodcio.defense.gov/Open-Source-Software-FAQ/#Q:_When_a_DoD_contractor_is_developing_a_new_system.2Fsoftware_as_a_deliverable_in_a_typical_DoD_contract.2C_is_it_possible_to_use_existing_software_licensed_using_the_GNU_General_Public_License_.28GPL.29.3F_Can_the_DoD_used_GPL-licensed_software.3F\" target=\"_blank\">used GPL-licensed software extensively</a> and even <a href=\"http://dodcio.defense.gov/Open-Source-Software-FAQ/#Q:_What_license_should_the_government_or_contractor_choose.2Fselect_when_releasing_open_source_software.3F\" target=\"_blank\">recommends government contractors select a GPL-compatible license</a> when developing software as a deliverable in DoD contracts.</p>\n<p>One beneficial byproduct of the DoD&#8217;s initiative to open source more code is that the public can watch and participate as federal employees discuss license selection in the open. The department is finally recognizing that taxpayer-funded code is a public good and inviting private sector professionals to the table to build modern software together. Anyone can open an issue or pull request, regardless of their background, location, or formal qualifications. The DoD plans to expand <a href=\"https://github.com/deptofdefense/code.mil\" target=\"_blank\">Code.mil</a> to include projects from other DoD offices and may develop it into a full-fledged website instead of simply redirecting to GitHub.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Mar 2017 04:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: WPWeekly Episode 267 – Interview With Aaron D. Campbell, WordPress Security Team Lead\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=67502&preview=true&preview_id=67502\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/wpweekly-episode-267-interview-with-aaron-d-campbell-wordpress-security-team-lead\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2376:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://aarondcampbell.com/\">Aaron D. Campbell</a>, WordPress Security Team Lead. Campbell provides insight into who&#8217;s on the team and what they do behind the scenes to coordinate security releases. We discuss the complex nature of <a href=\"https://aarondcampbell.com/tag/disclosure/\">disclosures</a>, when to publish them, and how much information they should have.</p>\n<p>In light of <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\">WordPress 4.7.2</a>, Campbell shares the lessons he learned and how they&#8217;ll be applied to future releases. If you&#8217;ve ever wondered about the security aspects of WordPress, this is the episode for you.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/woocommerce-3-0-0-scheduled-for-release-april-4th\">WooCommerce 3.0.0 Scheduled for Release April 4th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/fb-live-chat/\">Facebook Live Chat for WordPress</a> makes it easier for customers to connect with businesses via Facebook Messenger.</p>\n<p><a href=\"https://wordpress.org/plugins/cf7-database/\">Contact Form 7 Database</a> saves submissions from Contact Form 7 to the database for future reference. You can also view them in the WordPress backend.</p>\n<p><a href=\"https://wordpress.org/plugins/total-spent-by-customer-for-woocommerce/\">Total Spent by Customer for WooCommerce</a> adds a sortable column to the users list to show how much the user spent on your WooCommerce Store. This is useful to figure out who your top customers are.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 22nd 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #267:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Mar 2017 22:36:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"HeroPress: Going Back To My Roots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://heropress.com/essays/going-back-roots/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16907:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/031517-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Thanks to the WordPress Community, I\'ve made friends for life, travelled to new places, and had adventures I never thought possible,\" /><p>“Get out there and look at that f****n car. <em>Look at that f****n car!</em>”</p>\n<p>And all of the good little office girls jumped up and ran outside to ogle and coo over the chairman’s latest “prestige motor.”</p>\n<p>Me being me – someone who couldn’t care less about cars, or massaging the needy egos of the men who feel a need to show them off – I stayed sat at my desk and carried on with my work.</p>\n<p>My absence outside would be noted, and would not do me any favours.</p>\n<p>I had taken a job at a local business support organisation because I needed the work. I’d been told that my experience and abilities could benefit the organisation and, by extension, the local business community. The joke was on me.</p>\n<p>In truth, the organisation was a back-slapping boys&#8217; club which didn&#8217;t even have a business plan. Its main income source was, and remains to this day, the revenue from a vanity awards dinner, where members nominate themselves for meaningless awards and then pay thousands of pounds to find out if they won. Beyond that, its sole purpose was to provide the board and management with &#8220;prestige and status&#8221; (my manager&#8217;s words, not mine.) The office atmosphere was so toxic that the HR manager, faking every excuse in the book, hadn&#8217;t bothered to show up in months, which meant that I never saw a job description, had a performance review, or was signed up for the company pension; in fact, the only way I got a contract was by going in on a Saturday to type it up myself. It was all pretty ironic for an organisation which officially exists to support other businesses.</p>\n<p>But bills need to be paid, so I kept my head down and did my work and breathed deeply through the increasingly dysfunctional dramas of the board and management.</p>\n<blockquote><p>Believing that you can keep calm and avoid office politics in a dysfunctional workplace is a unique form of denial.</p></blockquote>\n<p>By showing up for work in the morning, observing the backstabbing behavior around you, and keeping your nose above the parapet, you make yourself easy pickings.</p>\n<p>It did not help that my job required me to read certain documents, pass on certain email exchanges, see certain expense receipts, and take minutes at certain meetings. I knew everything. I knew what everyone was up to. I knew too much.</p>\n<p>The things I knew too much about erupted violently in the space of a fortnight. Sackings, retaliatory sackings, accusations, slanders, backstabs, screaming, lies, people literally being escorted out the back door, people breaking into file cabinets and document storage, the whole ugly lot.</p>\n<p>I decided life was too short to put up with that nonsense and scurried off the sinking ship. Unemployment was preferable to working in a dysfunctional war zone.</p>\n<p>A few days later I was sitting in my living room in my pajamas (as unemployed people do), staring blankly at the Christmas tree, barely aware if it was day or night, my head still spinning about what had just happened and what I was going to do next. Then there was a knock at the door. The postman, I assumed.</p>\n<p>No, it was the police. They wanted to come in. So they did.</p>\n<p>Allegations had been made. Statements had been taken. Criminal charges would be filed.</p>\n<p>Against me.</p>\n<p>Merry Christmas.</p>\n<p>Merry Christmas to you too, I replied as I saw them out.</p>\n<p>Because that’s how office politics work, folks. You don&#8217;t walk away from egomaniacs on your own terms. That implies there is something wrong with them. They have to take you down on their own terms. That implies there is something wrong with you. You may think you have left the backstabbers to get on with their petty games without you taking the meeting minutes and processing the strip club expense receipts. You&#8217;re wrong. They have got to find a way to take you down and make you keep your mouth shut. And they will.</p>\n<h3>Moving On</h3>\n<p>I moved on with my life. I found a stable temp job which had the option to go permanent, and I was quite content with it. I even almost forgot about the police visit. The Scottish justice system, you see, is notoriously slow. So when a letter arrived four months later informing me that I would be standing in a criminal trial at the local sheriff court, I threw up.</p>\n<p>I was throwing up all the time at that point because I had just found out I was pregnant.</p>\n<p>Most women spend pregnancy in a dreamy haze surrounded by friends, family, and affection. I spent it taking unpaid breaks from my temp jobs to meet with a legal aid solicitor (being unemployed and on a temp wage, I couldn’t afford to pay a lawyer) to plan my defence. He was nice enough, but was clearly not sure what to make of the whole situation. He was used to dealing with actual crimes – stabbings, domestic assaults, and the like. And there was a five foot two pregnant lady in front of him explaining all the plot twists and characters in this pathetic real-life soap opera. He probably looked forward to getting back to the stabbings.</p>\n<p>In the meantime, for health and safety reasons, I had to inform my temp employer about the pregnancy. The permanent job offer evaporated instantly.</p>\n<blockquote><p>I spent the rest of my time taking whatever demeaning temp admin jobs a heavily pregnant woman could get in order to work the minimum number of days required to qualify for the basic state maternity allowance, which at the time was £106 a week for six months.</p></blockquote>\n<p>Suffice to say my dignity took a bit of a beating that year.</p>\n<p>By the time the date of preliminary hearing rolled around – again, the Scottish justice system being as slow as it is – I was on the edge of my third trimester. And so there I was, standing alone in the dock in a criminal courtroom, in sheriff court, next to drug dealers and knife thugs, wearing a hideous Marks and Spencer maternity dress, to plead not guilty to something that had never happened.</p>\n<p>All of that because of office politics.</p>\n<p>Now, the thing about legal aid is that you get what you pay for. My solicitor didn’t show up. He faxed an instruction to one of the solicitors at the sheriff court who acts on behalf of others in those matters. In hindsight, this was a strategy to suggest to the court that the case was so stupid it was not worth showing up for. On the day, though, I was completely, totally, alone, left to stand up and speak for myself.</p>\n<blockquote><p>The only person I had in the world to support me was kicking furiously in my stomach, as if to say: go, mum, go.</p></blockquote>\n<p>At that moment I had an insight. This, I realised, is it. This is the low point of my life. This is absolute rock bottom. It does not get any worse than this. From here, you can’t go any lower. It is only up from here. And that, standing there in that dock, was strangely liberating.</p>\n<p>Now here’s the thing about elderly male judges in curly 18th century wigs. They’re not stupid. He took one look at the charge sheet, one look at the folder of statements and evidence against me, and one look at me. He asked the befuddled prosecuting solicitor what on earth was going on here; the solicitor replied that they were looking to gather more evidence against me. “And how much longer are we to wait for that? This was ten months ago,” he replied to her, very, very cross. This is all very interesting, I thought.</p>\n<p>Two days later my solicitor phoned: the judge had ruled the case was “not in the public interest.” That is Scottish legal parlance for “an absolute load of crap.” All charges were dropped; I would have no criminal record; I was done. I was finished. I was free.</p>\n<p>Well, free, unemployed, heavily pregnant, destitute, my reputation had been destroyed, and now I had a large hole in my CV which would be awfully difficult to explain. Other than that, I was fine.</p>\n<h3>Moving On Again</h3>\n<p>I went on state maternity pay early and took some time to get my head back together. That gave me the breathing space to realise a few things.</p>\n<p>One was that I was done with office life. That meant I would have to find something to do on my own.</p>\n<p>Two was that I was pretty good with this web stuff – I’d been making web sites since 1997, had been running a very popular web site since 1998, and had always been the go-to girl for the web site in everywhere I’d ever worked – and so I might as well do that for a living.</p>\n<p>And three was that I had learned the law is bloody terrifying if you let other people blindside you with it. If you know what you are looking at, where you stand within it, and how others are seeking to use it to further their position, you are no longer a hapless bystander to it. You are an equal participant with a fair chance. That is your choice to make.</p>\n<h3>Setting Up Shop</h3>\n<p>So I set up shop as a self-employed web designer, working quite happily from home with my biggest fan babbling next to me in the playpen. The money wasn’t great, but my stress levels were non-existent, and I had no co-workers to stab me in the back.</p>\n<p>Lack of co-workers should never mean lack of colleagues, though, and after a few years I realised local business networking groups simply weren’t for me. I also needed people other than the members of an ancient listserv to bounce questions and ideas off of in real-time. By this point I’d started playing around with WordPress, and I learned about a local meetup group. I tiptoed in one night and awkwardly introduced myself and was welcomed right in.</p>\n<p>I realised over time that this was a very different sort of group. Everyone was grassroots volunteers, putting in the effort because they wanted to learn, not because they wanted social status. There was no tiresome hierarchy, no obsession with “prestige”, no kowtowing to the person with the sexiest car (in fact, we all took the bus.) If you had a question, you could ask it without being laughed out the room. No one was obliged to give anything more than they were able to give.</p>\n<blockquote><p>In short, it was my kind of group, and these were my kind of people.</p></blockquote>\n<p>After a few years we got ambitious enough to decide to put on a conference (which due to various reasons was a WordPress conference but not a WordCamp – ah, the good old days.) We were short of speakers. I suggested to Martin, the lead organiser, that someone should do a talk on that “cookie law” thing that at the time was coming into play very shortly.</p>\n<p>“Thank you for volunteering,” said Martin.</p>\n<p>“You’re a b*****d, you know that, Martin?” I replied.</p>\n<p>So Martin sent me off to do my homework and put together this conference talk. I thought it would just be a simple slide deck: what the law is, how it works, how to comply. Much to my surprise, putting that talk together changed my life.</p>\n<h3>The Old Becomes New</h3>\n<p>As I sat at my laptop, doing the research, I felt something strange stirring. It was old me.</p>\n<p>Old me, who had done an undergraduate degree in international politics. Old me, who’d been a policy intern at think tanks and research centers. Old me, who’d sat in Congressional committees and worked on the Hill and ate politics for breakfast. Old me who’d trained very hard to do one thing and had gotten sidetracked by real life and was now doing something else because something bad had happened. Old me was now new me reading the full text of a piece of EU legislation about how the internet is supposed to work while shouting at my laptop screen, “there is no bloody way that is ever going to work,” while my biggest fan looked at me baffled and then asked me for a cup of juice.</p>\n<blockquote><p>Whoever I was now, and whatever crap had happened to me in those intervening years, I was back.</p></blockquote>\n<p>That conference talk turned into an obsession. I began writing about law and policy issues that impact our work – be it regulations on accessibility, e-commerce, privacy and data protection, taxation, UX, contracts, copyright, geoblocking, or any of the smaller issues that touch our work every day. I even became a student again and earned a postgraduate certification in internet law and policy from the University of Strathclyde. I still did the client-facing web work but my enthusiasm for it waned by the month.</p>\n<p>At WordCamp London 2015 I gave a talk on various digital policy issues, then spent the rest of the time sitting in the track devoted to charity and not-for-profit web sites, as that was what my business did. As the speakers gave their superb talks I felt myself sinking lower in my chair. Another insight. Oh, woman, you’re in the wrong job. This isn’t what you are supposed to be doing. For the first time I asked myself why I was devoting such passion to the digital policy side while still carrying on with a web design business I started up to give myself a job with a newborn baby. A few months later I was flown out to Seville on a few days’ notice to speak at WordCamp Europe, where I replaced a speaker who had been hospitalised. I felt a tremendous sense of obligation because of that – it was deeply humbling to be given an opportunity because of someone else’s illness – and I resolved to do more to give back to the WordPress community.</p>\n<p>I hung up my web design mouse in the autumn of that year. I still do odd bits and bobs for a handful of existing clients but I now focus entirely on digital law and policy. My blog is read by the UK Parliament, the European Commission, and the US Department of State. I speak to non-WordPress groups ranging from Joomla developers to Ruby programmers, but WordPress remains my home and my community. I encourage members of the community to respect the law and to work within it, not to fear it. I think, all things considered, I’m more than qualified to understand why that’s true.</p>\n<p>Thanks to the WordPress community I’ve made friends for life, travelled to new places, and had adventures I never thought possible. I’ve built a new career while connecting with the important things I thought I had left behind. And last year when I was pickpocketed en route to a conference talk, the WordPress community in that city – none of whom I had ever met – leapt into action to provide me with food, beer, and hugs. In a strange city where I didn’t speak the language and had no money, being part of the community meant I didn’t have to be scared and alone.</p>\n<p>I&#8217;ve come a long way from that lonely courtroom dock.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Going Back To My Roots\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Going%20Back%20To%20My%20Roots&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fgoing-back-roots%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Going Back To My Roots\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fgoing-back-roots%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fgoing-back-roots%2F&title=Going+Back+To+My+Roots\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Going Back To My Roots\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/going-back-roots/&media=https://heropress.com/wp-content/uploads/2017/03/031517-150x150.jpg&description=Going Back To My Roots\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Going Back To My Roots\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/going-back-roots/\" title=\"Going Back To My Roots\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/going-back-roots/\">Going Back To My Roots</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Mar 2017 12:00:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Heather Burns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Bocoup Launches Study to Measure Impact of Open Work on Developer Well-Being\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/bocoup-launches-study-to-measure-impact-of-open-work-on-developer-well-being\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1980:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/06/survey.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/FI3UYVGNFD\">Lukasz Kowalewski</a>\n<p><a href=\"https://bocoup.com/\" target=\"_blank\">Bocoup</a>, an open source technology and design consulting company, is recruiting for a new study that aims to &#8220;measure the impact of open work on developer well-being and productivity.&#8221; The company is partnering with MIT and UCLA to develop an open work email-bot that will interact with organizations that sign up to participate. The study is open to teams that use source control.</p>\n<p>&#8220;We&#8217;re defining &#8216;open work&#8217; as a project where tasks/work product are/can be shared outside the group immediately responsible for those tasks,&#8221; Bocoup Director of Research Boaz Sender said.</p>\n<p>Participating organizations will get hooked up with Bocoup&#8217;s email-bot, which offers tools for recognizing team members or open source community members for their contributions to projects. Bocoup plans to publish the average results with the goal of educating businesses and policy makers about the value of open source work. Data from organizations participating in the study will be anonymized and untraceable.</p>\n<p>With all the new ways of working together on the web (GitHub, Slack, GitLab, etc.) it&#8217;s good to see a company prioritizing research on how this impacts developers. The study begins in March and will end in June. If you&#8217;re interested to have your organization be a part of it, you can find out more on the <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSc9sYreLFTZDxn-LuUhGCl043QDcagls9g0t_TbZ3Pd3ZnYNA/viewform?c=0&w=1\" target=\"_blank\">signup form</a> and get a better understanding of the time commitment on the <a href=\"https://docs.google.com/document/d/1EWD9c4cmIfyNVe4pGFsvPiLO83i1ZOij4mpF-cLVfTc/edit\" target=\"_blank\">FAQ</a> page.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Mar 2017 02:10:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: WooCommerce 3.0.0 Scheduled for Release April 4th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67438\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wptavern.com/woocommerce-3-0-0-scheduled-for-release-april-4th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4981:\"<p>Big changes are on the way for <a href=\"https://wordpress.org/plugins/woocommerce/\">WooCommerce</a>. Mike Jolley, lead developer of WooCommerce, <a href=\"https://woocommerce.wordpress.com/2017/03/13/important-update-regarding-the-upcoming-woocommerce-release-2-7-will-be-3-0-0/\">announced</a> that WooCommerce 2.7 will be versioned 3.0.0 with a scheduled release date of April 4th. During the 2.7 beta testing phase, the team discovered a <a href=\"https://github.com/woocommerce/woocommerce/issues/13498\">significant bug</a> in the way that timestamps are handled.</p>\n<p>&#8220;Essentially, some developers need a way to reliably get UTC timestamps as well as dates according to the site’s timezone,&#8221; Jolley said. &#8220;To resolve this we’re working on a solution which accepts <em>either</em> a UTC timestamp, or an ISO8601 datetime string, and returns a <a href=\"http://php.net/manual/en/class.datetime.php\">DateTime object</a> so timezone information can be retrieved if needed. This approach is not compatible with the <code>get_date_x</code> getters found in 2.7 beta.&#8221;</p>\n<p>Beginning with WooCommerce 3.0.0, the project will use semantic versioning or <a href=\"http://semver.org/\">SemVer</a>. WooCommerce has incrementally versioned its releases similar to WordPress. For example, WooCommerce 2.5, 2.6, 2.7. Semantic versioning allows for three digit version numbers and should make it easier to discern major versions from maintenance and bug fix releases. The three digits stand for major, minor, and patch.</p>\n<p>According to the <a href=\"http://semver.org/\">SemVer site</a>, each number is incremented when:</p>\n<ul>\n<li>MAJOR version for incompatible API changes.</li>\n<li>MINOR version when you add functionality in a backwards-compatible manner.</li>\n<li>PATCH version when you make backwards-compatible bug fixes.</li>\n</ul>\n<p>Under this system, WooCommerce 3.0.0 is a major update with 3.1.0 being a minor update. The next major update will be 4.0.0. Developers should take note that in 3.0.0 RC1, the versioning and @since properties are relabeled to 3.0.0. &#8220;If you have used version_compare statements in your code, they will still work since 3.0.0 is greater than 2.7.0, however, you can change these for clarity,&#8221; Jolley said. Themes with template files versioned 2.7.0 may need to be updated to use 3.0.0 to prevent reports of outdated template files.</p>\n<p>In addition to version changes and fixing major bugs, the team is allowing up to three weeks for 3.0.0 RC1 to be tested. The amount of time to test has been extended from one week to three <a href=\"https://woocommerce.wordpress.com/2017/02/17/woocommerce-2-7-beta-3/#comment-2589\">based on feedback </a>from extension developers.</p>\n<p>&#8220;An RC is really the first point in time when people can look at the code and feel confident it&#8217;s probably not going to change a lot before the official release,&#8221; Brent Shepherd, founder of <a href=\"http://prospress.com/\">Prospress Inc</a>. said. &#8220;With that in mind, having 3 months of beta testing, but only 1 week for the RC, doesn’t make a lot of sense. It makes sense to give more time in that later stage after the RC.&#8221;</p>\n<p>Josh Kohlbach, a WooCommerce extension developer, <a href=\"https://woocommerce.wordpress.com/2017/02/17/woocommerce-2-7-beta-3/#comment-2604\">also agreed</a> with extending the RC testing time. &#8220;Currently from our company’s perspective we’ve had to put other priorities on hold in order to put WC2.7 changes ahead,&#8221; Kohlbach said. &#8220;The 2.7 changes we were holding off on doing until RC, which is what we normally do.&#8221;</p>\n<p>&#8220;However, when it was announced that there would be only one week between, we figured that wouldn’t be enough time for proper testing and pushing updates on all of our products so we’re compatible on day one,&#8221; he said. &#8220;It just isn’t enough time so we, like many others by the sounds of it, started making our compatibility fixes around Beta 2 this time even though we knew there might be more changes coming down the pipe before RC gets here.&#8221;</p>\n<p>Extension developers are praising the team for changing to a semantic versioning system and extending the time to test Release Candidates. &#8220;I’m very happy to see these changes,&#8221; Shepherd said. &#8220;Big props for making the tough call late in the release cycle. Hopefully it will help ensure a smoother release for all WC users of this version.&#8221;</p>\n<p>&#8220;I think this is a really positive move forward for WooCommerce,&#8221; Kohlback said. &#8220;I for one want to thank you on behalf of all the third-party developers for being so open and taking on board all of our various points, really makes us happy to be part of the community!&#8221;</p>\n<p>If all goes well, you can expect to see an update for WooCommerce in your WordPress dashboard on April 4th.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Mar 2017 22:23:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Varying Vagrant Vagrants 2.0.0 Introduces YAML Configuration, Revamps Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67436\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/varying-vagrant-vagrants-2-0-0-introduces-yaml-configuration-revamps-documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4545:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/03/vvv-github.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://varyingvagrantvagrants.org/blog/2017/03/13/varying-vagrant-vagrants-2-0-0.html\" target=\"_blank\">Varying Vagrant Vagrants 2.0.0</a> was released yesterday with support for a <a href=\"https://varyingvagrantvagrants.org/docs/en-US/vvv-config/\" target=\"_blank\">YAML configuration</a> file. This is a major improvement that gives VVV users more flexibility in customizing their configurations. The new <code>vvv-config.yml</code> file includes the defaults and users can create a <code>vvv-custom.yml</code> file to change the default provisioning. Utilities have been broken out into their own repository, allowing users to specify PHP 5.6, 7.0, or 7.1 for new projects.</p>\n<p>&#8220;In the past, it was often difficult as a maintainer to say no to feature requests because I knew that the customizations would either be really annoying for someone to implement on their own or would require a fork, possibly losing the benefit of future changes,&#8221; VVV Project Lead Jeremy Felt said. &#8220;At the same time, it was hard to say yes because not everyone needs the same features. Those two clash, and the easiest answer is to stall. The new changes provide a pretty straight forward way of providing these custom changes and make it easy to stay in sync upstream.&#8221;</p>\n<p>Version 2.0.0 was also released with <a href=\"https://varyingvagrantvagrants.org/docs/en-US/\" target=\"_blank\">new documentation on the VVV website</a>. Contributors are migrating docs from the wiki on GitHub to the new website and plan to make them translatable in the future.</p>\n<p>Felt also recently <a href=\"https://jeremyfelt.com/2017/03/05/documenting-vvvs-governance-model/\" target=\"_blank\">documented VVV’s governance model</a> and promoted Lorelei Aurora to the role of Lead Developer on the project. VVV has 108 contributors, by Felt&#8217;s count, and he estimates approximately 100 clones of the project per day based on GitHub&#8217;s analytics. For the past five years, Felt has cultivated VVV’s growing community of contributors by developing a friendly and welcoming culture within the project.</p>\n<p>&#8220;Very early on I read something about OSS project maintenance that inspired me to always greet new commenters, issue creators, and developers in an effort to make them feel welcome from the beginning,&#8221; Felt said. &#8220;Removing even the smallest hurdles of contributing to open source goes a long way. Being friendly encourages people to stick around. Even in small projects like VVV, it can be overwhelming to figure out if you&#8217;re doing things right.&#8221;</p>\n<p>Felt said he wished he would have written the governance document sooner, because it provides a roadmap for contributors. He found that having this information available to the community from the beginning may be just as important as having a license in place.</p>\n<p>&#8220;It starts to answer the &#8216;what kind of impact can I have&#8217; question when someone is getting started,&#8221; Felt said. &#8220;The current list of committers is a little misleading in that they are all people who were very active early in the project, but not as much now. Their input continues to be trusted, but commit access probably won&#8217;t be used very much. This isn&#8217;t a bad thing, as a project goes through cycles, but something to keep track of as a maintainer. Having a process is a healthy thing. I&#8217;m hoping it attracts even more contributors!&#8221;</p>\n<h3>What&#8217;s Next on the VVV Roadmap?</h3>\n<p>The next focus on the VVV roadmap is building out the rest of the documentation on <a href=\"http://varyingvagrantvagrants.org\" target=\"_blank\">varyingvagrantvagrants.org</a>. Felt said he hopes it will become a great place for basic setup, detailed guides, and frequent troubleshooting tips. Translated docs is the next item that Felt said he hopes can be a huge benefit to the project and the community.</p>\n<p>&#8220;There are a couple things that would be fun for flexibility,&#8221; Felt said. &#8220;A long-running pull request that introduces PHP Brew would be nice to finally tackle. Introducing MySQL Sandbox would be cool. And who knows? Everyone should stop by and <a href=\"https://github.com/Varying-Vagrant-Vagrants/VVV\" target=\"_blank\">leave a note</a> with the feature they&#8217;d like to see most. I&#8217;m more comfortable saying &#8216;no&#8217; now.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Mar 2017 19:28:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: WordPress.com Updates Its Post Editor With a Distraction-Free Interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67429\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/wordpress-com-updates-its-post-editor-with-a-distraction-free-interface\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3321:\"<p>WordPress.com has <a href=\"https://en.blog.wordpress.com/2017/03/13/a-distraction-free-writing-space-at-wordpress-com/\">unveiled a refreshed post editor</a> that makes content front and center.</p>\n<p>The most noticeable change is the user interface. The sidebar of meta boxes is now on the right-hand side instead of the left. Clicking the Post Settings link hides the sidebar, providing a cleaner interface. The preview and publish buttons are no longer in a metabox and are permanently displayed.</p>\n<img />New WordPress.com Post Editor\n<p>Drafts are quickly accessible by clicking the number next to the Write button. Hovering over a draft title displays a small excerpt of the post. Unlike the distraction-free writing mode in the self-hosted version of WordPress, sidebars and other items on the screen do not disappear and reappear. This animation has <a href=\"https://wptavern.com/whats-your-first-impression-of-distraction-free-writing-in-wordpress-4-1#comment-62784\">been described</a> by some as a distraction.</p>\n<p>Joen Asmussen and Matías Ventura, two Automatticians based in Europe, helped create the new interface. In an interview conducted by John Maeda, <span class=\"st\">Global Head of Computational Design and Inclusion at Automattic, Asmussen describes what he&#8217;s most excited about with the improvements. </span></p>\n<p>&#8220;Everything has a right place,&#8221; Asmussen said. &#8220;In this iteration, we’ve tried to find those places for the preview and publish buttons, as well as the post settings. By making the buttons permanently visible and the sidebar optionally toggled, my hope is that the combination will provide a seamless flow for both the person who just wants to <i>write</i>, as well as the person who needs to configure their post settings.&#8221;</p>\n<p>Ventura says he is happy to bring the focus back on the content by placing it in the center. &#8220;I’m also fond of the recent drafts menu next to the &#8216;Write&#8217; button, as it provides a quick way to carry on with your unfinished posts,&#8221; he said. &#8220;These editor refinements have the potential to let your work on WordPress keep you deeply in the productive state of flow.&#8221;</p>\n<p>The core team continues to <a href=\"https://wptavern.com/wordpress-core-editor-team-publishes-ui-prototype-for-gutenberg-an-experimental-block-based-editor\">work on a block based editor</a> for the open-source WordPress project and <span class=\"st\">Asmussen</span> hints that this approach to writing could one day end up in the WordPress.com post editor.</p>\n<p>After testing the new editor on WordPress.com, I can say that it&#8217;s more enjoyable to use than the distraction-free writing mode in WordPress. There&#8217;s less distraction, meta boxes are either on the screen or they&#8217;re not, and I enjoyed writing without interface elements disappearing and reappearing on the screen.</p>\n<p>If you&#8217;d like to try the new editor on a self-hosted WordPress site, you can do so through Jetpack. Visit the Jetpack dashboard in the WordPress backend, click on the Apps link, then click the Try the New Editor button.</p>\n<p>After using the new editor, let us know what you think. How does it compare to the writing experience currently in WordPress?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Mar 2017 02:03:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: John Maeda’s 2017 Design in Tech Report Puts the Spotlight on Inclusive Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67406\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/john-maedas-2017-design-in-tech-report-puts-the-spotlight-on-inclusive-design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6207:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/03/design-in-tech-2017.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://maedastudio.com/\" target=\"_blank\">John Maeda</a>, Automattic&#8217;s Global Head of Computational Design and Inclusion, presented his third annual &#8220;<a href=\"https://designintechreport.wordpress.com/\" target=\"_blank\">Design in Tech</a>&#8221; report at SXSW over the weekend. The previous reports have received more than two million views and this one is equally loaded with thought-provoking information about the future of the design industry.</p>\n<p>&#8220;Design isn’t just about beauty; it’s about market relevance and meaningful results,&#8221; Maeda said. He highlighted how design leaders are increasingly top hires at major corporations, due to market demand. Businesses are beginning to embrace design as a fundamental tool for success. Design used to be relegated to extra-curricular clubs in business schools, but many schools are shifting to include design in the curriculum.</p>\n<p>Constant connectivity in the digital era has brought the idea of &#8220;computational design&#8221; to the forefront, which Maeda describes as &#8220;designing for billions of individual people and in realtime.&#8221; Designing at this scale requires an approach that is inclusive of the widest number of consumers, essentially designing for everyone.</p>\n<p>Maeda believes that &#8220;design and inclusion are inseparable&#8221; and he is on a mission to prove that inclusive design is good business. </p>\n<p>&#8220;When we separate inclusion into essentially an HR compliance topic, it loses its energy,&#8221; Maeda said. &#8220;It&#8217;s important, of course, but it loses the creativity that&#8217;s intrinsic to inclusion.&#8221; His 2017 Design in Tech report focuses on how inclusion matters in business. Maeda admits there are not many examples of how inclusion drives better financial outcomes, but one of his professional aims is to demonstrate how inclusive design can make a financial difference.</p>\n<p>&#8220;That&#8217;s why I joined Automattic,&#8221; Maeda said. &#8220;My hope is that this approach can lead to better business outcomes for the WordPress ecosystem. I don&#8217;t know if it will be possible but that&#8217;s my goal. I want to show that it&#8217;s possible numerically.&#8221;</p>\n<p>Making inclusive design profitable hinges on the principle that if you want to reach a larger market, you have to reach people you&#8217;re not already reaching by being inclusive. This new frontier of design requires some technical understanding outside of purely classical design. The hybrid designer/developer, often referred to as a &#8220;unicorn&#8221; in the tech industry, is often relied upon to bridge that gap.</p>\n<p>Maeda predicts that the scarcity of hybrid designer/developers will soon decrease, due to how things are changing in the industry. After surveying design leaders in 2016, Maeda found that 1/3 had formal engineering/science training, suggesting that &#8220;hybrid&#8221; talent has considerably increased in recent years. He shared his observations from surveying Automattic designers and developers about JavaScript competency. He found a significant segment of designers approaching moderate fluency in JavaScript after WordPress&#8217; 2015 initiative to encourage JavaScript mastery.</p>\n<p>&#8220;The world is moving, and moving with the world is what designers do,&#8221; Maeda said. He also made a bold recommendation for those who are maintaining a design-only skill set:</p>\n<p>&#8220;I encourage you, if you&#8217;re a pure pure designer, to &#8216;impurify yourself,&#8217; because it&#8217;s a whole new world and there&#8217;s a lot to learn,&#8221; Maeda said. &#8220;Anyone who&#8217;s in this game, if you aren&#8217;t watching videos and learning, you get behind in two months.&#8221; </p>\n<p>Maeda also encouraged listeners to shed biases that prevent them from seeing important trends and changes on the web. He addressed misconceptions about how products &#8220;made in China&#8221; are often thought of as something cheap or copycat, but China is moving forward in the mobile revolution in a far more advanced way than many other countries. He highlighted some major design trends pioneered by Chinese designers and how they are impacting the tech industry. </p>\n<p>Maeda closely monitors design-related M&#038;A activity and funds that are design and/or inclusion oriented. His data shows that tech companies are finding more value in design tool companies and design community platforms, with acquisitions steadily increasing every year. The value of design companies is especially evident in China where Maeda noted three designer co-founded Chinese companies have a combined market cap of over $300 billion. </p>\n<p>He also shared what he has learned about designers since taking his position at Automattic, which employs more than 500 people working remotely across 50 countries.</p>\n<p>&#8220;People want to have challenging work; they want to make change happen,&#8221; Maeda said. &#8220;With creative people this is their main driver. If that can&#8217;t be sated, they get unhappy and they leave. The problem is this kind of work is the kind that seems like bonus work, not the main work. So my question as a manager is, &#8216;How do I put the two together in some constructive way?&#8217; How do you make time to learn and grow? That&#8217;s something I didn&#8217;t know was pervasive in a busy busy tech company.&#8221;</p>\n<p>Maeda concludes that it is a good time to be a designer, especially if you&#8217;re willing to make up for the design education gap and teach yourself new skills online. His 2017 Design in Tech report is a must-read, not just for designers but for anyone working in tech or hiring tech talent. Check out the <a href=\"https://designintechreport.wordpress.com/\" target=\"_blank\">full report</a> on WordPress.com. You can also <a href=\"https://designintechreport.wordpress.com/2017/03/12/design-in-tech-report-2017-video/\" target=\"_blank\">listen to the audio of Maeda&#8217;s presentation</a> while viewing the slides.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Mar 2017 20:07:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Post Status: JavaScript frameworks in a WordPress context — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=35232\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://poststatus.com/javascript-frameworks-wordpress-context-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2808:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Live from the A Day of REST workshops, Brian, Joe, and Zac talk about the state of working with JavaScript &#8212; including several popular JavaScript frameworks &#8212; and WordPress. They go through the pros and cons of using each one, what to watch out for when working with them and WordPress, and ways they think the process can improve.</span></p>\n<p><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/62575.mp3\">https://audio.simplecast.com/62575.mp3</a><br />\n<a href=\"https://audio.simplecast.com/62575.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://javascriptforwp.com/\">JavaScript for WP</a></li>\n<li><a href=\"https://facebook.github.io/react/\">React</a></li>\n<li><a href=\"https://vuejs.org/\">Vue</a></li>\n<li><a href=\"http://backbonejs.org/\">Backbone</a></li>\n<li><a href=\"http://underscorejs.org/\">Underscores</a></li>\n<li><a href=\"https://angularjs.org/\">Angular</a></li>\n<li><a href=\"https://adayofrest.hm/boston-2017/\">A Day of Rest</a></li>\n</ul>\n<h3>Sponsor: WP Migrate DB Pro</h3>\n<p><span>Today’s show is sponsored by</span><a href=\"https://deliciousbrains.com/\"> <span>Delicious Brains</span></a><span>.</span><a href=\"https://deliciousbrains.com/wp-migrate-db-pro/\"> <span>WP Migrate DB Pro</span></a> <span>makes moving and copying databases simple. They  also have an exciting new project for merging databases, called Mergebot. Go to</span><a href=\"https://mergebot.com/\"> <span>Mergebot.com</span></a><span> for updates on that, and</span><a href=\"https://deliciousbrains.com/\"> <span>deliciousbrains.com</span></a><span> for more information on WPMigrate DB Pro. Thanks to the team at Delicious Brains for being a Post Status partner.</span></p>\n<h3>Special Thanks: Bocoup</h3>\n<p><span>Special thanks to <a href=\"https://bocoup.com/\">Bocoup</a> for allowing us to record this podcast episode in their office. Bocoup was a partner and workshop host for A Day of REST, and were incredibly hospitable. Checkout <a href=\"https://bocoup.com/\">Bocoup</a> to learn more about how they embrace open source as a consulting agency.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Mar 2017 00:56:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Hacker News Question: Developers with kids, how do you skill up?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67259\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/hacker-news-question-developers-with-kids-how-do-you-skill-up\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9488:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/child-theme.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/R0C7A5M4WB\">Leeroy</a>\n<p>By now you&#8217;ve probably seen the viral <a href=\"https://twitter.com/JOE_co_uk/status/840165524038377472\" target=\"_blank\">clip</a> of a father getting interrupted by his children while giving a live interview on BBC. Working parents everywhere, especially remote workers, could identify with the humorous embarrassment of the situation. Even those who have had pets interrupt Skype calls know the feeling. You want to be thought of as a professional and taken seriously but little home office invaders have other plans.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">This BBC interview is amazing. Just wait until the mum rushes in&#8230; <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f602.png\" alt=\"😂\" class=\"wp-smiley\" /> <a href=\"https://t.co/LGw1ACR9rg\">pic.twitter.com/LGw1ACR9rg</a></p>\n<p>&mdash; JOE.co.uk (@JOE_co_uk) <a href=\"https://twitter.com/JOE_co_uk/status/840165524038377472\">March 10, 2017</a></p></blockquote>\n<p></p>\n<p>Many developers who work from home with children know the daily struggle of balancing family life with work, which generally leaves very little time for improving professional skills. A popular question on Hacker News this week asks, <strong>&#8220;<a href=\"https://news.ycombinator.com/item?id=13816627\" target=\"_blank\">Developers with kids, how do you skill up?</a>&#8220;</strong>: </p>\n<blockquote><p>I recently had one of my colleagues comment on my GitHub account graph &#8211; &#8216;There won&#8217;t be many green boxes in your account once you have a kid&#8217;. This was in response to my suggestions on how we should all keep learning. I argued many good programmers have family with kids and still manage to keep up. They brushed me off saying it&#8217;s just not possible or they don&#8217;t look after their kids.</p>\n<p>When I look on the internet I find people doing full time jobs delivering products while having a family and some still find plenty of time to blog or write books. How is this possible? Are these people super-human? How are you all doing or managing if you have kids/family?</p></blockquote>\n<p>The question received nearly 500 replies with tips and stories from those who are making it work. One of the first participants on the thread is <a href=\"https://news.ycombinator.com/item?id=13821164\" target=\"_blank\">Rachel Andrew</a>, who shares how she learned Perl as a single mother, launching a new career in web development. She said found success by &#8220;simply working every possible moment&#8221; she could and learning to be organized and focused with her time.  </p>\n<p>One common theme among the replies is that having kids is like getting a crash course in time management. When your available time is significantly reduced, you are forced to become more purposeful about how you spend it.</p>\n<blockquote><p>What I learned: your time does get reduced drastically, but you spend the remaining time with more focus/direction. Also, you use your time smarter, e.g. I used to do sports (indoor climbing), but now I just cycle every day from/to work (~1 hour) to stay fit. It takes approximately the same time as going by train or car.</p></blockquote>\n<blockquote><p>If i have clear priorities in my head &#8211; what I want to achieve in the &#8216;extra time&#8217; that I have got. The clearer the goal, the better the results.</p></blockquote>\n<blockquote><p>&#8230;due to lack of free time and the newfound need to use it efficiently, I&#8217;ve found that I&#8217;ve probably read more actual physics in the last four years than in the previous many years of dreaming about it.</p></blockquote>\n<blockquote><p>Time management, to me, is a more powerful &#8220;skill up&#8221; than anything that could keep your GitHub green. When you know you have limited hours in the day and you have hard time commitments, you have no choice but to learn and work efficiently.</p></blockquote>\n<blockquote><p>\nI&#8217;d add that kids have taught me to be a better planner, and to break my priorities down into small, well defined chunks that can be slotted into a busy life. This has been valuable in general, not just for programming.</p></blockquote>\n<p>One commenter said he misses the days when he could stay up all night working and exploring new technologies; now it seems the world is going on without him. Other commenters reject the idea of &#8220;skilling up&#8221; entirely and encourage the original poster not to get too hung up on shiny new frameworks.</p>\n<blockquote><p>I agree with you about the need to remain buzzword compliant for jobs, but are we &#8220;skilling up&#8221; or spinning our wheels? There is some worthwhile learning, but a lot of it is just BS status signaling. Learning another SPA framework that solves the problems of the last framework, while introducing new problems? Learning yet another way to bundle your web content? A new transpiled language to patch the holes in JavaScript?</p>\n<p>A lot of what we regard as &#8220;skilling up&#8221; is just a product of our immature dev culture-learning stuff for the sake of buzzword compliance that doesn&#8217;t improve anything in the long run. And the high failure rate of software projects shows that we aren&#8217;t gaining a lot from this culture anyway.</p></blockquote>\n<h3>Combatting the Myth that You Can&#8217;t Do Anything with Just 15 Minutes</h3>\n<p>Another theme among the comments is the &#8220;myths&#8221; parents create that keep them from using the short increments of time that pop up throughout the day. One commenter <a href=\"https://news.ycombinator.com/item?id=13822865\" target=\"_blank\">summarizes</a> the self-limiting mindset that many adopt after having children:</p>\n<blockquote><p>New parents create limitations for themselves in their belief that it is utterly impossible to do anything outside of parenting. The OP is saying that meaningful work can be done in the 15 minutes your baby might be asleep. A year of 15 minutes adds up to a lot.</p></blockquote>\n<p>The key to productivity is being able to take those 15 minute increments and string them into bite-sized accomplishments towards a larger goal. Developer Chris Dawson shared how he wrote an app late at night while caring for his first child. </p>\n<p>&#8220;I only have ten minutes here, fifteen minutes there. I need focused hours of time to build something. That is just a story,&#8221; Dawson said. He used these short bits of time to create <a href=\"http://blog.teddyhyde.com/2013/04/03/teddy-hyde-the-no-compromise-extensible-one-handed-jekyll-blog-editor-for-android\" target=\"_blank\">a one-handed blogging tool</a>, because he needed a way to blog with one hand while holding his sleeping son.</p>\n<p>&#8220;When my daughter was born two years later, my wife was so exhausted she would go to bed at 8,&#8221; Dawson said. &#8220;I&#8217;d get my son to sleep and then promised myself I would write for just fifteen minutes before bed. That usually turned into an hour or two and three years later I had written <a href=\"http://shop.oreilly.com/product/mobile/0636920043027.do\" target=\"_blank\">a book for O&#8217;Reilly</a>.&#8221; </p>\n<p>&#8220;There are so many times I&#8217;m exhausted after getting the kids to bed and I just browse the Internet,&#8221; Dawson said. &#8220;If I was really intentional about my time, even that fifteen minutes could be used to work towards my goals. But there is a powerful story telling me that it won&#8217;t make a difference if I just waste that time.&#8221;</p>\n<p>Dawson doesn&#8217;t consider himself an extraordinary high achiever. He found success by changing his perspective about the sleep he was losing.</p>\n<p>&#8220;I&#8217;m not the greatest developer &#8211; I struggled with the Google interview I got,&#8221; Dawson said. &#8220;But, success is 90% perspiration and 10% ingenuity. Who cares if you are sweating because you are exhausted and sleep deprived caring for infants as compared to pulling all-night coding sessions?&#8221;</p>\n<p>&#8220;Most of what we think of as being &#8216;too busy&#8217; for any particular thing is a cognitive bias for forgetting just how much time we waste,&#8221; JavaScript engineer Sean McBeth said.</p>\n<p><a href=\"https://twitter.com/samlittlewood\" target=\"_blank\">Sam Littlewood</a>, senior architect at V-Nova, offered a few practical tips on the thread:</p>\n<ul>\n<li>Don&#8217;t use the computer to waste time &#8211; if I need decompression time, try and make it doing something w/ kids (LEGO!)</li>\n<li>A solid dev. environment where you can walk up, crank an iteration, and walk away. (Like in the time it takes a kettle to boil)</li>\n<li>Learning to code in my head &#8211; basically planning the path of changes/tests I will make next time I am back at my machine. It feels to me somewhat like the &#8216;method of loci&#8217; &#8211; a definite journey. Often times, the plan goes awry, but the successes make it worth it. After 12 years of reading to the kids, I can do this whilst reading a story to them.</li>\n</ul>\n<p>The comments are full of inspiring stories and ideas for routines and tips that can help parents be more productive. There&#8217;s no magical path to success but, as many working parents have discovered, you may find more time than you thought you had.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Mar 2017 23:32:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: In Case You Missed It – Issue 18\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67263\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wptavern.com/in-case-you-missed-it-issue-18\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7020:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?ssl=1\" rel=\"attachment wp-att-50955\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>The REST API Democratizes Reading</h2>\n<p>Mika Epstein <a href=\"https://halfelf.org/2017/rest-api-democratizing-reading/\">explains</a> how the WordPress REST API democratizes reading by making content more discoverable and accessible.</p>\n<blockquote><p>When you look at a website you see the design and the layout and the wonderful beauty. When an app reads your data, however, it doesn’t want or need any of that. An app needs the raw data. And the REST API does that. It outputs the data in a super basic and simple way. Furthermore, it lets you add on to this and output specific data in special ways.</p></blockquote>\n<h2>TechSPARK Interviews WordCamp Bristol Organizer</h2>\n<p>Bristol, UK, is gearing up for its <a href=\"https://2017.bristol.wordcamp.org/\">first WordCamp</a> and local media is taking notice. TechSPARK, a digital publication that covers tech in Bristol, Bath, and the West of England <a href=\"https://techspark.co/wordcamp-bristol/\">published</a> an interview with Janice Tye, one of the lead organizers of the event.</p>\n<p>In the interview, Tye explains what a WordCamp is and how people can get involved. WordCamp Bristol takes place May 13-14th, 2017 and has a limited <a href=\"https://2017.bristol.wordcamp.org/tickets/\">number of tickets</a> available.</p>\n<h2>Fishing Guide&#8217;s Site Used by Hackers for eCommerce Fraud</h2>\n<p>TechCrunch <a href=\"https://techcrunch.com/2017/03/03/woe-are-the-great-fish-of-cape-cod/\">published</a> an interesting story of how a Cape Cod fishing guide&#8217;s website that runs on WordPress was hacked and used to host an eCommerce store. The moral of the story is to keep WordPress and its plugins and themes updated. An additional safety measure is to enable two-factor authentication.</p>\n<h2>Being a Full-time Contributor Through Sponsorships</h2>\n<p>Late last year, John James Jacoby <a href=\"https://jjj.blog/2016/12/%f0%9f%92%af%e2%88%9e/\">outlined his goal</a> for his 100 initiative. &#8220;My goal is be a fully funded independent ambassador for WordPress and the surrounding initiatives, backed by many of the best companies who continue to push WordPress beyond its limits on a daily basis,&#8221; Jacoby said.</p>\n<p>Jacoby provided <a href=\"https://jjj.blog/2017/03/january-february/\">an update</a> on what he&#8217;s been working on since obtaining sponsorship from Pagely and Pantheon. He plans to take a two-week break in March to attend WordCamp Miami and will be speaking at other events. If you&#8217;re interested in sponsoring Jacoby to work on WordPress full-time for a month, please get <a href=\"http://jjj.me/\">in touch with him</a>.</p>\n<h1 class=\"entry-title\">Mode Effect Builds Website for WordPress.com&#8217;s Affiliate Program</h1>\n<p><a href=\"https://modeeffect.com/\">Mode Effect</a>, a web design agency, <a href=\"https://modeeffect.com/wordpress-com-creators-select-wordpress-agency-mode-effect-to-build-affiliate-program/\">built the site</a> for <a href=\"https://refer.wordpress.com/\">WordPress.com&#8217;s affiliate program</a>. According to Jon Burke, team lead for events, marketing, and advertising at Automattic, the agency was chosen based on recommendations and its previous work with the <a href=\"https://vip.wordpress.com/\">WordPress VIP program</a>.</p>\n<h2>New Features for WordPress.com Stats</h2>\n<p>WordPress.com unveiled a <a href=\"https://en.blog.wordpress.com/2017/03/06/your-stats-page-updated/\">number of new enhancements</a> to WordPress.com stats. More insights, summaries, and better use of wide screens are just a few of the improvements that were made.</p>\n<h2>Remembering HostReviews.io</h2>\n<p>Kevin Ohashi, founder of Review Signal, takes a <a href=\"http://reviewsignal.com/blog/2017/03/06/goodbye-hostingreviews-io-i-will-miss-you/\">look back at </a><span class=\"skimlinks-unlinked\"><a href=\"http://reviewsignal.com/blog/2017/03/06/goodbye-hostingreviews-io-i-will-miss-you/\">HostingReviews.io</a> created by Steven Gliebe that was recently acquired by HostingFacts.com. </span></p>\n<p>&#8220;I&#8217;m truly saddened because it&#8217;s disappearing at some point &#8216;soon.&#8217; The only real competitor whose data I trusted to compare myself against. So I thought I would take the opportunity to write about my favorite competitor,&#8221; Ohashi said.</p>\n<p>He compared the data that was manually curated by Gliebe to the data on Review Signal and discovered it was similar. Ohashi says he will miss having a trustworthy competitor to compare his data too.</p>\n<p>&#8220;It has been nice having <span class=\"skimlinks-unlinked\">HostingReviews.io</span> around when it was actively being updated (the manual process is certainly overwhelming for any individual I think!). I will miss having a real competitor to compare what I&#8217;m seeing in my data.&#8221;</p>\n<h2>Challenges of Security Disclosure</h2>\n<p>Aaron Campbell, WordPress security lead, <a href=\"https://aarondcampbell.com/2017/03/the-difficulties-of-security-disclosure/\">provides insight</a> into the challenges associated with security disclosure. Campbell describes disclosure as a constant balancing act.</p>\n<p>&#8220;But security isn’t a single balancing act,&#8221; Campbell said. &#8220;Many of the decisions we must make require finding the right balance. Each requires thought and consideration, as well as a clear set of priorities. Especially when it comes to disclosing vulnerabilities.&#8221;</p>\n<p>&#8220;Every situation is going to be unique, but knowing the right questions to ask will help. The time to think through these questions is now, hopefully long before you are faced with them.&#8221;</p>\n<p>On the topic of security disclosure, I recommend reading <a href=\"https://nacin.com/2014/05/30/security-is-nuanced/\">Security is Nuanced</a> by Andrew Nacin.</p>\n<h2>WordCamp Auckland Wapuu!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project.</p>\n<p><img /></p>\n<p>WordCamp <a href=\"https://2017.auckland.wordcamp.org/\">Auckland, New Zealand</a> is this weekend and the event&#8217;s Wapuu is appropriately enough, holding a Kiwi.</p>\n<p>That&#8217;s it for issue eighteen. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Mar 2017 02:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Matt: Review: From Plato to Post-modernism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47161\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://ma.tt/2017/03/review-from-plato-to-post-modernism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2379:\"<p><img />One thing I&#8217;m going to try this year is to write a review of every book I get a chance to read. It&#8217;s March already so I&#8217;m a bit behind and the next few will be out of order, but this seems like as good a place to start as any.</p>\n<p>One new thing I&#8217;ve been doing this year is listening to audiobooks with an Audible account, so this first book review is actually an audiobook. <a href=\"http://www.thegreatcourses.com/\">Great Courses</a> is actually an old school thing where you could order college lectures on tape. From the references throughout the lectures I listened to, my guess is that the recordings are from the 90s. This one is called <a href=\"https://www.amazon.com/dp/B00DTO6LZ2/\">From Plato to Post-modernism: Understanding the Essence of Literature and the Role of the Author</a> ($25 on Audible, $9.99 on cassette tape <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f643.png\" alt=\"🙃\" class=\"wp-smiley\" />).</p>\n<p>I really enjoyed this series. Some of the early lectures covering Aristotle, Longinus, and Sidney&#8217;s &#8220;Apology for Poetry&#8221; were quite brilliant. Later ones from Foucault and Derrida on were weaker and harder to follow, which I think is a function of both the material, which can be dense when it starts getting into Modernism, the length, fixed at 30 minutes, and the lecturer, <a href=\"https://en.wikipedia.org/wiki/Louis_Markos\">Louis Markos</a>. Markos teaches <a href=\"https://www.hbu.edu/contact/louis-markos/\">at Houston Baptist University</a> and his asides can sometimes be a little traditional, but in an adorable grandpa way. He has an infectious enthusiasm that makes even the slower chapters on Kant and Schiller bearable, but his love of and fluency in the earlier classics is really a pleasure.</p>\n<p>It made me curious to look into more online lectures and sometime this year I&#8217;m going to check out <a href=\"https://www.khanacademy.org/partner-content/wi-phi/wiphi-value-theory\">this one on Value Theory at Khan academy</a>. I also picked up a used copy of <a href=\"https://www.amazon.com/gp/product/0155055046/\">Critical Theory Since Plato</a> which had the original text for many things discussed in the lecture, so was a great reference point when I was at home in Houston, where I end up listening to most audio content since it&#8217;s a driving town.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2017 20:48:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: “Open Source in Brazil” eBook Now Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66404\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/open-source-in-brazil-ebook-now-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3365:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/brazil.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://commons.wikimedia.org/w/index.php?title=User:Ccarelo&action=edit&redlink=1\" class=\"new\" title=\"User:Ccarelo (page does not exist)\">Ccarelo</a> &#8211; <span class=\"int-own-work\" lang=\"en\">Own work</span>, <a href=\"http://creativecommons.org/licenses/by-sa/3.0\" title=\"Creative Commons Attribution-Share Alike 3.0\">CC BY-SA 3.0</a>, <a href=\"https://commons.wikimedia.org/w/index.php?curid=40606618\">Link</a>\n<p><a href=\"http://www.oreilly.com/programming/free/files/open-source-in-brazil.pdf\" target=\"_blank\">Open Source in Brazil</a> is a new free eBook from O’Reilly Media that offers an inside look into the growth of Brazil&#8217;s free software community despite the country&#8217;s unique barriers. Brazil has a vibrant IT and startup culture and hosts the largest open source conference in Latin America, <a href=\"http://softwarelivre.org/fisl16\" target=\"_blank\">Fórum Internacional Software Livre (FISL)</a>. The conference has been running for 17 years and had 5,200 participants in 2016.</p>\n<p>According to Andy Oram, the book&#8217;s author, open source software is ubiquitous in the country but challenges in business, education, and government have slowed its wider adoption. The book offers a fascinating account of how the free software movement won political favor in the early 2000&#8217;s, launching many governmental initiatives to use open source solutions instead of proprietary software.</p>\n<p>Unfortunately, the government was unable to deliver on these initiatives due to lack of expertise in evaluating software and working with open source communities. These factors, combined with a scarcity of local companies to help bridge the gap, and eventually corruption, caused more delays to converting government operations to open source software. These setbacks resulted in what Oram described as &#8220;inertia and corruption that leave companies and government agencies feeding huge amounts of money into proprietary software that was designed for the North American market.&#8221;</p>\n<p>Brazil has also struggled to keep highly skilled developers who can mentor the next generation due to a &#8220;brain drain&#8221; to international cities with higher wages:</p>\n<blockquote><p>The education of developers that takes place in many developed countries is hampered in Brazil, as in many countries, by a brain drain. Basically, if you become an expert in your technological area, you can get a foreign job that pays more than Brazillian jobs and offers the enticements of living in a major tech center such as London or San Francisco. Thus, the people who could be attending meetups and mentoring the next generation of experts are drawn away.</p></blockquote>\n<p>Despite the free software community&#8217;s temporary loss of momentum, its unique challenges have prompted Brazilian developers to rely less on government support and find new ways of promoting open source software. &#8220;Open Source in Brazil&#8221; is available for free in both <a href=\"http://www.oreilly.com/programming/free/files/open-source-in-brazil.pdf\" target=\"_blank\">English</a> and <a href=\"http://www.oreilly.com/programming/free/open-source-no-brasil.csp\" target=\"_blank\">Portuguese</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2017 18:19:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"BuddyPress: BuddyPress 2.8.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=264593\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://buddypress.org/2017/03/buddypress-2-8-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:843:\"<p>BuddyPress 2.8.2 is now available. This is a security release. We strongly encourage all BuddyPress sites to upgrade as soon as possible.</p>\n<p>BuddyPress 2.8.1 and earlier versions were affected by the following three security issues:</p>\n<ol>\n<li>Cross-site request forgery (CSRF) in the XProfile administration Dashboard panel.</li>\n<li>Cross-site request forgery (CSRF) in a number of user-facing AJAX endpoints.</li>\n<li>Cross-site request forgery (CSRF) when dismissing a pending email change.</li>\n</ol>\n<p>These vulnerabilities were reported privately by <a href=\"https://dk.linkedin.com/in/skansing\">Ronnie Skansing</a>. Our thanks to Ronnie for reporting security issues in accordance with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">WordPress&#8217;s security policies</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2017 16:04:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Boone Gorges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WeFoster Launches Hosting Platform Catered to Online Communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67151\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/wefoster-launches-hosting-platform-catered-to-online-communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5536:\"<p><a href=\"https://wefoster.co/\">WeFoster</a>, co-founded by <a href=\"https://wefoster.co/profiles/marion/profile/\">Marion Gooding</a> and <a href=\"https://wefoster.co/profiles/bowromir/profile/\">Bowe Frankema</a>, is a new managed hosting platform fine-tuned specifically for online communities.</p>\n<p>The duo came up with the idea for WeFoster <a href=\"https://wefoster.co/about/\">two years ago</a> at WordCamp London 2015. &#8220;Bowe and I sat down and thought of ideas on how we could contribute to the open source community,&#8221; Gooding said. &#8220;We eventually decided on BuddyPress and to build a business around it. We brainstormed on the basic premise of growing awareness, interest, and the user base of BuddyPress.&#8221;</p>\n<p>While BuddyPress is at the core of what WeFoster does, it isn&#8217;t limited to it. The hosting provider caters to all kinds of community building tools whether its <a href=\"https://www.peepso.com/\">Peepso</a>, <a href=\"https://s2member.com/\">s2Member</a>, or <a href=\"https://www.memberpress.com/\">Memberpress</a>.</p>\n<p>One of the things that sets WeFoster apart is its community creation wizard. Customers are asked a series of questions related to their community. For example, one of the questions asks if you&#8217;d like to have discussion forums. If you answer yes, bbPress will automatically be installed in the background. This process replaces the need to manually search and install a variety of plugins after installing WordPress.</p>\n<img />WeFoster Community Creation Wizard\n<p>When creating a community, customers can select from a set of partner templates. Partner templates are pre-configured WordPress installations setup specifically around a product. Partner templates include a white labeled dashboard allowing partners to brand it to match their product. Partners also receive a variety of other perks.</p>\n<p>The partner program is not an affiliate program and partners are hand selected. The team is looking for partners that are in line with the company&#8217;s vision of building better communities. For more information and to apply to be a partner, check out the <a href=\"https://wefoster.co/platform/partners/\">partner application</a> page.</p>\n<h2>WeFoster Uses Google&#8217;s Cloud Platform</h2>\n<p>WeFoster is built on <a href=\"https://cloud.google.com/\">Google&#8217;s Cloud Platform</a> enabling each site to be hosted in a container separate from others. The technology stack consists of PHP7, Nginx, Redis/Memcached, and MariaDB. If for whatever reason you need to downgrade to PHP 5.6, you can do so at the click of a button.</p>\n<img />Switching PHP Versions\n<p>WeFoster uses a custom caching solution dubbed CommunityCaching that it claims loads sites up to six times faster than traditional shared hosts and almost twice as fast as Managed WordPress hosts.</p>\n<p>The host is also a certified CloudFlare partner taking advantage of CloudFlare&#8217;s data centers located across the world. The partnership provides access to free SSL certificates. All sites created on WeFoster have SSL enabled by default and are served over the <a href=\"https://www.cloudflare.com/http2/what-is-http2/\">HTTP/2 protocol</a>.</p>\n<p>Sites are actively monitored for malware and are backed up to Amazon Secure Storage. Site owners can restore to any point in time since backups are stored indefinitely.</p>\n<h2>Tools for Developers</h2>\n<p>Although WeFoster has focused on eliminating technical hurdles experienced by those who manage online communities, the company didn&#8217;t forget about developers. Each site has a developer section that includes a code editor, database manager, an area for debugging, and other related tools. The code editor is a full-featured IDE that works in the browser. This eliminates the need use an FTP client to upload files to the web server.</p>\n<img />Developer Tools\n<p>Those who manage sites using a command line interface will be happy to know that WeFoster supports <a href=\"http://wp-cli.org/\">WP-CLI</a>.</p>\n<img />WP-CLI Support\n<h2>The WeFoster Community Hub</h2>\n<p>In addition to hosting communities, WeFoster itself <a href=\"https://wefoster.co/platform/community-features/\">is a community</a>. The WeFoster community hub is a place where community builders share advice, network with other builders, and gain access to exclusive resources. Prospecting developers can join the <a href=\"https://wefoster.co/profiles/type/developers/\">developer directory</a> and be part of <a href=\"https://wefoster.co/platform/community-care/\">Community Care</a>. Community Care enables community managers to submit tasks that are then completed by one or more experts from the developer directory for a fee.</p>\n<h2>Co-Founders Give a Guided Tour</h2>\n<p>WeFoster offers a <a href=\"https://wefoster.co/platform/launch\">seven-day free trial</a> for all <a href=\"https://wefoster.co/platform/pricing/\">its plans</a> and will migrate existing communities for free. Prices start at $29 per month for the Village plan and go as high as $249 for the Metropolis plan. If at the end of the trial period you decide not to use the service, remove your payment information so you don&#8217;t get charged.</p>\n<p>What I&#8217;ve highlighted above is only scratching the surface as to what WeFoster offers. To learn and see how it works, watch this 47 minute video where Gooding and Frankema give a guided tour and explain the thought process behind many of its features.</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Mar 2017 06:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"WPTavern: Stack Overflow Jobs Data Shows ReactJS Skills in High Demand, WordPress Market Oversaturated with Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=67202\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://wptavern.com/stack-overflow-jobs-data-shows-reactjs-skills-in-high-demand-wordpress-market-oversaturated-with-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4805:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/07/stack-overflow.png?ssl=1\"><img /></a></p>\n<p>Stack Overflow published its analysis of <a href=\"https://stackoverflow.blog/2017/03/09/developer-hiring-trends-2017/\" target=\"_blank\">2017 hiring trends</a> based on the targeting options employers selected when posting to <a href=\"http://stackoverflow.com/jobs\" target=\"_blank\">Stack Overflow Jobs</a>. The report, which compares data from 200 companies since 2015, ranks ReactJS, Docker, and Ansible at the top of the fastest growing skills in demand. When comparing the percentage change from 2015 to 2016, technologies like AJAX, Backbone.js, jQuery, and WordPress are less in demand.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/03/ChangesinDemand.png?ssl=1\"><img /></a></p>\n<p>Stack Overflow also measured the demand relative to the available developers in different tech skills. The demand for backend, mobile, and database engineers is higher than the number of qualified candidates available. WordPress is last among the oversaturated fields with a surplus of developers relative to available positions.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/03/HighDemand.png?ssl=1\"><img /></a></p>\n<p>In looking at these results, it&#8217;s important to consider the inherent biases within the Stack Overflow ecosystem. In 2016, the site surveyed more than 56,000 developers but noted that the survey was &#8220;biased against devs who don&#8217;t speak English.&#8221; The average age of respondents was 29.6 years old and 92.8% of them were male. </p>\n<p>For two years running, Stack Overflow survey respondents have <a href=\"https://wptavern.com/stack-overflow-survey-results-show-wordpress-is-trending-up-despite-being-ranked-among-most-dreaded-technologies\" target=\"_blank\">ranked WordPress among the most dreaded technologies</a> that they would prefer not to use. This may be one reason why employers wouldn&#8217;t be looking to advertise positions on the site&#8217;s job board, which is the primary source of the data for this report.</p>\n<p>Many IT career forecasts focus more generally on job descriptions and highest paying positions. Stack Overflow is somewhat unique in that it identifies trends in specific tech skills, pulling this data out of how employers are tagging their listings for positions. It presents demand in terms of number of skilled developers relative to available positions, a slightly more complicated approach than measuring demand based on advertised salary. However, Stack Overflow&#8217;s data presentation could use some refining. </p>\n<p>One commenter, Bruce Van Horn, <a href=\"https://stackoverflow.blog/2017/03/09/developer-hiring-trends-2017/#comment-3194770754\" target=\"_blank\">noted</a> that jobs tagged as &#8220;Full Stack Developer&#8221; already assume many of the skills that are listed separately: </p>\n<blockquote><p>I wonder how many of these skills are no longer listed because they are &#8220;table stakes&#8221;. You used to have to put CSS, jQuery, and JSON on the job description. I wouldn&#8217;t expect to have to put that on a Full Stack Developer description today &#8211; if you don&#8217;t know those then you aren&#8217;t a Full Stack Web Developer, and I&#8217;m more interested in whether you know the shiny things like React, Redux, and Angular2.</p></blockquote>\n<p>It would be interesting to know what is meant by tagging &#8220;WordPress&#8221; as a skill &#8211; whether it is the general ability to work within the WordPress ecosystem of tools or if it refers to specific skills like PHP. Browsing a few jobs on Stack Overflow, <a href=\"http://stackoverflow.com/jobs?sort=i&q=wordpress\" target=\"_blank\">WordPress positions</a> vary in the skills they require, such as React.js, Angular, PHP, HTML, CSS, and other technologies. This is a reflection of the diversity of technology that can be leveraged in creating WordPress-powered sites and applications, and several of these skills are listed independently of WordPress in the data. </p>\n<p>Regardless of how much credibility you give Stack Overflow&#8217;s analysis of hiring trends, the report&#8217;s recommendation for those working in technologies oversaturated with developers is a good one: &#8220;Consider brushing up on some technologies that offer higher employer demand and less competition.&#8221; WordPress&#8217; code base is currently <a href=\"https://www.openhub.net/p/wordpress/analyses/latest/languages_summary\" target=\"_blank\">59% PHP and 27% JavaScript</a>. The percentage of PHP has grown over time, but newer features and improvements to core are also being built in JavaScript. These are both highly portable skills that are in demand on the web.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";