<?php
/**
 * @package SKT Restaurant
 * Setup the WordPress core custom functions feature.
 *
*/

add_action('skt_restaurant_optionsframework_custom_scripts', 'skt_restaurant_optionsframework_custom_scripts');
function skt_restaurant_optionsframework_custom_scripts() { ?>
	<script type="text/javascript">
    jQuery(document).ready(function() {
    
        jQuery('#example_showhidden').click(function() {
            jQuery('#section-example_text_hidden').fadeToggle(400);
        });
        
        if (jQuery('#example_showhidden:checked').val() !== undefined) {
            jQuery('#section-example_text_hidden').show();
        }
        
    });
    </script><?php
}

// custom javascript for head
add_action('wp_head','hook_custom_javascript');
function hook_custom_javascript(){?>
	<script>
    jQuery(document).ready(function() {
        jQuery("#header-bottom-shape").click(function(){
            if ( jQuery( ".show_hide_header" ).is( ":hidden" ) ) {
                jQuery( ".show_hide_header" ).slideDown("slow");
            } else {
                jQuery( ".show_hide_header" ).slideUp("slow");
            }
            jQuery( this ).toggleClass('showDown');
        });
        jQuery( "#site-nav li:last" ).addClass("noBottomBorder");
        jQuery( "#site-nav li:parent" ).find('ul.sub-menu').parent().addClass("haschild");
    });
	</script><?php   
}

// get_the_content format text
function get_the_content_format( $str ){
	$raw_content = apply_filters( 'the_content', $str );
	$content = str_replace( ']]>', ']]&gt;', $raw_content );
	return $content;
}
// the_content format text
function the_content_format( $str ){
	echo get_the_content_format( $str );
}

function is_google_font( $font ){
	$notGoogleFont = array( 'Arial', 'Comic Sans MS', 'FreeSans', 'Georgia', 'Lucida Sans Unicode', 'Palatino Linotype', 'Symbol', 'Tahoma', 'Trebuchet MS', 'Verdana' );
	if( in_array($font, $notGoogleFont) ){
		return false;
	}else{
		return true;
	}
}

// subhead section function
function sub_head_section( $more ) {
	$pgs = 0;
	do {
		$pgs++;
	} while ($more > $pgs);
	return $pgs;
}

//[clear]
function clear_func() {
	$clr = '<div class="clear"></div>';
	return $clr;
}
add_shortcode( 'clear', 'clear_func' );

//[separator height="20"]
function separator_shortcode_func($atts ) {
	extract( shortcode_atts( array(
		'height' => '20',
	), $atts ) );
	$sptr = '<div style="clear:both; min-height:20px; height:'.$height.'px; background:url('.get_template_directory_uri().'/images/hr_double.png) no-repeat center center transparent;"></div>';
	return $sptr;
}
add_shortcode( 'separator', 'separator_shortcode_func' );

//[blankspace height="20"]
function blankspace_shortcode_func($atts ) {
	extract( shortcode_atts( array(
		'height' => '20',
	), $atts ) );
	$sptr = '<div style="clear:both; min-height:20px; height:'.$height.'px;"></div>';
	return $sptr;
}
add_shortcode( 'blankspace', 'blankspace_shortcode_func' );


//[column_content]Your content here...[/column_content]
function column_content_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'type' => '',		
	), $atts ) );
	$colPos = strpos($type, '_last');
	if($colPos === false){
		$cnt = '<div class="'.$type.'">'.do_shortcode($content).'</div>';
	}else{
		$type = substr($type,0,$colPos);
		$cnt = '<div class="'.$type.' last_column">'.do_shortcode($content).'</div>';
	}
	return $cnt;
}
add_shortcode( 'column_content', 'column_content_func' );


//[hr]
function hrule_func() {
	$hrule = '<div class="clear hrule"></div>';
	return $hrule;
}
add_shortcode( 'hr', 'hrule_func' );


//[hr_top]
function hr_top_func() {
	$hr_top = '<div class="clear linktotop"><a title="Top of Page" href="#top">Back to Top</a></div><div class="clear hrule"></div>';
	return $hr_top;
}
add_shortcode( 'hr_top', 'hr_top_func' );


// [searchform]
function searchform_shortcode_func( $atts ){
	return get_search_form( false );
}
add_shortcode( 'searchform', 'searchform_shortcode_func' );

// accordion
function accordion_func( $atts, $content = null ) {
	$acc = '<div style="margin-top:35px;">'.get_the_content_format( do_shortcode($content) ).'<div class="clear"></div></div>';
	return $acc;
}
add_shortcode( 'accordion', 'accordion_func' );
function accordion_content_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'title' => 'Accordion Title',
	), $atts ) );
	$content = wpautop(trim($content));
	$acn = '<div class="accordion-box"><h2>'.$title.'</h2>
			<div class="acc-content">'.$content.'</div><div class="clear"></div></div>';
	return $acn;
}
add_shortcode( 'accordion_content', 'accordion_content_func' );


// remove excerpt more
function new_excerpt_more( $more ) {
	return '... ';
}
add_filter('excerpt_more', 'new_excerpt_more');

// get post categories function
function getPostCategories(){
	$categories = get_the_category();
	$catOut = '';
	$separator = ', ';
	$catOutput = '';
	if($categories){
		foreach($categories as $category) {
			$catOutput .= '<a href="'.get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( "View all posts in %s", 'skt-restaurant' ), $category->name ) ) . '">'.$category->cat_name.'</a>'.$separator;
		}
		$catOut = 'Categories: '.trim($catOutput, $separator);
	}
	return $catOut;
}

// replace last occurance of a string.
function str_lreplace($search, $replace, $subject){
	$pos = strrpos($subject, $search);
	if($pos !== false){
		$subject = substr_replace($subject, $replace, $pos, strlen($search));
	}
	return $subject;
}

function pricing_table_shortcode_func( $atts, $content = null ) {
   extract( shortcode_atts( array(
		'columns' => '4',
	), $atts ) );
	$ptbl = '<div class="pricing_table pcol'.$columns.'">'.do_shortcode( str_replace(array('<br />','\t','\n','\r','\0'.'\x0B'), array('','','','','',''), $content) ) .'<div class="clear"></div></div>';
	return $ptbl;
}
add_shortcode( 'pricing_table', 'pricing_table_shortcode_func' );

function price_column_func( $atts, $content = null ) {
   extract( shortcode_atts( array(
		'highlight' => '',
		'bgcolor' => '',
	), $atts ) );
	$pcol = '<div class="price_col '.( (strtolower($highlight) == 'yes') ? 'highlight' : '' ).'" '.( ($bgcolor!='') ? 'style="background-color:'.$bgcolor.' !important;"' : '' ) .'>'.do_shortcode( $content ) .'</div>';
    return $pcol;
}
add_shortcode( 'price_column', 'price_column_func' );

function price_column_header_func( $atts, $content = null ) {
	$pheader = '<div class="th">'.strip_tags($content).'</div>';
    return $pheader;
}
add_shortcode( 'price_header', 'price_column_header_func' );

function price_column_footer_func( $atts, $content = null ) {
   extract( shortcode_atts( array(
		'link' => '#',
	), $atts ) );
	$pfooter = '<div class="tf"><a href="'.$link.'">'.strip_tags($content).'</a></div>';
    return $pfooter;
}
add_shortcode( 'price_footer', 'price_column_footer_func' );

function price_row_footer_func( $atts, $content = null ) {
	$prow = '<div class="td">'.$content.'</div>';
    return $prow;
}
add_shortcode( 'price_row', 'price_row_footer_func' );



//*Time table Shortcode*//
function time_table_shortcode_func( $atts, $content = null ) {
   extract( shortcode_atts( array(
		
	), $atts ) );
	$ttbl = '<div class="time_table">'.do_shortcode( str_replace(array('<br />','\t','\n','\r','\0'.'\x0B'), array('','','','','',''), $content) ) .'<div class="clear"></div></div>';
	return $ttbl;
}
add_shortcode( 'time_table', 'time_table_shortcode_func' );

function time_tabel_row_func( $atts) {
	extract(shortcode_atts(array(
	'title'		=> '',
	'start'		=> '',		
	), $atts));
	$trow = '<div class="time_row"><span class="title">'.$title.'</span><span class="start_time">'.$start.'</span></div>';
    return $trow;
}
add_shortcode( 'time_table_row', 'time_tabel_row_func' );


//custom post type for Our Team
function my_custom_post_team() {
	$labels = array(
		'name'               => __( 'Our Team', 'skt-restaurant' ),
		'singular_name'      => __( 'Our Team', 'skt-restaurant' ),
		'add_new'            => __( 'Add New', 'skt-restaurant' ),
		'add_new_item'       => __( 'Add New Team Member', 'skt-restaurant' ),
		'edit_item'          => __( 'Edit Team Member', 'skt-restaurant' ),
		'new_item'           => __( 'New Team Member', 'skt-restaurant' ),
		'all_items'          => __( 'All Team Members', 'skt-restaurant' ),
		'view_item'          => __( 'View Team Members', 'skt-restaurant' ),
		'search_items'       => __( 'Search Team Members', 'skt-restaurant' ),
		'not_found'          => __( 'No team members found', 'skt-restaurant' ),
		'not_found_in_trash' => __( 'No team members found in the Trash', 'skt-restaurant' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Our Team'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Team',
		'public'        => true,
		'menu_icon'		=> 'dashicons-groups',
		'menu_position' => null,
		'supports'      => array( 'title', 'editor', 'thumbnail' ),
		'has_archive'   => true,
	);
	register_post_type( 'team', $args );
}
add_action( 'init', 'my_custom_post_team' );


// add meta box to team
add_action( 'admin_init', 'my_team_admin_function' );
function my_team_admin_function() {
    add_meta_box( 'team_meta_box',
        'Member Info',
        'display_team_meta_box',
        'team', 'normal', 'high'
    );
}
// add meta box form to team
function display_team_meta_box( $team ) {
    // Retrieve current name of the Director and Movie Rating based on review ID
    $designation = esc_html( get_post_meta( $team->ID, 'designation', true ) );
    $facebook = get_post_meta( $team->ID, 'facebook', true );
	$facebooklink = esc_url( get_post_meta( $team->ID, 'facebooklink', true ) );
    $twitter = get_post_meta( $team->ID, 'twitter', true );
	$twitterlink = esc_url( get_post_meta( $team->ID, 'twitterlink', true ) );
    $linkedin = get_post_meta( $team->ID, 'linkedin', true );
	$linkedinlink = esc_url( get_post_meta( $team->ID, 'linkedinlink', true ) );
    $skype = get_post_meta( $team->ID, 'skype', true );
	$skypelink = get_post_meta( $team->ID, 'skypelink', true );
    ?>
    <table width="100%">
        <tr>
            <td width="20%">Designation </td>
            <td width="80%"><input type="text" name="designation" value="<?php echo $designation; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social link 1</td>
            <td width="40%"><input type="text" name="facebook" value="<?php echo $facebook; ?>" /></td>
            <td width="40%"><input style="width:500px;" type="text" name="facebooklink" value="<?php echo $facebooklink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 2</td>
            <td width="40%"><input type="text" name="twitter" value="<?php echo $twitter; ?>" /></td>
            <td width="40%"><input style="width:500px;" type="text" name="twitterlink" value="<?php echo $twitterlink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 3</td>
            <td width="40%"><input type="text" name="linkedin" value="<?php echo $linkedin; ?>" /></td>
            <td width="40%"><input style="width:500px;" type="text" name="linkedinlink" value="<?php echo $linkedinlink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 4</td>
            <td width="40%"><input type="text" name="skype" value="<?php echo $skype; ?>" /></td>
            <td width="40%"><input style="width:500px;" type="text" name="skypelink" value="<?php echo $skypelink; ?>" /></td>
        </tr>
        <tr>
        	<td width="100%" colspan="3"><label style="font-size:12px;"><strong>Note:</strong> Icon name should be in lowercase without space. More social icons can be found at: http://fortawesome.github.io/Font-Awesome/icons/</label></td>
        </tr>
    </table>
    <?php
}
// save team meta box form data
add_action( 'save_post', 'add_team_fields_function', 10, 2 );
function add_team_fields_function( $team_id, $team ) {
    // Check post type for testimonials
    if ( $team->post_type == 'team' ) {
        // Store data in post meta table if present in post data
        if ( isset($_POST['designation']) ) {
            update_post_meta( $team_id, 'designation', $_POST['designation'] );
        }
        if ( isset($_POST['facebook']) ) {
            update_post_meta( $team_id, 'facebook', $_POST['facebook'] );
        }
		if ( isset($_POST['facebooklink']) ) {
            update_post_meta( $team_id, 'facebooklink', $_POST['facebooklink'] );
        }
        if ( isset($_POST['twitter']) ) {
            update_post_meta( $team_id, 'twitter', $_POST['twitter'] );
        }
		if ( isset($_POST['twitterlink']) ) {
            update_post_meta( $team_id, 'twitterlink', $_POST['twitterlink'] );
        }
        if ( isset($_POST['linkedin']) ) {
            update_post_meta( $team_id, 'linkedin', $_POST['linkedin'] );
        }
		if ( isset($_POST['linkedinlink']) ) {
            update_post_meta( $team_id, 'linkedinlink', $_POST['linkedinlink'] );
        }
        if ( isset($_POST['skype']) ) {
            update_post_meta( $team_id, 'skype', $_POST['skype'] );
        }
		if ( isset($_POST['skypelink']) ) {
            update_post_meta( $team_id, 'skypelink', $_POST['skypelink'] );
        }
    }
}

//Testimonials function
function teamoutput_func( $atts ){
	extract( shortcode_atts( array( 
	'show' => '',
	), 
	$atts ) ); $postoutput = ''; wp_reset_query();
	$teamoutput = '<div class="team-member">';	
	$k = 0;
 	query_posts('post_type=team&posts_per_page='.$show);
	if ( have_posts() ) :
		while ( have_posts() ) : the_post();
		$designation = esc_html( get_post_meta( get_the_ID(), 'designation', true ) );
			$facebook = get_post_meta( get_the_ID(), 'facebook', true );
			$facebooklink = get_post_meta( get_the_ID(), 'facebooklink', true );
			$twitter = get_post_meta( get_the_ID(), 'twitter', true );
			$twitterlink = get_post_meta( get_the_ID(), 'twitterlink', true );
			$linkedin = get_post_meta( get_the_ID(), 'linkedin', true );
			$linkedinlink = get_post_meta( get_the_ID(), 'linkedinlink', true );
			$skype = get_post_meta( get_the_ID(), 'skype', true );
			$skypelink = get_post_meta( get_the_ID(), 'skypelink', true );
		$k++;
			$teamoutput .= '<div class="team-col '.(($k%4==0) ? 'last' : '').'">
			            <div class="teamthumbbx"><a href="'.get_the_permalink().'">'.get_the_post_thumbnail().'</a></div>
						<div class="team-desc"><h6><a href="'.get_the_permalink().'">'.get_the_title().'</a></h6>
						<span>'.$designation.'</span>
						'.content( of_get_option('teamexcerptlength') ).'
										
						
						
						<div class="social-links">';
							 if( $facebook != '' ){
									$teamoutput .= '<a href="'.$facebooklink.'" title="'.$facebook.'" target="_blank"><i class="fa fa-'.$facebook.' fa-lg"></i></a>';
								}
								if( $twitter != '' ){
									$teamoutput .= '<a href="'.$twitterlink.'" title="'.$twitter.'" target="_blank"><i class="fa fa-'.$twitter.' fa-lg"></i></a>';
								}
								if( $linkedin != '' ){
									$teamoutput .= '<a href="'.$linkedinlink.'" title="'.$linkedin.'" target="_blank"><i class="fa fa-'.$linkedin.' fa-lg"></i></a>';
								}
								if( $skype != '' ){
									$teamoutput .= '<a href="'.$skypelink.'" title="'.$skype.'" target="_blank"><i class="fa fa-'.$skype.' fa-lg"></i></a>';
								}							
				$teamoutput .= '</div></div>
					</div>';
		endwhile;
	endif;
	wp_reset_query();
	$teamoutput .= '<div class="clear"></div>';
	$teamoutput .= '</div>';
	return $teamoutput;
}
add_shortcode( 'ourteam', 'teamoutput_func' );

//Testimonials function
function testimonialoutput_func( $atts ){
	$testimonialoutput = '<div id="testimonials"><div class="quotes">
            <ul>';
	wp_reset_query();
	query_posts('post_type=testimonial');
	if ( have_posts() ) :
		while ( have_posts() ) : the_post();
			$testimonialoutput .= '
  			 <li>
			 	<div class="tm_thumb">'.get_the_post_thumbnail( get_the_ID(), array(110,110) ).'</div>
				<div class="tm_description">
				  '.content( of_get_option('testimonialwordlength') ).'
				  <h3> '.get_the_title().'</h3>				  
				</div>				
              </li>
			';
		endwhile;
		 $testimonialoutput .= '</ul></div></div>';
	else:
	  $testimonialoutput = '<div id="testimonials">
          <div class="quotes">
            <ul>
              <li>
                 <div class="tm_thumb"><img src="'.get_template_directory_uri()."/images/testimonial.jpg".'" alt="" /></div>
                  <div class="tm_description">
				   <p>Aliquam et varius orci, ut ornare justo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque augue metus, blandit vel nibh sed, sollicitudin placerat quam. Quisque id scelerisque nibh. Phasellus in orci et felis tristique finibus non quis erat. Quisque nec congue nunc, sagittis aliquet orci. Quisque pulvinar feugiat sodales. Nam fermentum tempus odio sed euismod.</p>
                   <h3>Eficitur Sodale</h3>				  
				  </div>              
              </li>
			  
              <li>
                 <div class="tm_thumb"><img src="'.get_template_directory_uri()."/images/testimonial.jpg".'" alt="" /></div>
                  <div class="tm_description">
				   <p>That which can be asserted Aliquam et varius orci, ut ornare justo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque augue metus, blandit vel nibh sed, sollicitudin placerat quam. Quisque id scelerisque nibh. Phasellus in orci et felis tristique finibus non quiserat. Quisque nec congue nunc, sagittis aliquet orci. Quisque pulvinar feugiat sodales euismod.</p>
                   <h3>Christopher Hitchens </h3>				  
				  </div>              
              </li>
			               
            </ul>         
    </div><!-- .quotes -->   
  </div> <!-- #testimonials -->			
		  ';			
	  endif;  
	wp_reset_query();
	return $testimonialoutput;
}
add_shortcode( 'testimonials', 'testimonialoutput_func' );



//Testimonials function
function testimonials_list_output_func( $atts ){
	extract( shortcode_atts( array( 
	'show' => '',
	), 
	$atts ) ); $postoutput = ''; wp_reset_query();
	$testimonialoutput = '<div id="testimonialslist">';
	wp_reset_query();
 	query_posts('post_type=testimonial&posts_per_page='.$show);
	if ( have_posts() ) :
		while ( have_posts() ) : the_post();			
			$testimonialoutput .= '				 
				   <div class="listing">				 
				   <div class="tml_thumb"><a href="'.get_permalink().'"> '.( (get_the_post_thumbnail( get_the_ID(), array(150,150)) != '') ? get_the_post_thumbnail() : '<img src="'.get_template_directory_uri().'/images/img_404.png" width="150" />' ).'</a></div>
				   <div class="descriptionbx">
				   <h5><a href="'.get_permalink().'">'.get_the_title().'</a></h5>				  
				    '.content( of_get_option('testimonialwordlength') ).'
				    
				   </div>
				   <div class="clear"></div> 
				</div>  ';
		endwhile;
		 $testimonialoutput .= '';
	else:
	  $testimonialoutput = 'There are not found testimonials';			
	  endif;  
	wp_reset_query();
	$testimonialoutput .= '</div>';
	
	return $testimonialoutput;
}
add_shortcode( 'testimonials-lists', 'testimonials_list_output_func' );


//Latest News Posts
function latestpostsoutput_func( $atts ){
   extract( shortcode_atts( array(
		'show' => 4,
	), $atts ) );
	$postoutput = '';
	wp_reset_query();
	$n = 0;
	query_posts(  array( 'posts_per_page'=>$show, 'post__not_in' => get_option('sticky_posts') )  );
	if ( have_posts() ) :
		while ( have_posts() ) : the_post();
			$n++;
			if( $n%2==0 ) 
			$nomgn = 'last';
			else
			$nomgn = ' ';
			if ( has_post_thumbnail()) {
				$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
				$imgUrl = $large_image_url[0];
			}else{
				$imgUrl = get_template_directory_uri().'/images/blogthumb.jpg';
			} 
			
			$postoutput .= '<div class="news-box '.$nomgn.'">
							  <div class="imbbox">
								<a href="'.get_the_permalink().'"><img src="'.$imgUrl.'" alt="" /></a>
								<span class="date-time">'.get_the_date('F j').'<span>'.get_the_date('g:i a').'</span></span>													
							 </div>
							<div class="news-content">
								<a href="'.get_the_permalink().'"><h2>'.get_the_title().'</h2></a>								
								'.content( of_get_option('hmlatestpostslength') ).'
						       <a class="readmore" href="'.get_the_permalink().'">'.of_get_option('hmlatestpostsreadmore').'</a>			
                    </div>
					<div class="clear"></div>
                        </div>';		
		endwhile;
	endif;
	wp_reset_query();
	$postoutput .= '<div class="clear"></div>';
	
	return $postoutput;
}
add_shortcode( 'latestposts', 'latestpostsoutput_func' );

// shortcode for custom width
function skt_restaurant_custom_width_func($atts, $content = null){
		extract(shortcode_atts(array(
			'width'		=> 'width',						
			'class'		=> null
		), $atts));
		return '<div class="'.$class.'" style="width:'.$width.';">'.do_shortcode($content).'</div>';		
}

add_shortcode('area','skt_restaurant_custom_width_func');


// Social Icon Shortcodes
function skt_restaurant_social_area($atts,$content = null){
  return '<div class="social-icons">'.do_shortcode($content).'</div>';
 }
add_shortcode('social_area','skt_restaurant_social_area');

function skt_restaurant_social($atts){
 extract(shortcode_atts(array(
  'icon' => '',
  'link' => ''
 ),$atts));
  return '<a href="'.$link.'" target="_blank" class="fa fa-'.$icon.' fa-1x" title="'.$icon.'"></a>';
 }
add_shortcode('social','skt_restaurant_social');


function contactform_func( $atts ) {
    $atts = shortcode_atts( array(
        'to_email' => get_bloginfo('admin_email'),
		'title' => 'Contact enquiry - '.home_url( '/' ),
    ), $atts );

	$cform = "<div class=\"main-form-area\" id=\"contactform_main\">";

	$cerr = array();
	if( isset($_POST['c_submit']) && $_POST['c_submit']=='Submit' ){
		$name 			= trim( $_POST['c_name'] );
		$email 			= trim( $_POST['c_email'] );
		$phone 			= trim( $_POST['c_phone'] );
		$website		= trim( $_POST['c_website'] );
		$comments 		= trim( $_POST['c_comments'] );
		$captcha 		= trim( $_POST['c_captcha'] );
		$captcha_cnf	= trim( $_POST['c_captcha_confirm'] );

		if( !$name )
			$cerr['name'] = 'Please enter your name.';
		if( ! filter_var($email, FILTER_VALIDATE_EMAIL) ) 
			$cerr['email'] = 'Please enter a valid email.';
		if( !$phone )
			$cerr['phone'] = 'Please enter your phone number.';
		if( !$comments )
			$cerr['comments'] = 'Please enter your message.';
		if( !$captcha || (md5($captcha) != $captcha_cnf) )
			$cerr['captcha'] = 'Please enter the correct answer.';

		if( count($cerr) == 0 ){
			$subject = $atts['title'];
			$headers = "From: ".$name." <" . strip_tags($email) . ">\r\n";
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

			$message = '<html><body>
							<table>
								<tr><td>Name: </td><td>'.$name.'</td></tr>
								<tr><td>Email: </td><td>'.$email.'</td></tr>
								<tr><td>Phone: </td><td>'.$phone.'</td></tr>
								<tr><td>Website: </td><td>'.$website.'</td></tr>
								<tr><td>Message: </td><td>'.$comments.'</td></tr>
							</table>
						</body>
					</html>';
			mail( $atts['to_email'], $subject, $message, $headers);
			$cform .= '<div class="success_msg">Thank you! A representative will get back to you very shortly.</div>';
			unset( $name, $email, $phone, $website, $comments, $captcha );
		}else{
			$cform .= '<div class="error_msg">';
			$cform .= implode('<br />',$cerr);
			$cform .= '</div>';
		}
	}

	$capNum1 	= rand(1,4);
	$capNum2 	= rand(1,5);
	$capSum		= $capNum1 + $capNum2;
	$sumStr		= $capNum1." + ".$capNum2 ." = ";

	$cform .= "<form name=\"contactform\" action=\"#contactform_main\" method=\"post\">
			<p><input type=\"text\" name=\"c_name\" value=\"". ( ( empty($name) == false ) ? $name : "" ) ."\" placeholder=\"Name\" /></p>
			<p><input type=\"email\" name=\"c_email\" value=\"". ( ( empty($email) == false ) ? $email : "" ) ."\" placeholder=\"Email\" /></p><div class=\"clear\"></div>
			<p><input type=\"tel\" name=\"c_phone\" value=\"". ( ( empty($phone) == false ) ? $phone : "" ) ."\" placeholder=\"Phone\" /></p>
			<p><input type=\"url\" name=\"c_website\" value=\"". ( ( empty($website) == false ) ? $website : "" ) ."\" placeholder=\"Website with prefix http://\" /></p><div class=\"clear\"></div>
			<p><textarea name=\"c_comments\" placeholder=\"Message\">". ( ( empty($comments) == false ) ? $comments : "" ) ."</textarea></p>";
	$cform .= "<p>$sumStr<input style=\"width:200px;\" type=\"text\" placeholder=\"Captcha\" value=\"". ( ( empty($captcha) == false ) ? $captcha : "" ) ."\" name=\"c_captcha\" /><input type=\"hidden\" name=\"c_captcha_confirm\" value=\"". md5($capSum)."\"></p><div class=\"clear\"></div>";
	$cform .= "<p class=\"sub\"><input type=\"submit\" name=\"c_submit\" value=\"Submit\" class=\"search-submit\" /></p>
		</form>
	</div>";

    return $cform;
}
add_shortcode( 'contactform', 'contactform_func' );

//custom post type for Our photogallery
function my_custom_post_photogallery() {
	$labels = array(
		'name'               => __( 'Photo Gallery','skt-restaurant' ),
		'singular_name'      => __( 'Photo Gallery','skt-restaurant' ),
		'add_new'            => __( 'Add New','skt-restaurant' ),
		'add_new_item'       => __( 'Add New Image','skt-restaurant' ),
		'edit_item'          => __( 'Edit Image','skt-restaurant' ),
		'new_item'           => __( 'New Image','skt-restaurant' ),
		'all_items'          => __( 'All Images','skt-restaurant' ),
		'view_item'          => __( 'View Image','skt-restaurant' ),
		'search_items'       => __( 'Search Images','skt-restaurant' ),
		'not_found'          => __( 'No images found','skt-restaurant' ),
		'not_found_in_trash' => __( 'No images found in the Trash','skt-restaurant' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Photo Gallery'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Photo Gallery',
		'public'        => true,
		'menu_icon'		=> 'dashicons-format-image',
		'menu_position' => null,
		'supports'      => array( 'title', 'editor', 'thumbnail' ),
		'has_archive'   => true,
	);
	register_post_type( 'photogallery', $args );
}
add_action( 'init', 'my_custom_post_photogallery' );


//  register gallery taxonomy
register_taxonomy( "gallerycategory", 
	array("photogallery"), 
	array(
		"hierarchical" => true, 
		"label" => "Gallery Category", 
		"singular_label" => "Photo Gallery", 
		"rewrite" => true
	)
);

add_action("manage_posts_custom_column",  "photogallery_custom_columns");
add_filter("manage_edit-photogallery_columns", "photogallery_edit_columns");
function photogallery_edit_columns($columns){
	$columns = array(
		"cb" => '<input type="checkbox" />',
		"title" => "Gallery Title",
		"pcategory" => "Gallery Category",
		"view" => "Image",
		"date" => "Date",
	);
	return $columns;
}
function photogallery_custom_columns($column){
	global $post;
	switch ($column) {
		case "pcategory":
			echo get_the_term_list($post->ID, 'gallerycategory', '', ', ','');
		break;
		case "view":
			the_post_thumbnail('thumbnail');
		break;
		case "date":

		break;
	}
}


//[photogallery filter="false"]
function photogallery_shortcode_func( $atts ) {
	extract( shortcode_atts( array(
		'show' => -1,
		'filter' => 'true'
	), $atts ) );
	$pfStr = '';
	
	if( $filter == 'true' ){
	$pfStr .= '<div class="controls"><ul><li class="filter" data-filter="all">Show All</li>';
	$categories = get_categories( array('taxonomy' => 'gallerycategory') );
	foreach ($categories as $category) {
		$pfStr .= '<li class="filter" data-filter="'.$category->term_id.'">'.$category->name.'</li>';
	}
	$pfStr .= '</ul></div>';
	}

	$pfStr .= '<div class="gallery"><ul id="Grid">';
	$j=0;
	$args = array(
			   'post_type'  => 'photogallery',
			   'posts_per_page' => $show,
				'meta_query' => array(
					array(
					 'key' => '_thumbnail_id',
					 'compare' => 'EXISTS'
					),
				)
			);
	query_posts($args); 
	if ( have_posts() ) : 
	while ( have_posts() ) : the_post(); 
	$j++;	
	$imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), array(347, 270));
	$terms = wp_get_post_terms( get_the_ID(), 'gallerycategory', array("fields" => "all"));
	$slugAr = array();
	foreach( $terms as $tv ){
		$slugAr[] = $tv->term_id;
	}
	$pfStr .= '<li class="mix '.implode(' ', $slugAr).'" '.( ($j%4==0) ? 'style="margin-right:0"' : '' ).'>
			   <strong>'.get_the_title().'</strong><a href="'.$imgSrc[0].'" rel="prettyPhoto[pp_gal]"><img src="'.$imgSrc[0].'"/></a></li>';
	unset( $slugAr );
	endwhile; else: 
		$pfStr .= '<p>Sorry, photo gallery is empty.</p>';
	endif; 
	wp_reset_query();	
	$pfStr .= '</ul></div>';
	return $pfStr;
}
add_shortcode( 'photogallery', 'photogallery_shortcode_func' );



/* Code For Our Menu */
//custom post type for Our Menu
function my_custom_post_ourmenu() {
	$labels = array(
		'name'               => __( 'Our Menu','skt-restaurant' ),
		'singular_name'      => __( 'Our Menu','skt-restaurant' ),
		'add_new'            => __( 'Add New','skt-restaurant' ),
		'add_new_item'       => __( 'Add New Menu','skt-restaurant' ),
		'edit_item'          => __( 'Edit Menu','skt-restaurant' ),
		'new_item'           => __( 'New Menu','skt-restaurant' ),
		'all_items'          => __( 'All Menu','skt-restaurant' ),
		'view_item'          => __( 'View Menu','skt-restaurant' ),
		'search_items'       => __( 'Search Menu','skt-restaurant' ),
		'not_found'          => __( 'No menu found','skt-restaurant' ),
		'not_found_in_trash' => __( 'No menu found in the Trash','skt-restaurant' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Our Menu'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Our Menu',
		'public'        => true,
		'menu_icon'		=> 'dashicons-images-alt2',
		'menu_position' => null,
		'supports'      => array( 'title', 'editor', 'thumbnail' ),
		'has_archive'   => true,
	);
	register_post_type( 'ourmenu', $args );
}
add_action( 'init', 'my_custom_post_ourmenu' );


//  register menu taxonomy
register_taxonomy( "menucategory", 
	array("ourmenu"), 
	array(
		"hierarchical" => true, 
		"label" => "Menu Category", 
		"singular_label" => "Our Menu", 
		"rewrite" => true
	)
);

add_action("manage_posts_custom_column",  "ourmenu_custom_columns");
add_filter("manage_edit-ourmenu_columns", "ourmenu_edit_columns");
function ourmenu_edit_columns($columns){
	$columns = array(
		"cb" => '<input type="checkbox" />',
		"title" => "Menu Title",
		"pcategory" => "Menu Category",
		"view" => "Image",
		"date" => "Date",
	);
	return $columns;
}
function ourmenu_custom_columns($column){
	global $post;
	switch ($column) {
		case "pcategory":
			echo get_the_term_list($post->ID, 'menucategory', '', ', ','');
		break;
		case "view":
			//the_post_thumbnail('thumbnail');
		break;
		case "date":

		break;
	}
}


//[ourmenu filter="false"] for inner page
function ourmenuinner_shortcode_func( $atts ) {
 extract( shortcode_atts( array(
  'show' => -1,
  'filter' => 'true'
 ), $atts ) );
 $pfStr = '';
 $pfStr .= '<div id="menulist">';
 if( $filter == 'true' ){
  $pfStr .= '<div class="omfilter-gallery"><ul id="filter"><li class="filter" data-filter="all">Show All</li>';
  $categories = get_categories( array('taxonomy' => 'menucategory') );
  foreach ($categories as $category) {
   $pfStr .= '<li class="filter" data-filter="'.$category->term_id.'">'.$category->name.'</li>';
  }
  $pfStr .= '</ul></div>';
 }

 $pfStr .= '<div class="omgallery"><ul id="portfolio">';
 $j=0;
 $args = array(
      'post_type'  => 'ourmenu',
      'posts_per_page' => $show,
    'meta_query' => array(
     array(
      'key' => '_thumbnail_id',
      'compare' => 'exists'
     ),
    )
   );
 query_posts($args); 
 if ( have_posts() ) : while ( have_posts() ) : the_post(); 
 $j++;
  $imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail');
  $terms = wp_get_post_terms( get_the_ID(), 'menucategory', array("fields" => "all"));
  $slugAr = array(); 
 
  foreach( $terms as $tv ){
   $slugAr[] = $tv->term_id;
  }
  
  $pfStr .= '<li class="mix '.implode(' ', $slugAr).'" '.( ($j%2==0) ? 'style="margin-right:0"' : '' ).'>
   <div class="menuthumb"><a href="'.get_the_permalink().'"><img src="'.$imgSrc[0].'"/></a></div>
   <h5>'.get_the_title().'</h5>
  '.content( of_get_option('menuexcerptlength') ).'
   <span>'.get_post_meta( get_the_ID(), 'menu_price', true ).'</span>
       
   
            </li>';
  unset( $slugAr );
 endwhile; else: 
  $pfStr .= '<p>Sorry, our menu is empty.</p>';
 endif; 
 wp_reset_query();
 $pfStr .= '</ul></div>';
 $pfStr .= '<div class="clear"></div></div></div>';
 return $pfStr;
}
add_shortcode( 'ourmenu-innerpage', 'ourmenuinner_shortcode_func' );


//[ourmenu filter="false"]
function ourmenu_shortcode_func( $atts ) {
	extract( shortcode_atts( array(
		'show' => -1,
		'filter' => 'false'
	), $atts ) );
	$pfStr = '';

	$pfStr .= '<div class="omphotobooth">';
	if( $filter == 'true' ){
		$pfStr .= '<div class="omfilter-gallery"><ul class="clean" id="filter"><li class="current"><a href="javascript:void(0)">All</a></li>';
		$categories = get_categories( array('taxonomy' => 'menucategory') );
		foreach ($categories as $category) {
			$pfStr .= '<li><a href="javascript:void(0)">'.$category->name.'</a></li>';
		}
		$pfStr .= '</ul></div>';
	}

	$pfStr .= '<div class="omgallery"><ul class="clean" id="portfolio">';
	$j=0;
	query_posts('post_type=ourmenu&posts_per_page='.$show); 
	if ( have_posts() ) : while ( have_posts() ) : the_post(); 
	$j++;
		$imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail');
		$terms = wp_get_post_terms( get_the_ID(), 'menucategory', array("fields" => "all"));
		$slugAr = array();
		foreach( $terms as $tv ){
			$slugAr[] = $tv->slug;
		}
		if ( $imgSrc[0]!='' ) {
			$imgUrl = $imgSrc[0];
		}else{
			$imgUrl = get_template_directory_uri().'/images/img_404.png';
		}
		$pfStr .= '<li class="'.implode(' ', $slugAr).'" '.( ($j%3==0) ? 'style="margin-right:0"' : '' ).'>
		 <strong>'.get_the_title().'</strong>
		 <img src="'.$imgSrc[0].'"/>
            </li>';
		unset( $slugAr );
	endwhile; else: 
		$pfStr .= '<p>Sorry, our menu is empty.</p>';
	endif; 
	wp_reset_query();
	$pfStr .= '</ul></div>';
	$pfStr .= '<div class="clear"></div></div>';
	return $pfStr;
}
add_shortcode( 'ourmenu', 'ourmenu_shortcode_func' );


// add meta box to menu
add_action( 'admin_init', 'my_menu_admin' );
function my_menu_admin() {
    add_meta_box( 'menu_meta_box',
        'Our Menu Info',
        'display_menu_meta_box',
        'ourmenu', 'normal', 'high'
    );
}

// add meta box form to menu
function display_menu_meta_box( $menu ) {
    // Retrieve current name of the Director and Movie Rating based on review ID
    $price = esc_html( get_post_meta( $menu->ID, 'menu_price', true ) );	
    ?>
    <table width="100%">
        <tr>
            <td width="20%">Menu Price</td>
            <td width="80%"><input type="text" size="80" name="menu_price" value="<?php echo $price; ?>" /></td>
        </tr>         
    </table>
    <?php 
}

// save menu meta box form data
add_action( 'save_post', 'add_menu_fields', 10, 2 );
function add_menu_fields( $menu_id, $menu ) {
    // Check post type for menu
    if ( $menu->post_type == 'ourmenu' ) {
        // Store data in post meta table if present in post data
        if ( isset( $_POST['menu_price'] ) && $_POST['menu_price'] != '' ) {
            update_post_meta( $menu_id, 'menu_price', $_POST['menu_price'] );
        }	
		
    }
}

/* Code For Our Menu */

function toggle_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'title' => 'Click here to toggle content',
	), $atts ) );
	$tog_content = "<div class=\"toggle_holder\"><h3 class=\"slide_toggle\"><a href=\"#\">{$title}</a></h3>
					<div class=\"slide_toggle_content\">".get_the_content_format( $content )."</div></div>";

	return $tog_content;
}
add_shortcode( 'toggle_content', 'toggle_func' );

function tabs_func( $atts, $content = null ) {
	$tabs = '<div class="tabs-wrapper"><ul class="tabs">'.do_shortcode($content).'</ul></div>';
	return $tabs;
}
add_shortcode( 'tabs', 'tabs_func' );

function tab_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'title' => 'Tab Title',
	), $atts ) );
	$rand = rand(100,999);
	$tab = '<li><a rel="tab'.$rand.'" href="javascript:void(0)"><span>'.$title.'</span></a><div id="tab'.$rand.'" class="tab-content">'.get_the_content_format($content).'</div></li>';
	return $tab;
}
add_shortcode( 'tab', 'tab_func' );

function gradient_button_func( $atts ) {
	extract( shortcode_atts( array(
		'size' => 'small',
		'bg_color' => '#636b74',
		'color' => '#fff',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'center',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" "; 
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"grad-btn-{$size} btn-align-{$position}\" style=\"background-color:{$bg_color}; color:{$color}\">";
	$btn .= "{$text}</a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'gradient_button', 'gradient_button_func' );

function simple_button_func( $atts ) {
	extract( shortcode_atts( array(
		'size' => 'small',
		'bg_color' => '#636b74',
		'color' => '#fff',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'left',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" "; 
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"simple-btn-{$size} btn-align-{$position}\" style=\"background-color:{$bg_color}; color:{$color}\">";
	$btn .= "{$text}</a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'simple_button', 'simple_button_func' );

function round_button_func( $atts ) {
	extract( shortcode_atts( array(
		'style' => 'dark',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'left',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" ";
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"round-btn-{$style} round-btn btn-align-{$position}\">";
	$btn .= "<span>{$text}</span></a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'round_button', 'round_button_func' );

function msg_box_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'type' => 'info',
		'bg_color' => '#f6f6f6',
		'color' => '#333',
		'start_color' => "#fff",
		'end_color' => "#eee",
		'border' => "#ccc",
		'align' => '',
		'width' => '100%',
	), $atts ) );
	$msg = '';

	if($type == 'success'){
		$msg  = '<div class="msg-success"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'success' style message box shortcode. To use this style use the following shortcode" : $content;
		$msg .= '</div></div>';
	}elseif($type == 'error'){
		$msg  = '<div class="msg-error"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'error' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'warning'){
		$msg  = '<div class="msg-warning"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'warning' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'info'){
		$msg  = '<div class="msg-info"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'info' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'about'){
		$msg  = '<div class="msg-about"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'about' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'custom'){
		$msg  = "<div style=\"width:{$width};\" class=\"msg-align-{$align}\"><div class=\"msg-custom\" style=\"background-color:{$end_color}; background: -moz-linear-gradient(center top , {$start_color}, {$end_color}); background: -webkit-gradient(linear, 0% 0%, 0% 100%, from({$start_color}), to({$end_color})); background: -webkit-linear-gradient(top, {$start_color}, {$end_color}); background: -ms-linear-gradient(top, {$start_color}, {$end_color}); background: -o-linear-gradient(top, {$start_color}, {$end_color}); border:1px {$border} solid; color:{$color};\">";
		$msg .= ($content == '') ? "This is a sample of the 'simple' style message box shortcode." : $content;
		$msg .= '</div></div><div class="clear"></div>';
	}elseif($type == 'simple'){
		$msg  = "<div class=\"msg-simple\" style=\"background-color:{$bg_color}; color:{$color};\">";
		$msg .= ($content == '') ? "This is a sample of the 'simple' style message box shortcode." : $content;
		$msg .= '</div>';
	}
	return $msg;
}
add_shortcode( 'message', 'msg_box_func' );


function unorderedlist_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'style' => 'list-1',
	), $atts ) );
	$content = wpautop(trim($content));
	$ulist = '<ul class="'.$style.'">'.$content.'</ul>';
	return $ulist;
}
add_shortcode( 'unordered_list', 'unorderedlist_func' );
define('SKT_THEME_DOC','http://sktthemesdemo.net/documentation/skt-restaurant-doc/');