<?php 

/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */ 

function optionsframework_option_name() {
	// Change this to use your theme slug
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );	
	return $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'skt-restaurant'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {
	//array of all custom font types.
	$font_types = array( '' => '',
    'ABeeZee' => 'ABeeZee',
    'Abel' => 'Abel',
    'Abril Fatface' => 'Abril Fatface',
    'Aclonica' => 'Aclonica',
    'Acme' => 'Acme',
    'Actor' => 'Actor',
    'Adamina' => 'Adamina',
    'Advent Pro' => 'Advent Pro',
    'Aguafina Script' => 'Aguafina Script',
    'Akronim' => 'Akronim',
    'Aladin' => 'Aladin',
    'Aldrich' => 'Aldrich',
    'Alegreya' => 'Alegreya',
    'Alegreya Sans SC' => 'Alegreya Sans SC',
    'Alegreya SC' => 'Alegreya SC',
    'Alex Brush' => 'Alex Brush',
    'Alef' => 'Alef',
    'Alfa Slab One' => 'Alfa Slab One',
    'Alice' => 'Alice',
    'Alike' => 'Alike',
    'Alike Angular' => 'Alike Angular',
    'Allan' => 'Allan',
    'Allerta' => 'Allerta',
    'Allerta Stencil' => 'Allerta Stencil',
    'Allura' => 'Allura',
    'Almendra' => 'Almendra',
    'Almendra Display' => 'Almendra Display',
    'Almendra SC' => 'Almendra SC',
    'Amiri' => 'Amiri',
    'Amarante' => 'Amarante',
    'Amaranth' => 'Amaranth',
    'Amatic SC' => 'Amatic SC',
    'Amethysta' => 'Amethysta',
    'Amita' => 'Amita',
    'Anaheim' => 'Anaheim',
    'Andada' => 'Andada',
    'Andika' => 'Andika',
    'Annie Use Your Telescope' => 'Annie Use Your Telescope',
    'Anonymous Pro' => 'Anonymous Pro',
    'Antic' => 'Antic',
    'Antic Didone' => 'Antic Didone',
    'Antic Slab' => 'Antic Slab',
    'Anton' => 'Anton',
    'Angkor' => 'Angkor',
    'Arapey' => 'Arapey',
    'Arbutus' => 'Arbutus',
    'Arbutus Slab' => 'Arbutus Slab',
    'Architects Daughter' => 'Architects Daughter',
    'Archivo White' => 'Archivo White',
    'Archivo Narrow' => 'Archivo Narrow',
    'Arial' => 'Arial',
    'Arimo' => 'Arimo',
    'Arya' => 'Arya',
    'Arizonia' => 'Arizonia',
    'Armata' => 'Armata',
    'Artifika' => 'Artifika',
    'Arvo' => 'Arvo',
    'Asar' => 'Asar',
    'Asap' => 'Asap',
    'Asset' => 'Asset',
    'Astloch' => 'Astloch',
    'Asul' => 'Asul',
    'Atomic Age' => 'Atomic Age',
    'Aubrey' => 'Aubrey',
    'Audiowide' => 'Audiowide',
    'Autour One' => 'Autour One',
    'Average' => 'Average',
    'Average Sans' => 'Average Sans',
    'Averia Gruesa Libre' => 'Averia Gruesa Libre',
    'Averia Libre' => 'Averia Libre',
    'Averia Sans Libre' => 'Averia Sans Libre',
    'Averia Serif Libre' => 'Averia Serif Libre',
    'Battambang' => 'Battambang',
    'Bad Script' => 'Bad Script',
    'Bayon' => 'Bayon',
    'Balthazar' => 'Balthazar',
    'Bangers' => 'Bangers',
    'Basic' => 'Basic',
    'Baumans' => 'Baumans',
    'Belgrano' => 'Belgrano',
    'Belleza' => 'Belleza',
    'BenchNine' => 'BenchNine',
    'Bentham' => 'Bentham',
    'Berkshire Swash' => 'Berkshire Swash',
    'Bevan' => 'Bevan',
    'Bigelow Rules' => 'Bigelow Rules',
    'Bigshot One' => 'Bigshot One',
    'Bilbo' => 'Bilbo',
    'Bilbo Swash Caps' => 'Bilbo Swash Caps',
    'Biryani' => 'Biryani',
    'Bitter' => 'Bitter',
    'White Ops One' => 'White Ops One',
    'Bokor' => 'Bokor',
    'Bonbon' => 'Bonbon',
    'Boogaloo' => 'Boogaloo',
    'Bowlby One' => 'Bowlby One',
    'Bowlby One SC' => 'Bowlby One SC',
    'Brawler' => 'Brawler',
    'Bree Serif' => 'Bree Serif',
    'Bubblegum Sans' => 'Bubblegum Sans',
    'Bubbler One' => 'Bubbler One',
    'Buda' => 'Buda',
    'Buenard' => 'Buenard',
    'Butcherman' => 'Butcherman',
    'Butcherman Caps' => 'Butcherman Caps',
    'Butterfly Kids' => 'Butterfly Kids',
    'Cabin' => 'Cabin',
    'Cabin Condensed' => 'Cabin Condensed',
    'Cabin Sketch' => 'Cabin Sketch',
    'Cabin' => 'Cabin',
    'Caesar Dressing' => 'Caesar Dressing',
    'Cagliostro' => 'Cagliostro',
    'Calligraffitti' => 'Calligraffitti',
    'Cambay' => 'Cambay',
    'Cambo' => 'Cambo',
    'Candal' => 'Candal',
    'Cantarell' => 'Cantarell',
    'Cantata One' => 'Cantata One',
    'Cantora One' => 'Cantora One',
    'Capriola' => 'Capriola',
    'Cardo' => 'Cardo',
    'Carme' => 'Carme',
    'Carrois Gothic' => 'Carrois Gothic',
    'Carrois Gothic SC' => 'Carrois Gothic SC',
    'Carter One' => 'Carter One',
    'Caveat' => 'Caveat',
    'Caveat Brush' => 'Caveat Brush',
    'Catamaran' => 'Catamaran',
    'Caudex' => 'Caudex',
    'Cedarville Cursive' => 'Cedarville Cursive',
    'Ceviche One' => 'Ceviche One',
    'Changa One' => 'Changa One',
    'Chango' => 'Chango',
    'Chau Philomene One' => 'Chau Philomene One',
    'Chenla' => 'Chenla',
    'Chela One' => 'Chela One',
    'Chelsea Market' => 'Chelsea Market',
    'Cherry Cream Soda' => 'Cherry Cream Soda',
    'Cherry Swash' => 'Cherry Swash',
    'Chewy' => 'Chewy',
    'Chicle' => 'Chicle',
    'Chivo' => 'Chivo',
    'Chonburi' => 'Chonburi',
    'Cinzel' => 'Cinzel',
    'Cinzel Decorative' => 'Cinzel Decorative',
    'Clicker Script' => 'Clicker Script',
    'Coda' => 'Coda',
    'Codystar' => 'Codystar',
    'Combo' => 'Combo',
    'Comfortaa' => 'Comfortaa',
    'Coming Soon' => 'Coming Soon',
    'Condiment' => 'Condiment',
    'Content' => 'Content',
    'Contrail One' => 'Contrail One',
    'Convergence' => 'Convergence',
    'Cookie' => 'Cookie',
    'Comic Sans MS' => 'Comic Sans MS',
    'Copse' => 'Copse',
    'Corben' => 'Corben',
    'Courgette' => 'Courgette',
    'Cousine' => 'Cousine',
    'Coustard' => 'Coustard',
    'Covered By Your Grace' => 'Covered By Your Grace',
    'Crafty Girls' => 'Crafty Girls',
    'Creepster' => 'Creepster',
    'Creepster Caps' => 'Creepster Caps',
    'Crete Round' => 'Crete Round',
    'Crimson' => 'Crimson',
    'Croissant One' => 'Croissant One',
    'Crushed' => 'Crushed',
    'Cuprum' => 'Cuprum',
    'Cutive' => 'Cutive',
    'Cutive Mono' => 'Cutive Mono',
    'Damion' => 'Damion',
    'Dangrek' => 'Dangrek',
    'Dancing Script' => 'Dancing Script',
    'Dawning of a New Day' => 'Dawning of a New Day',
    'Days One' => 'Days One',
    'Dekko' => 'Dekko',
    'Delius' => 'Delius',
    'Delius Swash Caps' => 'Delius Swash Caps',
    'Delius Unicase' => 'Delius Unicase',
    'Della Respira' => 'Della Respira',
    'Denk One' => 'Denk One',
    'Devonshire' => 'Devonshire',
    'Dhurjati' => 'Dhurjati',
    'Didact Gothic' => 'Didact Gothic',
    'Diplomata' => 'Diplomata',
    'Diplomata SC' => 'Diplomata SC',
    'Domine' => 'Domine',
    'Donegal One' => 'Donegal One',
    'Doppio One' => 'Doppio One',
    'Dorsa' => 'Dorsa',
    'Dosis' => 'Dosis',
    'Dr Sugiyama' => 'Dr Sugiyama',
    'Droid Sans' => 'Droid Sans',
    'Droid Sans Mono' => 'Droid Sans Mono',
    'Droid Serif' => 'Droid Serif',
    'Duru Sans' => 'Duru Sans',
    'Dynalight' => 'Dynalight',
    'EB Garamond' => 'EB Garamond',
    'Eczar' => 'Eczar',
    'Eagle Lake' => 'Eagle Lake',
    'Eater' => 'Eater',
    'Eater Caps' => 'Eater Caps',
    'Economica' => 'Economica',
    'Ek Mukta' => 'Ek Mukta',
    'Electrolize' => 'Electrolize',
    'Elsie' => 'Elsie',
    'Elsie Swash Caps' => 'Elsie Swash Caps',
    'Emblema One' => 'Emblema One',
    'Emilys Candy' => 'Emilys Candy',
    'Engagement' => 'Engagement',
    'Englebert' => 'Englebert',
    'Enriqueta' => 'Enriqueta',
    'Erica One' => 'Erica One',
    'Esteban' => 'Esteban',
    'Euphoria Script' => 'Euphoria Script',
    'Ewert' => 'Ewert',
    'Exo' => 'Exo',
    'Exo 2' => 'Exo 2',
    'Expletus Sans' => 'Expletus Sans',
    'Fanwood Text' => 'Fanwood Text',
    'Fascinate' => 'Fascinate',
    'Fascinate Inline' => 'Fascinate Inline',
    'Fasthand' => 'Fasthand',
    'Faster One' => 'Faster One',
    'Federant' => 'Federant',
    'Federo' => 'Federo',
    'Felipa' => 'Felipa',
    'Fenix' => 'Fenix',
    'Finger Paint' => 'Finger Paint',
    'Fira Mono' => 'Fira Mono',
    'Fira Sans' => 'Fira Sans',
    'Fjalla One' => 'Fjalla One',
    'Fjord One' => 'Fjord One',
    'Flamenco' => 'Flamenco',
    'Flavors' => 'Flavors',
    'Fondamento' => 'Fondamento',
    'Fontdiner Swanky' => 'Fontdiner Swanky',
    'Forum' => 'Forum',
    'Francois One' => 'Francois One',
    'FreeSans' => 'FreeSans',

    'Freckle Face' => 'Freckle Face',
    'Fredericka the Great' => 'Fredericka the Great',
    'Fredoka One' => 'Fredoka One',
    'Fresca' => 'Fresca',
    'Freehand' => 'Freehand',
    'Frijole' => 'Frijole',
    'Fruktur' => 'Fruktur',
    'Fugaz One' => 'Fugaz One',
    'Gafata' => 'Gafata',
    'Galdeano' => 'Galdeano',
    'Galindo' => 'Galindo',
    'Gentium Basic' => 'Gentium Basic',
    'Gentium Book Basic' => 'Gentium Book Basic',
    'Geo' => 'Geo',
    'Georgia' => 'Georgia',
    'Geostar' => 'Geostar',
    'Geostar Fill' => 'Geostar Fill',
    'Germania One' => 'Germania One',
    'Gilda Display' => 'Gilda Display',
    'Give You Glory' => 'Give You Glory',
    'Glass Antiqua' => 'Glass Antiqua',
    'Glegoo' => 'Glegoo',
    'Gloria Hallelujah' => 'Gloria Hallelujah',
    'Goblin One' => 'Goblin One',
    'Gochi Hand' => 'Gochi Hand',
    'Gorditas' => 'Gorditas',
    'Gurajada' => 'Gurajada',
    'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
    'Graduate' => 'Graduate',
    'Grand Hotel' => 'Grand Hotel',
    'Gravitas One' => 'Gravitas One',
    'Great Vibes' => 'Great Vibes',
    'Griffy' => 'Griffy',
    'Gruppo' => 'Gruppo',
    'Gudea' => 'Gudea',
    'Gidugu' => 'Gidugu',
    'GFS Didot' => 'GFS Didot',
    'GFS Neohellenic' => 'GFS Neohellenic',
    'Habibi' => 'Habibi',
    'Hammersmith One' => 'Hammersmith One',
    'Halant' => 'Halant',
    'Hanalei' => 'Hanalei',
    'Hanalei Fill' => 'Hanalei Fill',
    'Handlee' => 'Handlee',
    'Hanuman' => 'Hanuman',
    'Happy Monkey' => 'Happy Monkey',
    'Headland One' => 'Headland One',
    'Henny Penny' => 'Henny Penny',
    'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
    'Hind' => 'Hind',
    'Hind Siliguri' => 'Hind Siliguri',
    'Hind Vadodara' => 'Hind Vadodara',
    'Holtwood One SC' => 'Holtwood One SC',
    'Homemade Apple' => 'Homemade Apple',
    'Homenaje' => 'Homenaje',
    'IM Fell' => 'IM Fell',
    'Itim' => 'Itim',
    'Iceberg' => 'Iceberg',
    'Iceland' => 'Iceland',
    'Imprima' => 'Imprima',
    'Inconsolata' => 'Inconsolata',
    'Inder' => 'Inder',
    'Indie Flower' => 'Indie Flower',
    'Inknut Antiqua' => 'Inknut Antiqua',
    'Inika' => 'Inika',
    'Irish Growler' => 'Irish Growler',
    'Istok Web' => 'Istok Web',
    'Italiana' => 'Italiana',
    'Italianno' => 'Italianno',
    'Jacques Francois' => 'Jacques Francois',
    'Jacques Francois Shadow' => 'Jacques Francois Shadow',
    'Jim Nightshade' => 'Jim Nightshade',
    'Jockey One' => 'Jockey One',
    'Jaldi' => 'Jaldi',
    'Jolly Lodger' => 'Jolly Lodger',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Slab' => 'Josefin Slab',
    'Joti One' => 'Joti One',
    'Judson' => 'Judson',
    'Julee' => 'Julee',
    'Julius Sans One' => 'Julius Sans One',
    'Junge' => 'Junge',
    'Jura' => 'Jura',
    'Just Another Hand' => 'Just Another Hand',
    'Just Me Again Down Here' => 'Just Me Again Down Here',
    'Kadwa' => 'Kadwa',
    'Kdam Thmor' => 'Kdam Thmor',
    'Kalam' => 'Kalam', 
    'Kameron' => 'Kameron',
    'Kantumruy' => 'Kantumruy',
    'Karma' => 'Karma',
    'Karla' => 'Karla',
    'Kaushan Script' => 'Kaushan Script',
    'Kavoon' => 'Kavoon',
    'Keania One' => 'Keania One',
    'Kelly Slab' => 'Kelly Slab',
    'Kenia' => 'Kenia',
    'Khand' => 'Khand',
    'Khmer' => 'Khmer',
    'Khula' => 'Khula',
    'Kite One' => 'Kite One',
    'Knewave' => 'Knewave',
    'Kotta One' => 'Kotta One',
    'Kranky' => 'Kranky',
    'Kreon' => 'Kreon',
    'Kristi' => 'Kristi',
    'Koulen' => 'Koulen',
    'Krona One' => 'Krona One',
    'Kurale' => 'Kurale',
    'Lakki Reddy' => 'Lakki Reddy',
    'La Belle Aurore' => 'La Belle Aurore',
    'Lancelot' => 'Lancelot',
    'Laila' => 'Laila',
    'Lato' => 'Lato',
    'Lateef' => 'Lateef',
    'League Script' => 'League Script',
    'Leckerli One' => 'Leckerli One',
    'Ledger' => 'Ledger',
    'Lekton' => 'Lekton',
    'Lemon' => 'Lemon',

    'Libre Baskerville' => 'Libre Baskerville',
    'Life Savers' => 'Life Savers',
    'Lilita One' => 'Lilita One',
    'Limelight' => 'Limelight',
    'Linden Hill' => 'Linden Hill',
    'Lobster' => 'Lobster',
    'Lobster Two' => 'Lobster Two',
    'Londrina Outline' => 'Londrina Outline',
    'Londrina Shadow' => 'Londrina Shadow',
    'Londrina Sketch' => 'Londrina Sketch',
    'Londrina Solid' => 'Londrina Solid',
    'Lora' => 'Lora',
    'Love Ya Like A Sister' => 'Love Ya Like A Sister',
    'Loved by the King' => 'Loved by the King',
    'Lovers Quarrel' => 'Lovers Quarrel',
    'Lucida Sans Unicode' => 'Lucida Sans Unicode',
    'Luckiest Guy' => 'Luckiest Guy',
    'Lusitana' => 'Lusitana',
    'Lustria' => 'Lustria',
    'Macondo' => 'Macondo',
    'Macondo Swash Caps' => 'Macondo Swash Caps',
    'Magra' => 'Magra',
    'Maiden Orange' => 'Maiden Orange',
    'Mallanna' => 'Mallanna',
    'Mandali' => 'Mandali',
    'Mako' => 'Mako',
    'Marcellus' => 'Marcellus',
    'Marcellus SC' => 'Marcellus SC',
    'Marck Script' => 'Marck Script',
    'Margarine' => 'Margarine',
    'Marko One' => 'Marko One',
    'Marmelad' => 'Marmelad',
    'Marvel' => 'Marvel',
    'Martel' => 'Martel',
    'Martel Sans' => 'Martel Sans',
    'Mate' => 'Mate',
    'Mate SC' => 'Mate SC',
    'Maven Pro' => 'Maven Pro',
    'McLaren' => 'McLaren',
    'Meddon' => 'Meddon',
    'MedievalSharp' => 'MedievalSharp',
    'Medula One' => 'Medula One',
    'Megrim' => 'Megrim',
    'Meie Script' => 'Meie Script',
    'Merienda' => 'Merienda',
    'Merienda One' => 'Merienda One',
    'Merriweather' => 'Merriweather',
    'Metal' => 'Metal',
    'Metal Mania' => 'Metal Mania',
    'Metamorphous' => 'Metamorphous',
    'Metrophobic' => 'Metrophobic',
    'Michroma' => 'Michroma',
    'Milonga' => 'Milonga',
    'Miltonian' => 'Miltonian',
    'Miltonian Tattoo' => 'Miltonian Tattoo',
    'Miniver' => 'Miniver',
    'Miss Fajardose' => 'Miss Fajardose',
    'Miss Saint Delafield' => 'Miss Saint Delafield',
    'Modak' => 'Modak',
    'Modern Antiqua' => 'Modern Antiqua',
    'Molengo' => 'Molengo',
    'Molle' => 'Molle',
    'Moulpali' => 'Moulpali',
    'Monda' => 'Monda',
    'Monofett' => 'Monofett',
    'Monoton' => 'Monoton',
    'Monsieur La Doulaise' => 'Monsieur La Doulaise',
    'Montaga' => 'Montaga',
    'Montez' => 'Montez',
    'Montserrat' => 'Montserrat',
    'Montserrat Alternates' => 'Montserrat Alternates',
    'Montserrat Subrayada' => 'Montserrat Subrayada',
    'Mountains of Christmas' => 'Mountains of Christmas',
    'Mouse Memoirs' => 'Mouse Memoirs',
    'Moul' => 'Moul',
    'Mr Bedford' => 'Mr Bedford',
    'Mr Bedfort' => 'Mr Bedfort',
    'Mr Dafoe' => 'Mr Dafoe',
    'Mr De Haviland' => 'Mr De Haviland',
    'Mrs Saint Delafield' => 'Mrs Saint Delafield',
    'Mrs Sheppards' => 'Mrs Sheppards',
    'Muli' => 'Muli',
    'Mystery Quest' => 'Mystery Quest',
    'Neucha' => 'Neucha',
    'Neuton' => 'Neuton',
    'New Rocker' => 'New Rocker',
    'News Cycle' => 'News Cycle',
    'Niconne' => 'Niconne',
    'Nixie One' => 'Nixie One',
    'Nobile' => 'Nobile',
    'Nokora' => 'Nokora',
    'Norican' => 'Norican',
    'Nosifer' => 'Nosifer',
    'Nosifer Caps' => 'Nosifer Caps',
    'Nova Mono' => 'Nova Mono',
    'Noticia Text' => 'Noticia Text',
    'Noto Sans' => 'Noto Sans',
    'Noto Serif' => 'Noto Serif',
    'Nova Round' => 'Nova Round',
    'Numans' => 'Numans',
    'Nunito' => 'Nunito',
    'NTR' => 'NTR',
    'Offside' => 'Offside',
    'Oldenburg' => 'Oldenburg',
    'Oleo Script' => 'Oleo Script',
    'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
    'Open Sans' => 'Open Sans',
    'Open Sans Condensed' => 'Open Sans Condensed',
    'Oranienbaum' => 'Oranienbaum',
    'Orbitron' => 'Orbitron',
    'Odor Mean Chey' => 'Odor Mean Chey',
    'Oregano' => 'Oregano',
    'Orienta' => 'Orienta',
    'Original Surfer' => 'Original Surfer',
    'Oswald' => 'Oswald',
    'Over the Rainbow' => 'Over the Rainbow',
    'Overlock' => 'Overlock',
    'Overlock SC' => 'Overlock SC',
    'Ovo' => 'Ovo',
    'Oxygen' => 'Oxygen',
    'Oxygen Mono' => 'Oxygen Mono',
    'Palanquin Dark' => 'Palanquin Dark',
    'Peddana' => 'Peddana',
    'Poppins' => 'Poppins',
    'PT Mono' => 'PT Mono',
    'PT Sans' => 'PT Sans',
    'PT Sans Caption' => 'PT Sans Caption',
    'PT Sans Narrow' => 'PT Sans Narrow',
    'PT Serif' => 'PT Serif',
    'PT Serif Caption' => 'PT Serif Caption',
    'Pacifico' => 'Pacifico',
    'Paprika' => 'Paprika',
    'Parisienne' => 'Parisienne',
    'Passero One' => 'Passero One',
    'Passion One' => 'Passion One',
    'Patrick Hand' => 'Patrick Hand',
    'Patrick Hand SC' => 'Patrick Hand SC',
    'Patua One' => 'Patua One',
    'Paytone One' => 'Paytone One',
    'Peralta' => 'Peralta',
    'Permanent Marker' => 'Permanent Marker',
    'Petit Formal Script' => 'Petit Formal Script',
    'Petrona' => 'Petrona',
    'Philosopher' => 'Philosopher',
    'Piedra' => 'Piedra',
    'Pinyon Script' => 'Pinyon Script',
    'Pirata One' => 'Pirata One',
    'Plaster' => 'Plaster',
    'Palatino Linotype' => 'Palatino Linotype',
    'Play' => 'Play',
    'Playball' => 'Playball',
    'Playfair Display' => 'Playfair Display',
    'Playfair Display SC' => 'Playfair Display SC',
    'Podkova' => 'Podkova',
    'Poiret One' => 'Poiret One',
    'Poller One' => 'Poller One',
    'Poly' => 'Poly',
    'Pompiere' => 'Pompiere',
    'Pontano Sans' => 'Pontano Sans',
    'Port Lligat Sans' => 'Port Lligat Sans',
    'Port Lligat Slab' => 'Port Lligat Slab',
    'Prata' => 'Prata',
    'Pragati Narrow' => 'Pragati Narrow',
    'Preahvihear' => 'Preahvihear',
    'Press Start 2P' => 'Press Start 2P',
    'Princess Sofia' => 'Princess Sofia',
    'Prociono' => 'Prociono',
    'Prosto One' => 'Prosto One',
    'Puritan' => 'Puritan',
    'Purple Purse' => 'Purple Purse',
    'Quando' => 'Quando',
    'Quantico' => 'Quantico',
    'Quattrocento' => 'Quattrocento',
    'Quattrocento Sans' => 'Quattrocento Sans',
    'Questrial' => 'Questrial',
    'Quicksand' => 'Quicksand',
    'Quintessential' => 'Quintessential',
    'Qwigley' => 'Qwigley',
    'Racing Sans One' => 'Racing Sans One',
    'Radley' => 'Radley',
    'Rajdhani' => 'Rajdhani',
    'Raleway Dots' => 'Raleway Dots',
    'Raleway' => 'Raleway',
    'Rambla' => 'Rambla',
    'Ramabhadra' => 'Ramabhadra',
    'Ramaraja' => 'Ramaraja',
    'Rammetto One' => 'Rammetto One',
    'Ranchers' => 'Ranchers',
    'Rancho' => 'Rancho',
    'Ranga' => 'Ranga',
    'Ravi Prakash' => 'Ravi Prakash',
    'Rationale' => 'Rationale',
    'Redressed' => 'Redressed',
    'Reenie Beanie' => 'Reenie Beanie',
    'Revalia' => 'Revalia',
    'Rhodium Libre' => 'Rhodium Libre',
    'Ribeye' => 'Ribeye',
    'Ribeye Marrow' => 'Ribeye Marrow',
    'Righteous' => 'Righteous',
    'Risque' => 'Risque',
    'Roboto' => 'Roboto',
    'Roboto Condensed' => 'Roboto Condensed',
    'Roboto Mono' => 'Roboto Mono',
    'Roboto Slab' => 'Roboto Slab',
    'Rochester' => 'Rochester',
    'Rock Salt' => 'Rock Salt',
    'Rokkitt' => 'Rokkitt',
    'Romanesco' => 'Romanesco',
    'Ropa Sans' => 'Ropa Sans',
    'Rosario' => 'Rosario',
    'Rosarivo' => 'Rosarivo',
    'Rouge Script' => 'Rouge Script',
    'Rozha One' => 'Rozha One',
    'Rubik' => 'Rubik',
    'Rubik One' => 'Rubik One',
    'Rubik Mono One' => 'Rubik Mono One',
    'Ruda' => 'Ruda',
    'Rufina' => 'Rufina',
    'Ruge Boogie' => 'Ruge Boogie',
    'Ruluko' => 'Ruluko',
    'Rum Raisin' => 'Rum Raisin',
    'Ruslan Display' => 'Ruslan Display',
    'Russo One' => 'Russo One',
    'Ruthie' => 'Ruthie',
    'Rye' => 'Rye',
    'Sacramento' => 'Sacramento',
    'Sail' => 'Sail',
    'Salsa' => 'Salsa',
    'Sanchez' => 'Sanchez',
    'Sancreek' => 'Sancreek',
    'Sahitya' => 'Sahitya',
    'Sansita One' => 'Sansita One',
    'Sarpanch' => 'Sarpanch',
    'Sarina' => 'Sarina',
    'Satisfy' => 'Satisfy',
    'Scada' => 'Scada',
    'Scheherazade' => 'Scheherazade',
    'Schoolbell' => 'Schoolbell',
    'Seaweed Script' => 'Seaweed Script',
    'Sarala' => 'Sarala',
    'Sevillana' => 'Sevillana',
    'Seymour One' => 'Seymour One',
    'Shadows Into Light' => 'Shadows Into Light',
    'Shadows Into Light Two' => 'Shadows Into Light Two',
    'Shanti' => 'Shanti',
    'Share' => 'Share',
    'Share Tech' => 'Share Tech',
    'Share Tech Mono' => 'Share Tech Mono',
    'Shojumaru' => 'Shojumaru',
    'Short Stack' => 'Short Stack',
    'Sigmar One' => 'Sigmar One',
    'Suranna' => 'Suranna',
    'Suravaram' => 'Suravaram',
    'Suwannaphum' => 'Suwannaphum',
    'Signika' => 'Signika',
    'Signika Negative' => 'Signika Negative',
    'Simonetta' => 'Simonetta',
    'Siemreap' => 'Siemreap',
    'Sirin Stencil' => 'Sirin Stencil',
    'Six Caps' => 'Six Caps',
    'Skranji' => 'Skranji',
    'Slackey' => 'Slackey',
    'Smokum' => 'Smokum',
    'Smythe' => 'Smythe',
    'Sniglet' => 'Sniglet',
    'Snippet' => 'Snippet',
    'Snowburst One' => 'Snowburst One',
    'Sofadi One' => 'Sofadi One',
    'Sofia' => 'Sofia',
    'Sonsie One' => 'Sonsie One',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Source Code Pro' => 'Source Code Pro',
    'Source Sans Pro' => 'Source Sans Pro',
    'Special I am one' => 'Special I am one',
    'Spicy Rice' => 'Spicy Rice',
    'Spinnaker' => 'Spinnaker',
    'Spirax' => 'Spirax',
    'Squada One' => 'Squada One',
    'Sree Krushnadevaraya' => 'Sree Krushnadevaraya',
    'Stalemate' => 'Stalemate',
    'Stalinist One' => 'Stalinist One',
    'Stardos Stencil' => 'Stardos Stencil',
    'Stint Ultra Condensed' => 'Stint Ultra Condensed',
    'Stint Ultra Expanded' => 'Stint Ultra Expanded',
    'Stoke' => 'Stoke',
    'Stoke' => 'Stoke',
    'Strait' => 'Strait',
    'Sura' => 'Sura',
    'Sumana' => 'Sumana',
    'Sue Ellen Francisco' => 'Sue Ellen Francisco',
    'Sunshiney' => 'Sunshiney',
    'Supermercado One' => 'Supermercado One',
    'Swanky and Moo Moo' => 'Swanky and Moo Moo',
    'Syncopate' => 'Syncopate',
    'Symbol' => 'Symbol',
    'Timmana' => 'Timmana',
    'Taprom' => 'Taprom',
    'Tangerine' => 'Tangerine',
    'Tahoma' => 'Tahoma',
    'Teko' => 'Teko',
    'Telex' => 'Telex',
    'Tenali Ramakrishna' => 'Tenali Ramakrishna',
    'Tenor Sans' => 'Tenor Sans',
    'Terminal Dosis' => 'Terminal Dosis',
    'Terminal Dosis Light' => 'Terminal Dosis Light',
    'Text Me One' => 'Text Me One',
    'The Girl Next Door' => 'The Girl Next Door',
    'Tienne' => 'Tienne',
    'Tillana' => 'Tillana',
    'Tinos' => 'Tinos',
    'Titan One' => 'Titan One',
    'Titillium Web' => 'Titillium Web',
    'Trade Winds' => 'Trade Winds',
    'Trebuchet MS' => 'Trebuchet MS',
    'Trocchi' => 'Trocchi',
    'Trochut' => 'Trochut',
    'Trykker' => 'Trykker',
    'Tulpen One' => 'Tulpen One',
    'Ubuntu' => 'Ubuntu',
    'Ubuntu Condensed' => 'Ubuntu Condensed',
    'Ubuntu Mono' => 'Ubuntu Mono',
    'Ultra' => 'Ultra',
    'Uncial Antiqua' => 'Uncial Antiqua',
    'Underdog' => 'Underdog',
    'Unica One' => 'Unica One',
    'UnifrakturCook' => 'UnifrakturCook',
    'UnifrakturMaguntia' => 'UnifrakturMaguntia',
    'Unkempt' => 'Unkempt',
    'Unlock' => 'Unlock',
    'Unna' => 'Unna',
    'VT323' => 'VT323',
    'Vampiro One' => 'Vampiro One',
    'Varela' => 'Varela',
    'Varela Round' => 'Varela Round',
    'Vast Shadow' => 'Vast Shadow',
    'Vesper Libre' => 'Vesper Libre',
    'Verdana' => 'Verdana',
    'Vibur' => 'Vibur',
    'Vidaloka' => 'Vidaloka',
    'Viga' => 'Viga',
    'Voces' => 'Voces',
    'Volkhov' => 'Volkhov',
    'Vollkorn' => 'Vollkorn',
    'Voltaire' => 'Voltaire',
    'Waiting for the Sunrise' => 'Waiting for the Sunrise',
    'Wallpoet' => 'Wallpoet',
    'Walter Turncoat' => 'Walter Turncoat',
    'Warnes' => 'Warnes',
    'Wellfleet' => 'Wellfleet',
    'Wendy One' => 'Wendy One',
    'Wire One' => 'Wire One',
    'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
    'Yantramanav' => 'Yantramanav',
    'Yellowtail' => 'Yellowtail',
    'Yeseva One' => 'Yeseva One',
    'Yesteryear' => 'Yesteryear',
    'Zeyada' => 'Zeyada'
  );

	//array of all font sizes.
	$font_sizes = array( 
		'10px' => '10px',
		'11px' => '11px',
	);
	for($n=12;$n<=200;$n+=1){
		$font_sizes[$n.'px'] = $n.'px';
	}

	// array of section content.
	$section_text = array(
		1 => array(
			'section_title'		=> '',
			'menutitle'			=> 'ourrestaurant',
			'bgcolor' 			=> '#ffffff',
			'bgimage'			=> '',
			'class'				=> 'our-restaurant',
			'content'			=> '[column_content type="one_half"]<img src="'.get_template_directory_uri().'/images/welcome-restaurant.png" />[/column_content][column_content type="one_half_last"]
			<h2>Welcome to Our Restaurant</h2>
			<p>Donec porta quis justo id pulvinar. Integer sed varius velit. Sed turpis nunc, imperdiet at mi nec, maximus maximus odio. Integer vel molestie ante. Curabitur blandit, purus id scelerisque posuere, enim diam mattis odio, vitae cursus nulla ex malesuada nisi. Pellentesque facilisis ullamcorper lacus, a lobortis urna porttitor eu. Suspendisse rutrum velit tellus, id volutpat risus condimentum non. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Ut sit amet aliquet metus, porttitor iaculis nunc. Quisque cursus ipsum ac lacinia faucibus. Quisque id dui vulputate, varius lectus vitae, congue purus.</p><a class="button" href="#">Read More...</a>[/column_content]',
		),
		
		2 => array(
			'section_title'	=> 'Today’s Special',
			'menutitle'		=> 'todayspecial',
			'bgcolor' 		=> '#f7f7f7',
			'bgimage'		=> '',
			'class'			=> 'todayspecial',
			'content'		=> '[todayspecial title="Food" icon="'.get_template_directory_uri().'/images/food.jpg" link="#"][/todayspecial][todayspecial title="Desert" icon="'.get_template_directory_uri().'/images/drink.jpg" link="#"][/todayspecial][todayspecial title="Drink" icon="'.get_template_directory_uri().'/images/desert.jpg" link="#"][/todayspecial]',
		),

		3 => array(
			'section_title'	=> '',
			'menutitle'		=> 'hmourmenu',
			'bgcolor' 		=> '',
			'bgimage'		=> get_template_directory_uri()."/images/ourmenu-bg.jpg",
			'class'			=> 'hmourmenu',
			'content'		=> '[column_content type="one_half"][ourmenu show="6"][/column_content][column_content type="one_half_last"]
			<h2>Our Menu</h2>
			[area class="MenuDesc"]<p>For those with pure food indulgence in mind, come next door and sate your desires with our ever changing internationally and seasonally inspired small plates.  We love food, lots of different food, just like you.</p>[/area]<a class="button" href="#">View the Full Menu</a>[/column_content]',
		),
		
		4 => array(
			'section_title'	=> 'Latest News',
			'menutitle'		=> 'news',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> 'latest-news',
			'content'		=> '[latestposts show="4"]',
		),	
		
		5 => array(
			'section_title'	=> 'Our Testimonials',
			'menutitle'		=> 'testimonials',
			'bgcolor' 		=> '#f7f7f7',
			'bgimage'		=> '',
			'class'			=> 'testimonials',
			'content'		=> '[testimonials]',
		
		),			
		
		6 => array(
			'section_title'	=> '',
			'menutitle'		=> 'reservation',
			'bgcolor' 		=> '',
			'bgimage'		=> get_template_directory_uri()."/images/openinhour-bg.jpg",
			'class'			=> 'officehour',
			'content'		=> '[column_content type="one_half"]
			<h2>Reservations</h2>
			[area class="commonbox"]<p>Aliquam et varius orci, ut ornare justo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque augue metus, blandit vel nibh sed, sollicitudin placerat quam. Quisque id scelerisque nibh. Phasellus in orci et felis tristique finibus non quis  Lorem ipsum dolor sit amet, consectetur adipiscing elit erat.</p> <a class="button2" href="">Book Now</a>[/area][/column_content]

[column_content type="one_half_last"]
<h2>Opening Hours</h2>
[area class="commonbox lstbx"][time_table]
[time_table_row title="Monday" start="10:00 am - to - 08:00pm"]
[time_table_row title="Tuesday" start="10:30 pm - to - 09:00pm"]
[time_table_row title="Wednesday" start="09:00 am - to - 09:30pm"]
[time_table_row title="Thursday" start="09:00 am - to - 09:30pm"]
[time_table_row title="Friday" start="09:00 am - to - 05:00pm"]
[time_table_row title="Saturday" start="09:00 am - to - 04:00pm"]
[time_table_row title="Sunday" start="Closed"]
[/time_table][/area][/column_content]',
		),	
				
		7 => array(
			'section_title'	=> 'Photo Gallery',
			'menutitle'		=> 'ourgallery',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> 'our-projects',
			'content'		=> '[photogallery filter="false"] [blankspace height="50"]<center><a class="button" href="#">View Our Full Gallery</a></center>'
		),			

	);

	$options = array();

	//Basic Settings
	$options[] = array(
		'name' => __('Basic Settings', 'skt-restaurant'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Logo', 'skt-restaurant'),
		'desc' => __('Upload your main logo here', 'skt-restaurant'),
		'id' => 'logo',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/logo.png",
		'type' => 'upload');
		
	$options[] = array(		
		'desc' => __('change your logo height', 'skt-restaurant'),
		'id' => 'logoheight',
		'std' => '36',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Custom CSS', 'skt-restaurant'),
		'desc' => __('Some Custom Styling for your site. Place any css codes here instead of the style.css file.', 'skt-restaurant'),
		'id' => 'style2',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Sticky Header', 'skt-restaurant'),
		'desc' => __('Uncheck this to enable sticky header on scroll', 'skt-restaurant'),
		'id' => 'headstick',
		'std' => 'checked',
		'type' => 'checkbox');
		
	// font family start 
		
	$options[] = array(
		'name' => __('Font Faces', 'skt-restaurant'),
		'desc' => __('Select font for the body text', 'skt-restaurant'),
		'id' => 'bodyfontface',
		'type' => 'select',
		'std' => 'Arial',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the textual logo', 'skt-restaurant'),
		'id' => 'logofontface',
		'type' => 'select',
		'std' => 'Playball',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the navigation text', 'skt-restaurant'),
		'id' => 'navfontface',
		'type' => 'select',
		'std' => 'Roboto Condensed',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for heading text. eg: H1, H2, H3, H4, H5, H6', 'skt-restaurant'),
		'id' => 'headfontface',
		'type' => 'select',
		'std' => 'Playball',
		'options' => $font_types );
		
	// font sizes start	
	$options[] = array(
		'name' => __('Font Sizes', 'skt-restaurant'),
		'desc' => __('Select font size for body text', 'skt-restaurant'),
		'id' => 'bodyfontsize',
		'type' => 'select',
		'std' => '13px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for textual logo', 'skt-restaurant'),
		'id' => 'logofontsize',
		'type' => 'select',
		'std' => '36px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for navigation', 'skt-restaurant'),
		'id' => 'navfontsize',
		'type' => 'select',
		'std' => '15px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for reservation and opening hour box', 'skt-restaurant'),
		'id' => 'rohboxfontsize',
		'type' => 'select',
		'std' => '14px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for section title', 'skt-restaurant'),
		'id' => 'sectitlesize',
		'type' => 'select',
		'std' => '38px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for todays special box title', 'skt-restaurant'),
		'id' => 'spbxtitle',
		'type' => 'select',
		'std' => '48px',
		'options' => $font_sizes );	
		
	$options[] = array(
		'desc' => __('Select font size for footer title', 'skt-restaurant'),
		'id' => 'ftfontsize',
		'type' => 'select',
		'std' => '28px',
		'options' => $font_sizes );		

	// font colors start

	$options[] = array(
		'name' => __('Font Colors', 'skt-restaurant'),
		'desc' => __('Select font color for the body text', 'skt-restaurant'),
		'id' => 'bodyfontcolor',
		'std' => '#5c5c5c',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for textual logo', 'skt-restaurant'),
		'id' => 'logofontcolor',
		'std' => '#ffa200',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for section title', 'skt-restaurant'),
		'id' => 'sectitlecolor',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for reservation and opening hour box', 'skt-restaurant'),
		'id' => 'rohboxcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for navigation', 'skt-restaurant'),
		'id' => 'navfontcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for navigation hover', 'skt-restaurant'),
		'id' => 'navhovercolor',
		'std' => '#ffc600',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for todays specials box title', 'skt-restaurant'),
		'id' => 'spclbxtitle',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font hover color for todays specials box title', 'skt-restaurant'),
		'id' => 'spclhvbxtitle',
		'std' => '#ffc600',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for our menu box description', 'skt-restaurant'),
		'id' => 'ourmenudesc',
		'std' => '#ffffff',
		'type' => 'color');				
		
	$options[] = array(
		'desc' => __('Select font color for widget title', 'skt-restaurant'),
		'id' => 'wdgttitleccolor',
		'std' => '#2c2c2c',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer title', 'skt-restaurant'),
		'id' => 'foottitlecolor',
		'std' => '#fdfdf1',
		'type' => 'color');
		
	
	$options[] = array(
		'desc' => __('Select font color for footer', 'skt-restaurant'),
		'id' => 'footdesccolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer menu ', 'skt-restaurant'),
		'id' => 'footermenucolor',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select hover/active font color for footer menu ', 'skt-restaurant'),
		'id' => 'footermenucurrent',
		'std' => '#ffa200',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for footer left text (copyright)', 'skt-restaurant'),
		'id' => 'copycolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer right text (design by)', 'skt-restaurant'),
		'id' => 'designcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for links / anchor tags', 'skt-restaurant'),
		'id' => 'linkcolor',
		'std' => '#ffa200',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for links / anchor tags on hover', 'skt-restaurant'),
		'id' => 'linkhovercolor',
		'std' => '#a2a2a2',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select font color button', 'skt-restaurant'),
		'id' => 'btntxtcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color button on hover', 'skt-restaurant'),
		'id' => 'btntxthvcolor',
		'std' => '#ffffff',
		'type' => 'color');		
		
		
	$options[] = array(
		'desc' => __('Select font color for sidebar li a', 'skt-restaurant'),
		'id' => 'sidebarfontcolor',
		'std' => '#5c5c5c',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for book now button', 'skt-restaurant'),
		'id' => 'booknowfontcolor',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for our menu title', 'skt-restaurant'),
		'id' => 'hmmenutitle',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover/active color for our menu', 'skt-restaurant'),
		'id' => 'ourmenuhover',
		'std' => '#ffa200',
		'type' => 'color');	
		
			
	$options[] = array(
		'desc' => __('Select font color for tab, toggle, accordian', 'skt-restaurant'),
		'id' => 'togglecolor',
		'std' => '#3d3d3d',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font active color for tab, toggle, accordian', 'skt-restaurant'),
		'id' => 'toggleactive',
		'std' => '#ffa200',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for gallery filter', 'skt-restaurant'),
		'id' => 'glfilterfontcolor',
		'std' => '#5c5c5c',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover/active color for gallery filter', 'skt-restaurant'),
		'id' => 'glfilterfontcolorhv',
		'std' => '#ffa200',
		'type' => 'color');					
			
	
	// Background start		
	$options[] = array(	
		'name' => __('Background Colors', 'skt-restaurant'),	
		'desc' => __('Select background color for header', 'skt-restaurant'),
		'id' => 'headerbg',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background color opacity for header', 'skt-restaurant'),
		'id' => 'headerbgopacity',
		'std' => '0.3',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));
		
	$options[] = array(		
		'desc' => __('Select background color for reservation and opening hour box', 'skt-restaurant'),
		'id' => 'twoboxbg',
		'std' => '#ffa200',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background color opacity for reservation and opening hour box', 'skt-restaurant'),
		'id' => 'twoboxbgopacity',
		'std' => '0.7',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));		

		
	$options[] = array(
		'desc' => __('Select background color for button', 'skt-restaurant'),
		'id' => 'btncolor',
		'std' => '#ffa200',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select hover background color for button', 'skt-restaurant'),
		'id' => 'btnhvcolor',
		'std' => '#2f241e',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for footer', 'skt-restaurant'),
		'id' => 'footerbgcolor',
		'std' => '#272727',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for copyright section', 'skt-restaurant'),
		'id' => 'copybgcolor',
		'std' => '#131313',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for gallery hover', 'skt-restaurant'),
		'id' => 'galhvcolor',
		'std' => '#ffa200',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for our menu filter', 'skt-restaurant'),
		'id' => 'filterbgcolor',
		'std' => '#f2f2f2',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for book now button', 'skt-restaurant'),
		'id' => 'booknow',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for menu on responsive view', 'skt-restaurant'),
		'id' => 'menubgonresponsive',
		'std' => '#a2a2a2',
		'type' => 'color');		
		
		
	// Slider Caption colors
	$options[] = array(
		'name' => __('Slider Caption Colors', 'skt-restaurant'),
		'desc' => __('Select background color for slider caption title h2', 'skt-restaurant'),
		'id' => 'slidecaph2',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background color for slider description', 'skt-restaurant'),
		'id' => 'slidecapdes',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select font color for slider caption title', 'skt-restaurant'),
		'id' => 'slidetitlecolor',
		'std' => '#ffa200',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select font color for slider description', 'skt-restaurant'),
		'id' => 'slidedesccolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font size for slider title', 'skt-restaurant'),
		'id' => 'slidetitlefontsize',
		'type' => 'select',
		'std' => '40px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for slider description', 'skt-restaurant'),
		'id' => 'slidedescfontsize',
		'type' => 'select',
		'std' => '14px',
		'options' => $font_sizes );
		
	$options[] = array(		
		'desc' => __('Select background color opacity for slider caption', 'skt-restaurant'),
		'id' => 'slidecapopacity',
		'std' => '0.3',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));						
		
	// Slider controls colors
	$options[] = array(
		'name' => __('Slider controls Colors', 'skt-restaurant'),
		'desc' => __('Select background color for slider navigation', 'skt-restaurant'),
		'id' => 'sldnavbg',
		'std' => '#170f09',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for slider pager', 'skt-restaurant'),
		'id' => 'sldpagebg',
		'std' => '#170f09',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for slider pager active', 'skt-restaurant'),
		'id' => 'sldpagehvbg',
		'std' => '#ffa200',
		'type' => 'color');
		
	// Border colors			
	$options[] = array(
		'name' => __('Border Colors', 'skt-restaurant'),
		'desc' => __('Select font color for navigation hover bottom border', 'skt-restaurant'),
		'id' => 'navhoverborder',
		'std' => '#ffc600',
		'type' => 'color');	
		
	$options[] = array(
		'name' => __('Border Colors', 'skt-restaurant'),
		'desc' => __('Select border color for latest news boxes', 'skt-restaurant'),
		'id' => 'newsboxborder',
		'std' => '#ecebeb',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select border color for widget title', 'skt-restaurant'),
		'id' => 'wdgtbordercolor',
		'std' => '#cccccc',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select border color for opening hours', 'skt-restaurant'),
		'id' => 'ohborder',
		'std' => '#ffcc00',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select border color for footer title', 'skt-restaurant'),
		'id' => 'foottitleborder',
		'std' => '#333333',
		'type' => 'color');
		
		$options[] = array(
		'desc' => __('Select top border color for footer', 'skt-restaurant'),
		'id' => 'footerborder',
		'std' => '#131313',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select border color for social icons', 'skt-restaurant'),
		'id' => 'socialcolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select border hover color for social icons', 'skt-restaurant'),
		'id' => 'socialhvcolor',
		'std' => '#ffa200',
		'type' => 'color');
							
		
	//Blog Single Layout
	$options[] = array(
		'name' => __('Blog Single Layout', 'skt-restaurant'),
		'desc' => __('Select layout for blog single post ex. left sidebar, right sidebar, full width, no sidebar', 'skt-restaurant'),
		'id' => 'singlelayout',
		'type' => 'select',
		'std' => 'singleright',
		'options' => array('singleright'=>'Blog Single Right Sidebar', 'singleleft'=>'Blog Single Left Sidebar', 'sitefull'=>'Blog Single Full Width', 'nosidebar'=>'Blog Single No Sidebar') );		

		
	$options[] = array(
		'name' => __('Woocommerce Page Layout', 'skt-restaurant'),
		'desc' => __('Select layout. eg:Boxed, Wide', 'skt-restaurant'),
		'id' => 'woocomercelayout',
		'type' => 'select',
		'std' => 'woocomercesitefull',
		'options' => array('woocomerceright'=>'Woocomerce Right Sidebar', 'woocomerceleft'=>'Woocomerce Left Sidebar', 'woocomercesitefull'=>'Woocomerce Full Width') );
		
	$options[] = array(
		'name' => __('Responsive View Menu word changeable', 'skt-restaurant'),
		'desc' => __('Change menu word on responsive view', 'skt-restaurant'),
		'id' => 'menuwordchange',
		'std' => 'Menu',
		'type' => 'text');		
		
	$options[] = array(	
		'name' => __('Read More Text Button', 'skt-restaurant'),		
		'desc' => __('Change your read more button text for blog templates', 'skt-restaurant'),
		'id' => 'blogreadmoretext',
		'std' => 'Read More &raquo;',
		'type' => 'text');
		
	$options[] = array(					
		'desc' => __('Change your read more button text for homepage latest news', 'skt-restaurant'),
		'id' => 'hmlatestpostsreadmore',
		'std' => 'Read More...',
		'type' => 'text');		
		
	$options[] = array(		
		'name' => __('Custom Excerpt Length', 'skt-restaurant'),	
		'desc' => __('Select excerpt length for homepage latest news', 'skt-restaurant'),
		'id' => 'hmlatestpostslength',
		'std' => '25',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Select excerpt length for Client Testimonilas', 'skt-restaurant'),
		'id' => 'testimonialwordlength',
		'std' => '60',
		'type' => 'text');		
		
	$options[] = array(		
		'desc' => __('Select excerpt length for blog templates', 'skt-restaurant'),
		'id' => 'blogexcerptlength',
		'std' => '50',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Select excerpt length for our team member boxes', 'skt-restaurant'),
		'id' => 'teamexcerptlength',
		'std' => '25',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Select excerpt length for our menu for inner page', 'skt-restaurant'),
		'id' => 'menuexcerptlength',
		'std' => '18',
		'type' => 'text');			
					

	//Layout Settings
	$options[] = array(
		'name' => __('Sections', 'skt-restaurant'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Number of Sections', 'skt-restaurant'),
		'desc' => __('Select number of sections', 'skt-restaurant'),
		'id' => 'numsection',
		'type' => 'select',
		'std' => '7',
		'options' => array_combine(range(1,30), range(1,30)) );

	$numsecs = of_get_option( 'numsection', 7 );

	for( $n=1; $n<=$numsecs; $n++){
		$options[] = array(
			'desc' => __("<h3>Section ".$n."</h3>", 'skt-restaurant'),
			'class' => 'toggle_title',
			'type' => 'info');	
	
		$options[] = array(
			'name' => __('Section Title', 'skt-restaurant'),
			'id' => 'sectiontitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_title']) ) ? $section_text[$n]['section_title'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section ID', 'skt-restaurant'),
			'desc'	=> __('Enter your section ID here. SECTION ID MUST BE IN SMALL LETTERS ONLY AND DO NOT ADD SPACE OR SYMBOL.'),
			'id' => 'menutitle'.$n,
			'std' => ( ( isset($section_text[$n]['menutitle']) ) ? $section_text[$n]['menutitle'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section Background Color', 'skt-restaurant'),
			'desc' => __('Select background color for section', 'skt-restaurant'),
			'id' => 'sectionbgcolor'.$n,
			'std' => ( ( isset($section_text[$n]['bgcolor']) ) ? $section_text[$n]['bgcolor'] : '' ),
			'type' => 'color');
			
		$options[] = array(
			'name' => __('Background Image', 'skt-restaurant'),
			'id' => 'sectionbgimage'.$n,
			'class' => '',
			'std' => ( ( isset($section_text[$n]['bgimage']) ) ? $section_text[$n]['bgimage'] : '' ),
			'type' => 'upload');

		$options[] = array(
			'name' => __('Section CSS Class', 'skt-restaurant'),
			'desc' => __('Set class for this section.', 'skt-restaurant'),
			'id' => 'sectionclass'.$n,
			'std' => ( ( isset($section_text[$n]['class']) ) ? $section_text[$n]['class'] : '' ),
			'type' => 'text');
			
		$options[] = array(
			'name'	=> __('Hide Section', 'skt-restaurant'),
			'desc'	=> __('Check to hide this section', 'skt-restaurant'),
			'id'	=> 'hidesec'.$n,
			'type'	=> 'checkbox',
			'std'	=> '');

		$options[] = array(
			'name' => __('Section Content', 'skt-restaurant'),
			'id' => 'sectioncontent'.$n,
			'std' => ( ( isset($section_text[$n]['content']) ) ? $section_text[$n]['content'] : '' ),
			'type' => 'editor');
	}


	//SLIDER SETTINGS
	$options[] = array(
		'name' => __('Homepage Slider', 'skt-restaurant'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Inner Page Banner', 'skt-restaurant'),
		'desc' => __('Upload inner page banner for site', 'skt-restaurant'),
		'id' => 'innerpagebanner',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/default-banner.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Slider Effects and Timing', 'skt-restaurant'),
		'desc' => __('Select slider effect.','skt-restaurant'),
		'id' => 'slideefect',
		'std' => 'fade',
		'type' => 'select',
		'options' => array('random'=>'Random', 'fade'=>'Fade', 'fold'=>'Fold', 'sliceDown'=>'Slide Down', 'sliceDownLeft'=>'Slide Down Left', 'sliceUp'=>'Slice Up', 'sliceUpLeft'=>'Slice Up Left', 'sliceUpDown'=>'Slice Up Down', 'sliceUpDownLeft'=>'Slice Up Down Left', 'slideInRight'=>'SlideIn Right', 'slideInLeft'=>'SlideIn Left', 'boxRandom'=>'Box Random', 'boxRain'=>'Box Rain', 'boxRainReverse'=>'Box Rain Reverse', 'boxRainGrow'=>'Box Rain Grow', 'boxRainGrowReverse'=>'Box Rain Grow Reverse' ));
		
	$options[] = array(
		'desc' => __('Animation speed should be multiple of 100.', 'skt-restaurant'),
		'id' => 'slideanim',
		'std' => 500,
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add slide pause time.', 'skt-restaurant'),
		'id' => 'slidepause',
		'std' => 3000,
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slide Controllers', 'skt-restaurant'),
		'desc' => __('Hide/Show Direction Naviagtion of slider.','skt-restaurant'),
		'id' => 'slidenav',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Hide/Show pager of slider.','skt-restaurant'),
		'id' => 'slidepage',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Pause Slide on Hover.','skt-restaurant'),
		'id' => 'slidepausehover',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Yes', 'false'=>'No'));

	$options[] = array(
		'name' => __('Use any slider shortcode', 'skt-restaurant'),
		'desc' => __('you add any slider plugin shortcode here', 'skt-restaurant'),
		'id' => 'slidershortcode',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'name' => __('Slider Image 1', 'skt-restaurant'),
		'desc' => __('First Slide', 'skt-restaurant'),
		'id' => 'slide1',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider1.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 1', 'skt-restaurant'),
		'id' => 'slidetitle1',
		'std' => 'Restaurant & Cafe',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc1',
		'std' => 'Aliquam vitae nunc nibh. Nam sollicitudin orci vel eros
vulputate vestibulum. Sed bibendum felis sit amet lacus
scelerisque facilisis',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton1',
		'std' => 'Read More &raquo;',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl1',
		'std' => '#',
		'type' => 'text');		
		
	
	$options[] = array(
		'name' => __('Slider Image 2', 'skt-restaurant'),
		'desc' => __('Second Slide', 'skt-restaurant'),
		'class' => '',
		'id' => 'slide2',
		'std' => get_template_directory_uri()."/images/slides/slider2.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 2', 'skt-restaurant'),
		'id' => 'slidetitle2',
		'std' => 'Restaurant & Cafe',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc2',
		'std' => 'Aliquam vitae nunc nibh. Nam sollicitudin orci vel eros
vulputate vestibulum. Sed bibendum felis sit amet lacus
scelerisque facilisis',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton2',
		'std' => 'Read More &raquo;',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl2',
		'std' => '#',
		'type' => 'text');	
	
		
	$options[] = array(
		'name' => __('Slider Image 3', 'skt-restaurant'),
		'desc' => __('Third Slide', 'skt-restaurant'),
		'id' => 'slide3',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider3.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 3', 'skt-restaurant'),
		'id' => 'slidetitle3',
		'std' => 'Restaurant & Cafe',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc3',
		'std' => 'Aliquam vitae nunc nibh. Nam sollicitudin orci vel eros
vulputate vestibulum. Sed bibendum felis sit amet lacus
scelerisque facilisis',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton3',
		'std' => 'Read More &raquo;',
		'type' => 'text');					
	
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl3',
		'std' => '#',
		'type' => 'text');
			
	
	$options[] = array(
		'name' => __('Slider Image 4', 'skt-restaurant'),
		'desc' => __('Fourth Slide', 'skt-restaurant'),
		'id' => 'slide4',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 4', 'skt-restaurant'),
		'id' => 'slidetitle4',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc4',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton4',
		'std' => '',
		'type' => 'text');					
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl4',
		'std' => '',
		'type' => 'text');				
	
	$options[] = array(
		'name' => __('Slider Image 5', 'skt-restaurant'),
		'desc' => __('Fifth Slide', 'skt-restaurant'),
		'id' => 'slide5',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 5', 'skt-restaurant'),
		'id' => 'slidetitle5',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc5',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton5',
		'std' => '',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl5',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 6', 'skt-restaurant'),
		'desc' => __('Sixth Slide', 'skt-restaurant'),
		'id' => 'slide6',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
		
	$options[] = array(
		'desc' => __('Title 6', 'skt-restaurant'),
		'id' => 'slidetitle6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc6',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton6',
		'std' => '',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 7', 'skt-restaurant'),
		'desc' => __('Seventh Slide', 'skt-restaurant'),
		'id' => 'slide7',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 7', 'skt-restaurant'),
		'id' => 'slidetitle7',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc7',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton7',
		'std' => '',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl7',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 8', 'skt-restaurant'),
		'desc' => __('Eighth Slide', 'skt-restaurant'),
		'id' => 'slide8',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 8', 'skt-restaurant'),
		'id' => 'slidetitle8',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc8',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton8',
		'std' => '',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl8',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 9', 'skt-restaurant'),
		'desc' => __('Ninth Slide', 'skt-restaurant'),
		'id' => 'slide9',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 9', 'skt-restaurant'),
		'id' => 'slidetitle9',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc9',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton9',
		'std' => '',
		'type' => 'text');				
		
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl9',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 10', 'skt-restaurant'),
		'desc' => __('Tenth Slide', 'skt-restaurant'),
		'id' => 'slide10',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 10', 'skt-restaurant'),
		'id' => 'slidetitle10',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'skt-restaurant'),
		'id' => 'slidedesc10',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'skt-restaurant'),
		'id' => 'slidebutton10',
		'std' => '',
		'type' => 'text');			
	
	$options[] = array(
		'desc' => __('Slide Url', 'skt-restaurant'),
		'id' => 'slideurl10',
		'std' => '',
		'type' => 'text');

	//Footer SETTINGS
	$options[] = array(
		'name' => __('Footer', 'skt-restaurant'),
		'type' => 'heading');
		
	$options[] = array(	
		'name' => __('Footer Font Style', 'skt-restaurant'),	
		'desc' => __('Select font style for footer', 'skt-restaurant'),
		'id' => 'footerstyle',
		'std' => 'italic',
		'type' => 'select',
		'options'	=> array('italic' => 'italic', 'normal' => 'normal',));	
		
	$options[] = array(
		'name' => __('Footer Menu Section', 'skt-restaurant'),
		'desc' => __('footer menu title.', 'skt-restaurant'),
		'id' => 'footerabttitle',
		'std' => 'Main Menu',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Our Philosophy', 'skt-restaurant'),
		'desc' => __('Footer our philosophy title.', 'skt-restaurant'),
		'id' => 'philosophytitle',
		'std' => 'Our Philosophy',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Some text for footer of your site, you would like to display in the footer.', 'skt-restaurant'),
		'id' => 'footerabttext',
		'std' => 'Consectetur, adipisci velit, sed quiaony on numquam eius modi tempora incidunt, ut laboret dolore agnam aliquam quaeratine voluptatem. ut enim ad minima veniamting suscipit lab <br> <br><a class="readmore" href="">Read <span>More...</span></a>',
		'type' => 'textarea');	
		
	$options[] = array(
		'name' => __('Footer Follow Us Section', 'skt-restaurant'),
		'desc' => __('follow us text title.', 'skt-restaurant'),
		'id' => 'followustitle',
		'std' => 'Follow Us',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('add social icon name and link in the shortcodes.', 'skt-restaurant'),
		'id' => 'footersocialicons',
		'std' => '[social_area]
    [social icon="facebook" link="#"]
    [social icon="twitter" link="#"]
    [social icon="linkedin" link="#"]
    [social icon="pinterest" link="#"]
    [social icon="rss" link="#"]
    [social icon="youtube" link="#"]
    [social icon="google-plus" link="#"]
    [social icon="instagram" link="#"]
    [social icon="wordpress" link="#"]	
	[social icon="skype" link="#"]
	[social icon="yahoo" link="#"]
	[social icon="flickr" link="#"]
[/social_area]',
		'type' => 'textarea');		
		
	$options[] = array(
		'name' => __('Footer Address Title', 'skt-restaurant'),
		'desc' => __('Footer Address title.', 'skt-restaurant'),
		'id' => 'addresstitle',
		'std' => 'Contact Us',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add company address here.', 'skt-restaurant'),
		'id' => 'address',
		'std' => '100 King St, Melbourne PIC 4000, Australia',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add phone number here.', 'skt-restaurant'),
		'id' => 'phone',
		'std' => '+1 800 234 5678',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add email address here.', 'skt-restaurant'),
		'id' => 'email',
		'std' => 'info@sitename.com',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add company url here with http://.', 'skt-restaurant'),
		'id' => 'weblink',
		'std' => 'http://demo.com',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Footer Copyright', 'skt-restaurant'),
		'desc' => __('Copyright Text for your site.', 'skt-restaurant'),
		'id' => 'copytext',
		'std' => '&copy; 2015 <a href="#">Restaurant and Cafe</a>. All Rights Reserved',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Footre Text Link', 'skt-restaurant'),
		'id' => 'ftlink',
		'std' => 'Design by <a href="'.esc_url('http://sktthemes.net/').'" target="_blank">SKT Themes</a>',
		'type' => 'textarea',);

	//Short codes
	$options[] = array(
		'name' => __('Short Codes', 'skt-restaurant'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Latest posts', 'skt-restaurant'),
		'desc' => __('<pre>
[latestposts show="4"]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
		
	$options[] = array(
		'name' => __('Testimonial', 'skt-restaurant'),
		'desc' => __('<pre>
[testimonials]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
		$options[] = array(
		'name' => __('Testimonial Listing', 'skt-restaurant'),
		'desc' => __('<pre>
[testimonials-lists show="10"]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	
	$options[] = array(
		'name' => __('Gallery', 'skt-restaurant'),
		'desc' => __('[photogallery filter="true" show="8"]', 'skt-restaurant'),
		'type' => 'info');
		
		
	$options[] = array(
		'name' => __('Today Special', 'skt-restaurant'),
		'desc' => __('[todayspecial title="Food" icon="Enter here image url with https:" link="Enter here link"][/todayspecial][todayspecial title="Desert" icon="Enter here image url with https:" link="#"][/todayspecial][todayspecial title="Drink" icon="Enter here image url with https:" link="#"][/todayspecial]', 'skt-restaurant'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Our Menu front page shortcode', 'skt-restaurant'),
		'desc' => __('[ourmenu show="6"]', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Our Menu inner page shortcode', 'skt-restaurant'),
		'desc' => __('[ourmenu-innerpage show="6" filter="frue"]', 'skt-restaurant'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Our Team Member', 'skt-restaurant'),
		'desc' => __('[ourteam show="4"]', 'skt-restaurant'),
		'type' => 'info');			
		
	$options[] = array(
		'name' => __('Social Icons and Link', 'skt-restaurant'),
		'desc' => __('[social_area]
    [social icon="facebook" link="#"]
    [social icon="twitter" link="#"]
    [social icon="linkedin" link="#"]
    [social icon="pinterest" link="#"]
    [social icon="rss" link="#"]
    [social icon="youtube" link="#"]
    [social icon="google-plus" link="#"]
    [social icon="instagram" link="#"]
    [social icon="wordpress" link="#"]	
	[social icon="skype" link="#"]
	[social icon="yahoo" link="#"]
	[social icon="flickr" link="#"]
[/social_area]', 'skt-restaurant'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Office Time table', 'skt-restaurant'),
		'desc' => __('[time_table]
[time_table_row title="Monday" start="10:00 am - to - 08:00pm"]
[time_table_row title="Tuesday" start="10:30 pm - to - 09:00pm"]
[time_table_row title="Wednesday" start="09:00 am - to - 09:30pm"]
[time_table_row title="Thursday" start="09:00 am - to - 09:30pm"]
[time_table_row title="Friday" start="09:00 am - to - 05:00pm"]
[time_table_row title="Saturday" start="09:00 am - to - 04:00pm"]
[time_table_row title="Sunday" start="Closed"]
[/time_table]', 'skt-restaurant'),
		'type' => 'info');	
				
	$options[] = array(
		'name' => __('Search Form', 'skt-restaurant'),
		'desc' => __('[searchform] 
', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Contact Form', 'skt-restaurant'),
		'desc' => __('[contactform to_email="test@example.com" title="Contact Form"] 
', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('2 Column Content', 'skt-restaurant'),
		'desc' => __('<pre>
[column_content type="one_half"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_half_last"]
	Column 2 Content goes here...
[/column_content]
</pre>', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('3 Column Content', 'skt-restaurant'),
		'desc' => __('<pre>
[column_content type="one_third"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_third"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_third_last"]
	Column 3 Content goes here...
[/column_content]
</pre>', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('4 Column Content', 'skt-restaurant'),
		'desc' => __('<pre>
[column_content type="one_fourth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fourth_last"]
	Column 4 Content goes here...
[/column_content]
</pre>', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('5 Column Content', 'skt-restaurant'),
		'desc' => __('<pre>
[column_content type="one_fifth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 4 Content goes here...
[/column_content]

[column_content type="one_fifth_last"]
	Column 5 Content goes here...
[/column_content]
</pre>', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('Clear', 'skt-restaurant'),
		'desc' => __('<pre>
[clear]
</pre>', 'skt-restaurant'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('HR / Horizontal separation line', 'skt-restaurant'),
		'desc' => __('<pre>
[hr] or &lt;hr&gt;
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Separator / blank space', 'skt-restaurant'),
		'desc' => __('<pre>
[separator height="20"]
</pre>', 'skt-restaurant'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Blank space without image', 'skt-restaurant'),
		'desc' => __('<pre>
[blankspace height="20"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Tabs', 'skt-restaurant'),
		'desc' => __('<pre>
[tabs]
	[tab title="TAB TITLE 1"]
		TAB CONTENT 1
	[/tab]
	[tab title="TAB TITLE 2"]
		TAB CONTENT 2
	[/tab]
	[tab title="TAB TITLE 3"]
		TAB CONTENT 3
	[/tab]
[/tabs]
</pre>', 'skt-restaurant'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Toggle Content', 'skt-restaurant'),
		'desc' => __('<pre>
[toggle_content title="Toggle Title 1"]
	Toggle content 1...
[/toggle_content]
[toggle_content title="Toggle Title 2"]
	Toggle content 2...
[/toggle_content]
[toggle_content title="Toggle Title 3"]
	Toggle content 3...
[/toggle_content]
</pre>', 'skt-restaurant'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Accordion Content', 'skt-restaurant'),
		'desc' => __('<pre>
[accordion]
	[accordion_content title="ACCORDION TITLE 1"]
		ACCORDION CONTENT 1
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 2"]
		ACCORDION CONTENT 2
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 3"]
		ACCORDION CONTENT 3
	[/accordion_content]
[/accordion]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Small', 'skt-restaurant'),
		'desc' => __('<pre>
[gradient_button size="small" bg_color="#e00" color="#fff" text="Medium Gradient Button" title="Medium Gradient Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Medium', 'skt-restaurant'),
		'desc' => __('<pre>
[gradient_button size="medium" bg_color="#060" color="#fff" text="Medium Gradient Button" title="Medium Gradient Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Gradient Button - Large', 'skt-restaurant'),
		'desc' => __('<pre>
[gradient_button size="large" bg_color="#026" color="#fff" text="Large Gradient Button" title="Large Gradient Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Gradient Button - Xtra Large', 'skt-restaurant'),
		'desc' => __('<pre>
[gradient_button size="x-large" bg_color="#00ccff" color="#fff" text="Extra Large Simple Button" title="Extra Large Simple Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Small', 'skt-restaurant'),
		'desc' => __('<pre>
[simple_button size="small" bg_color="#c00" color="#fff" text="Small Simple Button" title="Small Simple Button" url="#" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Medium', 'skt-restaurant'),
		'desc' => __('<pre>
[simple_button size="medium" bg_color="#060" color="#fff" text="Medium Simple Button" title="Medium Simple Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Large', 'skt-restaurant'),
		'desc' => __('<pre>
[simple_button size="large" bg_color="#026" color="#fff" text="Large Simple Button" title="Large Simple Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Simple Button - Xtra Large', 'skt-restaurant'),
		'desc' => __('<pre>
[simple_button size="x-large" bg_color="#00ccff" color="#fff" text="Extra Large Simple Button" title="Extra Large Simple Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Round Button - Light', 'skt-restaurant'),
		'desc' => __('<pre>
[round_button style="light" text="Round Button" title="Round Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Round Button - Dark', 'skt-restaurant'),
		'desc' => __('<pre>
[round_button style="dark" text="Round Button" title="Round Button" url="" position="left"]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Message Box - Success', 'skt-restaurant'),
		'desc' => __('<pre>
[message type="success"]This is a sample of the \'success\' style message box shortcode. To use this style use the following shortcode[/message]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Error', 'skt-restaurant'),
		'desc' => __('<pre>
[message type="error"]This is a sample of the \'error\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Warning', 'skt-restaurant'),
		'desc' => __('<pre>
[message type="warning"]This is a sample of the \'warning\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - Info', 'skt-restaurant'),
		'desc' => __('<pre>
[message type="info"]This is a sample of the \'info\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-restaurant'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Message Box - About', 'skt-restaurant'),
		'desc' => __('<pre>
[message type="about"]This is a sample of the \'about\' style message box shortcode. To use this style use the following shortcode.[/message]
</pre>', 'skt-restaurant'),
		'type' => 'info');

	$options[] = array(
		'name' => __('List Styles', 'skt-restaurant'),
		'desc' => __('<pre>
[unordered_list style="list-1"]&lt;li&gt;List style 1&lt;/li&gt;[/unordered_list]
</pre>
<br />You can use above shortcode OR simply add class to ul. You can choose from list-1 to list-10 styles.<br />
<pre>
&lt;ul class="list-1"&gt;&lt;li&gt;List style 1&lt;/li&gt;&lt;/ul&gt;
</pre>
', 'skt-restaurant'),
		'type' => 'info');
		
	
	$options[] = array(
		'name' => __('Horizontal Separator', 'skt-restaurant'),
		'desc' => __('[hr_top] 
', 'skt-restaurant'),
		'type' => 'info');
	
		
	$options[] = array(
		'name' => __('Pricing', 'skt-restaurant'),
		'desc' => __('<pre>
[pricing_table columns="4"]
	[price_column highlight="no" bgcolor="#003366"]
		[price_header]Basic[/price_header]
		[price_row]&lt;strong&gt;$49.99 &lt;br /&gt;Per month&lt;/strong&gt;[/price_row]
		[price_row]5GB Bandwidth[/price_row]
		[price_row]1GB Storage[/price_row]
		[price_row]1 Domain[/price_row]
		[price_row]10 Email Accounts[/price_row]
		[price_footer link="#1"]Buy Basic[/price_footer]
	[/price_column][price_column highlight="yes" bgcolor="#990000"]
		[price_header]Premium[/price_header]
		[price_row]&lt;strong&gt;$99.99 &lt;br /&gt;Per month&lt;/strong&gt;[/price_row]
		[price_row]20GB Bandwidth[/price_row]
		[price_row]5GB Storage[/price_row]
		[price_row]5 Domains[/price_row]
		[price_row]25 Email Accounts[/price_row]
		[price_footer link="#2"]Buy Premium[/price_footer]
	[/price_column][price_column highlight="no" bgcolor="#83672b"]
		[price_header]Professional[/price_header]
		[price_row]&lt;strong&gt;$149.99 &lt;br /&gt;Per month&lt;/strong&gt;[/price_row]
		[price_row]50GB Bandwidth[/price_row]
		[price_row]10GB Storage[/price_row]
		[price_row]20 Domains[/price_row]
		[price_row]50 Email Accounts[/price_row]
		[price_footer link="#3"]Buy Professional[/price_footer]
	[/price_column][price_column highlight="no"]
		[price_header]Ultimate[/price_header]
		[price_row]&lt;strong&gt;$199.99 &lt;br /&gt;Per month&lt;/strong&gt;[/price_row]
		[price_row]Unlimited Bandwidth[/price_row]
		[price_row]Unlimited Storage[/price_row]
		[price_row]50 Domains[/price_row]
		[price_row]100 Email Accounts[/price_row]
		[price_footer link="#4"]Buy Ultimate[/price_footer]
	[/price_column]
[/pricing_table]
</pre>
', 'skt-restaurant'),
		'type' => 'info');

	// Support					
	$options[] = array(
		'name' => __('Our Themes', 'skt-restaurant'),
		'type' => 'heading');

	$options[] = array(
		'desc' => __('SKT Restaurant WordPress theme has been Designed and Created by <a href="'.esc_url('http://sktthemes.net/').'" target="_blank">SKT Themes</a>', 'skt-restaurant'),
		'type' => 'info');	

	 $options[] = array(
		'desc' => __('<a href="'.esc_url('http://sktthemes.net/').'" target="_blank"><img src="'.get_template_directory_uri().'/images/sktskill.jpg"></a>', 'skt-restaurant'),
		'type' => 'info');	

	return $options;
}